/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.CodeSource;
import java.util.Collections;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.webapp.WebAppContext;

public class EBP {
    public static void main(String[] args) throws Exception {
        File webAppsDir;
        int port = 8080;
        Object realm = null;
        Object logs = "logs";
        Object context = "/";
        boolean jaasOn = false;
        boolean forceRestart = false;
        boolean err = false;
        String EBP_HOME = null;
        File ebpHome = null;
        File ebpJar = null;
        CodeSource src = EBP.class.getProtectionDomain().getCodeSource();
        if (src != null) {
            URL jar = src.getLocation();
            ebpJar = new File(jar.getPath());
            EBP_HOME = ebpJar.getParent();
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--jaas")) {
                jaasOn = true;
                realm = null;
                continue;
            }
            if (i + 1 < args.length) {
                if (args[i].equals("--port")) {
                    try {
                        port = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException e) {
                        err = true;
                    }
                    continue;
                }
                if (args[i].equals("--home")) {
                    EBP_HOME = args[++i];
                    continue;
                }
                if (args[i].equals("--realm")) {
                    realm = args[++i];
                    jaasOn = false;
                    continue;
                }
                if (args[i].equals("--logs")) {
                    logs = args[++i];
                    continue;
                }
                if (args[i].equals("--context")) {
                    context = args[++i];
                    continue;
                }
                err = true;
                continue;
            }
            err = args[i].equals("--help") ? true : true;
        }
        ebpHome = new File(EBP_HOME);
        if (!ebpHome.isDirectory() || !ebpHome.canWrite()) {
            ebpHome.mkdirs();
            if (!ebpHome.isDirectory() || !ebpHome.canWrite()) {
                System.out.println("!!! EBP Home directory '" + EBP_HOME + "' not writable");
                err = true;
            }
        }
        if (realm != null && ((String)realm).length() > 0 && ((String)realm).charAt(0) != '/') {
            realm = EBP_HOME + File.separator + (String)realm;
        }
        if (logs != null && ((String)logs).length() > 0 && ((String)logs).charAt(0) != '/') {
            logs = EBP_HOME + File.separator + (String)logs;
        }
        if (context != null && ((String)context).length() > 0 && ((String)context).charAt(0) != '/') {
            context = "/" + (String)context;
        }
        if (err) {
            System.out.println("Heirloom Computing Elastic Batch Platform");
            System.out.println("Usage:  java -jar ebp.jar options...");
            System.out.println("Options:");
            System.out.println("    --port 8080 - defines the Web service port");
            System.out.println("    --home <jar location> - EBP Home directory");
            System.out.println("    --logs logs - log directory");
            System.out.println("    --realm <realm properties> - login properties file using Jetty format");
            System.out.println("    --jaas - use EBP RAC JAAS service");
            System.out.println("    --context / - URL path");
            System.out.println("    --help - this message");
            System.exit(0);
            return;
        }
        JarFile jf = null;
        try {
            jf = new JarFile(ebpJar);
        }
        catch (IOException e) {
            System.err.println("!!! could not open '" + ebpJar.getAbsolutePath() + "'");
            System.exit(1);
            return;
        }
        ZipEntry ze = jf.getEntry("ebp.war");
        if (ze == null) {
            System.err.println("!!! could not read 'ebp.war'");
            System.exit(1);
            jf.close();
            return;
        }
        File ebpWar = new File(EBP_HOME + File.separator + "ebp.war");
        if (!ebpWar.exists() || ebpWar.exists() && ebpWar.canWrite() && ebpWar.length() != ze.getSize()) {
            try {
                int rc;
                ebpWar.delete();
                ebpWar.createNewFile();
                InputStream is = jf.getInputStream(ze);
                FileOutputStream fos = new FileOutputStream(ebpWar);
                byte[] buf = new byte[40960];
                while ((rc = is.read(buf)) > 0) {
                    fos.write(buf, 0, rc);
                }
                fos.close();
                is.close();
            }
            catch (IOException e) {
                System.err.println("!!! could not extract 'ebp.war' to '" + ebpWar.getAbsolutePath() + "'");
                System.exit(1);
                jf.close();
                return;
            }
        }
        if ((webAppsDir = new File(EBP_HOME + File.separator + "webapp")).exists()) {
            File webXmlFile = new File(EBP_HOME + File.separator + "webapp" + File.separator + "WEB-INF" + File.separator + "web.xml");
            if (webXmlFile.canRead() && webXmlFile.canWrite()) {
                FileInputStream fis = new FileInputStream(webXmlFile);
                byte[] buf = new byte[10240];
                boolean rewrite = true;
                int n = fis.read(buf);
                fis.close();
                if (n == 10240 || n < 0) {
                    rewrite = false;
                }
                if (realm != null || jaasOn) {
                    str = new String(buf, 0, n);
                    rewrite = str.contains("- - >");
                    if (rewrite) {
                        str = str.replaceAll("- - >", "XX-->");
                        str = str.replaceAll("< ! - -", "<!--XXX");
                        buf = str.getBytes();
                        n = str.length();
                    }
                } else {
                    str = new String(buf, 0, n);
                    rewrite = str.contains("XX-->");
                    if (rewrite) {
                        str = str.replaceAll("XX-->", "- - >");
                        str = str.replaceAll("<!--XXX", "< ! - -");
                        buf = str.getBytes();
                        n = str.length();
                    }
                }
                if (rewrite) {
                    FileOutputStream fos = new FileOutputStream(webXmlFile);
                    fos.write(buf, 0, n);
                    fos.flush();
                    fos.close();
                }
            }
        } else if (realm != null || jaasOn) {
            System.err.println("!!! Extracting webapps dir ... restart in 5 seconds to turn on security");
            forceRestart = true;
        }
        try {
            jf.close();
        }
        catch (IOException e) {
            System.err.println("!!! could not close '" + ebpJar.getAbsolutePath() + "'");
            System.exit(1);
            return;
        }
        if (((String)logs).length() != 1 || ((String)logs).charAt(0) != '-') {
            try {
                File logsDir = new File((String)logs);
                logsDir.mkdirs();
                System.setOut(new PrintStream((String)logs + File.separator + "ebp_output.txt"));
                System.setErr(new PrintStream((String)logs + File.separator + "ebp_audit.txt"));
            }
            catch (IOException logsDir) {
                // empty catch block
            }
        }
        if (jaasOn) {
            System.setProperty("java.security.auth.login.config", EBP_HOME + File.separator + "META-INF" + File.separator + "jaas.config");
        }
        Server server = new Server(port);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean(mbContainer);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath((String)context);
        webapp.setWar(EBP_HOME + File.separator + "ebp.war");
        webapp.setTempDirectory(ebpHome);
        webapp.setPersistTempDirectory(true);
        server.setHandler(webapp);
        ConstraintSecurityHandler security = null;
        Constraint constraint = null;
        ConstraintMapping mapping = null;
        if (jaasOn || realm != null) {
            security = new ConstraintSecurityHandler();
            server.setHandler(security);
            constraint = new Constraint();
            constraint.setName("EBP");
            constraint.setAuthenticate(true);
            constraint.setRoles(new String[]{"EBP-user", "EBP-admin"});
            mapping = new ConstraintMapping();
            mapping.setPathSpec("/*");
            mapping.setConstraint(constraint);
            security.setConstraintMappings(Collections.singletonList(mapping));
            security.setAuthenticator(new BasicAuthenticator());
            security.setHandler(webapp);
        }
        if (jaasOn) {
            JAASLoginService loginService = new JAASLoginService();
            loginService.setName("EBP");
            loginService.setLoginModuleName("EBP");
            security.setLoginService(loginService);
            server.addBean(loginService);
        } else if (realm != null) {
            HashLoginService loginService = new HashLoginService();
            loginService.setName("EBP");
            loginService.setConfig((String)realm);
            security.setLoginService(loginService);
            server.addBean(loginService);
        }
        server.start();
        if (!forceRestart) {
            server.join();
        } else {
            Thread.sleep(5000L);
            System.exit(1);
        }
    }
}

