/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.api;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.Binary;
import com.heirloomcomputing.ecs.exec.BinaryRev;
import com.heirloomcomputing.ecs.exec.Comp1;
import com.heirloomcomputing.ecs.exec.Comp1MVS;
import com.heirloomcomputing.ecs.exec.Comp1R;
import com.heirloomcomputing.ecs.exec.Comp2;
import com.heirloomcomputing.ecs.exec.Comp2MVS;
import com.heirloomcomputing.ecs.exec.Comp2R;
import com.heirloomcomputing.ecs.exec.CompD;
import com.heirloomcomputing.ecs.exec.CompD2;
import com.heirloomcomputing.ecs.exec.DisplayA;
import com.heirloomcomputing.ecs.exec.DisplayH;
import com.heirloomcomputing.ecs.exec.DisplayMVS;
import com.heirloomcomputing.ecs.exec.DisplayP;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.PackedDecimal6;
import com.heirloomcomputing.ecs.exec.PackedDecimalA;
import com.heirloomcomputing.ecs.exec.PackedDecimalI;
import com.heirloomcomputing.ecs.exec.PackedDecimalP;
import com.heirloomcomputing.ecs.exec.UnbufferedMemory;
import com.heirloomcomputing.ecs.exec.Variable;

public class DatatypeGenerator {
    public static final int TYPE_INVALID = -1;
    public static final int TYPE_SIGN_MASK = 7;
    public static final int TYPE_JUST_MASK = 8;
    public static final int TYPE_NUMERIC_MASK = 16;
    public static final int TYPE_CLASS_MASK = 112;
    public static final int TYPE_VARIANT_MASK = 896;
    public static final int TYPE_SIGN_NONE = 0;
    public static final int TYPE_SIGN_LEAD = 1;
    public static final int TYPE_SIGN_TRAIL = 2;
    public static final int TYPE_SIGN_LEAD_SEP = 3;
    public static final int TYPE_SIGN_TRAIL_SEP = 4;
    public static final int TYPE_JUST_LEFT = 0;
    public static final int TYPE_JUST_RIGHT = 8;
    public static final int TYPE_NUMERIC = 16;
    public static final int TYPE_NON_NUMERIC = 0;
    public static final int TYPE_CLASS_ZONED = 16;
    public static final int TYPE_CLASS_BINARY = 48;
    public static final int TYPE_CLASS_PACKED_DECIMAL = 80;
    public static final int TYPE_CLASS_FLOAT = 112;
    public static final int TYPE_CLASS_TEXT = 0;
    public static final int TYPE_CLASS_GROUP = 32;
    public static final int TYPE_CLASS_TABLE = 64;
    public static final int TYPE_VARIANT_0 = 0;
    public static final int TYPE_VARIANT_1 = 128;
    public static final int TYPE_VARIANT_2 = 256;
    public static final int TYPE_VARIANT_3 = 384;
    public static final int TYPE_VARIANT_4 = 512;
    public static final int TYPE_VARIANT_5 = 640;
    public static final int TYPE_VARIANT_6 = 768;
    public static final int TYPE_VARIANT_7 = 896;
    public static final int TYPE_REDEFINES = 4096;

    public static IDatatype create(int type) {
        return DatatypeGenerator.create(type, null, 0, -1, 0, 0);
    }

    public static IDatatype create(int type, byte[] memory) {
        return DatatypeGenerator.create(type, memory, 0, -1, 0, 0);
    }

    public static IDatatype create(int type, byte[] memory, int offset) {
        return DatatypeGenerator.create(type, memory, offset, -1, 0, 0);
    }

    public static IDatatype create(int type, byte[] memory, int offset, int length) {
        return DatatypeGenerator.create(type, memory, offset, length, 0, 0);
    }

    public static IDatatype create(int type, byte[] memory, int offset, int length, int decimalPositions) {
        return DatatypeGenerator.create(type, memory, offset, length, decimalPositions, 0);
    }

    public static IDatatype create(int type, byte[] memory, int offset, int length, int decimalPositions, int scale) {
        return DatatypeGenerator.create(type, memory, offset, length, decimalPositions, scale, 0);
    }

    public static IDatatype create(int type, byte[] memory, int offset, int length, int decimalPositions, int scale, int pictureLength) {
        if (type < 0) {
            return null;
        }
        int typeClass = type & 0x70;
        int variant = type & 0x380;
        Variable result = null;
        block0 : switch (typeClass) {
            case 16: {
                if (length < 0) {
                    length = 18;
                }
                switch (variant) {
                    case 0: {
                        result = new DisplayP();
                        break;
                    }
                    case 128: {
                        result = new DisplayA();
                        break;
                    }
                    case 384: {
                        result = new DisplayH();
                        break;
                    }
                    case 640: {
                        result = new CompD();
                        break;
                    }
                    case 768: {
                        result = new DisplayMVS();
                        break;
                    }
                    case 896: {
                        result = new CompD2();
                    }
                }
                break;
            }
            case 48: {
                if (length < 0) {
                    length = 4;
                }
                switch (variant) {
                    case 0: {
                        result = new Binary();
                        break;
                    }
                    case 128: {
                        result = new BinaryRev();
                    }
                }
                break;
            }
            case 80: {
                if (length < 0) {
                    length = 4;
                }
                switch (variant) {
                    case 0: {
                        result = new PackedDecimalP();
                        break;
                    }
                    case 128: {
                        result = new PackedDecimalA();
                        break;
                    }
                    case 384: {
                        result = new PackedDecimalI();
                        break;
                    }
                    case 640: {
                        result = new PackedDecimal6();
                    }
                }
                break;
            }
            case 112: {
                if (length < 0) {
                    length = 8;
                }
                switch (length) {
                    case 4: {
                        switch (variant) {
                            case 0: {
                                result = new Comp1();
                                break;
                            }
                            case 128: {
                                result = new Comp1R();
                                break;
                            }
                            case 768: {
                                result = new Comp1MVS();
                            }
                        }
                        break block0;
                    }
                    default: {
                        length = 8;
                    }
                    case 8: 
                }
                switch (variant) {
                    case 0: {
                        result = new Comp2();
                        break;
                    }
                    case 128: {
                        result = new Comp2R();
                        break;
                    }
                    case 768: {
                        result = new Comp2MVS();
                    }
                }
                break;
            }
            case 0: {
                if (length < 0) {
                    length = 1;
                }
                result = new Variable();
                break;
            }
            case 32: {
                if (length < 0) {
                    length = 1;
                }
                result = new Variable();
                break;
            }
            case 64: {
                if (length < 0) {
                    length = 1;
                }
                result = new Variable();
            }
        }
        if (offset < 0) {
            offset = 0;
        }
        if (length < 0) {
            length = 1;
        }
        if (memory == null) {
            if (length > Short.MAX_VALUE) {
                length = Short.MAX_VALUE;
            }
            memory = new byte[length + offset];
        }
        if (scale < 0) {
            scale = 0;
        }
        if (decimalPositions < 0) {
            decimalPositions = 0;
        }
        if (pictureLength < 0) {
            pictureLength = 0;
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("parms int, byte[], int, int, int, int, int: Before calling variable.dynamicType(): . type=" + type + ". length=" + length + ". decimalPositions=" + decimalPositions + ". scale=" + scale + ". pictureLength=" + pictureLength + ". ");
        }
        result.dynamicType(type, memory, offset, length, decimalPositions, scale, pictureLength);
        return result;
    }

    public static void setMemory(IDatatype datatypeColumn, byte[] data, int offset) {
        if (datatypeColumn instanceof Variable) {
            Variable var = (Variable)datatypeColumn;
            if (!var.getMemory().isSetTo(data)) {
                var.setMemory(new UnbufferedMemory(data));
            }
            var.setAddress(offset);
        }
    }
}

