/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.api.ISpecialNames;
import com.heirloomcomputing.ecs.exec.AS400Connect;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.ScreenProperty;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.term.KeyValue;
import com.heirloomcomputing.term.ScreenHandler;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.LocalDataArea;

public class AS400LocalData
extends IO {
    public static final boolean debugMode = false;
    protected Object system = null;
    protected Object localArea = null;
    protected boolean initialized = false;

    public static void debug(String text) {
        System.out.println("AS400LocalData: " + text);
    }

    protected void initialize(Context context) {
        this.initialized = true;
        try {
            AS400Connect con = AS400Connect.getAS400Connection(context, null);
            if (con != null) {
                this.system = con.getSystemConnection(7);
            }
            if (this.system != null) {
                this.localArea = new LocalDataArea((AS400)this.system);
            }
        }
        catch (Throwable t) {
            this.system = null;
        }
    }

    @Override
    public boolean display(String text, String FOR) {
        return this.display((ISpecialNames)null, text, FOR);
    }

    @Override
    public boolean display(ISpecialNames specialNames, String text, String FOR) {
        Context context = null;
        if (specialNames instanceof Context) {
            context = (Context)specialNames;
        }
        if (!this.initialized) {
            this.initialize(context);
        }
        if (this.localArea == null) {
            return false;
        }
        try {
            ((LocalDataArea)this.localArea).write(text);
            return true;
        }
        catch (Exception e) {
            int error = AS400Connect.getErrorFromException(e);
            return false;
        }
    }

    @Override
    public boolean display(String text, float line, float column, boolean advance, ScreenProperty p) {
        return this.display(text, (String)null);
    }

    @Override
    public boolean display(Variable v, float line, float column, boolean advance) {
        if (v != null) {
            return this.display(v.toDisplayString(), (String)null);
        }
        return false;
    }

    @Override
    public boolean display(Handle h) {
        return false;
    }

    @Override
    public boolean display(Handle h, float line, float column) {
        return false;
    }

    @Override
    public boolean display(Handle h, float line, float column, ScreenProperty p) {
        return false;
    }

    @Override
    public synchronized boolean accept(ISpecialNames specialNames, Variable v, String device) {
        Context context = null;
        if (specialNames instanceof Context) {
            context = (Context)specialNames;
        }
        if (!this.initialized) {
            this.initialize(context);
        }
        if (this.localArea == null) {
            return false;
        }
        try {
            String result = ((LocalDataArea)this.localArea).read();
            v.move(result);
            return true;
        }
        catch (Exception e) {
            int error = AS400Connect.getErrorFromException(e);
            return false;
        }
    }

    @Override
    public boolean acceptOmitted(long timeout) {
        return false;
    }

    @Override
    public boolean accept(Variable v, float line, float column, long timeout) {
        return this.accept(v, (String)null);
    }

    @Override
    public String accept(int length, long timeout) {
        return this.accept((ISpecialNames)null, length, timeout);
    }

    @Override
    public String accept(ISpecialNames specialNames, int length, long timeout) {
        Context context = null;
        if (specialNames instanceof Context) {
            context = (Context)specialNames;
        }
        if (!this.initialized) {
            this.initialize(context);
        }
        if (this.localArea == null) {
            return null;
        }
        try {
            String result = ((LocalDataArea)this.localArea).read(0, length);
            return result;
        }
        catch (Exception e) {
            int error = AS400Connect.getErrorFromException(e);
            return null;
        }
    }

    @Override
    protected KeyValue getChar() {
        return null;
    }

    @Override
    public ScreenHandler getScreenHandler() {
        return null;
    }

    @Override
    public IO newInstance(String title) {
        return new AS400LocalData();
    }

    @Override
    public boolean isGraphical() {
        return false;
    }

    public void end() {
    }
}

