/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Handle;
import java.awt.event.KeyEvent;
import java.util.EventObject;

public final class AcceptEvent {
    public static final int CMD_CLOSE = 1;
    public static final int CMD_GOTO = 3;
    public static final int CMD_CLICKED = 4;
    public static final int CMD_DBLCLICK = 5;
    public static final int CMD_ACTIVATE = 6;
    public static final int CMD_TABCHANGED = 7;
    public static final int CMD_HELP = 8;
    public static final int CMD_WINDOWREMOVED = 300;
    public static final int NTF_SELCHANGE = 4099;
    public static final int NTF_CHANGED = 4100;
    public static final int NTF_PL_NEXT = 4101;
    public static final int NTF_PL_PREV = 4102;
    public static final int NTF_PL_NEXTPAGE = 4103;
    public static final int NTF_PL_PREVPAGE = 4104;
    public static final int NTF_PL_FIRST = 4105;
    public static final int NTF_PL_LAST = 4106;
    public static final int NTF_PL_SEARCH = 4107;
    public static final int NTF_RESIZED = 4114;
    public static final int MSG_SB_NEXT = 16385;
    public static final int MSG_SB_PREV = 16386;
    public static final int MSG_SB_NEXTPAGE = 16387;
    public static final int MSG_SB_PREVPAGE = 16388;
    public static final int MSG_SB_THUMB = 16389;
    public static final int MSG_SB_THUMBTRACK = 16390;
    public static final int MSG_VALIDATE = 16391;
    public static final int MSG_BEGIN_ENTRY = 16392;
    public static final int MSG_FINISH_ENTRY = 16393;
    public static final int MSG_CANCEL_ENTRY = 16394;
    public static final int MSG_GOTO_CELL = 16395;
    public static final int MSG_GOTO_CELL_MOUSE = 16396;
    public static final int MSG_MENU_INPUT = 16397;
    public static final int MSG_INIT_MENU = 16398;
    public static final int MSG_END_MENU = 16399;
    public static final int MSG_BITMAP_CLICKED = 16400;
    public static final int MSG_BITMAP_DBLCLICK = 16401;
    public static final int MSG_HEADING_CLICKED = 16402;
    public static final int MSG_HEADING_DBLCLICK = 16403;
    public static final int MSG_GOTO_CELL_DRAG = 16404;
    public static final int MSG_HEADING_DRAGGED = 16405;
    public static final int MSG_BEGIN_DRAG = 16406;
    public static final int MSG_END_DRAG = 16407;
    public static final int MSG_BEGIN_HEADING_DRAG = 16408;
    public static final int MSG_END_HEADING_DRAG = 16409;
    public static final int MSG_COL_WIDTH_CHANGED = 16410;
    public static final int MSG_TV_SELCHANGING = 16411;
    public static final int MSG_TV_SELCHANGE = 16412;
    public static final int MSG_TV_EXPANDING = 16413;
    public static final int MSG_TV_EXPANDED = 16414;
    public static final int MSG_CLOSE = 16415;
    public static final int MSG_SPIN_UP = 16416;
    public static final int MSG_SPIN_DOWN = 16417;
    public static final int MSG_PAGED_NEXT = 16419;
    public static final int MSG_PAGED_PREV = 16420;
    public static final int MSG_PAGED_NEXTPAGE = 16421;
    public static final int MSG_PAGED_PREVPAGE = 16422;
    public static final int MSG_PAGED_FIRST = 16423;
    public static final int MSG_PAGED_LAST = 16424;
    public static final int MSG_GRID_RBUTTON_DOWN = 16426;
    public static final int MSG_GRID_RBUTTON_UP = 16427;
    public static final int MSG_TV_DBLCLICK = 16428;
    public static final int MSG_WB_BEFORE_NAVIGATE = 16429;
    public static final int MSG_WB_NAVIGATE_COMPLETE = 16430;
    public static final int MSG_WB_DOWNLOAD_BEGIN = 16431;
    public static final int MSG_WB_DOWNLOAD_COMPLETE = 16432;
    public static final int MSG_WB_PROGRESS_CHANGE = 16433;
    public static final int MSG_WB_STATUS_TEXT_CHANGE = 16434;
    public static final int MSG_WB_TITLE_CHANGE = 16435;
    public static final int EVENT = 0;
    public static final int TERMINATION = 1;
    public static final int EXCEPTION = 2;
    public static final int TIMEOUT = 3;
    public static final int KEY = 4;
    public static final int E_MOUSE_MOVED = 80;
    public static final int E_LEFT_BUTTON_PUSHED = 81;
    public static final int E_LEFT_BUTTON_RELEASED = 82;
    public static final int E_LEFT_BUTTON_DBL_CLICKED = 83;
    public static final int E_MIDDLE_BUTTON_PUSHED = 84;
    public static final int E_MIDDLE_BUTTON_RELEASED = 85;
    public static final int E_MIDDLE_BUTTON_DBL_CLICKED = 86;
    public static final int E_RIGHT_BUTTON_PUSHED = 87;
    public static final int E_RIGHT_BUTTON_RELEASED = 88;
    public static final int E_RIGHT_BUTTON_DBL_CLICKED = 89;
    private Object source;
    private EventObject sourceEvent;
    private int type = 0;
    private int value;
    private int eventData1;
    private int eventData2;
    private int terminationValue;
    private int exceptionValue;
    public static final int W_TIMEOUT = 99;
    public static final int W_CONVERSION_ERROR = 98;
    public static final int W_NO_FIELDS = 97;
    public static final int W_EVENT = 96;
    public static final int W_MESSAGE = 95;
    private static int mouseRow = 1;
    private static int mouseColumn = 1;
    private static int lButtonStatus = 0;
    private static int mButtonStatus = 2;
    private static int rButtonStatus = 0;
    private boolean terminatingEvent = false;
    private boolean terminatingEventOverride = false;

    public int getExceptionValue() {
        if (this.exceptionValue != 0) {
            return this.exceptionValue;
        }
        if (this.type == 2) {
            return this.value;
        }
        if (this.isCommandEvent() || this.isNotifyEvent()) {
            return 96;
        }
        if (this.isMessageEvent()) {
            return 95;
        }
        if (this.type == 3) {
            return 99;
        }
        return 0;
    }

    public boolean isExceptionCondition() {
        if (this.exceptionValue != 0) {
            return true;
        }
        if (this.type == 2) {
            return true;
        }
        if (this.isCommandEvent() || this.isNotifyEvent()) {
            return true;
        }
        if (this.isMessageEvent()) {
            return true;
        }
        return this.type == 3;
    }

    public int getTerminationValue() {
        if (this.terminationValue != 0) {
            return this.terminationValue;
        }
        if (this.type == 1) {
            return this.value;
        }
        return 0;
    }

    public void setExceptionValue(int value) {
        this.exceptionValue = value;
    }

    public void setTerminationValue(int value) {
        this.terminationValue = value;
    }

    public AcceptEvent(Object source, int value) {
        this(source, 0, value, null, 0, 0);
    }

    public AcceptEvent(Object source, int type, int value) {
        this(source, type, value, null, 0, 0);
    }

    public AcceptEvent(Object source, int type, int value, EventObject eventObject) {
        this(source, type, value, eventObject, 0, 0);
    }

    public AcceptEvent(Object source, int type, int value, EventObject eventObject, int eventData1) {
        this(source, type, value, eventObject, eventData1, 0);
    }

    public AcceptEvent(Object source, KeyEvent key) {
        this(source, 4, key.getKeyCode(), key);
    }

    public AcceptEvent(Object source, int type, int value, EventObject eventObject, int eventData1, int eventData2) {
        if (type == 0 && eventObject == null && value == 3) {
            value = 300;
        }
        this.setSource(source);
        this.setType(type);
        this.setValue(value);
        this.setEventObject(eventObject);
        this.setEventData1(eventData1);
        this.setEventData2(eventData2);
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public EventObject getEventObject() {
        return this.sourceEvent;
    }

    public void setEventObject(EventObject value) {
        this.sourceEvent = value;
    }

    public static int getMouseRow() {
        return mouseRow;
    }

    public static int getMouseColumn() {
        return mouseColumn;
    }

    public static int getLButtonStatus() {
        return lButtonStatus;
    }

    public static int getMButtonStatus() {
        return mButtonStatus;
    }

    public static int getRButtonStatus() {
        return rButtonStatus;
    }

    public static void setMouseRow(int value) {
        mouseRow = value;
    }

    public static void setMouseColumn(int value) {
        mouseColumn = value;
    }

    public static void setLButtonStatus(int value) {
        lButtonStatus = value;
    }

    public static void setMButtonStatus(int value) {
        mButtonStatus = value;
    }

    public static void setRButtonStatus(int value) {
        rButtonStatus = value;
    }

    public int getEventData1() {
        return this.eventData1;
    }

    public void setEventData1(int value) {
        this.eventData1 = value;
    }

    public int getEventData2() {
        return this.eventData2;
    }

    public void setEventData2(int value) {
        this.eventData2 = value;
    }

    public boolean isEvent() {
        return this.type == 0;
    }

    public boolean isTermination() {
        return this.type == 1;
    }

    public boolean isException() {
        return this.type == 2;
    }

    public boolean isTimeout() {
        return this.type == 3;
    }

    public boolean isKey() {
        return this.type == 4;
    }

    public int getEventType() {
        return this.getValue();
    }

    public Handle getWindow() {
        try {
            return ((Handle)this.source).getWindowHandle();
        }
        catch (Throwable t) {
            return Handle.NULL;
        }
    }

    public Handle getControlHandle() {
        try {
            return (Handle)this.source;
        }
        catch (Throwable t) {
            return Handle.NULL;
        }
    }

    public int getControlId() {
        try {
            return ((Handle)this.source).getId();
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public boolean isTerminatingEvent() {
        if (this.terminatingEventOverride) {
            return this.terminatingEvent;
        }
        return this.isCommandEvent() || this.isNotifyEvent();
    }

    public void setTerminatingEvent() {
        this.setTerminatingEvent(true);
    }

    public void setTerminatingEvent(boolean state) {
        this.terminatingEvent = state;
        this.terminatingEventOverride = true;
    }

    public boolean isTerminating() {
        switch (this.type) {
            case 0: {
                return this.isTerminatingEvent();
            }
            case 1: 
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return true;
    }

    public boolean isCommandEvent() {
        if (this.type != 0) {
            return false;
        }
        return this.value >= 0 && this.value < 4000;
    }

    public boolean isNotifyEvent() {
        if (this.type != 0) {
            return false;
        }
        return this.value >= 4000 && this.value < 16000;
    }

    public int getReasonForEntry() {
        return this.isNotifyEvent() ? 1 : 0;
    }

    public boolean isMessageEvent() {
        if (this.type != 0) {
            return false;
        }
        return this.value >= 160000;
    }

    public boolean isCustomEvent() {
        if (this.type != 0) {
            return false;
        }
        return this.value < 0;
    }

    public static String nameOfValue(int value) {
        String valueString = String.valueOf(value);
        switch (value) {
            case 1: {
                return "CMD-CLOSE";
            }
            case 3: {
                return "CMD-GOTO";
            }
            case 4: {
                return "CMD-CLICKED";
            }
            case 5: {
                return "CMD-DBLCLICK";
            }
            case 6: {
                return "CMD-ACTIVATE";
            }
            case 7: {
                return "CMD-TABCHANGED";
            }
            case 8: {
                return "CMD-HELP";
            }
            case 300: {
                return "CMD-WINDOWREMOVED";
            }
            case 4099: {
                return "NTF-SELCHANGE";
            }
            case 4100: {
                return "NTF-CHANGED";
            }
            case 4101: {
                return "NTF-PL-NEXT";
            }
            case 4102: {
                return "NTF-PL-PREV";
            }
            case 4103: {
                return "NTF-PL-NEXTPAGE";
            }
            case 4104: {
                return "NTF-PL-PREVPAGE";
            }
            case 4105: {
                return "NTF-PL-FIRST";
            }
            case 4106: {
                return "NTF-PL-LAST";
            }
            case 4107: {
                return "NTF-PL-SEARCH";
            }
            case 4114: {
                return "NTF-RESIZED";
            }
            case 16385: {
                return "MSG-SB-NEXT";
            }
            case 16386: {
                return "MSG-SB-PREV";
            }
            case 16387: {
                return "MSG-SB-NEXTPAGE";
            }
            case 16388: {
                return "MSG-SB-PREVPAGE";
            }
            case 16389: {
                return "MSG-SB-THUMB";
            }
            case 16390: {
                return "MSG-SB-THUMBTRACK";
            }
            case 16391: {
                return "MSG-VALIDATE";
            }
            case 16392: {
                return "MSG-BEGIN-ENTRY";
            }
            case 16393: {
                return "MSG-FINISH-ENTRY";
            }
            case 16394: {
                return "MSG-CANCEL-ENTRY";
            }
            case 16395: {
                return "MSG-GOTO-CELL";
            }
            case 16396: {
                return "MSG-GOTO-CELL-MOUSE";
            }
            case 16397: {
                return "MSG-MENU-INPUT";
            }
            case 16398: {
                return "MSG-INIT-MENU";
            }
            case 16399: {
                return "MSG-END-MENU";
            }
            case 16400: {
                return "MSG-BITMAP-CLICKED";
            }
            case 16401: {
                return "MSG-BITMAP-DBLCLICK";
            }
            case 16402: {
                return "MSG-HEADING-CLICKED";
            }
            case 16403: {
                return "MSG-HEADING-DBLCLICK";
            }
            case 16404: {
                return "MSG-GOTO-CELL-DRAG";
            }
            case 16405: {
                return "MSG-HEADING-DRAGGED";
            }
            case 16406: {
                return "MSG-BEGIN-DRAG";
            }
            case 16407: {
                return "MSG-END-DRAG";
            }
            case 16408: {
                return "MSG-BEGIN-HEADING-DRAG";
            }
            case 16409: {
                return "MSG-END-HEADING-DRAG";
            }
            case 16410: {
                return "MSG-COL-WIDTH-CHANGED";
            }
            case 16411: {
                return "MSG-TV-SELCHANGING";
            }
            case 16412: {
                return "MSG-TV-SELCHANGE";
            }
            case 16413: {
                return "MSG-TV-EXPANDING";
            }
            case 16414: {
                return "MSG-TV-EXPANDED";
            }
            case 16415: {
                return "MSG-CLOSE";
            }
            case 16416: {
                return "MSG-SPIN-UP";
            }
            case 16417: {
                return "MSG-SPIN-DOWN";
            }
            case 16419: {
                return "MSG-PAGED-NEXT";
            }
            case 16420: {
                return "MSG-PAGED-PREV";
            }
            case 16421: {
                return "MSG-PAGED-NEXTPAGE";
            }
            case 16422: {
                return "MSG-PAGED-PREVPAGE";
            }
            case 16423: {
                return "MSG-PAGED-FIRST";
            }
            case 16424: {
                return "MSG-PAGED-LAST";
            }
            case 16426: {
                return "MSG-GRID-RBUTTON-DOWN";
            }
            case 16427: {
                return "MSG-GRID-RBUTTON-UP";
            }
            case 16428: {
                return "MSG-TV-DBLCLICK";
            }
            case 16429: {
                return "MSG-WB-BEFORE-NAVIGATE";
            }
            case 16430: {
                return "MSG-WB-NAVIGATE-COMPLETE";
            }
            case 16431: {
                return "MSG-WB-DOWNLOAD-BEGIN";
            }
            case 16432: {
                return "MSG-WB-DOWNLOAD-COMPLETE";
            }
            case 16433: {
                return "MSG-WB-PROGRESS-CHANGE";
            }
            case 16434: {
                return "MSG-WB-STATUS-TEXT-CHANGE";
            }
            case 16435: {
                return "MSG-WB-TITLE-CHANGE";
            }
        }
        return valueString;
    }

    public boolean isItemHelp() {
        return this.isException() && this.getExceptionValue() == Handle.exceptionValueItemHelp;
    }

    public boolean isHelpCursor() {
        if (this.isException() && this.getExceptionValue() == Handle.exceptionValueHelpCursor) {
            return true;
        }
        return true;
    }

    public boolean isCutSelection() {
        return this.isException() && this.getExceptionValue() == Handle.exceptionValueCutSelection;
    }

    public boolean isCopySelection() {
        return this.isException() && this.getExceptionValue() == Handle.exceptionValueCopySelection;
    }

    public boolean isPasteSelection() {
        return this.isException() && this.getExceptionValue() == Handle.exceptionValuePasteSelection;
    }

    public boolean isDeleteSelection() {
        return this.isException() && this.getExceptionValue() == Handle.exceptionValueDeleteSelection;
    }

    public boolean isUndo() {
        return this.isException() && this.getExceptionValue() == Handle.exceptionValueUndo;
    }

    public String toString() {
        String typeString = "?";
        String valueString = String.valueOf(this.value);
        switch (this.type) {
            case 0: {
                typeString = "EVENT";
                valueString = AcceptEvent.nameOfValue(this.value);
                break;
            }
            case 1: {
                typeString = "TERMINATION";
                break;
            }
            case 2: {
                typeString = "EXCEPTION";
                break;
            }
            case 3: {
                typeString = "TIMEOUT";
                break;
            }
            case 4: {
                typeString = "KEY";
            }
        }
        return "AcceptEvent [type=" + typeString + ", value=" + valueString + ", source=" + this.source + ", sourceEvent=" + this.sourceEvent + ", eventData1=" + this.eventData1 + ", eventData2=" + this.eventData2 + "]";
    }
}

