/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.BTreeHandler;
import com.heirloomcomputing.ecs.exec.IndexedFile;
import com.heirloomcomputing.ecs.exec.LockRecord;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public abstract class BTreeIndexedFile
extends IndexedFile {
    private static Boolean LockingEnabled = null;
    protected static final boolean debug = false;
    protected static final boolean sanityCheck = false;
    protected BTreeHandler[] keyBTree = null;
    protected Object[] keyStartLocation = new Object[256];
    protected LockRecord dataLockRecord = LockRecord.create();
    protected LockRecord idxLockRecord = LockRecord.create();
    protected long[] keyDupCount = null;

    public static void debug(String text) {
        System.out.println("BTreeIndexedFile: " + text);
    }

    @Override
    boolean idx_init() {
        if (LockingEnabled == null) {
            String globalLocking = RuntimeEnvironment.getGlobalParameter("RECORDLOCKING");
            LockingEnabled = globalLocking == null ? Boolean.valueOf(true) : Boolean.valueOf((globalLocking = globalLocking.toUpperCase()).length() > 0 && (globalLocking.charAt(0) == 'Y' || globalLocking.charAt(0) == '1' || globalLocking.charAt(0) == 'T'));
        }
        this.keyDupCount = new long[this.numberOfKeys];
        return this.file_init(this.filename);
    }

    public Object checkSanityX1K(Object num) {
        long lnum;
        comparableByteArray cba;
        byte[] bytes;
        if (num instanceof comparableByteArray && (bytes = (cba = (comparableByteArray)num).toByteArray()).length == 6 && (lnum = (long)(bytes[0] & 0xFF) << 40 | (long)(bytes[1] & 0xFF) << 32 | (long)(bytes[2] & 0xFF) << 24 | (long)(bytes[3] & 0xFF) << 16 | (long)(bytes[4] & 0xFF) << 8 | (long)(bytes[5] & 0xFF)) % 1024L != 0L) {
            throw new RuntimeException("*** Heirloom Computing internal error BTreeIndexedFile: root locations must be multiples of 1K but is  " + lnum);
        }
        return num;
    }

    @Override
    boolean idx_setFilename(String filename) {
        return this.file_setFilename(filename);
    }

    @Override
    boolean idx_resetCache() {
        if (LockingEnabled.booleanValue() && this.locking() && !this.idxReadLockAll(true)) {
            return false;
        }
        this.file_reset();
        this.file_getHeaderInformation();
        if (this.keyBTree != null) {
            for (int i = 0; i < this.numberOfKeys; ++i) {
                this.keyBTree[i].updateRootLocation(this.keyStartLocation[i]);
                this.keyBTree[i].restoreCurrentLocation();
            }
        }
        if (LockingEnabled.booleanValue() && this.locking()) {
            this.idxReadUnlockAll();
        }
        return true;
    }

    @Override
    boolean idx_flushCache() {
        if (LockingEnabled.booleanValue() && this.locking() && !this.idxWriteLockAll()) {
            return false;
        }
        if (this.keyBTree != null) {
            for (int i = 0; i < this.numberOfKeys; ++i) {
                this.keyBTree[i].saveCurrentLocation();
                this.keyBTree[i].flushCache();
            }
        }
        this.file_setHeaderInformation();
        this.file_flushCache();
        if (LockingEnabled.booleanValue() && this.locking()) {
            this.idxWriteUnlockAll();
        }
        return true;
    }

    @Override
    boolean idx_open(int mode) {
        boolean locking;
        boolean bl = locking = LockingEnabled != false && this.locking();
        if (locking) {
            this.readOnlyCaching = true;
        }
        int returnCode = this.file_open(mode);
        this.setIOStatus(returnCode);
        if (returnCode <= -10) {
            return false;
        }
        if (this.isNewFile()) {
            if (locking && !this.idxWriteLockAll(true)) {
                this.file_close();
                this.warning("BTreeIndexedFile.idx_open", "file locked");
                this.setIOStatus(-93);
                return false;
            }
            this.keyBTree = new BTreeHandler[this.numberOfKeys];
            for (int count = 0; count < this.numberOfKeys; ++count) {
                this.keyBTree[count] = this.file_getBTreeHandler();
                returnCode = this.keyBTree[count].init(this.keyArray[count], this.keyArray[count].length(), this.keyDuplicates[count], this.readOnlyCaching);
                if (returnCode != 0) {
                    if (locking) {
                        this.idxWriteUnlockAll();
                    }
                    this.file_close();
                    this.setIOStatus(returnCode);
                    return false;
                }
                this.keyStartLocation[count] = this.keyBTree[count].getRootLocation();
            }
            returnCode = this.file_setHeaderInformation();
            if (returnCode != 0) {
                if (locking) {
                    this.idxWriteUnlockAll();
                }
                this.file_close();
                this.setIOStatus(returnCode);
                return false;
            }
            if (this.readOnlyCaching) {
                this.file_flushCache();
            }
            if (locking) {
                this.keyBTree[0].saveCurrentLocation();
                this.idxWriteUnlockAll();
            }
        } else {
            if (locking && !this.idxReadLockAll(true)) {
                returnCode = this.getPriorError();
                this.file_close();
                this.setIOStatus(returnCode);
                this.warning("BTreeIndexedFile.idx_open", "could not lock");
                return false;
            }
            boolean matches = this.file_getHeaderInformation();
            if (!matches) {
                if (locking) {
                    this.idxReadUnlockAll();
                }
                this.file_close();
                this.setIOStatus(-39);
                this.warning("BTreeIndexedFile.idx_open", "open attributes do not match file header");
                return false;
            }
            this.keyBTree = new BTreeHandler[this.numberOfKeys];
            for (int count = 0; count < this.numberOfKeys; ++count) {
                this.keyBTree[count] = this.file_getBTreeHandler();
                returnCode = this.keyBTree[count].init(this.keyArray[count], this.keyArray[count].length(), this.keyStartLocation[count], this.keyDuplicates[count], this.readOnlyCaching);
                if (returnCode == 0) continue;
                if (locking) {
                    this.idxReadUnlockAll();
                }
                this.file_close();
                this.setIOStatus(returnCode);
                return false;
            }
            if (this.isExtend() && (returnCode = this.keyBTree[0].seekToEnd()) != 0) {
                if (locking) {
                    this.idxReadUnlockAll();
                }
                this.file_close();
                this.setIOStatus(returnCode);
                return false;
            }
            if (locking) {
                this.keyBTree[0].saveCurrentLocation();
                this.idxReadUnlockAll();
            }
        }
        this.fileMarkerKeyOffset = 0;
        return true;
    }

    @Override
    boolean close(int mode) {
        return super.close(mode);
    }

    @Override
    boolean idx_close(int mode) {
        boolean flag;
        int returnCode = this.file_close(mode);
        this.setIOStatus(returnCode);
        if (this.isOK() && !(flag = this.file_init(this.filename))) {
            this.warning("BTreeIndexedFile.idx_close", "could not close");
            this.setIOStatus(-30);
            return false;
        }
        return returnCode == 0;
    }

    @Override
    boolean idx_start(int mode, Variable currentKey) {
        boolean locking;
        int keyOffset = this.findKeyOffset(currentKey);
        if (keyOffset < 0) {
            this.fileMarkerKeyOffset = -1;
            int returnCode = -23;
            this.setIOStatus(-23);
            this.warning("BTreeIndexedFile.idx_start", "invalid key, random record missing");
            return this.isInvalidKey(returnCode);
        }
        boolean bl = locking = LockingEnabled != false && this.locking();
        if (locking && !this.idxReadLock(keyOffset + 1)) {
            this.fileMarkerKeyOffset = -1;
            return false;
        }
        int returnCode = this.keyBTree[keyOffset].seek(mode, currentKey);
        if (returnCode != 0) {
            if (locking) {
                this.idxReadUnlock(keyOffset + 1);
            }
            this.setIOStatus(returnCode);
            this.fileMarkerKeyOffset = -1;
            return this.isInvalidKey(returnCode);
        }
        this.lastWasAStart = true;
        this.fileMarkerKeyOffset = keyOffset;
        this.lastAccessError = 0;
        if (locking) {
            this.keyBTree[keyOffset].saveCurrentLocation();
            this.idxReadUnlock(keyOffset + 1);
        }
        return false;
    }

    protected int inner_readData(Variable keyIs, byte[] bytes) {
        int returnCode;
        byte[] data = this.keyBTree[this.fileMarkerKeyOffset].getCurrentData();
        if (data == null) {
            this.fileMarkerKeyOffset = -1;
            int returnCode2 = -23;
            this.setIOStatus(-23);
            this.readDataResult = this.isInvalidKey(returnCode2);
            this.warning("BTreeIndexedFile.inner_readData", "invalid key, random record missing");
            return 0;
        }
        int length = data.length;
        if (length > this.maximum) {
            returnCode = -4;
            this.setIOStatus(-4);
            this.warning("BTreeIndexedFile.inner_readData", "data record length " + length + " greater than file attribute maximum " + this.maximum);
            length = this.maximum;
        }
        if (length < this.minimum) {
            returnCode = -4;
            this.setIOStatus(-4);
            this.warning("BTreeIndexedFile.inner_readData", "data record length " + length + " less than file attribute minimum " + this.minimum);
        }
        this.lastAccessError = 0;
        this.lastWasARead = true;
        if (this.dependingOn != null) {
            this.dependingOn.move(length);
        }
        if (this.keyDuplicates[this.fileMarkerKeyOffset] && this.keyBTree[this.fileMarkerKeyOffset].isNextKeyDuplicate()) {
            this.setIOStatus(-2);
        }
        System.arraycopy(data, 0, bytes, 0, length);
        this.readDataResult = false;
        return length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int idx_readData(Variable keyIs, int keyOffset, byte[] bytes, int mode, double timeout) {
        boolean locking;
        int returnCode = this.getPriorError();
        boolean bl = locking = LockingEnabled != false && this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
        if (locking && !this.idxReadLock(keyOffset + 1)) {
            this.lastWasAStart = false;
            this.fileMarkerKeyOffset = -1;
            this.readDataResult = false;
            return 0;
        }
        boolean isSeq = this.isSequential();
        BTreeHandler tree = this.keyBTree[keyOffset];
        if (locking) {
            tree.saveCurrentLocation();
        }
        if (isSeq) {
            if (this.seqDirection >= 0) {
                if (this.lastWasAStart) {
                    tree.seekPrevious();
                    this.lastWasAStart = false;
                }
                if (tree.isAtEnd()) {
                    this.lastWasARead = false;
                    this.lastAccessError = 0;
                    returnCode = -46;
                    this.setIOStatus(-46);
                    this.readDataResult = this.isInvalidKey(returnCode);
                    this.warning("BTreeIndexedFile.idx_readData", "can't read, prior error status ignored");
                    return 0;
                }
                if (!tree.seekNext()) {
                    this.lastWasAStart = false;
                    if (locking) {
                        this.idxReadUnlock(keyOffset + 1);
                    }
                    this.fileMarkerKeyOffset = -1;
                    returnCode = -23;
                    this.setIOStatus(-23);
                    this.readDataResult = this.isInvalidKey(returnCode);
                    this.warning("BTreeIndexedFile.idx_readData", "invalid key, random record missing");
                    return 0;
                }
                if (tree.isAtEnd()) {
                    this.lastAccessError = 0;
                    this.lastWasARead = true;
                    this.lastWasAStart = false;
                    if (locking) {
                        this.idxReadUnlock(keyOffset + 1);
                    }
                    returnCode = -10;
                    this.setIOStatus(-10);
                    this.readDataResult = true;
                    return 0;
                }
            } else {
                if (this.lastWasAStart) {
                    tree.seekNext();
                    this.lastWasAStart = false;
                }
                if (tree.isAtBeginning()) {
                    this.lastWasARead = false;
                    this.lastAccessError = 0;
                    returnCode = -46;
                    this.setIOStatus(-46);
                    this.readDataResult = this.isInvalidKey(returnCode);
                    this.warning("BTreeIndexedFile.idx_readData", "can't read, prior error status ignored");
                    return 0;
                }
                if (!tree.seekPrevious()) {
                    // empty if block
                }
                if (tree.isAtBeginning()) {
                    this.lastAccessError = 0;
                    this.lastWasARead = true;
                    this.lastWasAStart = false;
                    if (locking) {
                        this.idxReadUnlock(keyOffset + 1);
                    }
                    returnCode = -10;
                    this.setIOStatus(-10);
                    this.readDataResult = true;
                    return 0;
                }
            }
        }
        this.fileMarkerKeyOffset = keyOffset;
        if (!isSeq && !tree.findKey(keyIs)) {
            this.lastWasAStart = false;
            if (locking) {
                this.idxReadUnlock(keyOffset + 1);
            }
            this.fileMarkerKeyOffset = -1;
            returnCode = -23;
            this.setIOStatus(-23);
            this.readDataResult = this.isInvalidKey(returnCode);
            this.warning("BTreeIndexedFile.idx_readData", "invalid key, random record missing");
            return 0;
        }
        if (!locking) {
            int len = this.inner_readData(keyIs, bytes);
            this.lastWasAStart = false;
            return len;
        }
        int retries = 0;
        long currentTime = 0L;
        long finalTime = 0L;
        if ((mode & 0x100000) != 0 && timeout != 0.0) {
            double seconds = timeout;
            currentTime = System.currentTimeMillis();
            finalTime = currentTime + (long)(seconds * 1000.0);
        }
        boolean retry = false;
        Object lockObject = tree.getCurrentLocation();
        do {
            if (this.dataLock(lockObject)) {
                this.lastWasAStart = false;
                tree.saveCurrentLocation();
                int len = this.inner_readData(keyIs, bytes);
                if (this.isInput()) {
                    this.dataUnlock(lockObject);
                    this.idxReadUnlock(keyOffset + 1);
                    return len;
                }
                if (this.lockingSingle()) {
                    this.idxReadUnlock(keyOffset + 1);
                    return len;
                }
                if (this.isOK()) {
                    if ((mode & 0x200000) != 0) {
                        this.dataUnlock(lockObject);
                    } else if (LockingEnabled.booleanValue() && this.lockingManual() && (mode & 0x1000000) == 0) {
                        this.dataUnlock(lockObject);
                    }
                    this.idxReadUnlock(keyOffset + 1);
                    return len;
                }
                if ((mode & 0x200000) != 0) {
                    this.idxReadUnlock(keyOffset + 1);
                    return len;
                }
                this.dataUnlock(lockObject);
                this.idxReadUnlock(keyOffset + 1);
                return len;
            }
            retry = false;
            if ((mode & 0x2000000) != 0) {
                ++retries;
                if (timeout != 0.0 && !((double)retries < timeout)) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                retry = true;
                continue;
            }
            if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (System.currentTimeMillis() >= finalTime) continue;
            retry = true;
        } while (retry);
        tree.restoreCurrentLocation();
        if (this.isSequential()) {
            this.lastAccessError = 0;
            this.lastWasARead = true;
        } else {
            this.fileMarkerKeyOffset = -1;
            this.lastWasAStart = false;
        }
        this.idxReadUnlock(keyOffset + 1);
        if (this.dataLockRecord.isStatusRejectedNoErrors()) {
            this.setIOStatus(-99);
        } else if (this.dataLockRecord.isStatusTooMany()) {
            this.setIOStatus(54);
        } else {
            this.setIOStatus(-95);
        }
        this.readDataResult = false;
        return 0;
    }

    @Override
    boolean idx_write(Variable fromVar, int mode, double timeout) {
        int returnCode;
        if (this.fileMarkerKeyOffset >= 0) {
            this.keyBTree[this.fileMarkerKeyOffset].saveCurrentLocation();
        }
        if ((returnCode = this.bTree_insert(fromVar, mode, timeout)) != 0) {
            this.setIOStatus(returnCode);
            if (this.isOK()) {
                this.lastAccessError = 0;
            }
            return this.isInvalidKey(returnCode);
        }
        if (this.fileMarkerKeyOffset >= 0) {
            this.keyBTree[this.fileMarkerKeyOffset].restoreCurrentLocation();
        }
        this.lastAccessError = 0;
        return false;
    }

    @Override
    boolean idx_rewrite(Variable fromVar, int mode, double timeout) {
        int returnCode;
        boolean locking;
        if (this.fileMarkerKeyOffset >= 0) {
            this.keyBTree[this.fileMarkerKeyOffset].saveCurrentLocation();
        }
        boolean bl = locking = LockingEnabled != false && this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
        if (!locking) {
            returnCode = this.bTree_rewrite(fromVar, mode, timeout);
            if (returnCode != 0) {
                this.setIOStatus(returnCode);
                this.lastWasARead = false;
                this.lastWasAStart = false;
                if (this.fileMarkerKeyOffset >= 0) {
                    this.keyBTree[this.fileMarkerKeyOffset].restoreCurrentLocation();
                }
                return this.isInvalidKey(returnCode);
            }
        } else {
            int retries = 0;
            long currentTime = 0L;
            long finalTime = 0L;
            if ((mode & 0x100000) != 0 && timeout != 0.0) {
                double seconds = timeout;
                currentTime = System.currentTimeMillis();
                finalTime = currentTime + (long)(seconds * 1000.0);
            }
            boolean retry = false;
            do {
                if ((returnCode = this.bTree_rewrite(fromVar, mode, timeout)) != -99) {
                    if (returnCode != 0) {
                        this.lastWasARead = false;
                        this.lastWasAStart = false;
                        if (this.fileMarkerKeyOffset >= 0) {
                            this.keyBTree[this.fileMarkerKeyOffset].restoreCurrentLocation();
                        }
                        this.setIOStatus(returnCode);
                        return this.isInvalidKey(returnCode);
                    }
                    retry = true;
                    break;
                }
                retry = false;
                if ((mode & 0x2000000) != 0) {
                    ++retries;
                    if (timeout == 0.0 || (double)retries < timeout) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                    }
                } else if ((mode & 0x100000) != 0 && System.currentTimeMillis() < finalTime) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < finalTime) {
                        retry = true;
                    }
                }
                if (!retry || this.fileMarkerKeyOffset < 0) continue;
                this.keyBTree[this.fileMarkerKeyOffset].restoreCurrentLocation();
            } while (retry);
            if (!retry) {
                if (this.fileMarkerKeyOffset >= 0) {
                    this.keyBTree[this.fileMarkerKeyOffset].restoreCurrentLocation();
                }
                this.lastWasARead = false;
                this.lastWasAStart = false;
                this.setIOStatus(-99);
                return this.isInvalidKey(-99);
            }
        }
        if (this.fileMarkerKeyOffset >= 0) {
            this.keyBTree[this.fileMarkerKeyOffset].restoreCurrentLocation();
        }
        this.lastWasARead = false;
        this.lastWasAStart = false;
        if (returnCode != 0) {
            this.setIOStatus(returnCode);
            if (this.isOK()) {
                this.lastAccessError = 0;
            }
            return this.isInvalidKey(returnCode);
        }
        this.lastAccessError = 0;
        return false;
    }

    @Override
    boolean idx_delete(int mode, double timeout) {
        boolean locking;
        boolean bl = locking = LockingEnabled != false && this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
        if (!locking) {
            if (this.fileMarkerKeyOffset >= 0) {
                this.keyBTree[this.fileMarkerKeyOffset].saveCurrentLocation();
            }
            int returnCode = this.bTree_delete(mode, timeout);
            if (this.fileMarkerKeyOffset >= 0) {
                this.keyBTree[this.fileMarkerKeyOffset].restoreCurrentLocation();
            }
            if (returnCode != 0) {
                this.setIOStatus(returnCode);
                if (this.isOK()) {
                    this.lastAccessError = 0;
                }
                return this.isInvalidKey(returnCode);
            }
            this.lastAccessError = 0;
            return false;
        }
        int retries = 0;
        long currentTime = 0L;
        long finalTime = 0L;
        if ((mode & 0x100000) != 0 && timeout != 0.0) {
            double seconds = timeout;
            currentTime = System.currentTimeMillis();
            finalTime = currentTime + (long)(seconds * 1000.0);
        }
        boolean retry = false;
        do {
            retry = false;
            if (this.fileMarkerKeyOffset >= 0) {
                this.keyBTree[this.fileMarkerKeyOffset].saveCurrentLocation();
            }
            int returnCode = this.bTree_delete(mode, timeout);
            if (this.fileMarkerKeyOffset >= 0) {
                this.keyBTree[this.fileMarkerKeyOffset].restoreCurrentLocation();
            }
            if (returnCode == -99) {
                if ((mode & 0x2000000) != 0) {
                    ++retries;
                    if (timeout != 0.0 && !((double)retries < timeout)) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    retry = true;
                    continue;
                }
                if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (System.currentTimeMillis() >= finalTime) continue;
                retry = true;
                continue;
            }
            if (returnCode != 0) {
                this.setIOStatus(returnCode);
                if (this.isOK()) {
                    this.lastAccessError = 0;
                }
                return this.isInvalidKey(returnCode);
            }
            this.lastAccessError = 0;
            return false;
        } while (retry);
        this.setIOStatus(-99);
        return this.isInvalidKey(-99);
    }

    @Override
    void idx_unlock() {
        this.dataLockRecord.unlockAll();
        this.setIOStatus(0);
    }

    @Override
    void idx_exclusive() {
        while (!this.dataLockRecord.exclusive()) {
            this.setIOStatus(-93);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        this.setIOStatus(0);
    }

    @Override
    void idx_exclusiveConditionally() {
        if (this.dataLockRecord.exclusive()) {
            this.setIOStatus(0);
        } else {
            this.setIOStatus(-93);
        }
    }

    @Override
    void idx_unexclusive() {
        this.dataLockRecord.unexclusive();
        this.setIOStatus(0);
    }

    private final int bTree_insert(Variable fromVar, int mode, double timeout) {
        boolean locking;
        boolean bl = locking = LockingEnabled != false && this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
        if (this.isSequential()) {
            if (locking && !this.idxReadLock(1)) {
                return this.getPriorError();
            }
            if (!this.keyBTree[0].isAtEnd(this.keyArray[0])) {
                if (locking) {
                    this.idxReadUnlock(1);
                }
                return -21;
            }
            if (locking) {
                this.idxReadUnlock(1);
            }
        }
        if (locking && !this.idxWriteLockAll()) {
            return this.getPriorError();
        }
        boolean alreadySet = false;
        for (int count = 0; count < this.numberOfKeys; ++count) {
            if (this.keyBTree[count].findKey(this.keyArray[count])) {
                if (!this.keyDuplicates[count]) {
                    if (locking) {
                        this.idxWriteUnlockAll();
                    }
                    return -22;
                }
                long result = this.keyBTree[count].seekToNextNonDuplicateKey(this.keyArray[count]);
                this.keyDupCount[count] = result > 0L ? result + 1L : 1L;
                if (alreadySet) continue;
                this.setIOStatus(-2);
                alreadySet = true;
                continue;
            }
            this.keyDupCount[count] = 0L;
        }
        int length = this.dependingOn != null ? this.dependingOn.toInt() : fromVar.length();
        if (length > this.maximum) {
            length = this.maximum;
        } else if (length < this.minimum) {
            length = this.minimum;
        }
        Object location = this.file_addData(fromVar.getMemory().getBytes(fromVar.getAddress(), length), 0, length);
        if (location == null) {
            if (locking) {
                this.idxWriteUnlockAll();
            }
            return -30;
        }
        if (locking && !this.dataLock(location)) {
            this.idxWriteUnlockAll();
            if (this.dataLockRecord.isStatusRejectedNoErrors()) {
                this.setIOStatus(-99);
            } else if (this.dataLockRecord.isStatusTooMany()) {
                this.setIOStatus(54);
            } else {
                this.setIOStatus(-96);
            }
            return this.getPriorError();
        }
        for (int count = 0; count < this.numberOfKeys; ++count) {
            Variable tempKey = this.keyArray[count];
            int returnCode = this.keyBTree[count].insertKeyAtCursor(tempKey, location, this.keyDupCount[count]);
            if (returnCode != 0) {
                if (locking) {
                    if (!this.lockingSingle() && (mode & 0x1000000) == 0) {
                        this.dataUnlock(location);
                    }
                    this.idxWriteUnlockAll();
                }
                return returnCode;
            }
            this.keyStartLocation[count] = this.keyBTree[count].getRootLocation();
            if (!locking) continue;
            this.keyBTree[count].saveCurrentLocation();
        }
        if (this.readOnlyCaching) {
            this.file_setHeaderInformation();
            this.file_flushCache();
        }
        if (locking) {
            if (!this.lockingSingle() && (mode & 0x1000000) == 0) {
                this.dataUnlock(location);
            }
            this.idxWriteUnlockAll();
        }
        return 0;
    }

    private final int bTree_delete(int mode, double timeout) {
        byte[] tempBytes;
        Object location;
        boolean locking;
        boolean bl = locking = LockingEnabled != false && this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
        if (locking && !this.idxWriteLockAll()) {
            return this.getPriorError();
        }
        if (this.isSequential()) {
            location = this.keyBTree[this.fileMarkerKeyOffset].getCurrentLocation();
            if (location == null) {
                if (locking) {
                    this.idxWriteUnlockAll();
                }
                this.warning("BTreeIndexedFile.bTree_delete", "invalid key, random record missing");
                return -23;
            }
            if (locking && !this.dataLock(location)) {
                this.idxWriteUnlockAll();
                return this.getPriorError();
            }
            tempBytes = this.keyBTree[this.fileMarkerKeyOffset].getCurrentData();
            if (tempBytes == null) {
                if (locking) {
                    this.dataUnlock(location);
                    this.idxWriteUnlockAll();
                }
                this.warning("BTreeIndexedFile.bTree_delete", "invalid key, random record missing");
                return -23;
            }
        } else {
            if (!this.keyBTree[0].findKey(this.keyArray[0])) {
                if (locking) {
                    this.idxWriteUnlockAll();
                }
                this.warning("BTreeIndexedFile.bTree_delete", "invalid key, random record missing");
                return -23;
            }
            location = this.keyBTree[0].getCurrentLocation();
            if (location == null) {
                if (locking) {
                    this.idxWriteUnlockAll();
                }
                this.warning("BTreeIndexedFile.bTree_delete", "invalid key, random record missing");
                return -23;
            }
            if (locking && !this.dataLock(location)) {
                this.idxWriteUnlockAll();
                return this.getPriorError();
            }
            tempBytes = this.keyBTree[0].getCurrentData();
            if (tempBytes == null) {
                if (locking) {
                    this.dataUnlock(location);
                    this.idxWriteUnlockAll();
                }
                this.warning("BTreeIndexedFile.bTree_delete", "invalid key, random record missing");
                return -23;
            }
        }
        Variable[] tempKey = new Variable[this.numberOfKeys];
        for (int count = 0; count < this.numberOfKeys; ++count) {
            tempKey[count] = this.getKeyFromBytes(count, tempBytes);
            int returnCode = this.keyBTree[count].deleteKey(tempKey[count], location);
            if (returnCode != 0) {
                if (locking) {
                    this.dataUnlock(location);
                    this.idxWriteUnlockAll();
                }
                return returnCode;
            }
            this.keyStartLocation[count] = this.keyBTree[count].getRootLocation();
        }
        int result = this.file_removeData(location);
        if (this.readOnlyCaching) {
            this.file_setHeaderInformation();
            this.file_flushCache();
        }
        if (locking) {
            this.dataUnlock(location);
            this.idxWriteUnlockAll();
        }
        return result;
    }

    private final int bTree_rewrite(Variable fromVar, int mode, double timeout) {
        int returnCode;
        Variable myKey;
        int count;
        byte[] tempBytes;
        Object location;
        boolean locking;
        boolean bl = locking = LockingEnabled != false && this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
        if (locking && !this.idxWriteLockAll()) {
            return this.getPriorError();
        }
        if (this.isSequential()) {
            location = this.keyBTree[this.fileMarkerKeyOffset].getCurrentLocation();
            if (location == null) {
                if (locking) {
                    this.idxWriteUnlockAll();
                }
                this.warning("BTreeIndexedFile.bTree_rewrite", "invalid key, random record missing");
                return -23;
            }
            if (locking && !this.dataLock(location)) {
                this.idxWriteUnlockAll();
                return this.getPriorError();
            }
            tempBytes = this.keyBTree[this.fileMarkerKeyOffset].getCurrentData();
            if (tempBytes == null) {
                if (locking) {
                    this.dataUnlock(location);
                    this.idxWriteUnlockAll();
                }
                this.warning("BTreeIndexedFile.bTree_rewrite", "invalid key, random record missing");
                return -23;
            }
        } else {
            if (!this.keyBTree[0].findKey(this.keyArray[0])) {
                if (locking) {
                    this.idxWriteUnlockAll();
                }
                this.warning("BTreeIndexedFile.bTree_rewrite", "invalid key, random record missing");
                return -23;
            }
            location = this.keyBTree[0].getCurrentLocation();
            if (location == null) {
                if (locking) {
                    this.idxWriteUnlockAll();
                }
                this.warning("BTreeIndexedFile.bTree_rewrite", "invalid key, random record missing");
                return -23;
            }
            if (locking && !this.dataLock(location)) {
                this.idxWriteUnlockAll();
                return this.getPriorError();
            }
            tempBytes = this.keyBTree[0].getCurrentData();
            if (tempBytes == null) {
                if (locking) {
                    this.dataUnlock(location);
                    this.idxWriteUnlockAll();
                }
                this.warning("BTreeIndexedFile.bTree_rewrite", "invalid key, random record missing");
                return -23;
            }
        }
        Variable[] tempKey = new Variable[this.numberOfKeys];
        boolean[] notSame = new boolean[this.numberOfKeys];
        for (count = 0; count < this.numberOfKeys; ++count) {
            boolean areNotIdentical;
            myKey = this.keyArray[count];
            tempKey[count] = this.getKeyFromBytes(count, tempBytes);
            boolean bl2 = areNotIdentical = tempKey[count].compare((comparableByteArray)myKey, true) != 0;
            if (!areNotIdentical) continue;
            if (count == 0) {
                if (locking) {
                    this.dataUnlock(location);
                    this.idxWriteUnlockAll();
                }
                this.warning("BTreeIndexedFile.bTree_rewrite", "duplicate primary key");
                return -22;
            }
            notSame[count] = true;
            if (!this.keyBTree[count].findKey(myKey)) continue;
            if (!this.keyDuplicates[count]) {
                if (locking) {
                    this.dataUnlock(location);
                    this.idxWriteUnlockAll();
                }
                this.warning("BTreeIndexedFile.bTree_rewrite", "duplicate primary key");
                return -22;
            }
            this.setIOStatus(-2);
        }
        for (count = 0; count < this.numberOfKeys; ++count) {
            myKey = this.keyArray[count];
            if (!notSame[count]) continue;
            returnCode = this.keyBTree[count].deleteKey(tempKey[count], location);
            if (returnCode != 0) {
                if (locking) {
                    this.dataUnlock(location);
                    this.idxWriteUnlockAll();
                }
                return returnCode;
            }
            returnCode = this.keyBTree[count].insertKey(myKey, location);
            if (returnCode != 0) {
                if (locking) {
                    this.dataUnlock(location);
                    this.idxWriteUnlockAll();
                }
                return returnCode;
            }
            this.keyStartLocation[count] = this.keyBTree[count].getRootLocation();
        }
        int result = this.file_removeData(location);
        if (result != 0) {
            return result;
        }
        int length = this.dependingOn != null ? this.dependingOn.toInt() : fromVar.length();
        if (length > this.maximum) {
            length = this.maximum;
        } else if (length < this.minimum) {
            length = this.minimum;
        }
        Object prevLocation = location;
        location = this.file_addData(fromVar.getMemory().getBytes(fromVar.getAddress(), length), 0, length);
        if (location == null) {
            if (locking) {
                this.dataUnlock(prevLocation);
                this.idxWriteUnlockAll();
            }
            this.warning("BTreeIndexedFile.bTree_rewrite", "internal error");
            return -30;
        }
        if (locking) {
            if (!this.dataLock(location)) {
                this.dataUnlock(prevLocation);
                this.idxWriteUnlockAll();
                if (this.dataLockRecord.isStatusRejectedNoErrors()) {
                    this.setIOStatus(-99);
                } else if (this.dataLockRecord.isStatusTooMany()) {
                    this.setIOStatus(54);
                } else {
                    this.setIOStatus(-96);
                }
                this.warning("BTreeIndexedFile.bTree_rewrite", "record lock error");
                return this.getPriorError();
            }
            if (!location.equals(prevLocation)) {
                this.dataUnlock(prevLocation);
            }
        }
        for (count = 0; count < this.numberOfKeys; ++count) {
            myKey = this.keyArray[count];
            returnCode = this.keyBTree[count].setDataForKey(myKey, prevLocation, location);
            if (returnCode == 0) continue;
            if (locking) {
                if (!this.lockingSingle() && (mode & 0x1000000) == 0) {
                    this.dataUnlock(location);
                }
                this.idxWriteUnlockAll();
            }
            return returnCode;
        }
        if (this.readOnlyCaching) {
            this.file_setHeaderInformation();
            this.file_flushCache();
        }
        if (locking) {
            if (!this.lockingSingle() && (mode & 0x1000000) == 0) {
                this.dataUnlock(location);
            }
            this.idxWriteUnlockAll();
        }
        return 0;
    }

    @Override
    boolean idx_isOpen() {
        return this.file_isOpen();
    }

    @Override
    boolean idx_isInput() {
        return this.file_isInput();
    }

    @Override
    boolean idx_isOutput() {
        return this.file_isOutput();
    }

    @Override
    boolean idx_isIO() {
        return this.file_isIO();
    }

    @Override
    boolean idx_isExtend() {
        return this.file_isExtend();
    }

    @Override
    boolean idx_isWritable() {
        return this.file_isWritable();
    }

    @Override
    boolean idx_isReadable() {
        return this.file_isReadable();
    }

    @Override
    boolean idx_isNewFile() {
        return this.file_isNewFile();
    }

    @Override
    boolean idx_deleteFile() {
        return this.file_deleteFile();
    }

    protected void resetInformation(int val) {
        if (val == 0) {
            this.file_reset();
            this.file_getHeaderInformation();
            return;
        }
        if (this.keyBTree != null && --val >= 0 && val < this.keyBTree.length) {
            this.keyBTree[val].updateRootLocation(this.keyStartLocation[val]);
            this.keyBTree[val].restoreCurrentLocation();
        }
    }

    protected boolean idxReadLock(int val) {
        if (!this.idxLockRecord.blockingReadLock(1L)) {
            if (this.idxLockRecord.isStatusRejectedNoErrors()) {
                this.setIOStatus(-99);
            } else if (this.idxLockRecord.isStatusTooMany()) {
                this.setIOStatus(54);
            } else {
                this.setIOStatus(-95);
            }
            this.warning("BTreeIndexedFile.idxReadLock", "record lock error");
            return false;
        }
        if (this.idxLockRecord.isStatusRecordChanged()) {
            this.resetInformation(0);
        }
        if (val == 0) {
            return true;
        }
        if (!this.idxLockRecord.blockingReadLock(val + 1)) {
            if (this.idxLockRecord.isStatusRejectedNoErrors()) {
                this.setIOStatus(-99);
            } else if (this.idxLockRecord.isStatusTooMany()) {
                this.setIOStatus(54);
            } else {
                this.setIOStatus(-95);
            }
            this.idxLockRecord.readUnlock(1L);
            this.warning("BTreeIndexedFile.idxReadLock", "record lock error");
            return false;
        }
        if (this.idxLockRecord.isStatusRecordChanged()) {
            this.resetInformation(val);
        }
        return true;
    }

    protected boolean idxReadUnlock(int val) {
        this.idxLockRecord.readUnlock(val + 1);
        if (val != 0) {
            this.idxLockRecord.readUnlock(1L);
        }
        return true;
    }

    protected boolean idxReadLockAll() {
        return this.idxReadLockAll(false);
    }

    protected boolean idxReadLockAll(boolean disallowReset) {
        if (!this.idxLockRecord.blockingReadLock(1L)) {
            if (this.idxLockRecord.isStatusRejectedNoErrors()) {
                this.setIOStatus(-93);
            } else if (this.idxLockRecord.isStatusTooMany()) {
                this.setIOStatus(54);
            } else {
                this.setIOStatus(-95);
            }
            this.warning("BTreeIndexedFile.idxReadLockAll", "record lock error");
            return false;
        }
        if (!disallowReset && this.idxLockRecord.isStatusRecordChanged()) {
            this.resetInformation(0);
        }
        for (int i = 1; i <= this.numberOfKeys; ++i) {
            if (!this.idxLockRecord.blockingReadLock(i + 1)) {
                if (this.idxLockRecord.isStatusRejectedNoErrors()) {
                    this.setIOStatus(-93);
                } else if (this.idxLockRecord.isStatusTooMany()) {
                    this.setIOStatus(54);
                } else {
                    this.setIOStatus(-95);
                }
                for (int j = i; j > 1; --j) {
                    this.idxLockRecord.readUnlock(j);
                }
                this.idxLockRecord.readUnlock(1L);
                this.warning("BTreeIndexedFile.idxReadLockAll", "record lock error");
                return false;
            }
            if (disallowReset || !this.idxLockRecord.isStatusRecordChanged()) continue;
            this.resetInformation(i);
        }
        return true;
    }

    protected boolean idxReadUnlockAll() {
        for (int i = this.numberOfKeys; i > 0; --i) {
            this.idxLockRecord.readUnlock(i + 1);
        }
        this.idxLockRecord.readUnlock(1L);
        return true;
    }

    protected boolean idxWriteLock(int val) {
        if (!this.idxLockRecord.blockingWriteLock(1L)) {
            if (this.idxLockRecord.isStatusRejectedNoErrors()) {
                this.setIOStatus(-99);
            } else if (this.idxLockRecord.isStatusTooMany()) {
                this.setIOStatus(54);
            } else {
                this.setIOStatus(-96);
            }
            this.warning("BTreeIndexedFile.idxWriteLock", "record lock error");
            return false;
        }
        if (this.idxLockRecord.isStatusRecordChanged()) {
            this.resetInformation(0);
        }
        if (val == 0) {
            return true;
        }
        if (!this.idxLockRecord.blockingWriteLock(val + 1)) {
            if (this.idxLockRecord.isStatusRejectedNoErrors()) {
                this.setIOStatus(-99);
            } else if (this.idxLockRecord.isStatusTooMany()) {
                this.setIOStatus(54);
            } else {
                this.setIOStatus(-96);
            }
            this.idxLockRecord.writeUnlock(1L);
            this.warning("BTreeIndexedFile.idxWriteLock", "record lock error");
            return false;
        }
        if (this.idxLockRecord.isStatusRecordChanged()) {
            this.resetInformation(val);
        }
        return true;
    }

    protected boolean idxWriteUnlock(int val) {
        this.idxLockRecord.writeUnlock(val + 1);
        if (val != 0) {
            this.idxLockRecord.writeUnlock(1L);
        }
        return true;
    }

    protected boolean idxWriteLockAll() {
        return this.idxWriteLockAll(false);
    }

    protected boolean idxWriteLockAll(boolean disallowReset) {
        if (!this.idxLockRecord.blockingWriteLock(1L)) {
            if (this.idxLockRecord.isStatusRejectedNoErrors()) {
                this.setIOStatus(-99);
            } else if (this.idxLockRecord.isStatusTooMany()) {
                this.setIOStatus(54);
            } else {
                this.setIOStatus(-96);
            }
            this.warning("BTreeIndexedFile.idxWriteLockAll", "record lock error");
            return false;
        }
        if (!disallowReset && this.idxLockRecord.isStatusRecordChanged()) {
            this.resetInformation(0);
        }
        for (int i = 1; i <= this.numberOfKeys; ++i) {
            if (!this.idxLockRecord.blockingWriteLock(i + 1)) {
                if (this.idxLockRecord.isStatusRejectedNoErrors()) {
                    this.setIOStatus(-99);
                } else if (this.idxLockRecord.isStatusTooMany()) {
                    this.setIOStatus(54);
                } else {
                    this.setIOStatus(-96);
                }
                for (int j = i; j > 1; --j) {
                    this.idxLockRecord.writeUnlock(j);
                }
                this.idxLockRecord.writeUnlock(1L);
                this.warning("BTreeIndexedFile.idxWriteLockAll", "record lock error");
                return false;
            }
            if (disallowReset || !this.idxLockRecord.isStatusRecordChanged()) continue;
            this.resetInformation(i);
        }
        return true;
    }

    protected boolean idxWriteUnlockAll() {
        for (int i = this.numberOfKeys; i > 0; --i) {
            this.idxLockRecord.writeUnlock(i + 1);
        }
        this.idxLockRecord.writeUnlock(1L);
        return true;
    }

    protected boolean dataLock(Object lockObject) {
        boolean flag = this.file_dataLock(lockObject);
        if (!flag) {
            if (this.dataLockRecord.isStatusRejectedNoErrors()) {
                this.setIOStatus(-99);
            } else if (this.dataLockRecord.isStatusTooMany()) {
                this.setIOStatus(54);
            } else {
                this.setIOStatus(-96);
            }
            this.warning("BTreeIndexedFile.dataLock", "record lock error");
        } else {
            this.setIOStatus(0);
        }
        return flag;
    }

    protected boolean dataUnlock(Object lockObject) {
        return this.file_dataUnlock(lockObject);
    }

    @Override
    protected int idx_mapStatusCode(int status) {
        return this.file_mapStatusCode(status);
    }

    abstract boolean file_init(String var1);

    abstract boolean file_setFilename(String var1);

    abstract int file_open(int var1);

    abstract int file_close(int var1);

    abstract int file_close();

    abstract boolean file_getHeaderInformation();

    abstract int file_setHeaderInformation();

    abstract BTreeHandler file_getBTreeHandler();

    abstract Object file_addData(byte[] var1);

    abstract Object file_addData(byte[] var1, int var2, int var3);

    abstract int file_removeData(Object var1);

    abstract boolean file_isOpen();

    abstract boolean file_isInput();

    abstract boolean file_isOutput();

    abstract boolean file_isIO();

    abstract boolean file_isExtend();

    abstract boolean file_isWritable();

    abstract boolean file_isReadable();

    abstract boolean file_isNewFile();

    abstract void file_flushCache();

    abstract void file_reset();

    abstract boolean file_dataLock(Object var1);

    abstract boolean file_dataUnlock(Object var1);

    abstract boolean file_deleteFile();

    abstract int file_mapStatusCode(int var1);
}

