/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public final class Bignum
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Bignum ZERO = new Bignum(BigDecimal.ZERO);
    private BigDecimal decimal;
    private boolean iAmNotNumeric;
    private boolean requireNumericValidate = false;
    private byte signPosition;
    private static boolean computeRounded;
    private static int computeScale;
    private static boolean computeCalc;

    public static void setComputeParams(boolean computeRounded, int scale) {
        computeCalc = true;
        Bignum.computeRounded = computeRounded;
        computeScale = scale;
    }

    public static void unsetCompute() {
        computeCalc = false;
    }

    public Bignum(String val) {
        this.convert(val);
    }

    public final void make(String val) {
        this.convert(val);
    }

    public Bignum(String param, char decimalPoint) {
        this.make(param, decimalPoint);
    }

    public void make(String param, char decimalPoint) {
        if (decimalPoint != '.') {
            param = param.replaceAll(".", "").replace(decimalPoint, '.');
        }
        this.convert(param);
    }

    public Bignum(char[] val, int length) {
        this.make(val, length);
    }

    public void make(char[] val, int length) {
        String str = new String(val);
        if (val.length > length) {
            str = str.substring(0, length);
        }
        this.convert(str);
    }

    public Bignum(char[] val, int offset, int length) {
        this.make(val, offset, length);
    }

    public void make(char[] val, int offset, int length) {
        char[] c = new char[length];
        for (int i = 0; i < length; ++i) {
            c[i] = val[i + offset];
        }
        this.convert(new String(c));
    }

    public Bignum(byte[] val, int length) {
        this.make(val, length);
    }

    public void make(byte[] val, int length) {
        String str = Variable.codePageToString(val);
        if (val.length > length) {
            str = str.substring(0, length);
        }
        this.convert(str);
    }

    public Bignum(byte[] val, int offset, int length) {
        this.make(val, offset, length);
    }

    public void make(byte[] val, int offset, int length) {
        this.convert(val, offset, length, InternalRep.DisplayP);
    }

    public Bignum(byte[] val, int offset, int length, int param_place) {
        this.convert(val, offset, length, InternalRep.DisplayP);
        if (param_place != 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(-param_place);
        }
    }

    public Bignum(byte[] val, int offset, int length, int param_place, int opt_scale) {
        this.convert(val, offset, length, InternalRep.DisplayP);
        if (param_place != 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(-param_place);
        }
        if (opt_scale > 0 && this.decimal.scale() == 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(opt_scale);
        }
    }

    public Bignum(byte[] val, int offset, int length, int param_place, int opt_scale, InternalRep rep) {
        this.convert(val, offset, length, rep);
        if (param_place != 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(-param_place);
        }
        if (opt_scale > 0 && this.decimal.scale() == 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(opt_scale);
        }
    }

    public Bignum(Memory val, int offset, int length, int param_place, int opt_scale, InternalRep rep) {
        this.convert(val, offset, length, rep);
        if (param_place != 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(-param_place);
        }
        if (opt_scale > 0 && this.decimal.scale() == 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(opt_scale);
        }
    }

    public Bignum(Memory val, int offset, int length, int param_place, int opt_scale, InternalRep rep, byte signPos) {
        this.signPosition = signPos;
        this.convert(val, offset, length, rep);
        if (param_place != 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(-param_place);
        }
        if (opt_scale > 0 && this.decimal.scale() == 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(opt_scale);
        }
    }

    public Bignum(double val) {
        this.decimal = new BigDecimal(val);
        this.iAmNotNumeric = false;
    }

    public final void make(double val) {
        this.decimal = new BigDecimal(val);
        this.iAmNotNumeric = false;
    }

    private Bignum(BigDecimal val) {
        this.decimal = val;
        this.iAmNotNumeric = false;
    }

    public Bignum(long val) {
        this.decimal = new BigDecimal(val);
        this.iAmNotNumeric = false;
    }

    public final void make(long val) {
        this.decimal = new BigDecimal(val);
        this.iAmNotNumeric = false;
    }

    public Bignum(long val, int param_place) {
        this.decimal = new BigDecimal(val);
        if (param_place != 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(-param_place);
        }
        this.iAmNotNumeric = false;
    }

    public final void make(long val, int param_place) {
        this.decimal = new BigDecimal(val);
        if (param_place != 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(-param_place);
        }
        this.iAmNotNumeric = false;
    }

    public Bignum(long val, int param_place, int param_sigDigits) {
        MathContext mc = new MathContext(param_sigDigits, RoundingMode.DOWN);
        this.decimal = new BigDecimal(val, mc);
        if (param_place != 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(-param_place);
        }
        this.iAmNotNumeric = false;
    }

    public final void make(long val, int param_place, int param_sigDigits) {
        MathContext mc = new MathContext(param_sigDigits, RoundingMode.DOWN);
        this.decimal = new BigDecimal(val, mc);
        if (param_place != 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(-param_place);
        }
        this.iAmNotNumeric = false;
    }

    public static Bignum valueOf(long val, int place) {
        return new Bignum(val, place);
    }

    public static Bignum valueOf(long val) {
        return new Bignum(val);
    }

    public Bignum(int val) {
        this.decimal = new BigDecimal(val);
    }

    public final void make(int val) {
        this.decimal = new BigDecimal(val);
    }

    public Bignum(int val, int param_place) {
        this.decimal = new BigDecimal(val);
        if (param_place != 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(-param_place);
        }
    }

    public final void make(int val, int param_place) {
        this.decimal = new BigDecimal(val);
        if (param_place != 0) {
            this.decimal = this.decimal.scaleByPowerOfTen(-param_place);
        }
    }

    public Bignum() {
        this.decimal = new BigDecimal(0);
    }

    private void convert(String val) {
        boolean altered = true;
        boolean negate = false;
        StringBuffer sb = new StringBuffer(val.trim());
        int lastPosn = sb.length() - 1;
        if (lastPosn >= 0) {
            char firstch = sb.charAt(0);
            char lastch = sb.charAt(lastPosn);
            if (lastch == 'B' && lastPosn != 0) {
                negate = true;
                sb.setLength(lastPosn - 1);
            } else if (lastch == 'R' && lastPosn != 0) {
                sb.setLength(lastPosn - 1);
            } else if (firstch == '+') {
                sb.setCharAt(0, '0');
            } else if (lastch == '+') {
                sb.setLength(lastPosn);
            } else if (lastch == '-') {
                sb.setLength(lastPosn);
                negate = true;
            } else {
                altered = false;
            }
        }
        try {
            if (altered) {
                val = sb.toString();
            }
            this.decimal = new BigDecimal(val);
            this.iAmNotNumeric = false;
        }
        catch (NumberFormatException e) {
            int i;
            this.setiAmNotNumeric(true);
            StringBuffer eSb = new StringBuffer();
            boolean changeDP = Memory.getGlobalDecimal() == ',';
            char[] chArray = val.toCharArray();
            for (i = 0; i < chArray.length && chArray[i] == ' '; ++i) {
                chArray[i] = 48;
            }
            for (i = chArray.length - 1; i >= 0 && chArray[i] == ' '; --i) {
                chArray[i] = 48;
            }
            val = String.valueOf(chArray);
            for (i = 0; i < val.length(); ++i) {
                char ch = val.charAt(i);
                if (ch == '-' || ch == '.' || ch >= '0' && ch <= '9') {
                    eSb.append(ch);
                    continue;
                }
                if (ch != ',' || !changeDP) continue;
                eSb.append('.');
            }
            try {
                this.decimal = new BigDecimal(eSb.toString());
            }
            catch (NumberFormatException f) {
                this.decimal = BigDecimal.ZERO;
            }
        }
        if (negate) {
            this.decimal = this.decimal.negate();
        }
    }

    public void convert(byte[] b, int offset, int length, InternalRep rep) {
        boolean negate = false;
        byte[] bb = new byte[length];
        switch (rep) {
            case DisplayP: {
                for (int i = 0; i < length; ++i) {
                    byte ch = b[i + offset];
                    if (ch >= 112 && ch <= 121) {
                        bb[i] = (byte)(ch - 112 + 48);
                        negate = true;
                        continue;
                    }
                    bb[i] = ch;
                }
                break;
            }
            case DisplayA: {
                for (int i = 0; i < length; ++i) {
                    byte ch = b[i + offset];
                    if (ch == 123) {
                        bb[i] = 48;
                        continue;
                    }
                    if (ch >= 65 && ch <= 73) {
                        bb[i] = (byte)(ch - 65 + 49);
                        continue;
                    }
                    if (ch == 125) {
                        bb[i] = 48;
                        negate = true;
                        continue;
                    }
                    if (ch >= 74 && ch <= 82) {
                        bb[i] = (byte)(ch - 74 + 49);
                        negate = true;
                        continue;
                    }
                    bb[i] = ch;
                }
                break;
            }
            case DisplayH: {
                for (int i = 0; i < length; ++i) {
                    byte ch = b[i + offset];
                    if (ch == 123) {
                        bb[i] = 48;
                        continue;
                    }
                    if (ch >= 65 && ch <= 73) {
                        bb[i] = (byte)(ch - 65 + 49);
                        continue;
                    }
                    if (ch == 125) {
                        bb[i] = 48;
                        negate = true;
                        continue;
                    }
                    if (ch >= 74 && ch <= 82) {
                        bb[i] = (byte)(ch - 74 + 49);
                        negate = true;
                        continue;
                    }
                    bb[i] = ch;
                }
                break;
            }
            case DisplayMVS: {
                for (int i = 0; i < length; ++i) {
                    byte ch = b[i + offset];
                    if (ch >= -16 && ch <= -7) {
                        bb[i] = (byte)(ch - -16 + 48);
                        continue;
                    }
                    if (ch >= -64 && ch <= -55) {
                        bb[i] = (byte)(ch - -64 + 48);
                        continue;
                    }
                    if (ch >= -48 && ch <= -39) {
                        bb[i] = (byte)(ch - -48 + 48);
                        negate = true;
                        continue;
                    }
                    bb[i] = ch;
                }
                break;
            }
        }
        try {
            this.convert(new String(bb, "iso-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            this.convert(new String(bb));
        }
        if (negate) {
            this.decimal = this.decimal.negate();
        }
    }

    public void convert(Memory m, int offset, int length, InternalRep rep) {
        boolean negate = false;
        byte[] bb = new byte[length];
        switch (rep) {
            case DisplayP: {
                for (int i = 0; i < length; ++i) {
                    byte ch = m.getByte(i + offset);
                    if (ch >= 112 && ch <= 121) {
                        bb[i] = (byte)(ch - 112 + 48);
                        negate = true;
                        continue;
                    }
                    bb[i] = ch;
                }
                break;
            }
            case DisplayA: {
                for (int i = 0; i < length; ++i) {
                    byte ch = m.getByte(i + offset);
                    if (ch == 123) {
                        bb[i] = 48;
                        continue;
                    }
                    if (ch >= 65 && ch <= 73) {
                        bb[i] = (byte)(ch - 65 + 49);
                        continue;
                    }
                    if (ch == 125) {
                        bb[i] = 48;
                        negate = true;
                        continue;
                    }
                    if (ch >= 74 && ch <= 82) {
                        bb[i] = (byte)(ch - 74 + 49);
                        negate = true;
                        continue;
                    }
                    bb[i] = ch;
                }
                break;
            }
            case DisplayH: {
                for (int i = 0; i < length; ++i) {
                    byte ch = m.getByte(i + offset);
                    if (ch == 123) {
                        bb[i] = 48;
                        continue;
                    }
                    if (ch >= 65 && ch <= 73) {
                        bb[i] = (byte)(ch - 65 + 49);
                        continue;
                    }
                    if (ch == 125) {
                        bb[i] = 48;
                        negate = true;
                        continue;
                    }
                    if (ch >= 74 && ch <= 82) {
                        bb[i] = (byte)(ch - 74 + 49);
                        negate = true;
                        continue;
                    }
                    bb[i] = ch;
                }
                break;
            }
            case DisplayMVS: {
                int i = 0;
                if (this.signPosition == 4) {
                    if (96 == m.getByte(i + offset)) {
                        negate = true;
                    }
                    i = 1;
                }
                if (this.signPosition == 5) {
                    if (96 == m.getByte(offset + length - 1)) {
                        negate = true;
                    }
                    --length;
                }
                while (i < length) {
                    byte ch = m.getByte(i + offset);
                    if (ch >= -16 && ch <= -7) {
                        bb[i] = (byte)(ch - -16 + 48);
                    } else if (ch >= -64 && ch <= -55) {
                        bb[i] = (byte)(ch - -64 + 48);
                    } else if (ch >= -48 && ch <= -39) {
                        bb[i] = (byte)(ch - -48 + 48);
                        negate = true;
                    } else {
                        bb[i] = 32;
                    }
                    ++i;
                }
                break;
            }
        }
        try {
            this.convert(new String(bb, "iso-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            this.convert(new String(bb));
        }
        if (negate) {
            this.decimal = this.decimal.negate();
        }
    }

    public void scaleBy(int pow) {
        this.decimal = this.decimal.movePointRight(pow);
    }

    public void scaleUp(int places) {
        this.decimal = this.decimal.movePointRight(places);
    }

    public Bignum add(Bignum val) {
        return new Bignum(this.decimal.add(val.decimal));
    }

    public Bignum add(long val_longVal) {
        return new Bignum(this.decimal.add(new BigDecimal(val_longVal)));
    }

    public void adding(Bignum val) {
        this.decimal = this.decimal.add(val.decimal);
    }

    public void adding(long ival) {
        this.decimal = this.decimal.add(new BigDecimal(ival));
    }

    public final Bignum addingWith(Bignum val) {
        this.decimal = this.decimal.add(val.decimal);
        return new Bignum(this.decimal);
    }

    public final Bignum addingWith(long ival) {
        this.decimal = this.decimal.add(new BigDecimal(ival));
        return new Bignum(this.decimal);
    }

    public Bignum subtract(Bignum val) {
        return new Bignum(this.decimal.subtract(val.decimal));
    }

    public void subtracting(Bignum val) {
        this.decimal = this.decimal.subtract(val.decimal);
    }

    public final Bignum subtractingWith(Bignum val) {
        this.decimal = this.decimal.subtract(val.decimal);
        return new Bignum(this.decimal);
    }

    public Bignum multiply(Bignum val) {
        return new Bignum(this.decimal.multiply(val.decimal));
    }

    public Bignum multiply(long val_longVal) {
        return new Bignum(this.decimal.multiply(new BigDecimal(val_longVal)));
    }

    public void multiplying(Bignum val) {
        this.decimal = this.decimal.multiply(val.decimal);
    }

    public void multiplying(long ival) {
        this.decimal = this.decimal.multiply(new BigDecimal(ival));
    }

    public Bignum multiplyingWith(Bignum val) {
        this.decimal = this.decimal.multiply(val.decimal);
        return new Bignum(this.decimal);
    }

    public final Bignum multiplyingWith(long ival) {
        this.decimal = this.decimal.multiply(new BigDecimal(ival));
        return new Bignum(this.decimal);
    }

    public Bignum divide(Bignum val) {
        int totalPrecision = this.decimal.precision() + val.decimal.precision();
        if (RuntimeEnvironment.isIBM && totalPrecision < 31) {
            totalPrecision = 31;
        } else if (totalPrecision < 18) {
            totalPrecision = 18;
        }
        MathContext mc = new MathContext(totalPrecision, RoundingMode.HALF_UP);
        BigDecimal rslt = this.decimal.divide(val.decimal, mc);
        if (computeCalc && RuntimeEnvironment.isIBM) {
            int dmax;
            int dmax1 = computeScale > this.decimal.scale() ? computeScale : this.decimal.scale();
            int dmax2 = this.decimal.scale() - val.decimal.scale();
            int n = dmax = dmax1 > dmax2 ? dmax1 : dmax2;
            if (!computeRounded) {
                return new Bignum(rslt.setScale(dmax, RoundingMode.DOWN));
            }
            return new Bignum(rslt);
        }
        return new Bignum(rslt);
    }

    public Bignum remainder(Bignum val) {
        int totalPrecision = this.decimal.precision() + val.decimal.precision();
        if (RuntimeEnvironment.isIBM && totalPrecision < 31) {
            totalPrecision = 31;
        } else if (totalPrecision < 18) {
            totalPrecision = 18;
        }
        MathContext mc = new MathContext(totalPrecision, RoundingMode.HALF_UP);
        return new Bignum(this.decimal.remainder(val.decimal, mc));
    }

    public Bignum[] integerDivide(Bignum val) {
        Bignum[] result = new Bignum[]{new Bignum(this.longValue() / val.longValue()), new Bignum(this.longValue() % val.longValue())};
        return result;
    }

    public void dividing(Bignum val) {
        int totalPrecision = this.decimal.precision() + val.decimal.precision();
        if (RuntimeEnvironment.isIBM && totalPrecision < 31) {
            totalPrecision = 31;
        } else if (totalPrecision < 18) {
            totalPrecision = 18;
        }
        MathContext mc = new MathContext(totalPrecision, RoundingMode.HALF_UP);
        this.decimal = this.decimal.divide(val.decimal, mc);
    }

    public Bignum dividingWith(Bignum val) {
        int totalPrecision = this.decimal.precision() + val.decimal.precision();
        if (RuntimeEnvironment.isIBM && totalPrecision < 31) {
            totalPrecision = 31;
        } else if (totalPrecision < 18) {
            totalPrecision = 18;
        }
        MathContext mc = new MathContext(totalPrecision, RoundingMode.HALF_UP);
        BigDecimal rslt = this.decimal.divide(val.decimal, mc);
        if (computeCalc && RuntimeEnvironment.isIBM) {
            int dmax;
            int dmax1 = computeScale > this.decimal.scale() ? computeScale : this.decimal.scale();
            int dmax2 = this.decimal.scale() - val.decimal.scale();
            int n = dmax = dmax1 > dmax2 ? dmax1 : dmax2;
            if (!computeRounded) {
                this.decimal = rslt.setScale(dmax, RoundingMode.DOWN);
                return new Bignum(this.decimal);
            }
            return new Bignum(rslt);
        }
        this.decimal = rslt;
        return new Bignum(this.decimal);
    }

    public final void remaindering(Bignum val) {
        int totalPrecision = this.decimal.precision() + val.decimal.precision();
        if (RuntimeEnvironment.isIBM && totalPrecision < 31) {
            totalPrecision = 31;
        } else if (totalPrecision < 18) {
            totalPrecision = 18;
        }
        MathContext mc = new MathContext(totalPrecision, RoundingMode.HALF_UP);
        this.decimal = this.decimal.remainder(val.decimal, mc);
    }

    public final int compareTo(Bignum val) {
        return this.decimal.compareTo(val.decimal);
    }

    public Bignum movePointLeft(int n) {
        return new Bignum(this.decimal.movePointLeft(n));
    }

    public void movingPointLeft(int n) {
        this.decimal = this.decimal.movePointLeft(n);
    }

    public Bignum movePointRight(int n) {
        return new Bignum(this.decimal.movePointRight(n));
    }

    public final void movingPointRight(int n) {
        this.decimal = this.decimal.movePointRight(n);
    }

    public final void movingPoint(int n, int place) {
        if (place > 0) {
            this.movingPointLeft(n);
        } else {
            this.movingPointRight(n);
        }
    }

    public Bignum abs() {
        return new Bignum(this.decimal.abs());
    }

    public Bignum negate() {
        return new Bignum(this.decimal.negate());
    }

    public void negating() {
        this.decimal = this.decimal.negate();
    }

    public Bignum negatingWith() {
        this.decimal = this.decimal.negate();
        return new Bignum(this.decimal);
    }

    public int signum() {
        return this.decimal.signum();
    }

    public void makeUnsigned() {
        if (this.decimal.signum() < 0) {
            this.decimal = this.decimal.negate();
        }
    }

    public boolean makeUnsignedCheck() {
        if (this.decimal.signum() < 0) {
            this.decimal = this.decimal.negate();
            return true;
        }
        return false;
    }

    public final boolean isNegative() {
        return this.decimal.signum() < 0;
    }

    public final boolean isPositive() {
        return this.decimal.signum() > 0;
    }

    public final boolean isZero() {
        return this.decimal.signum() == 0;
    }

    public boolean equals(Object param) {
        if (!(param instanceof Bignum)) {
            return false;
        }
        Bignum bignumParam = (Bignum)param;
        return this.decimal.compareTo(bignumParam.decimal) == 0;
    }

    public final Bignum min(Bignum val) {
        return this.decimal.compareTo(val.decimal) < 0 ? this : val;
    }

    public final Bignum max(Bignum val) {
        return this.decimal.compareTo(val.decimal) > 0 ? this : val;
    }

    public final int hashCode() {
        return this.decimal.hashCode();
    }

    public String toDebugString() {
        return "(decimal=" + this.decimal.toString() + ")";
    }

    public String toString() {
        return this.decimal.toPlainString();
    }

    public final String toNumericString() {
        return this.decimal.toPlainString();
    }

    public final String toEngineeringString() {
        return this.decimal.toEngineeringString();
    }

    public byte byteValue() {
        return this.decimal.byteValue();
    }

    public short shortValue() {
        return this.decimal.shortValue();
    }

    public int intValue() {
        return this.decimal.intValue();
    }

    public long longValue() {
        return this.decimal.longValue();
    }

    public BigDecimal decimalValue() {
        return this.decimal;
    }

    public BigInteger bigIntegerValue() {
        return this.decimal.toBigInteger();
    }

    public long getLong() {
        return this.decimal.unscaledValue().longValue();
    }

    public boolean fitsInLong() {
        return this.decimal.precision() < 19;
    }

    public long getLong(int varPlaceAndScale) {
        BigDecimal tmp = varPlaceAndScale == this.decimal.scale() ? this.decimal : this.decimal.scaleByPowerOfTen(this.decimal.scale() - varPlaceAndScale).setScale(0, RoundingMode.DOWN);
        return tmp.unscaledValue().longValue();
    }

    public long getLong(int varPlace, int varScale) {
        int varPlaceAndScale = varPlace + varScale;
        BigDecimal tmp = varPlaceAndScale == this.decimal.scale() ? this.decimal : this.decimal.scaleByPowerOfTen(this.decimal.scale() - varPlaceAndScale).setScale(0, RoundingMode.DOWN);
        return tmp.unscaledValue().longValue();
    }

    public void setLong(long param) {
        this.make(param);
    }

    public float floatValue() {
        return this.decimal.floatValue();
    }

    public double doubleValue() {
        return this.decimal.doubleValue();
    }

    public float toFloat() {
        return this.decimal.floatValue();
    }

    public double toDouble() {
        return this.decimal.doubleValue();
    }

    public final long toLongAtPlace(int desiredPlace) {
        return this.decimal.scaleByPowerOfTen(desiredPlace).longValue();
    }

    public Bignum pow(int n) {
        return new Bignum(this.decimal.pow(n, MathContext.DECIMAL64));
    }

    public Bignum pow(Bignum n) {
        return new Bignum(Math.pow(this.decimal.doubleValue(), n.decimal.doubleValue()));
    }

    public void powing(Bignum n) {
        MathContext mc = new MathContext(this.decimal.precision(), RoundingMode.HALF_UP);
        this.decimal = new BigDecimal(Math.pow(this.decimal.doubleValue(), n.decimal.doubleValue()), mc);
    }

    public final Bignum pow(double d) {
        return new Bignum(Math.pow(this.decimal.doubleValue(), d));
    }

    public final Bignum powingWith(Bignum n) {
        this.decimal = new BigDecimal(Math.pow(this.decimal.doubleValue(), n.decimal.doubleValue()));
        return this;
    }

    public Bignum(Bignum value) {
        this.decimal = value.decimal;
        this.iAmNotNumeric = false;
    }

    public void make(Bignum value) {
        this.decimal = value.decimal;
        this.iAmNotNumeric = false;
    }

    public int getScale() {
        return this.decimal.scale();
    }

    public int getSigDigits() {
        return this.decimal.precision();
    }

    public boolean roundPreserve(int totalDigits, int decimalPlaces) {
        boolean sizeError;
        if (totalDigits <= 0) {
            return true;
        }
        MathContext mc = new MathContext(totalDigits, RoundingMode.HALF_UP);
        BigDecimal tmp = this.decimal.setScale(decimalPlaces, RoundingMode.HALF_UP);
        boolean bl = sizeError = tmp.precision() > totalDigits;
        if (!sizeError) {
            this.decimal = tmp.scale() >= this.decimal.scale() ? tmp.round(mc) : tmp;
        }
        return sizeError;
    }

    public boolean truncatePreserve(int totalDigits, int decimalPlaces) {
        boolean sizeError;
        if (totalDigits <= 0) {
            return true;
        }
        BigDecimal tmp = this.decimal.setScale(decimalPlaces, RoundingMode.DOWN);
        boolean bl = sizeError = tmp.precision() > totalDigits;
        if (!sizeError) {
            MathContext mc = new MathContext(totalDigits, RoundingMode.DOWN);
            this.decimal = tmp.round(mc);
        }
        return sizeError;
    }

    public boolean truncatePreserveOnFalse(int totalDigits, int decimalPlaces) {
        boolean sizeError;
        if (totalDigits <= 0) {
            return true;
        }
        BigDecimal tmp = this.decimal.setScale(decimalPlaces, RoundingMode.DOWN);
        boolean bl = sizeError = tmp.precision() > totalDigits;
        if (!sizeError) {
            MathContext mc = new MathContext(totalDigits, RoundingMode.DOWN);
            this.decimal = tmp.round(mc);
        }
        return sizeError;
    }

    public boolean round(int totalDigits, int decimalPlaces) {
        if (totalDigits <= 0) {
            this.decimal = BigDecimal.ZERO;
            return true;
        }
        BigDecimal tmp = this.decimal.setScale(decimalPlaces, RoundingMode.HALF_UP);
        boolean sizeError = tmp.precision() > totalDigits;
        MathContext mc = new MathContext(totalDigits, RoundingMode.HALF_UP);
        if (tmp.scale() >= this.decimal.scale()) {
            tmp = tmp.round(mc);
        }
        if (sizeError) {
            int intlen;
            boolean negate;
            String str;
            if (tmp.signum() < 0) {
                str = tmp.negate().toPlainString();
                negate = true;
            } else {
                str = tmp.toPlainString();
                negate = false;
            }
            int dp = str.indexOf(46);
            if (dp == -1) {
                dp = str.length();
            }
            if ((intlen = totalDigits - decimalPlaces) < dp) {
                str = str.substring(dp - intlen);
                tmp = new BigDecimal(str, mc).setScale(decimalPlaces, RoundingMode.DOWN);
                if (negate) {
                    tmp = tmp.negate();
                }
            }
        }
        this.decimal = tmp;
        return sizeError;
    }

    public boolean truncate(int totalDigits, int decimalPlaces) {
        boolean sizeError;
        if (totalDigits <= 0) {
            this.decimal = BigDecimal.ZERO;
            return true;
        }
        BigDecimal tmp = this.decimal.setScale(decimalPlaces, RoundingMode.DOWN);
        boolean bl = sizeError = tmp.precision() > totalDigits;
        if (sizeError) {
            int intlen;
            boolean negate;
            String str;
            if (tmp.signum() < 0) {
                str = tmp.negate().toPlainString();
                negate = true;
            } else {
                str = tmp.toPlainString();
                negate = false;
            }
            int dp = str.indexOf(46);
            if (dp == -1) {
                dp = str.length();
            }
            if ((intlen = totalDigits - decimalPlaces) < dp) {
                str = str.substring(dp - intlen);
                MathContext mc = new MathContext(totalDigits, RoundingMode.DOWN);
                tmp = new BigDecimal(str, mc).setScale(decimalPlaces, RoundingMode.DOWN);
                if (negate) {
                    tmp = tmp.negate();
                }
            }
        }
        this.decimal = tmp;
        return sizeError;
    }

    public void truncateBinary(int itemSize, boolean signed) {
        long longVal = this.decimal.unscaledValue().longValue();
        if (signed) {
            switch (itemSize) {
                case 1: {
                    if ((longVal & 0x80L) == 128L) {
                        longVal |= 0xFFFFFFFFFFFFFF80L;
                        break;
                    }
                    longVal &= 0x7FL;
                    break;
                }
                case 2: {
                    if ((longVal & 0x8000L) == 32768L) {
                        longVal |= 0xFFFFFFFFFFFF8000L;
                        break;
                    }
                    longVal &= 0x7FFFL;
                    break;
                }
                case 3: {
                    if ((longVal & 0x800000L) == 0x800000L) {
                        longVal |= 0xFFFFFFFFFF800000L;
                        break;
                    }
                    longVal &= 0x7FFFFFL;
                    break;
                }
                case 4: {
                    if ((longVal & 0x80000000L) == 0x80000000L) {
                        longVal |= Integer.MIN_VALUE;
                        break;
                    }
                    longVal &= Integer.MAX_VALUE;
                    break;
                }
                case 5: {
                    if ((longVal & 0x8000000000L) == 0x8000000000L) {
                        longVal |= 0xFFFFFF8000000000L;
                        break;
                    }
                    longVal &= 0x7FFFFFFFFFL;
                    break;
                }
                case 6: {
                    if ((longVal & 0x800000000000L) == 0x800000000000L) {
                        longVal |= 0xFFFF800000000000L;
                        break;
                    }
                    longVal &= 0x7FFFFFFFFFFFL;
                    break;
                }
                case 7: {
                    if ((longVal &= 0x80000000000000L) == 0x80000000000000L) {
                        longVal |= 0xFF80000000000000L;
                        break;
                    }
                    longVal &= 0x7FFFFFFFFFFFFFL;
                }
            }
        } else {
            longVal = Math.abs(longVal);
            switch (itemSize) {
                case 1: {
                    longVal &= 0xFFL;
                    break;
                }
                case 2: {
                    longVal &= 0xFFFFL;
                    break;
                }
                case 3: {
                    longVal &= 0xFFFFFFL;
                    break;
                }
                case 4: {
                    longVal &= 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                case 5: {
                    longVal &= 0xFFFFFFFFFFL;
                    break;
                }
                case 6: {
                    longVal &= 0xFFFFFFFFFFFFL;
                    break;
                }
                case 7: {
                    longVal &= 0xFFFFFFFFFFFFFFL;
                }
            }
        }
        int scale = this.decimal.scale();
        this.decimal = new BigDecimal(longVal).scaleByPowerOfTen(-scale);
    }

    public void floor() {
        this.decimal = this.decimal.setScale(0, RoundingMode.FLOOR);
    }

    public void ceil() {
        this.decimal = this.decimal.setScale(0, RoundingMode.CEILING);
    }

    public boolean isiAmNotNumeric() {
        return this.iAmNotNumeric;
    }

    public void setiAmNotNumeric(boolean iAmNotNumeric) {
        this.iAmNotNumeric = iAmNotNumeric;
    }

    public void setNumericValidate(boolean numcheck) {
        this.requireNumericValidate = numcheck;
    }

    public boolean requiresNumericValidate() {
        return this.requireNumericValidate;
    }

    static {
        computeCalc = false;
    }

    public static enum InternalRep {
        DisplayA,
        DisplayH,
        DisplayMVS,
        DisplayP;

    }
}

