/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Utilities;
import java.awt.Color;
import java.awt.SystemColor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class ColorProvider {
    private static Hashtable<String, Object> colorNames;
    private static final int OFF = 0;
    private static final int LO = 85;
    private static final int MID = 127;
    private static final int HI = 192;
    private static final int ALL = 255;

    private static void initializeColorNames() {
        colorNames = new Hashtable();
        Object[] list = new Object[]{"DARK-GREY", Color.darkGray, "DARKGREY", Color.darkGray, "GREY", Color.gray, "LIGHT-GREY", Color.lightGray, "LIGHTGREY", Color.lightGray, "ACTIVE-CAPTION", SystemColor.activeCaption, "ACTIVE-CAPTION-BORDER", SystemColor.activeCaptionBorder, "ACTIVE-CAPTION-TEXT", SystemColor.activeCaptionText, "CONTROL", SystemColor.control, "CONTROL-DARK-SHADOW", SystemColor.controlDkShadow, "CONTROL-HIGHLIGHT", SystemColor.controlHighlight, "CONTROL-LIGHT-HIGHLIGHT", SystemColor.controlLtHighlight, "CONTROL-SHADOW", SystemColor.controlShadow, "CONTROL-TEXT", SystemColor.controlText, "DESKTOP", SystemColor.desktop, "INACTIVE-CAPTION", SystemColor.inactiveCaption, "INACTIVE-CAPTION-BORDER", SystemColor.inactiveCaptionBorder, "INACTIVE-CAPTION-TEXT", SystemColor.inactiveCaptionText, "INFO", SystemColor.info, "INFO-TEXT", SystemColor.infoText, "MENU", SystemColor.menu, "MENU-TEXT", SystemColor.menuText, "SCROLLBAR", SystemColor.scrollbar, "TEXT-HIGHLIGHT", SystemColor.textHighlight, "TEXT-HIGHLIGHT-TEXT", SystemColor.textHighlightText, "TEXT-INACTIVE-TEXT", SystemColor.textInactiveText, "TEXT-TEXT", SystemColor.textText, "WINDOW", SystemColor.window, "WINDOW-BORDER", SystemColor.windowBorder, "WINDOW-TEXT", SystemColor.windowText, "BLACK", new Color(0, 0, 0), "DARK BLUE", new Color(0, 0, 127), "DARK GREEN", new Color(0, 127, 0), "DARK CYAN", new Color(0, 127, 127), "DARK RED", new Color(127, 0, 0), "DARK MAGENTA", new Color(127, 0, 127), "BROWN", new Color(127, 127, 0), "DARK GRAY", new Color(85, 85, 85), "LIGHT GRAY", new Color(192, 192, 192), "BLUE", new Color(0, 0, 255), "GREEN", new Color(0, 255, 0), "CYAN", new Color(0, 255, 255), "RED", new Color(255, 0, 0), "MAGENTA", new Color(255, 0, 255), "YELLOW", new Color(255, 255, 0), "WHITE", new Color(255, 255, 255), "GRAY", new Color(128, 128, 128), "MAROON", new Color(128, 0, 0), "PURPLE", new Color(128, 0, 128), "OLIVE", new Color(128, 128, 0), "NAVY", new Color(0, 0, 128), "TEAL", new Color(0, 128, 128), "SILVER", new Color(192, 192, 192), "FUCHSIA", new Color(255, 0, 255), "LIME", new Color(0, 255, 0), "AQUA", new Color(0, 255, 255), "BLACK", Color.black, "BLUE", Color.blue, "CYAN", Color.cyan, "DARKGRAY", Color.darkGray, "GRAY", Color.gray, "GREEN", Color.green, "LIGHTGRAY", Color.lightGray, "MAGENTA", Color.magenta, "ORANGE", Color.orange, "PINK", Color.pink, "RED", Color.red, "WHITE", Color.white, "YELLOW", Color.yellow};
        int listLength = list.length;
        String name = null;
        try {
            for (int i = 0; i < listLength; i += 2) {
                name = (String)list[i];
                if (name == null) continue;
                name = name.trim().toUpperCase().replace('-', ' ').replace('_', ' ');
                if (!(list[i + 1] instanceof Color)) continue;
                colorNames.put(name, list[i + 1]);
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        try {
            InputStream is;
            String param = RuntimeEnvironment.getGlobalParameter("RGB.TXT");
            if (param == null) {
                param = "rgb.txt";
            }
            if ((is = Utilities.getInputStream(param)) == null) {
                try {
                    File f;
                    if (File.separatorChar == '/' && (f = new File("/usr/lib/X11/rgb.txt")).exists()) {
                        is = new FileInputStream(f.toString());
                    }
                }
                catch (RuntimeException f) {
                    // empty catch block
                }
            }
            if (is != null) {
                BufferedReader d = new BufferedReader(new InputStreamReader(is));
                String line = null;
                do {
                    if ((line = d.readLine()) != null) {
                        line = line.trim();
                    }
                    if (line == null || line.length() <= 0 || line.startsWith("#")) continue;
                    try {
                        line = line.trim();
                        int comma = line.indexOf(32);
                        if (comma < 0) continue;
                        String redString = line.substring(0, comma).trim();
                        if ((comma = (line = line.substring(comma + 1).trim()).indexOf(32)) < 0) continue;
                        String greenString = line.substring(0, comma).trim();
                        if ((comma = (line = line.substring(comma + 1).trim()).indexOf(32)) < 0) continue;
                        String blueString = line.substring(0, comma).trim();
                        line = line.substring(comma + 1).trim();
                        int r = Integer.parseInt(redString);
                        int g = Integer.parseInt(greenString);
                        int b = Integer.parseInt(blueString);
                        line = line.trim().toUpperCase().replace('-', ' ').replace('_', ' ');
                        Color c = new Color(r, g, b);
                        colorNames.put(line, c);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } while (line != null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Color getColor(String name) {
        return ColorProvider.getColor(name, 1.0);
    }

    public static Color getColor(String name, double percentage) {
        try {
            if (name == null) {
                return null;
            }
            if ((name = name.trim()).startsWith("(")) {
                try {
                    name = name.substring(1);
                    if (name.endsWith(")")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    name = name.trim();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                if (name.startsWith("#")) {
                    if ((name = name.substring(1)).length() == 3) {
                        return new Color((int)((double)Integer.parseInt(name.substring(0, 1), 16) * percentage), (int)((double)Integer.parseInt(name.substring(1, 2), 16) * percentage), (int)((double)Integer.parseInt(name.substring(2), 16) * percentage));
                    }
                    if (name.length() == 6) {
                        return new Color((int)((double)Integer.parseInt(name.substring(0, 2), 16) * percentage), (int)((double)Integer.parseInt(name.substring(2, 4), 16) * percentage), (int)((double)Integer.parseInt(name.substring(4, 6), 16) * percentage));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int comma2;
                int comma = name.indexOf(44);
                if (comma >= 0 && (comma2 = name.indexOf(44, comma + 1)) >= 0) {
                    String red = name.substring(0, comma).trim();
                    String green = name.substring(comma + 1, comma2).trim();
                    String blue = name.substring(comma2 + 1).trim();
                    int comma3 = blue.indexOf(44);
                    if (comma3 >= 0) {
                        blue = blue.substring(0, comma3).trim();
                    }
                    int R = Integer.parseInt(red);
                    int G = Integer.parseInt(green);
                    int B = Integer.parseInt(blue);
                    return new Color((int)((double)R * percentage), (int)((double)G * percentage), (int)((double)B * percentage));
                }
            }
            catch (Exception comma) {
                // empty catch block
            }
            if (colorNames == null) {
                ColorProvider.initializeColorNames();
            }
            if (colorNames != null) {
                String triple;
                Color c = (Color)colorNames.get(name = name.toUpperCase().replace('-', ' ').replace('_', ' '));
                if (c == null && (triple = RuntimeEnvironment.getGlobalParameter(name)) != null) {
                    triple = triple.trim();
                    int r = -1;
                    int g = -1;
                    int b = -1;
                    if (triple.startsWith("#")) {
                        r = Integer.parseInt(triple.substring(1, 3), 16);
                        g = Integer.parseInt(triple.substring(3, 5), 16);
                        b = Integer.parseInt(triple.substring(5));
                    } else {
                        int comma1 = triple.indexOf(44);
                        if (comma1 < 0) {
                            comma1 = triple.indexOf(32);
                        }
                        if (comma1 >= 0) {
                            int comma2 = triple.indexOf(44, comma1 + 1);
                            if (comma2 < 0) {
                                comma2 = triple.indexOf(32);
                            }
                            if (comma2 >= 0) {
                                r = Integer.parseInt(triple.substring(0, comma1).trim());
                                g = Integer.parseInt(triple.substring(comma1, comma2).trim());
                                b = Integer.parseInt(triple.substring(comma2).trim());
                            }
                        }
                    }
                    if (r >= 0 && g >= 0 && b >= 0 && r <= 255 && g <= 255 && b <= 255) {
                        c = new Color(r, g, b);
                        colorNames.put(name, c);
                    }
                }
                if (c != null) {
                    if (percentage == 1.0) {
                        return c;
                    }
                    int pr = (int)((double)c.getRed() * percentage);
                    int pg = (int)((double)c.getGreen() * percentage);
                    int pb = (int)((double)c.getBlue() * percentage);
                    if (pr < 0) {
                        pr = 0;
                    }
                    if (pg < 0) {
                        pg = 0;
                    }
                    if (pb < 0) {
                        pb = 0;
                    }
                    if (pr > 255) {
                        pr = 255;
                    }
                    if (pg > 255) {
                        pg = 255;
                    }
                    if (pb > 255) {
                        pb = 255;
                    }
                    return new Color(pr, pg, pb);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

