/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.Cache;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Comp2;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.Index;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.ZonedDescription;
import com.heirloomcomputing.ecs.exec.comparableByteArray;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Comp1
extends Numeric
implements Cloneable,
comparableByteArray {
    static final long serialVersionUID = 1L;
    private static boolean displayInternal = false;
    protected float floatValue = 0.0f;
    private static boolean reverse;
    private static boolean mvs370;
    private static final NumberFormat DEFAULT_FORMAT;
    private NumberFormat numberFormat;

    @Override
    public String getClassName() {
        return "com.heirloomcomputing.ecs.exec.Comp1";
    }

    @Override
    public String getUsage() {
        return "Comp1";
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public int getStorageClass() {
        return 1;
    }

    @Override
    protected int canStore(String value) {
        return 0;
    }

    @Override
    public boolean isNaN() {
        this.updateFromMemory(false);
        return Float.isNaN(this.floatValue);
    }

    @Override
    public boolean isNegativeInfinity() {
        this.updateFromMemory(false);
        return this.floatValue == Float.NEGATIVE_INFINITY;
    }

    @Override
    public void setNegativeInfinity() {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = Float.NEGATIVE_INFINITY;
        this.updateToMemory();
    }

    @Override
    public boolean isPositiveInfinity() {
        this.updateFromMemory(false);
        return this.floatValue == Float.POSITIVE_INFINITY;
    }

    @Override
    public void setPositiveInfinity() {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = Float.POSITIVE_INFINITY;
        this.updateToMemory();
    }

    @Override
    public boolean isInfinite() {
        return Float.isInfinite(this.floatValue);
    }

    @Override
    public void setInfinite() {
        this.setPositiveInfinity();
    }

    @Override
    public Numeric negate() {
        this.updateFromMemory(false);
        return new Numeric(-this.floatValue);
    }

    @Override
    public boolean isZero() {
        this.updateFromMemory(false);
        return this.floatValue == 0.0f;
    }

    @Override
    public int compareZero() {
        this.updateFromMemory(false);
        if (this.floatValue < 0.0f) {
            return -1;
        }
        if (this.floatValue > 0.0f) {
            return 1;
        }
        return 0;
    }

    @Override
    public comparableByteArray copy() {
        return super.copyVariable();
    }

    @Override
    public final Numeric odoNumeric() {
        Variable odo = this.findOdo();
        if (odo != null) {
            int newSize = odo.itemSize * odo.occurs();
            odo = odo.parent;
            int difference = newSize - odo.itemSize;
            odo.itemSize = newSize;
            odo = odo.parent;
            while (odo != null) {
                odo.itemSize += (difference *= odo.maxIndex);
                odo = odo.parent;
            }
        }
        return this;
    }

    public Comp1() {
        this.maxIndex = 1;
        this.itemSize = 4;
    }

    public Comp1(float param) {
        this((double)param);
    }

    public Comp1(double param) {
        this.itemSize = 4;
        this.pointerMemory = new Memory(this.itemSize, new String[0]);
        this.pointerAddress = 0;
        this.picLength = this.itemSize;
        this.move(param);
    }

    @Override
    public int getUsageNumber() {
        return 1;
    }

    public static void setDatatype(int type) {
        switch (type) {
            case 0: {
                reverse = false;
                mvs370 = false;
                break;
            }
            case 1: {
                reverse = true;
                mvs370 = false;
                break;
            }
            case 2: {
                reverse = false;
                mvs370 = false;
                break;
            }
            case 3: {
                reverse = false;
                mvs370 = true;
            }
        }
    }

    @Override
    public final void fillFromMemory() {
        if (Cache.standard) {
            if (this.alwaysFlush) {
                return;
            }
            if (this.notify != null) {
                this.notify.flushToMemory();
            } else if (this.pointerMemory != null) {
                this.pointerMemory.flushToMemory(this, true);
            }
            this.fillFromMemoryNow();
        } else if (!this.valid) {
            if (this.redefinedFrom != null) {
                ++ModifyOnce;
                if (this.redefinedFrom.dirty) {
                    this.redefinedFrom.flushDirtyToMemory();
                } else {
                    this.redefinedFrom.cleanChildren(true);
                }
            }
            this.fillFromMemoryNow();
            this.valid = true;
            this.dirty = false;
        }
    }

    @Override
    public final void flushDirtyToMemory() {
        if (Cache.standard) {
            this.numericString = null;
            if (this.alwaysFlush) {
                return;
            }
            this.dirty = false;
            this.flushToMemoryNow();
        } else if (Cache.forbid) {
            if (this.dirty && !this.valid) {
                this.flushToMemoryNow();
            } else if (!this.dirty) {
                this.cleanAncestors();
            } else {
                this.flushToMemoryNow();
                this.dirty = false;
            }
        }
    }

    @Override
    public final void flushToMemory() {
        if (Cache.standard) {
            this.numericString = null;
            if (this.alwaysFlush) {
                return;
            }
            if (!this.dirty) {
                if (this.notify != null) {
                    this.notify.flushToMemory();
                } else if (this.pointerMemory != null) {
                    this.pointerMemory.flushToMemory(this, false);
                }
                return;
            }
            this.dirty = false;
            this.flushToMemoryNow();
        } else if (this.dirty && !this.valid) {
            this.flushToMemoryNow();
            this.dirty = false;
            this.valid = true;
        } else if (!this.dirty) {
            this.cleanAncestors();
        } else {
            this.flushToMemoryNow();
            this.dirty = false;
        }
    }

    public void fillFromMemoryNow() {
        try {
            this.floatValue = mvs370 ? this.pointerMemory.getFloat370(this.pointerAddress) : (reverse ? this.pointerMemory.getFloatReverse(this.pointerAddress) : this.pointerMemory.getFloat(this.pointerAddress));
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in COMP-1 retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    public void flushToMemoryNow() {
        try {
            if (mvs370) {
                this.pointerMemory.setFloat370(this.pointerAddress, this.floatValue);
            } else if (reverse) {
                this.pointerMemory.setFloatReverse(this.pointerAddress, this.floatValue);
            } else {
                this.pointerMemory.setFloat(this.pointerAddress, this.floatValue);
            }
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in COMP-1 storage of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public final void updateFromMemory(boolean andMarkDirty) {
        if (Cache.standard) {
            if (this.alwaysFlush || andMarkDirty && !this.dirty || !andMarkDirty && !this.valid) {
                this.fillFromMemoryNow();
                if (andMarkDirty) {
                    this.setDirty();
                } else {
                    this.setValid();
                }
            }
        } else if (!this.valid) {
            if (this.redefinedFrom != null) {
                ++ModifyOnce;
                if (this.redefinedFrom.dirty) {
                    this.redefinedFrom.flushDirtyToMemory();
                } else {
                    this.redefinedFrom.cleanChildren(true);
                }
            }
            this.fillFromMemoryNow();
            this.valid = true;
            this.dirty = false;
        }
    }

    public final void updateToMemory() {
        if (this.signPosition == 0 && this.value.makeUnsignedCheck()) {
            this.numericString = null;
        }
        if (Cache.standard) {
            this.flushToMemoryNow();
        } else {
            this.valid = true;
            this.dirty = true;
        }
        if ((this.flagBits & 0x10000) != 0) {
            this.odoslide();
        }
    }

    @Override
    public final Numeric add(int param) {
        this.updateFromMemory(true);
        this.floatValue += (float)param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric add(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.floatValue += param.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric add(Bignum param) {
        this.updateFromMemory(true);
        this.floatValue += param.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable add(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() + param2.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable add(Bignum param1, Numeric param2) {
        if (param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() + param2.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable add(Numeric param1, Bignum param2) {
        if (param1.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() + param2.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable add(Bignum param1, Bignum param2) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() + param2.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric addRounded(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.floatValue += param.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric addRounded(Bignum param) {
        this.updateFromMemory(true);
        this.floatValue += param.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable addRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() + param2.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable addRounded(Bignum param1, Numeric param2) {
        if (param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() + param2.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable addRounded(Numeric param1, Bignum param2) {
        if (param1.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() + param2.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable addRounded(Bignum param1, Bignum param2) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() + param2.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric sub(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.floatValue -= param.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric sub(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() - param2.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric subRounded(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.floatValue -= param.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric subRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() - param2.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric mul(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.floatValue *= param.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric mul(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() * param2.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric mulRounded(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.floatValue *= param.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric mulRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() * param2.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric div(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        float paramn = param.toFloat();
        if (paramn == 0.0f) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.floatValue /= paramn;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric div(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        float param2n = param2.toFloat();
        if (param2n == 0.0f) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() / param2n;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric divRounded(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        float paramn = param.toFloat();
        if (paramn == 0.0f) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.floatValue /= paramn;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric divRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        float param2n = param2.toFloat();
        if (param2n == 0.0f) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toFloat() / param2n;
        this.updateToMemory();
        return this;
    }

    public final Numeric idiv(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        long paramn = param.toLong();
        if (paramn == 0L) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.floatValue = (long)this.floatValue / paramn;
        this.updateToMemory();
        return this;
    }

    public final Numeric idiv(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        long param2n = param2.toLong();
        if (param2n == 0L) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toLong() / param2n;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric mod(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        long paramn = param.toLong();
        if (paramn == 0L) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.floatValue = (long)this.floatValue % paramn;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric mod(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        long param2n = param2.toLong();
        if (param2n == 0L) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param1.toLong() % param2n;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric pow(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        float paramn = param.toFloat();
        if (this.floatValue == 0.0f && paramn == 0.0f) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.floatValue = (float)Math.pow(this.floatValue, paramn);
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric pow(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        float param1n = param1.toFloat();
        float param2n = param2.toFloat();
        if (param1n == 0.0f && param2n == 0.0f) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = (float)Math.pow(param1n, param2n);
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric powRounded(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        float paramn = param.toFloat();
        if (this.floatValue == 0.0f && paramn == 0.0f) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.floatValue = (float)Math.pow(this.floatValue, paramn);
        this.updateToMemory();
        return this;
    }

    @Override
    public final Numeric powRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        float param1n = param1.toFloat();
        float param2n = param2.toFloat();
        if (param1n == 0.0f && param2n == 0.0f) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = (float)Math.pow(param1n, param2n);
        this.updateToMemory();
        return this;
    }

    @Override
    public int compare(Numeric param) {
        this.updateFromMemory(false);
        float paramn = param.toFloat();
        if (this.floatValue < paramn) {
            return -1;
        }
        if (this.floatValue > paramn) {
            return 1;
        }
        return 0;
    }

    @Override
    public final int compare(Numeric param, String alphabet) {
        return this.compare(param);
    }

    @Override
    public final int compare(Index i) {
        this.updateFromMemory(false);
        int v = (int)this.floatValue;
        if (v < i.toInt()) {
            return -1;
        }
        if (v > i.toInt()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compare(Variable param) {
        float thatValue = param.toFloat();
        this.updateFromMemory(false);
        if (this.floatValue < thatValue) {
            return -1;
        }
        if (this.floatValue > thatValue) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compare(Comp1 param) {
        float thatValue = param.toFloat();
        this.updateFromMemory(false);
        if (this.floatValue < thatValue) {
            return -1;
        }
        if (this.floatValue > thatValue) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compare(Comp2 param) {
        int rc = param.compare(this);
        if (rc < 0) {
            return 1;
        }
        if (rc > 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public final char toChar() {
        this.updateFromMemory(false);
        return (char)this.floatValue;
    }

    @Override
    public final byte toByte() {
        this.updateFromMemory(false);
        return (byte)this.floatValue;
    }

    @Override
    public final short toShort() {
        this.updateFromMemory(false);
        return (short)this.floatValue;
    }

    @Override
    public final int toInt() {
        this.updateFromMemory(false);
        return (int)this.floatValue;
    }

    @Override
    public final long toLong() {
        this.updateFromMemory(false);
        return (long)this.floatValue;
    }

    @Override
    public final String toString() {
        return this.getString();
    }

    @Override
    public final Bignum toBignum() {
        this.updateFromMemory(false);
        return new Bignum(this.floatValue);
    }

    @Override
    public final Bignum toModifyBignum() {
        this.updateFromMemory(false);
        return new Bignum(this.floatValue);
    }

    @Override
    public final float toFloat() {
        this.updateFromMemory(false);
        return this.floatValue;
    }

    @Override
    public final double toDouble() {
        this.updateFromMemory(false);
        return this.floatValue;
    }

    @Override
    public final boolean toBoolean() {
        this.updateFromMemory(false);
        return (double)this.floatValue != 0.0;
    }

    @Override
    public final Variable move(char param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable move(byte param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable move(short param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable move(int param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable move(long param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable move(String param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        try {
            this.floatValue = (float)Double.valueOf(this.massageFloatString(param)).doubleValue();
        }
        catch (Exception e) {
            this.floatValue = 0.0f;
        }
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable move(Bignum param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param.floatValue();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable move(float param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable move(double param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = (float)param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable move(Numeric param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable move(Variable param) {
        if (param.getChild() != null || param.isGroupMove()) {
            String paramString = param.toString();
            if (this.isJustRight()) {
                if (paramString.length() > this.itemSize) {
                    this.setString(paramString.substring(paramString.length() - this.itemSize));
                } else {
                    this.setString(Comp1.all(' ', this.itemSize - paramString.length()) + paramString);
                }
            } else if (paramString.length() > this.itemSize) {
                this.setString(paramString.substring(0, this.itemSize));
            } else {
                this.setString(paramString + Comp1.all(' ', this.itemSize - paramString.length()));
            }
            this.dirty = false;
            this.valid = false;
        } else {
            this.move(param.toString());
        }
        return this;
    }

    @Override
    public final Variable moveSE(char param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(byte param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(short param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(int param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(long param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(String param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        try {
            this.floatValue = (float)Double.valueOf(this.massageFloatString(param)).doubleValue();
        }
        catch (Exception e) {
            this.floatValue = 0.0f;
            this.setSizeError();
        }
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(Bignum param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param.floatValue();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(float param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(double param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = (float)param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(Variable param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.move(param.toString());
        return this;
    }

    @Override
    public final Variable moveSER(char param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(byte param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(short param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(int param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(long param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(String param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        try {
            this.floatValue = (float)Double.valueOf(this.massageFloatString(param)).doubleValue();
        }
        catch (Exception e) {
            this.floatValue = 0.0f;
            this.setSizeError();
        }
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(Bignum param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param.floatValue();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(float param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(double param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = (float)param;
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param.toFloat();
        this.updateToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(Variable param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.move(param.toString());
        return this;
    }

    @Override
    public final Variable moveR(Bignum param) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = param.floatValue();
        this.updateToMemory();
        return this;
    }

    @Override
    public final String toNumericString() {
        this.updateFromMemory(false);
        return Float.toString(this.floatValue);
    }

    @Override
    public final String toScalelessString() {
        this.updateFromMemory(false);
        return new Float(this.floatValue).toString();
    }

    @Override
    public final boolean isAlphabetic() {
        return false;
    }

    @Override
    public final boolean isAlphabeticUpper() {
        return false;
    }

    @Override
    public final boolean isAlphabeticLower() {
        return false;
    }

    @Override
    public boolean isNumeric(ZonedDescription zonedDescription) {
        return true;
    }

    private NumberFormat calculateDisplayFormat() {
        int i;
        char[] pic = this.getPictureArray();
        if (pic == null) {
            return DEFAULT_FORMAT;
        }
        StringBuffer pattern = new StringBuffer();
        int c = 0;
        int lc = 0;
        int length = pic.length;
        boolean signed = false;
        boolean positiveShown = false;
        boolean decimalFound = false;
        int countPlace = this.place;
        if (countPlace == 0) {
            countPlace = -1;
        }
        int rep = 0;
        boolean implicitDecimal = true;
        block16: for (i = 0; i < length; ++i) {
            switch (pic[i]) {
                case 'E': {
                    implicitDecimal = false;
                    continue block16;
                }
                case '.': 
                case 'V': {
                    implicitDecimal = false;
                }
            }
        }
        for (i = 0; i < length; ++i) {
            block18: do {
                if (rep > 1) {
                    --rep;
                    c = lc;
                } else {
                    lc = c;
                    c = Character.toUpperCase(pic[i]);
                }
                switch (c) {
                    case 90: {
                        if (!decimalFound) {
                            --countPlace;
                        }
                        pattern.append('#');
                        if (!implicitDecimal || countPlace != 0) continue block18;
                        pattern.append('.');
                        --countPlace;
                        break;
                    }
                    case 57: {
                        if (!decimalFound) {
                            --countPlace;
                        }
                        pattern.append('0');
                        if (!implicitDecimal || countPlace != 0) continue block18;
                        pattern.append('.');
                        --countPlace;
                        break;
                    }
                    case 46: 
                    case 86: {
                        pattern.append('.');
                        c = 86;
                        break;
                    }
                    case 44: {
                        pattern.append(',');
                        break;
                    }
                    case 69: {
                        pattern.append('E');
                        break;
                    }
                    case 37: {
                        pattern.append('%');
                        break;
                    }
                    case 43: {
                        positiveShown = true;
                    }
                    case 45: {
                        signed = true;
                        break;
                    }
                    case 41: {
                        break;
                    }
                    case 40: {
                        rep = 0;
                        do {
                            if ((c = pic[++i]) < 48 || c > 57) continue;
                            rep *= 10;
                            rep += c - 48;
                        } while (c != 41 && i < length);
                        if (lc != 86) continue block18;
                        lc = 57;
                        pattern.append('0');
                        break;
                    }
                    default: {
                        pattern.append('\'').append((char)c).append('\'');
                    }
                }
            } while (rep > 1);
        }
        String patternString = pattern.toString();
        this.numberFormat = new DecimalFormat(patternString);
        if (positiveShown) {
            ((DecimalFormat)this.numberFormat).setPositivePrefix("+");
        } else if (signed) {
            ((DecimalFormat)this.numberFormat).setPositivePrefix(" ");
        } else {
            ((DecimalFormat)this.numberFormat).setPositivePrefix("");
        }
        return this.numberFormat;
    }

    @Override
    public String toDisplayString() {
        if (displayInternal) {
            return this.toString();
        }
        this.updateFromMemory(false);
        if (this.numberFormat == null) {
            this.numberFormat = this.calculateDisplayFormat();
        }
        if (this.numberFormat == DEFAULT_FORMAT) {
            return String.valueOf(this.floatValue);
        }
        return this.numberFormat.format(this.floatValue);
    }

    @Override
    public String toInspectString() {
        return this.toDisplayString();
    }

    @Override
    public int getAcceptSize() {
        return 80;
    }

    @Override
    protected final String toCompareString() {
        this.updateFromMemory(false);
        String floatValueString = String.valueOf(this.floatValue);
        int i = floatValueString.indexOf(46);
        if (i > 0) {
            floatValueString = floatValueString.substring(0, i);
        } else if (i == 0) {
            floatValueString = "0";
        }
        i = floatValueString.indexOf(101);
        if (i > 0) {
            floatValueString = floatValueString.substring(0, i);
        } else if (i == 0) {
            floatValueString = "0";
        }
        i = floatValueString.indexOf(69);
        if (i > 0) {
            floatValueString = floatValueString.substring(0, i);
        } else if (i == 0) {
            floatValueString = "0";
        }
        if (memoryCharset != null) {
            floatValueString = new String(floatValueString.getBytes(memoryCharset), defaultCharset);
        }
        return floatValueString;
    }

    @Override
    public int getArgumentType() {
        return 23;
    }

    @Override
    public byte[] getArgument() {
        this.updateFromMemory(false);
        return ConvertData.nativeIntToBytes(Float.floatToIntBits(this.floatValue));
    }

    @Override
    public void setArgument(byte[] data) {
        if (!this.dirty) {
            this.setDirtyNoFill();
        }
        this.floatValue = Float.intBitsToFloat(ConvertData.nativeBytesToInt(data));
        this.updateToMemory();
    }

    @Override
    public Object getObjectParameter() {
        return new Float(this.toFloat());
    }

    @Override
    public Object getSqlObject() {
        this.updateFromMemory(false);
        return new Float(this.floatValue);
    }

    @Override
    public Object getSqlObject(boolean trim) {
        return this.getSqlObject();
    }

    @Override
    public int getType() {
        return this.getBasicType(112);
    }

    @Override
    public void initData() {
        this.pointerMemory.setFloat(this.pointerAddress, 0.0f);
    }

    static {
        String displaytype = RuntimeEnvironment.getGlobalParameter("display.1");
        if (displaytype != null && displaytype.length() > 0) {
            switch (displaytype.charAt(0)) {
                case 'I': 
                case 'i': {
                    displayInternal = true;
                    break;
                }
            }
        }
        reverse = false;
        mvs370 = false;
        DEFAULT_FORMAT = new DecimalFormat();
    }
}

