/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.BignumType;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public class CompD
extends BignumType
implements Cloneable,
comparableByteArray {
    private static boolean displayInternal = false;
    public static final String positiveDigits;
    public static final String unsignedDigits;
    public static final String negativeDigits;
    public static char positiveChar;
    public static final char negativeChar = '\r';
    public static final char decimalChar = '.';
    public static byte positiveByte;
    public static final byte negativeByte = 13;
    public static final byte decimalByte = 46;
    public static final char[] positiveArray;
    public static final char[] unsignedArray;
    public static final char[] negativeArray;
    public static final byte[] positiveByteArray;
    public static final byte[] unsignedByteArray;
    public static final byte[] negativeByteArray;
    private static final char[] indexPositive;
    private static final char[] indexNegative;

    @Override
    public final String getClassName() {
        return "com.heirloomcomputing.ecs.exec.CompD";
    }

    @Override
    public final String getUsage() {
        return "CompD";
    }

    public static void setDatatype(int n) {
        int i;
        switch (n) {
            default: {
                positiveChar = (char)11;
                positiveByte = (byte)11;
                break;
            }
            case 1: {
                positiveChar = (char)12;
                positiveByte = (byte)12;
            }
        }
        for (i = 0; i < 256; ++i) {
            CompD.indexPositive[i] = '\u0000';
            CompD.indexNegative[i] = '\u0000';
        }
        int length = positiveDigits.length();
        for (i = 0; i < length; ++i) {
            CompD.indexPositive[CompD.positiveDigits.charAt((int)i)] = (char)(i + 48);
            CompD.positiveArray[i] = positiveDigits.charAt(i);
            CompD.positiveByteArray[i] = (byte)positiveDigits.charAt(i);
        }
        length = unsignedDigits.length();
        for (i = 0; i < length; ++i) {
            CompD.indexPositive[CompD.unsignedDigits.charAt((int)i)] = (char)(i + 48);
            CompD.unsignedArray[i] = unsignedDigits.charAt(i);
            CompD.unsignedByteArray[i] = (byte)unsignedDigits.charAt(i);
        }
        length = negativeDigits.length();
        for (i = 0; i < length; ++i) {
            CompD.indexNegative[CompD.negativeDigits.charAt((int)i)] = (char)(i + 48);
            CompD.negativeArray[i] = negativeDigits.charAt(i);
            CompD.negativeByteArray[i] = (byte)negativeDigits.charAt(i);
        }
    }

    @Override
    public final Numeric odoNumeric() {
        Variable odo = this.findOdo();
        if (odo != null) {
            int newSize = odo.itemSize * odo.occurs();
            odo = odo.parent;
            int difference = newSize - odo.itemSize;
            odo.itemSize = newSize;
            odo = odo.parent;
            while (odo != null) {
                odo.itemSize += (difference *= odo.maxIndex);
                odo = odo.parent;
            }
        }
        return this;
    }

    @Override
    public int getUsageNumber() {
        return 35;
    }

    @Override
    public final void fillFromMemoryNow() {
        try {
            this.numericString = null;
            int address = this.pointerAddress;
            long result = 0L;
            boolean negative = false;
            int sigDigits = 0;
            block18: for (int i = 0; i < this.length(); ++i) {
                byte bc = this.pointerMemory.getByte(address++);
                switch (bc) {
                    case 0: {
                        continue block18;
                    }
                    default: {
                        --address;
                        sigDigits = this.length() - i;
                        while (i < this.length()) {
                            bc = this.pointerMemory.getByte(address++);
                            switch (bc) {
                                case 13: {
                                    negative = true;
                                    --sigDigits;
                                    break;
                                }
                                case 0: {
                                    result *= 10L;
                                    break;
                                }
                                case 1: {
                                    result *= 10L;
                                    ++result;
                                    break;
                                }
                                case 2: {
                                    result *= 10L;
                                    result += 2L;
                                    break;
                                }
                                case 3: {
                                    result *= 10L;
                                    result += 3L;
                                    break;
                                }
                                case 4: {
                                    result *= 10L;
                                    result += 4L;
                                    break;
                                }
                                case 5: {
                                    result *= 10L;
                                    result += 5L;
                                    break;
                                }
                                case 6: {
                                    result *= 10L;
                                    result += 6L;
                                    break;
                                }
                                case 7: {
                                    result *= 10L;
                                    result += 7L;
                                    break;
                                }
                                case 8: {
                                    result *= 10L;
                                    result += 8L;
                                    break;
                                }
                                case 9: {
                                    result *= 10L;
                                    result += 9L;
                                    break;
                                }
                                default: {
                                    --sigDigits;
                                }
                            }
                            ++i;
                        }
                        break block18;
                    }
                }
            }
            if (this.scale > 0 && this.place == 0) {
                result = (long)((double)result * Math.pow(10.0, this.scale));
            }
            this.value = new Bignum(negative ? -result : result, (int)this.place, sigDigits);
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in COMP-D retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public final void flushToMemoryNow() {
        try {
            byte bignumPlace = this.scale > 0 && this.place == 0 ? this.scale : this.place;
            long result = this.value.getLong(bignumPlace);
            int beginAddress = this.pointerAddress;
            int endAddress = beginAddress + this.length(this.pointerMemory.getTopOfMemory() - beginAddress);
            boolean negative = false;
            if (result < 0L) {
                negative = true;
                result = -result;
            }
            switch (this.signPosition) {
                case 4: {
                    this.pointerMemory.setByte(beginAddress++, negative ? (byte)13 : (byte)positiveByte);
                    while (endAddress > beginAddress) {
                        this.pointerMemory.setByte(--endAddress, unsignedByteArray[(int)(result % 10L)]);
                        result /= 10L;
                    }
                    break;
                }
                case 5: {
                    this.pointerMemory.setByte(--endAddress, negative ? (byte)13 : (byte)positiveByte);
                    while (endAddress > beginAddress) {
                        this.pointerMemory.setByte(--endAddress, unsignedByteArray[(int)(result % 10L)]);
                        result /= 10L;
                    }
                    break;
                }
                case 2: {
                    ++beginAddress;
                    while (endAddress > beginAddress) {
                        this.pointerMemory.setByte(--endAddress, unsignedByteArray[(int)(result % 10L)]);
                        result /= 10L;
                    }
                    this.pointerMemory.setByte(--beginAddress, negative ? negativeByteArray[(int)(result % 10L)] : positiveByteArray[(int)(result % 10L)]);
                    break;
                }
                case 3: {
                    this.pointerMemory.setByte(--endAddress, negative ? negativeByteArray[(int)(result % 10L)] : positiveByteArray[(int)(result % 10L)]);
                    result /= 10L;
                    while (endAddress > beginAddress) {
                        this.pointerMemory.setByte(--endAddress, unsignedByteArray[(int)(result % 10L)]);
                        result /= 10L;
                    }
                    break;
                }
                case 0: {
                    while (endAddress > beginAddress) {
                        this.pointerMemory.setByte(--endAddress, unsignedByteArray[(int)(result % 10L)]);
                        result /= 10L;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in COMP-D storage of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public final String toNumericString() {
        if (!this.dirty) {
            this.updateFromMemory(false);
        }
        if (this.numericString != null) {
            return this.numericString;
        }
        String result = this.value.toString();
        int desiredLength = this.length();
        if (this.signPosition == 4 || this.signPosition == 5) {
            --desiredLength;
        }
        if (result.charAt(0) == '-') {
            int insertLength;
            if ((insertLength = ++desiredLength - result.length()) > 0) {
                int i;
                char[] resultBuffer = new char[desiredLength];
                resultBuffer[0] = 45;
                int length = result.length();
                int count = insertLength + 1;
                for (i = 1; i <= insertLength; ++i) {
                    resultBuffer[i] = 48;
                }
                for (i = 1; i < length; ++i) {
                    resultBuffer[count++] = result.charAt(i);
                }
                if (this.alwaysFlush) {
                    return new String(resultBuffer);
                }
                this.numericString = new String(resultBuffer);
                return this.numericString;
            }
        } else {
            int insertLength = desiredLength - result.length();
            if (insertLength > 0) {
                int i;
                int length = result.length();
                char[] resultBuffer = new char[desiredLength];
                int count = insertLength;
                for (i = 0; i < insertLength; ++i) {
                    resultBuffer[i] = 48;
                }
                for (i = 0; i < length; ++i) {
                    resultBuffer[count++] = result.charAt(i);
                }
                if (this.alwaysFlush) {
                    return new String(resultBuffer);
                }
                this.numericString = new String(resultBuffer);
                return this.numericString;
            }
        }
        this.numericString = result;
        return this.numericString;
    }

    @Override
    public final String toDisplayString() {
        if (displayInternal) {
            return this.toString();
        }
        return super.toDisplayString();
    }

    @Override
    public final String toInspectString() {
        if (!this.dirty) {
            this.updateFromMemory(false);
        }
        return this.value.toString();
    }

    @Override
    public final int getAcceptSize() {
        int result = this.length();
        if (this.signPosition == 2 || this.signPosition == 3) {
            ++result;
        }
        if (this.place > 0) {
            ++result;
        }
        return result;
    }

    @Override
    public final void calcStoreSize() {
        this.storeSize = this.length();
        if (this.signPosition == 4 || this.signPosition == 5) {
            --this.storeSize;
        }
    }

    @Override
    public int getType() {
        return this.getBasicType(656);
    }

    static {
        String displaytype = RuntimeEnvironment.getGlobalParameter("display.d");
        if (displaytype != null && displaytype.length() > 0 && (displaytype = displaytype.toUpperCase()).charAt(0) == 'I') {
            displayInternal = true;
        }
        unsignedDigits = positiveDigits = new StringBuffer(10).append('\u0000').append('\u0001').append('\u0002').append('\u0003').append('\u0004').append('\u0005').append('\u0006').append('\u0007').append('\b').append('\t').toString();
        negativeDigits = positiveDigits;
        positiveChar = (char)43;
        positiveByte = (byte)43;
        positiveArray = new char[10];
        unsignedArray = new char[10];
        negativeArray = new char[10];
        positiveByteArray = new byte[10];
        unsignedByteArray = new byte[10];
        negativeByteArray = new byte[10];
        indexPositive = new char[256];
        indexNegative = new char[256];
        CompD.setDatatype(0);
    }
}

