/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.BignumType;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.ZonedDescription;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public class Display
extends BignumType
implements Cloneable,
comparableByteArray {
    private static final long serialVersionUID = 1L;
    private transient char[] fillArray;
    private static Boolean displayInternal = null;
    public static String positiveDigits = "0123456789";
    public static String unsignedDigits = "0123456789";
    public static String negativeDigits = "pqrstuvwxy";
    public static final String packedSigns = "\f\u001c\u001d\u001f,-/<=?LMO\\]_lmo|}\u007f\u008c\u008d\u008f\u009c\u009d\u009f\u00c0\u00c1\u00d1\u00f1\u00c2\u00d2\u00f2\u00c3\u00d3\u00f3\u00c4\u00d4\u00f4\u00c5\u00d5\u00f5\u00c6\u00d6\u00f6\u00c7\u00d7\u00f7\u00c8\u00d8\u00f8\u00c9\u00d9\u00f9";
    public static char positiveChar = (char)43;
    public static char negativeChar = (char)45;
    public static char decimalChar = (char)46;
    public static byte positiveByte = (byte)43;
    public static byte negativeByte = (byte)45;
    public static byte decimalByte = (byte)46;
    public static final char[] positiveArray = new char[10];
    public static final char[] unsignedArray = new char[10];
    public static final char[] negativeArray = new char[10];
    public static final byte[] positiveByteArray = new byte[10];
    public static final byte[] unsignedByteArray = new byte[10];
    public static final byte[] negativeByteArray = new byte[10];
    private static final char[] indexPositive = new char[256];
    private static final char[] indexNegative = new char[256];
    private static ZonedDescription zonedDescription;
    public static final Numeric conditionCode;
    public static final Numeric tally;

    @Override
    public final String getClassName() {
        return "com.heirloomcomputing.ecs.exec.Display";
    }

    @Override
    public final String getUsage() {
        return "Display";
    }

    private static boolean displayInternal() {
        if (displayInternal != null) {
            return displayInternal;
        }
        String displaytype = RuntimeEnvironment.getGlobalParameter("display.0");
        if (displaytype != null) {
            if (displaytype.length() > 0) {
                switch (displaytype.charAt(0)) {
                    case 'I': 
                    case 'i': {
                        displayInternal = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        displayInternal = false;
                    }
                }
            } else {
                displayInternal = false;
            }
        } else {
            displayInternal = false;
        }
        return displayInternal;
    }

    public static String getPositiveDigits() {
        return positiveDigits;
    }

    public static String getUnsignedDigits() {
        return unsignedDigits;
    }

    public static String getNegativeDigits() {
        return negativeDigits;
    }

    public static char getPositiveChar() {
        return positiveChar;
    }

    public static char getNegativeChar() {
        return negativeChar;
    }

    public static char getDecimalChar() {
        return decimalChar;
    }

    public static void setDatatype(int n) {
        int i;
        switch (n) {
            default: {
                positiveDigits = "0123456789";
                unsignedDigits = "0123456789";
                negativeDigits = "pqrstuvwxy";
                positiveChar = (char)43;
                negativeChar = (char)45;
                decimalChar = (char)46;
                positiveByte = (byte)43;
                negativeByte = (byte)45;
                decimalByte = (byte)46;
                break;
            }
            case 1: {
                positiveDigits = "0123456789";
                unsignedDigits = "0123456789";
                negativeDigits = "pqrstuvwxy";
                positiveChar = (char)43;
                negativeChar = (char)45;
                decimalChar = (char)46;
                positiveByte = (byte)43;
                negativeByte = (byte)45;
                decimalByte = (byte)46;
                break;
            }
            case 2: {
                positiveDigits = "0123456789";
                unsignedDigits = "0123456789";
                negativeDigits = "IJKLMNOPQR";
                negativeChar = (char)45;
                positiveChar = (char)43;
                decimalChar = (char)46;
                negativeByte = (byte)45;
                positiveByte = (byte)43;
                decimalByte = (byte)46;
                break;
            }
            case 3: {
                positiveDigits = new StringBuffer(10).append('\u00c0').append('\u00c1').append('\u00c2').append('\u00c3').append('\u00c4').append('\u00c5').append('\u00c6').append('\u00c7').append('\u00c8').append('\u00c9').toString();
                unsignedDigits = new StringBuffer(10).append('\u00f0').append('\u00f1').append('\u00f2').append('\u00f3').append('\u00f4').append('\u00f5').append('\u00f6').append('\u00f7').append('\u00f8').append('\u00f9').toString();
                negativeDigits = new StringBuffer(10).append('\u00d0').append('\u00d1').append('\u00d2').append('\u00d3').append('\u00d4').append('\u00d5').append('\u00d6').append('\u00d7').append('\u00d8').append('\u00d9').toString();
                negativeChar = (char)96;
                positiveChar = (char)78;
                decimalChar = (char)75;
                negativeByte = (byte)96;
                positiveByte = (byte)78;
                decimalByte = (byte)75;
                break;
            }
            case 4: {
                positiveDigits = "{ABCDEFGHI";
                unsignedDigits = "0123456789";
                negativeDigits = "}JKLMNOPQR";
                negativeChar = (char)45;
                positiveChar = (char)43;
                decimalChar = (char)46;
                negativeByte = (byte)45;
                positiveByte = (byte)43;
                decimalByte = (byte)46;
            }
        }
        for (i = 0; i < 256; ++i) {
            Display.indexPositive[i] = '\u0000';
            Display.indexNegative[i] = '\u0000';
        }
        int length = positiveDigits.length();
        for (i = 0; i < length; ++i) {
            Display.indexPositive[Display.positiveDigits.charAt((int)i)] = (char)(i + 48);
            Display.positiveArray[i] = positiveDigits.charAt(i);
            Display.positiveByteArray[i] = (byte)positiveDigits.charAt(i);
        }
        length = unsignedDigits.length();
        for (i = 0; i < length; ++i) {
            Display.indexPositive[Display.unsignedDigits.charAt((int)i)] = (char)(i + 48);
            Display.unsignedArray[i] = unsignedDigits.charAt(i);
            Display.unsignedByteArray[i] = (byte)unsignedDigits.charAt(i);
        }
        length = negativeDigits.length();
        for (i = 0; i < length; ++i) {
            Display.indexNegative[Display.negativeDigits.charAt((int)i)] = (char)(i + 48);
            Display.negativeArray[i] = negativeDigits.charAt(i);
            Display.negativeByteArray[i] = (byte)negativeDigits.charAt(i);
        }
    }

    public static final ZonedDescription getZonedDescription() {
        if (zonedDescription != null) {
            return zonedDescription;
        }
        zonedDescription = new ZonedDescription(){

            @Override
            public String getPositiveDigits() {
                return positiveDigits;
            }

            @Override
            public String getUnsignedDigits() {
                return unsignedDigits;
            }

            @Override
            public String getNegativeDigits() {
                return negativeDigits;
            }

            @Override
            public String getPackedSigns() {
                return Display.packedSigns;
            }

            @Override
            public char getPositiveChar() {
                return positiveChar;
            }

            @Override
            public char getNegativeChar() {
                return negativeChar;
            }

            @Override
            public char getDecimalChar() {
                return decimalChar;
            }
        };
        return zonedDescription;
    }

    @Override
    public ZonedDescription getZonedDescriptionInstance() {
        return Display.getZonedDescription();
    }

    @Override
    public final comparableByteArray copy() {
        Display copy = (Display)super.copy();
        copy.fillArray = null;
        return copy;
    }

    @Override
    public final Numeric odoNumeric() {
        Variable odo = this.findOdo();
        if (odo != null) {
            int newSize = odo.itemSize * odo.occurs();
            odo = odo.parent;
            int difference = newSize - odo.itemSize;
            odo.itemSize = newSize;
            odo = odo.parent;
            while (odo != null) {
                odo.itemSize += (difference *= odo.maxIndex);
                odo = odo.parent;
            }
        }
        return this;
    }

    public Display() {
    }

    public Display(String setPic, String setValue) {
        super(setPic, setValue);
        this.calcStoreSize();
    }

    public Display(int itemSize, byte place, byte scale, byte signPosition) {
        this.itemSize = itemSize;
        this.place = place;
        this.scale = scale;
        this.picLength = itemSize;
        this.signPosition = signPosition;
        this.pointerMemory = new Memory(itemSize, new String[0]);
        this.pointerAddress = 0;
        this.calcStoreSize();
    }

    public Display(int param) {
        this((long)param);
    }

    public Display(long param) {
        this.itemSize = 18;
        this.place = 0;
        this.pointerMemory = new Memory(this.itemSize, new String[0]);
        this.pointerAddress = 0;
        this.signPosition = (byte)3;
        this.picLength = this.itemSize;
        this.calcStoreSize();
        this.move(param);
    }

    public Display(String param) {
        int i;
        this.itemSize = 18;
        this.place = (byte)9;
        this.pointerMemory = new Memory(this.itemSize, new String[0]);
        this.pointerAddress = 0;
        this.signPosition = (byte)3;
        this.picLength = this.itemSize;
        char c = this.getDecimal();
        if (c != '.' && (i = param.indexOf(46)) >= 0) {
            param = i == 0 ? c + param.substring(1) : (i == param.length() - 1 ? param.substring(0, param.length() - 1) + c : param.substring(0, i) + c + param.substring(i + 1));
        }
        this.calcStoreSize();
        this.move(param);
    }

    @Override
    public int getUsageNumber() {
        return 0;
    }

    public static Display createZeroDisplay() {
        Display result = new Display();
        result.itemSize = 1;
        result.place = 0;
        result.pointerMemory = new Memory(new byte[]{48});
        result.pointerAddress = 0;
        result.signPosition = (byte)3;
        result.picLength = 1;
        result.value = new Bignum();
        result.setName("ZEROS");
        result.calcStoreSize();
        return result;
    }

    @Override
    public final void fillFromMemoryNow() {
        block19: {
            try {
                if (this.fillArray == null) {
                    this.fillArray = new char[this.length() + 2];
                }
                this.fillArray[0] = 48;
                this.numericString = null;
                int address = this.pointerAddress;
                if (this.scale > 0) {
                    byte temporaryPlace = this.place;
                    if (this.place > 0) {
                        temporaryPlace = (byte)(temporaryPlace - this.scale);
                    }
                    int store = 1;
                    int decimal = this.length() - temporaryPlace;
                    if (this.signPosition == 5) {
                        --decimal;
                    }
                    for (int i = 0; i < this.length(); ++i) {
                        char foundDigit;
                        char bc;
                        if ((bc = this.pointerMemory.getChar(address++)) == positiveChar) continue;
                        if (bc == negativeChar) {
                            this.fillArray[0] = 45;
                            continue;
                        }
                        if (i == decimal) {
                            this.fillArray[store++] = 46;
                        }
                        if ((foundDigit = indexPositive[bc]) == '\u0000') {
                            foundDigit = indexNegative[bc];
                            if (foundDigit <= '\u0000') continue;
                            this.fillArray[0] = 45;
                            this.fillArray[store++] = foundDigit;
                            continue;
                        }
                        this.fillArray[store++] = foundDigit;
                    }
                    try {
                        this.value = new Bignum(this.fillArray, store);
                    }
                    catch (Exception e) {
                        this.value = new Bignum();
                    }
                    this.value.movingPoint(this.scale, temporaryPlace);
                    break block19;
                }
                int store = 1;
                int decimal = this.length() - this.place;
                if (this.signPosition == 5) {
                    --decimal;
                }
                for (int i = 0; i < this.length(); ++i) {
                    char foundDigit;
                    char bc;
                    if ((bc = this.pointerMemory.getChar(address++)) == positiveChar) continue;
                    if (bc == negativeChar) {
                        this.fillArray[0] = 45;
                        continue;
                    }
                    if (i == decimal) {
                        this.fillArray[store++] = 46;
                    }
                    if ((foundDigit = indexPositive[bc]) == '\u0000') {
                        foundDigit = indexNegative[bc];
                        if (foundDigit <= '\u0000') continue;
                        this.fillArray[store++] = foundDigit;
                        this.fillArray[0] = 45;
                        continue;
                    }
                    this.fillArray[store++] = foundDigit;
                }
                try {
                    this.value = new Bignum(this.fillArray, store);
                }
                catch (Exception e) {
                    this.value = new Bignum();
                }
            }
            catch (Exception e) {
                CobolException.runtimeError("Error in DISPLAY retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
            }
        }
    }

    @Override
    public final void flushToMemoryNow() {
        try {
            int c;
            int decimal;
            byte bufferPlace = this.place;
            Bignum storeValue = this.value;
            if (this.scale > 0) {
                if (this.place > 0) {
                    storeValue = this.value.movePointRight(this.scale);
                    this.place = (byte)(this.place - this.scale);
                } else {
                    storeValue = this.value.movePointLeft(this.scale);
                }
            }
            String temp = storeValue.toString();
            int length = temp.length();
            boolean negative = false;
            if (length >= 1) {
                char t1 = temp.charAt(0);
                boolean bl = negative = t1 == '-';
                if (length == 1 && t1 == '0') {
                    temp = "";
                    length = 0;
                } else if (length >= 2) {
                    char t2 = temp.charAt(1);
                    if (length == 2 && negative && t2 == '0') {
                        temp = "";
                        length = 0;
                    } else if (t1 == '0' && t2 == '.') {
                        temp = temp.substring(1);
                        --length;
                    } else if (length >= 3 && negative && t2 == '0' && temp.charAt(2) == '.') {
                        temp = "-" + temp.substring(2);
                        --length;
                    }
                }
            }
            if ((decimal = temp.indexOf(46)) < 0) {
                decimal = length;
            }
            int rightMost = this.length();
            if (this.signPosition == 5) {
                --rightMost;
            }
            int load = decimal - (rightMost - this.place);
            if (this.signPosition == 4) {
                ++load;
            }
            int address = this.pointerAddress;
            int itemSizeMinus1 = this.length() - 1;
            if (negative) {
                switch (this.signPosition) {
                    case 2: {
                        for (int i = 0; i < this.length(); ++i) {
                            if (load >= 1) {
                                if (load == decimal) {
                                    ++load;
                                }
                                c = load >= length ? 48 : (int)temp.charAt(load);
                            } else {
                                c = 48;
                            }
                            if (i == 0) {
                                this.pointerMemory.setByte(address++, negativeByteArray[c - 48]);
                            } else {
                                this.pointerMemory.setByte(address++, unsignedByteArray[c - 48]);
                            }
                            ++load;
                        }
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < this.length(); ++i) {
                            if (load >= 1) {
                                if (load == decimal) {
                                    ++load;
                                }
                                c = load >= length ? 48 : (int)temp.charAt(load);
                            } else {
                                c = 48;
                            }
                            if (i == itemSizeMinus1) {
                                this.pointerMemory.setByte(address++, negativeByteArray[c - 48]);
                            } else {
                                this.pointerMemory.setByte(address++, unsignedByteArray[c - 48]);
                            }
                            ++load;
                        }
                        break;
                    }
                    case 4: {
                        this.pointerMemory.setByte(address++, negativeByte);
                        for (int i = 1; i < this.length(); ++i) {
                            if (load >= 1) {
                                if (load == decimal) {
                                    ++load;
                                }
                                if (load >= length) {
                                    this.pointerMemory.setByte(address++, unsignedByteArray[0]);
                                } else {
                                    this.pointerMemory.setByte(address++, unsignedByteArray[temp.charAt(load) - 48]);
                                }
                            } else {
                                this.pointerMemory.setByte(address++, unsignedByteArray[0]);
                            }
                            ++load;
                        }
                        break;
                    }
                    case 5: {
                        for (int i = 0; i < itemSizeMinus1; ++i) {
                            if (load >= 1) {
                                if (load == decimal) {
                                    ++load;
                                }
                                if (load >= length) {
                                    this.pointerMemory.setByte(address++, unsignedByteArray[0]);
                                } else {
                                    this.pointerMemory.setByte(address++, unsignedByteArray[temp.charAt(load) - 48]);
                                }
                            } else {
                                this.pointerMemory.setByte(address++, unsignedByteArray[0]);
                            }
                            ++load;
                        }
                        this.pointerMemory.setByte(address++, negativeByte);
                    }
                }
            } else {
                switch (this.signPosition) {
                    case 0: {
                        for (int i = 0; i < this.length(); ++i) {
                            if (load >= 0) {
                                if (load == decimal) {
                                    ++load;
                                }
                                if (load >= length) {
                                    this.pointerMemory.setByte(address++, unsignedByteArray[0]);
                                } else {
                                    this.pointerMemory.setByte(address++, unsignedByteArray[temp.charAt(load) - 48]);
                                }
                            } else {
                                this.pointerMemory.setByte(address++, unsignedByteArray[0]);
                            }
                            ++load;
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < this.length(); ++i) {
                            if (load >= 0) {
                                if (load == decimal) {
                                    ++load;
                                }
                                c = load >= length ? 48 : (int)temp.charAt(load);
                            } else {
                                c = 48;
                            }
                            if (i == 0) {
                                this.pointerMemory.setByte(address++, positiveByteArray[c - 48]);
                            } else {
                                this.pointerMemory.setByte(address++, unsignedByteArray[c - 48]);
                            }
                            ++load;
                        }
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < this.length(); ++i) {
                            if (load >= 0) {
                                if (load == decimal) {
                                    ++load;
                                }
                                c = load >= length ? 48 : (int)temp.charAt(load);
                            } else {
                                c = 48;
                            }
                            if (i == itemSizeMinus1) {
                                this.pointerMemory.setByte(address++, positiveByteArray[c - 48]);
                            } else {
                                this.pointerMemory.setByte(address++, unsignedByteArray[c - 48]);
                            }
                            ++load;
                        }
                        break;
                    }
                    case 4: {
                        this.pointerMemory.setByte(address++, positiveByte);
                        for (int i = 1; i < this.length(); ++i) {
                            if (load >= 0) {
                                if (load == decimal) {
                                    ++load;
                                }
                                if (load >= length) {
                                    this.pointerMemory.setByte(address++, unsignedByteArray[0]);
                                } else {
                                    this.pointerMemory.setByte(address++, unsignedByteArray[temp.charAt(load) - 48]);
                                }
                            } else {
                                this.pointerMemory.setByte(address++, unsignedByteArray[0]);
                            }
                            ++load;
                        }
                        break;
                    }
                    case 5: {
                        for (int i = 0; i < this.length() - 1; ++i) {
                            if (load >= 0) {
                                if (load == decimal) {
                                    ++load;
                                }
                                if (load >= length) {
                                    this.pointerMemory.setByte(address++, unsignedByteArray[0]);
                                } else {
                                    this.pointerMemory.setByte(address++, unsignedByteArray[temp.charAt(load) - 48]);
                                }
                            } else {
                                this.pointerMemory.setByte(address++, unsignedByteArray[0]);
                            }
                            ++load;
                        }
                        this.pointerMemory.setByte(address++, positiveByte);
                    }
                }
            }
            this.place = bufferPlace;
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in DISPLAY storage of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public final String toNumericString() {
        String result;
        if (!this.dirty) {
            this.updateFromMemory(false);
        }
        if (this.numericString != null) {
            return this.numericString;
        }
        int desiredLength = this.length();
        if (this.signPosition == 4 || this.signPosition == 5) {
            --desiredLength;
        }
        if ((result = this.value.toString()).charAt(0) == '-') {
            int insertLength;
            if ((insertLength = ++desiredLength - result.length()) > 0) {
                char[] resultBuffer = new char[desiredLength];
                resultBuffer[0] = 45;
                int length = result.length();
                for (int i = 1; i <= insertLength; ++i) {
                    resultBuffer[i] = 48;
                }
                result.getChars(1, length, resultBuffer, insertLength + 1);
                if (this.alwaysFlush) {
                    return new String(resultBuffer);
                }
                this.numericString = new String(resultBuffer);
                return this.numericString;
            }
        } else {
            int insertLength = desiredLength - result.length();
            if (insertLength > 0) {
                int length = result.length();
                char[] resultBuffer = new char[desiredLength];
                for (int i = 0; i < insertLength; ++i) {
                    resultBuffer[i] = 48;
                }
                result.getChars(0, length, resultBuffer, insertLength);
                if (this.alwaysFlush) {
                    return new String(resultBuffer);
                }
                this.numericString = new String(resultBuffer);
                return this.numericString;
            }
        }
        this.numericString = result;
        return this.numericString;
    }

    @Override
    public final String toDisplayString() {
        if (Display.displayInternal()) {
            return this.toString();
        }
        return super.toDisplayString();
    }

    @Override
    public final String toInspectString() {
        if (!this.dirty) {
            this.updateFromMemory(false);
        }
        return this.value.toString();
    }

    @Override
    public final int getAcceptSize() {
        int result = this.length();
        if (this.signPosition == 2 || this.signPosition == 3) {
            ++result;
        }
        if (this.place > 0) {
            ++result;
        }
        return result;
    }

    @Override
    public final void calcStoreSize() {
        this.storeSize = this.signPosition == 4 || this.signPosition == 5 ? this.length() - 1 : this.length();
    }

    @Override
    public int getArgumentType() {
        switch (this.signPosition) {
            case 0: {
                return 1;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 2;
            }
        }
        return 3;
    }

    @Override
    public int relativeKeyLength() {
        return this.length();
    }

    @Override
    public int getType() {
        return this.getBasicType(16);
    }

    static {
        Display.setDatatype(0);
        conditionCode = Numeric.conditionCode;
        tally = Numeric.tally;
    }
}

