/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;

public class Exec {
    public static final boolean debugMode = false;
    private static Vector<String> environment = new Vector();
    private static String[] environmentArray;

    public static void setEnvironment(String name, String value) {
        environmentArray = null;
        environment.addElement(name + "=" + value);
    }

    public static void setEnvironment(String nameEqualsValue) {
        environmentArray = null;
        environment.addElement(nameEqualsValue);
    }

    private String[] getEnvironment() {
        if (environmentArray == null) {
            environmentArray = new String[environment.size()];
            environment.copyInto(environmentArray);
        }
        return environmentArray;
    }

    public static int exec(String command) {
        return Exec.exec(command, true, true);
    }

    public static int execWait(String command) {
        return Exec.exec(command, false, true);
    }

    public static int execPrint(String command) {
        return Exec.exec(command, true, false);
    }

    public static int exec(String command, boolean printResults, boolean wait) {
        Exec me = new Exec();
        int returnCode = 0;
        Exec.printSeparator();
        Process p = null;
        try {
            returnCode = -1;
            p = Runtime.getRuntime().exec(command);
            returnCode = me.process(p);
        }
        catch (Exception e) {
            try {
                if (p != null) {
                    p.destroy();
                }
                p = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            Exec.printError(command, e);
            throw new RuntimeException("Process Unavailable");
        }
        try {
            if (p != null) {
                p.destroy();
            }
            p = null;
        }
        catch (Exception e2) {
            Exec.printError(command, e2);
        }
        Exec.printDone();
        return returnCode;
    }

    public static int exec(String[] Command2, boolean printResults, boolean wait) {
        Exec me = new Exec();
        int returnCode = 0;
        String command = "";
        Exec.printSeparator();
        for (int i = 0; i < Command2.length; ++i) {
            command = command + " " + Command2[i];
        }
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(Command2);
            returnCode = me.process(p);
        }
        catch (Exception e) {
            try {
                if (p != null) {
                    p.destroy();
                }
                p = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            Exec.printError(command, e);
            throw new RuntimeException("Process Unavailable");
        }
        try {
            if (p != null) {
                p.destroy();
            }
            p = null;
        }
        catch (Exception e2) {
            Exec.printError(command, e2);
        }
        Exec.printDone();
        return returnCode;
    }

    private static void printDone() {
    }

    private static void printError(String command, Exception e) {
    }

    private static void printError(String command) {
    }

    private static void printSeparator() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int process(Process p) {
        Reader reader2;
        Reader reader1;
        int returnCode = 0;
        InputStream i_s = p.getInputStream();
        InputStream e_s = p.getErrorStream();
        DataInputStream dis = new DataInputStream(i_s);
        DataInputStream des = new DataInputStream(e_s);
        try {
            reader1 = new Reader(dis);
            reader2 = new Reader(des);
        }
        catch (Throwable t) {
            return -1;
        }
        reader1.start();
        reader2.start();
        boolean finished = false;
        try {
            while (!finished) {
                try {
                    returnCode = p.exitValue();
                    finished = true;
                }
                catch (IllegalThreadStateException e) {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            reader1.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            reader2.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            dis.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            des.close();
            return returnCode;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return returnCode;
    }

    class Reader
    extends Thread {
        DataInputStream is = null;

        public Reader(DataInputStream is) {
            this.setDaemon(true);
            this.is = is;
        }

        @Override
        public void run() {
            boolean readyForLinefeed = false;
            try {
                while (this.is != null) {
                    while (this.is.available() > 0) {
                        int b = this.is.read();
                        if (b == -1) {
                            this.is = null;
                            return;
                        }
                        b &= 0xFFFF;
                        if (readyForLinefeed) {
                            readyForLinefeed = false;
                            System.out.println("");
                            if (b == 10 || b == 13) continue;
                        }
                        if (b == 13) {
                            readyForLinefeed = true;
                            continue;
                        }
                        readyForLinefeed = false;
                        if (b == 10) {
                            System.out.println("");
                            continue;
                        }
                        System.out.print((char)b);
                    }
                    Thread.sleep(250L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

