/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Variable;
import java.io.PrintStream;
import java.util.Hashtable;

public class Exhibit {
    private static PrintStream out = System.out;
    private static Hashtable<Object, String> exhibitedValues = new Hashtable();

    private static String getName(Variable v) {
        String name = v.getName();
        if (name == null) {
            return name;
        }
        return name.toUpperCase().replace('_', '-');
    }

    private static void setExhibitedValue(Variable v, String currentValue) {
        exhibitedValues.put(v, currentValue);
    }

    private static boolean isExhibitedValueChanged(Variable v) {
        boolean result;
        if (v == null) {
            return false;
        }
        String currentValue = v.toDisplayString();
        String oldValue = exhibitedValues.get(v);
        if (currentValue == null) {
            if (oldValue == null) {
                return false;
            }
            Exhibit.setExhibitedValue(v, currentValue);
            return true;
        }
        if (oldValue == null) {
            Exhibit.setExhibitedValue(v, currentValue);
            return true;
        }
        boolean bl = result = !oldValue.equals(currentValue);
        if (result) {
            Exhibit.setExhibitedValue(v, currentValue);
        }
        return result;
    }

    private static void setExhibitedValue(Object v, String currentValue) {
        exhibitedValues.put(v, currentValue);
    }

    private static boolean isExhibitedValueChanged(Object v) {
        boolean result;
        if (v == null) {
            return false;
        }
        String currentValue = v.toString();
        String oldValue = exhibitedValues.get(v);
        if (currentValue == null) {
            if (oldValue == null) {
                return false;
            }
            Exhibit.setExhibitedValue(v, currentValue);
            return true;
        }
        if (oldValue == null) {
            Exhibit.setExhibitedValue(v, currentValue);
            return true;
        }
        boolean bl = result = !oldValue.equals(currentValue);
        if (result) {
            Exhibit.setExhibitedValue(v, currentValue);
        }
        return result;
    }

    public static void setPrintStream(PrintStream param) {
        out = param;
    }

    public static boolean exhibitNamed(Variable v) {
        try {
            return Exhibit.exhibitNamed(Exhibit.getName(v), v);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean exhibitNamed(String name, Variable v) {
        if (v != null) {
            out.print(name + "=" + v.toDisplayString() + " ");
        }
        return true;
    }

    public static boolean exhibitNamed(Object v) {
        try {
            return Exhibit.exhibitNamed(v.getClass().getName(), v);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean exhibitNamed(String name, Object v) {
        if (v != null) {
            out.print(name + "=" + String.valueOf(v) + " ");
        }
        return true;
    }

    public static boolean exhibitChangedNamed(Variable v) {
        if (v != null && Exhibit.isExhibitedValueChanged(v)) {
            return Exhibit.exhibitNamed(v);
        }
        return false;
    }

    public static boolean exhibitChangedNamed(String name, Variable v) {
        if (v != null && Exhibit.isExhibitedValueChanged(v)) {
            return Exhibit.exhibitNamed(name, v);
        }
        return false;
    }

    public static boolean exhibitChangedNamed(Object v) {
        if (v != null && Exhibit.isExhibitedValueChanged(v)) {
            return Exhibit.exhibitNamed(v);
        }
        return false;
    }

    public static boolean exhibitChangedNamed(String name, Object v) {
        if (v != null && Exhibit.isExhibitedValueChanged(v)) {
            return Exhibit.exhibitNamed(name, v);
        }
        return false;
    }

    public static boolean exhibitChanged(Variable v) {
        if (v != null && Exhibit.isExhibitedValueChanged(v)) {
            return Exhibit.exhibit(v);
        }
        return false;
    }

    public static boolean exhibitChanged(Object v) {
        if (v != null && Exhibit.isExhibitedValueChanged(v)) {
            return Exhibit.exhibit(v);
        }
        return false;
    }

    public static boolean exhibit(Variable v) {
        if (v != null) {
            out.print(v.toDisplayString() + " ");
            return true;
        }
        return false;
    }

    public static boolean exhibit(Object v) {
        if (v != null) {
            out.print(String.valueOf(v) + " ");
            return true;
        }
        return false;
    }

    public static boolean exhibit(String s) {
        if (s != null) {
            out.print(s + " ");
            return true;
        }
        return false;
    }

    public static void exhibitOutput(boolean outputNewline) {
        if (outputNewline) {
            System.out.println("");
        }
    }
}

