/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ColorProvider;
import com.heirloomcomputing.ecs.exec.GuiSystemJFC;
import com.heirloomcomputing.ecs.exec.MediaImage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;

public class GuiSystem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static GuiSystemJFC jfc;
    private static Class<?> DimensionClass;
    private static Class<?> FontClass;
    private static Class<?> ColorClass;
    private static Class<?> StringClass;
    private static Class<?> BevelBorderClass;
    private static Class<?> EtchedBorderClass;
    private static Class<?> TitledBorderClass;
    private static Class<?> BorderLayoutClass;
    private static Class<?> CardLayoutClass;
    private static Class<?> PointClass;
    private static Class<?> CursorClass;
    private static Class<?> FlowLayoutClass;
    private static Class<?> FileClass;
    private static Class<?> GridLayoutClass;
    private static Class<?> ImageClass;
    private static Class<?> IconClass;
    private static Class<?> ImageIconClass;
    private static Class<?> InsetsClass;
    private static Class<?> URLClass;
    private static Class<?> RectangleClass;
    private static Class<?> LocaleClass;
    private static Class<?> CharacterClass;
    private static Class<?> CheckboxGroupClass;
    private static Class<?> ClassClass;
    private static Class<?> DefaultComboBoxModelClass;
    private static Class<?> DefaultListModelClass;
    private static Class<?> DefaultSingleSelectionModelClass;
    private static Class<?> GridBagLayoutClass;
    private static Class<?> EditorKitClass;
    private static Class<?> LayoutManagerClass;
    private static Class<?> ScrollPaneLayoutClass;
    private static Class<?> ViewportLayoutClass;
    private static Class<?> TableColumnModelClass;
    private static Class<?> TableModelClass;
    private static Class<?> TextLayoutClass;
    private static Class<?> TreeModelClass;
    private static Class<?> TreeNodeClass;
    private static Class<?> thisClass;
    private static Properties printProps;

    public static Object parse(String data, Class<?> classtype) {
        if (classtype == null) {
            return null;
        }
        if (classtype == DimensionClass) {
            try {
                int paren = data.indexOf(40);
                int comma = data.indexOf(44);
                if (comma >= 0) {
                    int lastParen = data.lastIndexOf(41);
                    if (lastParen == paren) {
                        lastParen = data.length();
                    }
                    if (lastParen < 0) {
                        lastParen = data.length();
                    }
                    if (lastParen >= 0) {
                        int width = Integer.parseInt(data.substring(paren + 1, comma).trim());
                        int height = Integer.parseInt(data.substring(comma + 1, lastParen).trim());
                        return new Dimension(width, height);
                    }
                }
            }
            catch (Exception paren) {
                // empty catch block
            }
            return new Dimension(0, 0);
        }
        if (classtype == FontClass) {
            try {
                int comma = data.indexOf(44);
                int lastComma = data.lastIndexOf(44);
                if (comma >= 0 && lastComma > comma) {
                    String fontName = data.substring(0, comma).trim();
                    String fontStyle = data.substring(comma + 1, lastComma).trim().toUpperCase();
                    String fontSize = data.substring(lastComma + 1).trim();
                    int intFontStyle = 0;
                    if (fontStyle.indexOf(66) >= 0) {
                        intFontStyle |= 1;
                    }
                    if (fontStyle.indexOf(84) >= 0) {
                        intFontStyle |= 2;
                    }
                    int intFontSize = Integer.parseInt(fontSize);
                    return new Font(fontName, intFontStyle, intFontSize);
                }
                if (comma >= 0) {
                    String fontName = data.substring(0, comma).trim();
                    String fontSize = data.substring(comma + 1).trim();
                    int intFontSize = Integer.parseInt(fontSize);
                    return new Font(fontName, 0, intFontSize);
                }
                return new Font(data, 0, 12);
            }
            catch (Exception comma) {
                return new Font("Serif", 0, 12);
            }
        }
        if (classtype == ColorClass) {
            try {
                return ColorProvider.getColor(data);
            }
            catch (Throwable t) {
                return Color.white;
            }
        }
        if (classtype == StringClass) {
            return data;
        }
        if (classtype == BorderLayoutClass) {
            try {
                int paren = data.indexOf(40);
                int comma = data.indexOf(44);
                if (comma >= 0) {
                    int lastParen = data.lastIndexOf(41);
                    if (lastParen == paren) {
                        lastParen = data.length();
                    }
                    if (lastParen < 0) {
                        lastParen = data.length();
                    }
                    if (lastParen >= 0) {
                        int hgap = Integer.parseInt(data.substring(paren + 1, comma).trim());
                        int vgap = Integer.parseInt(data.substring(comma + 1, lastParen).trim());
                        return new BorderLayout(hgap, vgap);
                    }
                }
            }
            catch (Exception paren) {
                // empty catch block
            }
            return new BorderLayout(0, 0);
        }
        if (classtype == CardLayoutClass) {
            try {
                int paren = data.indexOf(40);
                int comma = data.indexOf(44);
                if (comma >= 0) {
                    int lastParen = data.lastIndexOf(41);
                    if (lastParen == paren) {
                        lastParen = data.length();
                    }
                    if (lastParen < 0) {
                        lastParen = data.length();
                    }
                    if (lastParen >= 0) {
                        int hgap = Integer.parseInt(data.substring(paren + 1, comma).trim());
                        int vgap = Integer.parseInt(data.substring(comma + 1, lastParen).trim());
                        return new CardLayout(hgap, vgap);
                    }
                }
            }
            catch (Exception paren) {
                // empty catch block
            }
            return new CardLayout(0, 0);
        }
        if (classtype == PointClass) {
            try {
                int paren = data.indexOf(40);
                int comma = data.indexOf(44);
                if (comma >= 0) {
                    int lastParen = data.lastIndexOf(41);
                    if (lastParen == paren) {
                        lastParen = data.length();
                    }
                    if (lastParen < 0) {
                        lastParen = data.length();
                    }
                    if (lastParen >= 0) {
                        int hgap = Integer.parseInt(data.substring(paren + 1, comma).trim());
                        int vgap = Integer.parseInt(data.substring(comma + 1, lastParen).trim());
                        return new Point(hgap, vgap);
                    }
                }
            }
            catch (Exception paren) {
                // empty catch block
            }
            return new Point(0, 0);
        }
        if (classtype == CursorClass) {
            try {
                int type = Integer.parseInt(data);
                return new Cursor(type);
            }
            catch (Exception type) {
                return new Cursor(0);
            }
        }
        if (classtype == FileClass) {
            try {
                return new File(data);
            }
            catch (Exception type) {
                return null;
            }
        }
        if (classtype == FlowLayoutClass) {
            if (data.startsWith("(")) {
                data = data.substring(1);
            }
            int alignment = 0;
            int comma = data.indexOf(44);
            String align = data.substring(0, comma);
            if (align.indexOf("LEFT") >= 0) {
                alignment = 0;
            } else if (align.indexOf("CENTER") >= 0) {
                alignment = 1;
            } else if (align.indexOf("RIGHT") >= 0) {
                alignment = 2;
            }
            data = data.substring(comma + 1);
            try {
                int paren = data.indexOf(40);
                comma = data.indexOf(44);
                if (comma >= 0) {
                    int lastParen = data.lastIndexOf(41);
                    if (lastParen == paren) {
                        lastParen = data.length();
                    }
                    if (lastParen < 0) {
                        lastParen = data.length();
                    }
                    if (lastParen >= 0) {
                        int hgap = Integer.parseInt(data.substring(paren + 1, comma).trim());
                        int vgap = Integer.parseInt(data.substring(comma + 1, lastParen).trim());
                        return new FlowLayout(alignment, hgap, vgap);
                    }
                }
            }
            catch (Exception paren) {
                // empty catch block
            }
            return new FlowLayout(alignment, 0, 0);
        }
        if (classtype == GridLayoutClass) {
            try {
                if (data.startsWith("(")) {
                    data = data.substring(1);
                }
                int comma1 = data.indexOf(44);
                int comma2 = data.indexOf(44, comma1 + 1);
                int comma3 = data.indexOf(44, comma2 + 1);
                int paren = data.lastIndexOf(41);
                if (paren < 0) {
                    paren = data.length();
                }
                if (comma1 >= 0 && comma2 >= 0 && comma3 >= 0) {
                    int top = Integer.parseInt(data.substring(0, comma1));
                    int left = Integer.parseInt(data.substring(comma1 + 1, comma2));
                    int bottom = Integer.parseInt(data.substring(comma2 + 1, comma3));
                    int right = Integer.parseInt(data.substring(comma3 + 1), paren);
                    return new GridLayout(top, left, bottom, right);
                }
                if (comma1 >= 0) {
                    int top = Integer.parseInt(data.substring(0, comma1));
                    int left = Integer.parseInt(data.substring(comma1 + 1, comma2));
                    return new GridLayout(top, left);
                }
            }
            catch (Exception comma1) {
                // empty catch block
            }
            return new GridLayout();
        }
        if (classtype == InsetsClass) {
            try {
                if (data.startsWith("(")) {
                    data = data.substring(1);
                }
                int comma1 = data.indexOf(44);
                int comma2 = data.indexOf(44, comma1 + 1);
                int comma3 = data.indexOf(44, comma2 + 1);
                int paren = data.lastIndexOf(41);
                if (paren < 0) {
                    paren = data.length();
                }
                if (comma1 >= 0 && comma2 >= 0 && comma3 >= 0) {
                    int top = Integer.parseInt(data.substring(0, comma1));
                    int left = Integer.parseInt(data.substring(comma1 + 1, comma2));
                    int bottom = Integer.parseInt(data.substring(comma2 + 1, comma3));
                    int right = Integer.parseInt(data.substring(comma3 + 1, paren));
                    return new Insets(top, left, bottom, right);
                }
            }
            catch (Exception comma1) {
                // empty catch block
            }
            return new Insets(0, 0, 0, 0);
        }
        if (classtype == ImageClass) {
            return GuiSystem.getImage(data);
        }
        if (classtype == URLClass) {
            try {
                return new URL(data);
            }
            catch (Exception comma1) {
                return null;
            }
        }
        if (classtype == RectangleClass) {
            try {
                if (data.startsWith("(")) {
                    data = data.substring(1);
                }
                int comma1 = data.indexOf(44);
                int comma2 = data.indexOf(44, comma1 + 1);
                int comma3 = data.indexOf(44, comma2 + 1);
                int paren = data.lastIndexOf(41);
                if (paren < 0) {
                    paren = data.length();
                }
                if (comma1 >= 0 && comma2 >= 0 && comma3 >= 0) {
                    int top = Integer.parseInt(data.substring(0, comma1));
                    int left = Integer.parseInt(data.substring(comma1 + 1, comma2));
                    int bottom = Integer.parseInt(data.substring(comma2 + 1, comma3));
                    int right = Integer.parseInt(data.substring(comma3 + 1, paren));
                    return new Rectangle(top, left, bottom, right);
                }
            }
            catch (Exception comma1) {
                // empty catch block
            }
            return new Rectangle(0, 0, 0, 0);
        }
        if (classtype == LocaleClass) {
            int comma1 = data.indexOf(44);
            int comma2 = data.indexOf(44, comma1 + 1);
            if (comma1 >= 0 && comma2 < 0) {
                return new Locale(data.substring(0, comma1), data.substring(comma1 + 1));
            }
            if (comma1 >= 0 && comma2 >= 0) {
                return new Locale(data.substring(0, comma1), data.substring(comma1 + 1, comma2), data.substring(comma2 + 1));
            }
            return Locale.getDefault();
        }
        if (classtype == CharacterClass) {
            if (data.length() == 0) {
                return new Character('\u0000');
            }
            if (data.length() == 1) {
                return new Character(data.charAt(0));
            }
            if (data.startsWith("0x")) {
                int theCharacter = Integer.parseInt(data.substring(2).trim(), 16);
                return new Character((char)theCharacter);
            }
            try {
                int theCharacter = Integer.parseInt(data.trim());
                return new Character((char)theCharacter);
            }
            catch (Exception e) {
                return new Character(data.charAt(0));
            }
        }
        if (classtype == CheckboxGroupClass) {
            return new CheckboxGroup();
        }
        if (classtype == ClassClass) {
            try {
                return Class.forName(data);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (classtype == GridBagLayoutClass) {
            return new GridBagLayout();
        }
        if (classtype == LayoutManagerClass) {
            try {
                return (LayoutManager)Class.forName(data).newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (classtype == ScrollPaneLayoutClass && ScrollPaneLayoutClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getScrollPaneLayout(data);
        }
        if (classtype == BevelBorderClass && BevelBorderClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getBevelBorder(data);
        }
        if (classtype == EtchedBorderClass && EtchedBorderClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getEtchedBorder(data);
        }
        if (classtype == TitledBorderClass && TitledBorderClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getTitledBorder(data);
        }
        if (classtype == IconClass && IconClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getImageIcon(data);
        }
        if (classtype == ImageIconClass && ImageIconClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getImageIcon(data);
        }
        if (classtype == DefaultComboBoxModelClass && DefaultComboBoxModelClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getComboBoxModel(data);
        }
        if (classtype == DefaultListModelClass && DefaultListModelClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getListModel(data);
        }
        if (classtype == DefaultSingleSelectionModelClass && DefaultSingleSelectionModelClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getSingleSelectionModel(data);
        }
        if (classtype == EditorKitClass && EditorKitClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getEditorKit(data);
        }
        if (classtype == ViewportLayoutClass && ViewportLayoutClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getViewportLayout(data);
        }
        if (classtype == TableColumnModelClass && TableColumnModelClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getTableColumnModel(data);
        }
        if (classtype == TableModelClass && TableModelClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getTableModel(data);
        }
        if (classtype == TextLayoutClass && TextLayoutClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getTextLayout(data);
        }
        if (classtype == TreeModelClass && TreeModelClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getTreeModel(data);
        }
        if (classtype == TreeNodeClass && TreeNodeClass != null) {
            if (jfc == null) {
                jfc = new GuiSystemJFC();
            }
            return jfc.getTreeNode(data);
        }
        try {
            return Class.forName(data).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Image getImage(String filename) {
        if (filename == null) {
            return null;
        }
        try {
            return MediaImage.getImage(filename, new Component(){});
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String deparse(Object data) {
        if (data == null) {
            return "";
        }
        if (data instanceof Dimension) {
            Dimension d = (Dimension)data;
            return "(" + d.width + "," + d.height + ")";
        }
        if (data instanceof Color) {
            Color c = (Color)data;
            return "(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
        }
        if (data instanceof Font) {
            Font f = (Font)data;
            String style = "";
            if ((f.getStyle() & 1) != 0) {
                style = style + "BOLD ";
            }
            if ((f.getStyle() & 2) != 0) {
                style = style + "ITALIC";
            }
            return f.getName() + "," + style + "," + f.getSize();
        }
        return data.toString();
    }

    public static Container container(Object o) {
        if (o == null) {
            return null;
        }
        if (BevelBorderClass == null || BevelBorderClass == thisClass) {
            return (Container)o;
        }
        if (jfc == null) {
            jfc = new GuiSystemJFC();
        }
        return jfc.container(o);
    }

    public static Component component(Object o) {
        try {
            if (o == null) {
                return null;
            }
            return (Component)o;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final boolean print(Object component) {
        if (component instanceof Component) {
            return GuiSystem.print((Component)component);
        }
        return false;
    }

    public static final boolean print(Component component) {
        Component currentComponent;
        Frame f = null;
        boolean status = false;
        for (currentComponent = component; currentComponent != null && !(currentComponent instanceof Frame); currentComponent = currentComponent.getParent()) {
        }
        f = (Frame)currentComponent;
        boolean newFrame = false;
        if (f == null) {
            f = new Frame();
            newFrame = true;
        }
        try {
            if (f != null) {
                try {
                    PrintJob job;
                    Toolkit t = component.getToolkit();
                    if (printProps == null) {
                        printProps = new Properties();
                    }
                    if ((job = t.getPrintJob(f, "Print", printProps)) == null) {
                        throw new Exception("Canceled");
                    }
                    Graphics page = job.getGraphics();
                    Dimension size = component.getSize();
                    Dimension pageSize = job.getPageDimension();
                    page.translate((pageSize.width - size.width) / 2, (pageSize.height - size.height) / 2);
                    page.setClip(0, 0, size.width, size.height);
                    if (component instanceof Container) {
                        ((Container)component).printComponents(page);
                    } else {
                        component.print(page);
                    }
                    page.dispose();
                    job.end();
                    status = true;
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newFrame) {
            try {
                f.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return status;
    }

    static {
        thisClass = GuiSystem.class;
        try {
            RectangleClass = Class.forName("java.awt.Rectangle");
        }
        catch (Exception e) {
            RectangleClass = thisClass;
        }
        try {
            URLClass = Class.forName("java.net.URL");
        }
        catch (Exception e) {
            URLClass = thisClass;
        }
        try {
            IconClass = Class.forName("javax.swing.Icon");
        }
        catch (Exception e) {
            IconClass = thisClass;
        }
        try {
            ImageIconClass = Class.forName("javax.swing.ImageIcon");
        }
        catch (Exception e) {
            ImageIconClass = thisClass;
        }
        try {
            InsetsClass = Class.forName("java.awt.Insets");
        }
        catch (Exception e) {
            InsetsClass = thisClass;
        }
        try {
            GridLayoutClass = Class.forName("java.awt.GridLayout");
        }
        catch (Exception e) {
            GridLayoutClass = thisClass;
        }
        try {
            ImageClass = Class.forName("java.awt.Image");
        }
        catch (Exception e) {
            ImageClass = thisClass;
        }
        try {
            FileClass = Class.forName("java.io.File");
        }
        catch (Exception e) {
            FileClass = thisClass;
        }
        try {
            FlowLayoutClass = Class.forName("java.awt.FlowLayout");
        }
        catch (Exception e) {
            FlowLayoutClass = thisClass;
        }
        try {
            PointClass = Class.forName("java.awt.Point");
        }
        catch (Exception e) {
            PointClass = thisClass;
        }
        try {
            CursorClass = Class.forName("java.awt.Cursor");
        }
        catch (Exception e) {
            CursorClass = thisClass;
        }
        try {
            CardLayoutClass = Class.forName("java.awt.CardLayout");
        }
        catch (Exception e) {
            CardLayoutClass = thisClass;
        }
        try {
            BorderLayoutClass = Class.forName("java.awt.BorderLayout");
        }
        catch (Exception e) {
            BorderLayoutClass = thisClass;
        }
        try {
            TitledBorderClass = Class.forName("javax.swing.border.TitledBorder");
        }
        catch (Exception e) {
            TitledBorderClass = thisClass;
        }
        try {
            EtchedBorderClass = Class.forName("javax.swing.border.EtchedBorder");
        }
        catch (Exception e) {
            EtchedBorderClass = thisClass;
        }
        try {
            BevelBorderClass = Class.forName("javax.swing.border.BevelBorder");
        }
        catch (Exception e) {
            BevelBorderClass = thisClass;
        }
        try {
            StringClass = Class.forName("java.lang.String");
        }
        catch (Exception e) {
            StringClass = thisClass;
        }
        try {
            ColorClass = Class.forName("java.awt.Color");
        }
        catch (Exception e) {
            ColorClass = thisClass;
        }
        try {
            FontClass = Class.forName("java.awt.Font");
        }
        catch (Exception e) {
            FontClass = thisClass;
        }
        try {
            DimensionClass = Class.forName("java.awt.Dimension");
        }
        catch (Exception e) {
            DimensionClass = thisClass;
        }
        try {
            TextLayoutClass = Class.forName("com.synkronix.ui.TextLayout");
        }
        catch (Exception e) {
            TextLayoutClass = thisClass;
        }
        try {
            TableColumnModelClass = Class.forName("javax.swing.table.TableColumnModel");
        }
        catch (Exception e) {
            TableColumnModelClass = thisClass;
        }
        try {
            TableModelClass = Class.forName("javax.swing.table.TableModel");
        }
        catch (Exception e) {
            TableModelClass = thisClass;
        }
        try {
            ScrollPaneLayoutClass = Class.forName("javax.swing.ScrollPaneLayout");
        }
        catch (Exception e) {
            ScrollPaneLayoutClass = thisClass;
        }
        try {
            ViewportLayoutClass = Class.forName("javax.swing.ViewportLayout");
        }
        catch (Exception e) {
            ViewportLayoutClass = thisClass;
        }
        try {
            GridBagLayoutClass = Class.forName("java.awt.GridBagLayout");
        }
        catch (Exception e) {
            GridBagLayoutClass = thisClass;
        }
        try {
            LayoutManagerClass = Class.forName("java.awt.LayoutManager");
        }
        catch (Exception e) {
            LayoutManagerClass = thisClass;
        }
        try {
            EditorKitClass = Class.forName("javax.swing.text.EditorKit");
        }
        catch (Exception e) {
            EditorKitClass = thisClass;
        }
        try {
            DefaultSingleSelectionModelClass = Class.forName("javax.swing.DefaultSingleSelectionModel");
        }
        catch (Exception e) {
            DefaultSingleSelectionModelClass = thisClass;
        }
        try {
            DefaultListModelClass = Class.forName("javax.swing.DefaultListModel");
        }
        catch (Exception e) {
            DefaultListModelClass = thisClass;
        }
        try {
            DefaultComboBoxModelClass = Class.forName("javax.swing.DefaultComboBoxModel");
        }
        catch (Exception e) {
            DefaultComboBoxModelClass = thisClass;
        }
        try {
            ClassClass = Class.forName("java.lang.Class");
        }
        catch (Exception e) {
            ClassClass = thisClass;
        }
        try {
            CheckboxGroupClass = Class.forName("java.awt.CheckboxGroup");
        }
        catch (Exception e) {
            CheckboxGroupClass = thisClass;
        }
        try {
            CharacterClass = Class.forName("java.lang.Character");
        }
        catch (Exception e) {
            CharacterClass = thisClass;
        }
        try {
            LocaleClass = Class.forName("java.util.Locale");
        }
        catch (Exception e) {
            LocaleClass = thisClass;
        }
        try {
            TreeModelClass = Class.forName("javax.swing.tree.TreeModel");
        }
        catch (Exception e) {
            TreeModelClass = thisClass;
        }
        try {
            TreeNodeClass = Class.forName("javax.swing.tree.TreeNode");
        }
        catch (Exception e) {
            TreeNodeClass = thisClass;
        }
        printProps = null;
    }
}

