/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

public class IPC {
    public static final IPC byRef = new IPC(true, -1);
    public static final IPC byContent = new IPC(true, -2);
    public static final IPC byValue = new IPC(true, -3);
    public static final int PARAMS_RIGHT_TO_LEFT = 0;
    public static final int PARAMS_LEFT_TO_RIGHT = 1;
    public static final int PARAMS_REMOVED_FROM_STACK_BY_CALLER = 0;
    public static final int PARAMS_REMOVED_FROM_STACK_BY_CALLED = 2;
    public static final int RETURN_CODE_UPDATED_ON_EXIT = 0;
    public static final int RETURN_CODE_NOT_UPDATED_ON_EXIT = 4;
    public static final int NORMAL_LINKING_BEHAVIOR = 0;
    public static final int CALL_RESOLVED_AT_LINK_TIME = 8;
    public static final int OS2_OPTLINK = 16;
    public static final int THUNKED_TO_16_BIT = 32;
    public static final int NT_STDCALL = 64;
    public static final int CC_UNSAFE = 128;
    public static final int DISALLOW_NATIVE = 128;
    public static final int DISALLOW_PROGRAM = 256;
    public static final int DISALLOW_JAVA = 512;
    public static final int DISALLOW_COBOL = 1024;
    public static final int DISALLOW_OLD_COBOL = 2048;
    public static final int DISALLOW_INTRINSIC = 4096;
    public static final int DISALLOW_INTERNAL = 8192;
    public static final int DISALLOW_TRANSLATION = 16384;
    public static final int THREAD = 32768;
    public static final int SESSION = 65536;
    public static final int EVENT = 131072;
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 5;
    public static final int BOOLEAN = 6;
    public static final int STRING = 7;
    public static final int OBJECT = 8;
    public static final int PARAM_STYLE = 9;
    private int type = 0;
    private int valueInt;
    private long valueLong;
    private double valueDouble;
    private Object valueObject;

    private IPC(boolean internal, int parameterStyle) {
        this.type = 9;
        this.valueInt = parameterStyle;
    }

    public IPC(byte value) {
        this.type = 0;
        this.valueInt = value;
    }

    public byte toByte() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                return (byte)this.valueInt;
            }
            case 3: {
                return (byte)this.valueLong;
            }
            case 4: 
            case 5: {
                return (byte)this.valueDouble;
            }
            case 6: {
                return (byte)this.valueInt;
            }
            case 7: {
                return (byte)Integer.parseInt(((String)this.valueObject).trim());
            }
            case 8: {
                return (byte)Integer.parseInt(String.valueOf(this.valueObject).trim());
            }
        }
        return 0;
    }

    public IPC(short value) {
        this.type = 1;
        this.valueInt = value;
    }

    public short toShort() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                return (short)this.valueInt;
            }
            case 3: {
                return (short)this.valueLong;
            }
            case 4: 
            case 5: {
                return (short)this.valueDouble;
            }
            case 6: {
                return (short)this.valueInt;
            }
            case 7: {
                return (short)Integer.parseInt(((String)this.valueObject).trim());
            }
            case 8: {
                return (short)Integer.parseInt(String.valueOf(this.valueObject).trim());
            }
        }
        return 0;
    }

    public IPC(int value) {
        this.type = 2;
        this.valueInt = value;
    }

    public int toInt() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                return this.valueInt;
            }
            case 3: {
                return (int)this.valueLong;
            }
            case 4: 
            case 5: {
                return (int)this.valueDouble;
            }
            case 6: {
                return this.valueInt;
            }
            case 7: {
                return Integer.parseInt(((String)this.valueObject).trim());
            }
            case 8: {
                return Integer.parseInt(String.valueOf(this.valueObject).trim());
            }
        }
        return 0;
    }

    public IPC(long value) {
        this.type = 3;
        this.valueLong = value;
    }

    public long toLong() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                return this.valueInt;
            }
            case 3: {
                return this.valueLong;
            }
            case 4: 
            case 5: {
                return (long)this.valueDouble;
            }
            case 6: {
                return this.valueInt;
            }
            case 7: {
                return Long.parseLong(((String)this.valueObject).trim());
            }
            case 8: {
                return Long.parseLong(String.valueOf(this.valueObject).trim());
            }
        }
        return 0L;
    }

    public IPC(float value) {
        this.type = 4;
        this.valueDouble = value;
    }

    public float toFloat() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                return this.valueInt;
            }
            case 3: {
                return this.valueLong;
            }
            case 4: 
            case 5: {
                return (float)this.valueDouble;
            }
            case 6: {
                return this.valueInt;
            }
            case 7: {
                return Float.valueOf(((String)this.valueObject).trim()).floatValue();
            }
            case 8: {
                return Float.valueOf(String.valueOf(this.valueObject).trim()).floatValue();
            }
        }
        return 0.0f;
    }

    public IPC(double value) {
        this.type = 5;
        this.valueDouble = value;
    }

    public double toDouble() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                return this.valueInt;
            }
            case 3: {
                return this.valueLong;
            }
            case 4: 
            case 5: {
                return this.valueDouble;
            }
            case 6: {
                return this.valueInt;
            }
            case 7: {
                return Double.valueOf(((String)this.valueObject).trim());
            }
            case 8: {
                return Double.valueOf(String.valueOf(this.valueObject).trim());
            }
        }
        return 0.0;
    }

    public IPC(boolean value) {
        this.type = 6;
        this.valueInt = value ? 1 : 0;
    }

    public boolean toBoolean() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                return this.valueInt != 0;
            }
            case 3: {
                return this.valueLong != 0L;
            }
            case 4: 
            case 5: {
                return this.valueDouble != 0.0;
            }
            case 6: {
                return this.valueInt != 0;
            }
            case 7: 
            case 8: {
                String s = String.valueOf(this.valueObject).trim();
                if (s.length() == 0) {
                    return false;
                }
                char c = Character.toUpperCase(s.charAt(0));
                switch (c) {
                    case '1': 
                    case 'T': 
                    case 'Y': {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public IPC(String value) {
        this.type = 7;
        this.valueObject = value;
    }

    public String toString() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                return String.valueOf(this.valueInt);
            }
            case 3: {
                return String.valueOf(this.valueLong);
            }
            case 4: 
            case 5: {
                return String.valueOf(this.valueDouble);
            }
            case 6: {
                return this.valueInt != 0 ? "TRUE" : "FALSE";
            }
            case 7: 
            case 8: {
                return String.valueOf(this.valueObject);
            }
        }
        return null;
    }

    public IPC(Object value) {
        this.type = 8;
        this.valueObject = value;
    }

    public Object toObject() {
        switch (this.type) {
            case 0: {
                return new Byte((byte)this.valueInt);
            }
            case 1: {
                return new Short((short)this.valueInt);
            }
            case 2: {
                return new Integer(this.valueInt);
            }
            case 3: {
                return new Long(this.valueLong);
            }
            case 4: {
                return new Float(this.valueDouble);
            }
            case 5: {
                return new Double(this.valueDouble);
            }
            case 6: {
                return new Boolean(this.valueInt != 0);
            }
            case 7: {
                return String.valueOf(this.valueObject);
            }
            case 8: {
                return this.valueObject;
            }
        }
        return null;
    }

    public static Object call(String programId, int callingConvention) {
        return IPC.call(programId, null, callingConvention, null, null);
    }

    public static Object call(String programId, int callingConvention, Object[] params) {
        return IPC.call(programId, null, callingConvention, params, null);
    }

    public static Object call(String programId, int callingConvention, Object[] params, Object givingResult) {
        return IPC.call(programId, null, callingConvention, params, givingResult);
    }

    public static Object call(String programId, Object session, int callingConvention) {
        return IPC.call(programId, session, callingConvention, null, null);
    }

    public static Object call(String programId, Object session, int callingConvention, Object[] params) {
        return IPC.call(programId, session, callingConvention, params, null);
    }

    public static Object call(String programId, Object session, int callingConvention, Object[] params, Object givingResult) {
        throw new RuntimeException("IPC call style not supported in this release.");
    }

    public static void cancel(String programId) {
        IPC.cancel(programId, -1);
    }

    public static void cancel(String programId, int callingConvention) {
    }
}

