/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class LNF {
    private static String alreadySetName = "javax.swing.plaf.metal.MetalLookAndFeel";

    public static void resetName() {
        alreadySetName = "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    public static void setNativeLookAndFeel() {
        String ui = RuntimeEnvironment.getGlobalParameter("UI");
        if (ui == null) {
            ui = UIManager.getSystemLookAndFeelClassName();
        } else if (ui.indexOf(46) < 0) {
            String uiUppercase = ui.toUpperCase();
            if (uiUppercase.indexOf("METAL") >= 0) {
                ui = "javax.swing.plaf.metal.MetalLookAndFeel";
            } else if (uiUppercase.indexOf("MOTIF") >= 0) {
                ui = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if (uiUppercase.indexOf("WINDOWS") >= 0) {
                ui = "com.sun.java.swing.plaf.window.WindowLookAndFeel";
            }
            RuntimeEnvironment.setGlobalParameter("UI", ui);
        }
        LNF.setLookAndFeel(ui);
    }

    public static void setLookAndFeel(String name) {
        if (name == null) {
            return;
        }
        if (name.equals(alreadySetName)) {
            return;
        }
        alreadySetName = name;
        try {
            UIManager.setLookAndFeel(name);
        }
        catch (Throwable t) {
            Class<?> lfClass = null;
            Object o = null;
            try {
                lfClass = Class.forName(name);
                o = lfClass.newInstance();
                if (o instanceof LookAndFeel) {
                    UIManager.setLookAndFeel(o);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

