/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.LockRecord;
import com.heirloomcomputing.ecs.exec.PopupDialog;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class LockRecordNetwork
extends LockRecord
implements FileConstants {
    private static int usePort = -1;
    private boolean initialized;
    private Socket socket;
    private int port = 6586;
    private boolean connected;
    private String filename;
    private int mode;
    private DataOutputStream os;
    private DataInputStream is;
    private int status;
    private int reasonCode;

    @Override
    public boolean isStatusLocked() {
        return LockRecordNetwork.isStatusLocked(this.getStatus());
    }

    @Override
    public boolean isStatusRejected() {
        return LockRecordNetwork.isStatusRejected(this.getStatus());
    }

    @Override
    public boolean isStatusRejectedNoErrors() {
        int status = this.getStatus();
        return LockRecordNetwork.isStatusRejected(status) && LockRecordNetwork.isStatusNoErrors(status);
    }

    @Override
    public boolean isStatusFileChanged() {
        return LockRecordNetwork.isStatusFileChanged(this.getStatus());
    }

    @Override
    public boolean isStatusRecordChanged() {
        return LockRecordNetwork.isStatusRecordChanged(this.getStatus());
    }

    @Override
    public boolean isStatusErrorUnknown() {
        return LockRecordNetwork.isStatusErrorUnknown(this.getStatus());
    }

    @Override
    public boolean isStatusTooMany() {
        return LockRecordNetwork.isStatusTooMany(this.getStatus());
    }

    public static boolean isStatusNoErrors(int n) {
        return (n & 0x18) == 0;
    }

    public static boolean isStatusLocked(int n) {
        return (n & 1) != 0;
    }

    public static boolean isStatusRejected(int n) {
        return (n & 1) == 0;
    }

    public static boolean isStatusFileChanged(int n) {
        return (n & 2) != 0;
    }

    public static boolean isStatusRecordChanged(int n) {
        return (n & 4) != 0;
    }

    public static boolean isStatusErrorUnknown(int n) {
        return (n & 8) != 0;
    }

    public static boolean isStatusTooMany(int n) {
        return (n & 0x10) != 0;
    }

    @Override
    public void open(String filename, int mode) {
        this.filename = filename;
        this.mode = mode;
        this.shutdown();
    }

    @Override
    public void close() {
        this.shutdown();
    }

    @Override
    public boolean exclusive() {
        if (this.connect()) {
            try {
                this.os.writeInt(1);
                this.os.flush();
                return this.is.readInt() == 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void unexclusive() {
        if (this.connect()) {
            try {
                this.os.writeInt(2);
                this.os.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean lock(long record, long size) {
        this.lockSequence(record);
        return this.isStatusLocked();
    }

    @Override
    public boolean writeLock(long record, long size) {
        return this.lock(record);
    }

    @Override
    public boolean blockingReadLock(long record, long size) {
        return this.blockingReadLockTimeout(record, size, 30000L);
    }

    @Override
    public boolean blockingWriteLock(long record, long size) {
        return this.blockingWriteLockTimeout(record, size, 30000L);
    }

    @Override
    public boolean readLock(long record, long size) {
        this.readLockSequence(record);
        return this.isStatusLocked();
    }

    @Override
    public void writeUnlock(long record, long size) {
        this.unlock(record);
    }

    @Override
    public void unlock(long record, long size) {
        if (this.connect()) {
            try {
                this.os.writeInt(4);
                this.os.writeLong(record);
                this.os.flush();
                this.setReason(0);
                return;
            }
            catch (IOException e) {
                this.setReason(31);
            }
            catch (Exception e) {
                this.setReason(32);
            }
        }
    }

    @Override
    public void readUnlock(long record, long size) {
        if (this.connect()) {
            try {
                this.os.writeInt(4);
                this.os.writeLong(-record);
                this.os.flush();
                this.setReason(0);
            }
            catch (IOException e) {
                this.setReason(41);
            }
            catch (Exception e) {
                this.setReason(42);
            }
        }
    }

    @Override
    public void unlockAll() {
        if (this.connect()) {
            try {
                this.os.writeInt(5);
                this.os.flush();
                this.setReason(0);
            }
            catch (IOException e) {
                this.setReason(51);
            }
            catch (Exception e) {
                this.setReason(52);
            }
        }
    }

    @Override
    public void setFileObject(Object fileObject) {
    }

    private void shutdown() {
        if (this.connected) {
            try {
                if (this.os != null) {
                    this.os.writeInt(0);
                    this.os.flush();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.os = null;
            this.is = null;
            this.socket = null;
            this.connected = false;
            this.initialized = false;
        }
    }

    private boolean connect() {
        if (this.connected) {
            return true;
        }
        if (this.init()) {
            try {
                this.os.writeUTF(this.filename);
                this.os.writeInt(this.mode);
                this.os.flush();
                this.connected = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.connected;
    }

    private void setReason(int c) {
        this.reasonCode = c;
    }

    private int getStatus() {
        return this.status;
    }

    private void setStatus(int status) {
        this.status = status;
    }

    private boolean init() {
        if (this.initialized) {
            return true;
        }
        if (usePort == -1) {
            String lockPortString = RuntimeEnvironment.getGlobalParameter("LOCKPORT");
            if (lockPortString != null) {
                try {
                    usePort = ConvertData.parseInt(lockPortString.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (usePort < 0) {
                usePort = 0;
            }
        }
        if (usePort > 0) {
            this.port = usePort;
        }
        if (!this.internalConnect(true)) {
            return false;
        }
        this.initialized = true;
        return true;
    }

    private boolean internalConnect(boolean interact) {
        if (this.connected) {
            return true;
        }
        try {
            String lockServer = RuntimeEnvironment.getGlobalParameter("LOCKSERVER");
            String lockHost = "127.0.0.1";
            int lockPort = this.port;
            if (lockServer != null) {
                int dot = lockServer.indexOf(58);
                if (dot >= 0) {
                    lockHost = lockServer.substring(0, dot);
                    try {
                        lockPort = ConvertData.parseInt(lockServer.substring(dot + 1).trim());
                    }
                    catch (Exception exception) {}
                } else {
                    lockHost = lockServer;
                }
            }
            this.socket = new Socket(lockHost, lockPort);
            this.socket.setSoTimeout(0);
            this.socket.setTcpNoDelay(true);
            this.os = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.is = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.initialized = true;
            return true;
        }
        catch (Exception initException) {
            if (interact) {
                this.socket = null;
                String msg = "Could not find RecordServer: java -cp ecobol.jar com.heirloomcomputing.ecs.exec.RecordServer";
                try {
                    PopupDialog d = new PopupDialog("Start Record Server Now", msg, "RC");
                    d.setVisible(true);
                    char c = d.getResultChar();
                    if (c == 'R') {
                        return this.internalConnect(interact);
                    }
                }
                catch (Throwable e) {
                    Utilities.debugOutput(msg);
                }
            }
            return false;
        }
    }

    private int lockSequence(long record) {
        if (this.connect()) {
            try {
                this.os.writeInt(3);
                this.os.writeLong(record);
                this.os.flush();
                int status = this.is.readInt();
                this.setReason(0);
                this.setStatus(status);
                return status;
            }
            catch (Exception e) {
                this.setReason(71);
            }
        }
        this.setStatus(8);
        return 0;
    }

    private int blockingReadLockSequenceTimeout(long record, long size, long millis) {
        if (this.connect()) {
            try {
                this.os.writeInt(6);
                this.os.writeLong(-record);
                this.os.writeLong(millis);
                this.os.flush();
                int status = this.is.readInt();
                this.setReason(0);
                this.setStatus(status);
                return status;
            }
            catch (IOException e) {
                this.setReason(1);
            }
            catch (Exception e) {
                this.setReason(2);
            }
        }
        this.setStatus(8);
        return 0;
    }

    private int blockingWriteLockSequenceTimeout(long record, long size, long millis) {
        if (this.connect()) {
            try {
                this.os.writeInt(6);
                this.os.writeLong(record);
                this.os.writeLong(millis);
                this.os.flush();
                int status = this.is.readInt();
                this.setReason(0);
                this.setStatus(status);
                return status;
            }
            catch (IOException e) {
                this.setReason(11);
            }
            catch (Exception e) {
                this.setReason(12);
            }
        }
        this.setStatus(8);
        return 0;
    }

    private int readLockSequence(long record) {
        if (this.connect()) {
            try {
                this.os.writeInt(3);
                this.os.writeLong(-record);
                this.os.flush();
                int status = this.is.readInt();
                this.setReason(0);
                this.setStatus(status);
                return status;
            }
            catch (IOException e) {
                this.setReason(21);
            }
            catch (Exception e) {
                this.setReason(22);
            }
        }
        this.setStatus(8);
        return 0;
    }

    public int transformOpenMode(int openMode) {
        return openMode;
    }

    private boolean blockingReadLockTimeout(long record, long size, long millis) {
        this.blockingReadLockSequenceTimeout(record, size, millis);
        return this.isStatusLocked();
    }

    private boolean blockingWriteLockTimeout(long record, long size, long millis) {
        this.blockingWriteLockSequenceTimeout(record, size, millis);
        return this.isStatusLocked();
    }
}

