/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.LockRecord;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.MFFilePointer;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.VariableList;
import com.heirloomcomputing.ecs.exec.comparableByteArray;
import com.heirloomcomputing.ecs.exec.seqFile;
import com.heirloomcomputing.ecs.exec.smartFile;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class MFFile {
    private static final int IDX3_FILE_POINTER_SIZE = 4;
    private static final int IDX3_STD_HEADER_SIZE = 0;
    private static final int IDX8_FILE_POINTER_SIZE = 6;
    private static final int IDX8_STD_HEADER_SIZE = 2;
    public static final int STD_FILE_HEADER_TYPE = 1;
    public static final int IDX_KEY_BLOCK_HEADER_TYPE = 2;
    private static final int IDX8_LRG_HEADER_SIZE = 4;
    private static final int IDX8_KEY_COMPRESSION_DUPS = 1;
    private static final int IDX8_KEY_COMPRESSION_LEAD = 2;
    private static final int IDX8_KEY_COMPRESSION_TRAL = 4;
    private static final int IDX8_KEY_COMPRESSION_NULL = 8;
    private static final int IDX8_KEY_COMPRESSION_MASK = 15;
    protected static final boolean debugMode = false;
    protected static final boolean sanityCheck = false;
    protected seqFile dataFile;
    protected smartFile keyFile;
    protected int nodeSize = 0;
    protected int numberOfKeys = 0;
    protected String filename = null;
    protected boolean dataFileWasDeclared = false;
    protected int recordFrom = -1;
    protected int recordTo = -1;
    protected Variable dependingOn = null;
    protected int newModes = 0;
    protected int[] keyLengths = null;
    protected boolean[] keyDuplicatesAllowed = null;
    protected Object[] keyStartLocations = null;
    protected int[] keyOffsets = null;
    protected Variable[] keyArray = null;
    protected Variable masterRecord = null;
    protected boolean isOpen = false;
    protected boolean readable = false;
    protected boolean writable = false;
    protected boolean extend = false;
    protected boolean fileAlreadyExists = false;
    private int status = 0;
    protected byte[] keyFileHeader = null;
    protected Vector<byte[]> keyInfoRecords = null;
    protected long startOfKeyInfoRecords = 0L;
    protected long startOfDataFreeSpaceRecords = 0L;
    protected long startOfKeyFreeSpaceRecords = 0L;
    protected long endOfKeyFileIndex = 0L;
    protected long currentKeyFileIndex = 0L;
    protected long endOfDataFileIndex = 0L;
    protected long currentDataFileIndex = 0L;
    protected int keyCompression = 0;
    protected int dataCompression = 0;
    protected Compression algorithm = null;
    protected int idxFormat = 3;
    protected int filePointerSize = 4;
    protected int idxHeaderSize = 0;
    protected Date creationTime = null;
    protected int treeHeight = 0;
    protected LockRecord dataLockRecord = null;
    protected LockRecord idxLockRecord = null;
    private int keyBlockCurIndex = -1;
    private int keyBlockOffset = -1;
    private int keyBlockContinuationRecordNumber = -1;
    private static int CurrentCompression = 0;
    private static Compression BuiltinCompression = null;
    private static Compression[] UserCompressions = null;
    private static boolean InittedCompression = false;

    public static void debug(String text) {
        System.out.println("MFFile: " + text);
    }

    protected void warning(String method, String text) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.warning("MFFile." + method + " Open Error (file " + (this.filename == null ? "unknown" : this.filename) + "): " + text);
        }
    }

    public MFFile(int nodeSize, int numberOfKeys, int recordFrom, int recordTo, Variable dependingOn, int keyCompression, int dataCompression, int idxFormat, int[] keyLengths, boolean[] keyDuplicatesAllowed, Object[] keyStartLocations, int[] keyOffsets, Variable[] keyArray, Variable masterRecord, int newModes, LockRecord dataLockRecord, LockRecord idxLockRecord) {
        this.idxFormat = idxFormat;
        if (idxFormat == 3 || idxFormat == 0 || idxFormat == 4) {
            this.dataFile = new seqFile();
            this.keyFile = new smartFile();
            this.dataLockRecord = dataLockRecord;
            this.idxLockRecord = idxLockRecord;
            dataLockRecord.setFileObject(this.dataFile.getSmartFile());
            idxLockRecord.setFileObject(this.keyFile);
            this.filePointerSize = 4;
            this.idxHeaderSize = 0;
        } else if (idxFormat == 8) {
            this.dataFile = null;
            this.keyFile = new smartFile();
            this.dataLockRecord = null;
            this.idxLockRecord = idxLockRecord;
            idxLockRecord.setFileObject(this.keyFile);
            this.filePointerSize = 6;
            this.idxHeaderSize = recordTo > 4095 ? 4 : 2;
        }
        this.nodeSize = nodeSize;
        this.numberOfKeys = numberOfKeys;
        this.dataFileWasDeclared = false;
        this.recordFrom = recordFrom;
        this.recordTo = recordTo;
        this.dependingOn = dependingOn;
        this.keyLengths = keyLengths;
        this.keyDuplicatesAllowed = keyDuplicatesAllowed;
        this.keyStartLocations = keyStartLocations;
        this.keyOffsets = keyOffsets;
        this.keyArray = keyArray;
        this.masterRecord = masterRecord;
        this.dataCompression = dataCompression;
        if (dataCompression != 0) {
            this.algorithm = MFFile.GetCompression(dataCompression);
            if (this.algorithm == null) {
                this.dataCompression = 0;
            }
        }
        this.newModes = newModes;
    }

    boolean deleteFile() {
        String name = this.filename;
        if (name == null) {
            return false;
        }
        File f = new File(name);
        boolean flag = false;
        try {
            flag = f.exists() ? f.delete() : true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!flag) {
            return false;
        }
        if (this.idxFormat == 3 || this.idxFormat == 0 || this.idxFormat == 4) {
            if (name.toLowerCase().endsWith(".dat")) {
                name = name.substring(0, name.length() - 4);
            }
            name = name + ".idx";
            f = new File(name);
            flag = false;
            try {
                flag = f.exists() ? f.delete() : true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return flag;
    }

    int setFilename(String filename) {
        if (filename.toLowerCase().endsWith(".idx")) {
            return -90004;
        }
        this.filename = filename;
        if (this.idxFormat == 3 || this.idxFormat == 0 || this.idxFormat == 4) {
            if (!this.dataFileWasDeclared) {
                int status = this.declareDataFile();
                if (status < 0) {
                    return status;
                }
            } else {
                this.dataFile.setFilename("mf" + this.idxFormat + ":" + filename);
            }
            String keyFilename = filename;
            if (keyFilename.endsWith(".dat")) {
                keyFilename = keyFilename.substring(0, keyFilename.length() - 4);
                keyFilename = keyFilename + ".idx";
            } else if (keyFilename.endsWith(".DAT")) {
                keyFilename = keyFilename.substring(0, keyFilename.length() - 4);
                keyFilename = keyFilename + ".IDX";
            } else {
                keyFilename = keyFilename + ".idx";
            }
            this.keyFile.setFilename(keyFilename);
        } else if (this.idxFormat == 8) {
            this.filePointerSize = 6;
            this.idxHeaderSize = this.recordTo > 4095 ? 4 : 2;
            this.keyFile.setFilename(filename);
        }
        return 0;
    }

    int declareDataFile() {
        this.dataFile.declare(true, "mf" + this.idxFormat + ":" + this.filename, -1, null, '\u0000', null, -1, -1, false, this.recordFrom, this.recordTo, this.dependingOn, false, null, -1, null, -1, null, -1, null, -1, null, this.newModes | 2);
        this.dataFileWasDeclared = true;
        return 0;
    }

    int open(int mode) {
        this.iostatus(0);
        int dataMode = mode;
        this.readable = (mode & 1) != 0;
        this.writable = (mode & 2) != 0;
        if ((mode & 4) != 0) {
            this.writable = true;
            this.extend = true;
            dataMode |= 8;
        } else {
            this.extend = false;
        }
        int openReturnCode = this.keyFile.open(dataMode);
        this.iostatus(openReturnCode);
        if (openReturnCode > -10) {
            int returnCode;
            if (this.dataLockRecord != null) {
                this.dataLockRecord.open(this.filename, mode & 0x16000);
            }
            if (this.idxLockRecord != null) {
                this.idxLockRecord.open(this.keyFile.getFilename(), mode & 0x16000 | 0x10000);
            }
            boolean bl = this.fileAlreadyExists = !this.keyFile.isNewFile();
            if (!this.fileAlreadyExists) {
                if (this.idxFormat != 8) {
                    String name = this.filename;
                    File f = new File(name);
                    boolean flag = false;
                    try {
                        flag = f.delete();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                dataMode |= 0x408;
            } else {
                int requestedIdxFormat = this.idxFormat;
                returnCode = this.readHeaderInformation();
                this.iostatus(returnCode);
                if (returnCode < 0) {
                    try {
                        this.keyFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return returnCode;
                }
                if (requestedIdxFormat != this.idxFormat) {
                    if (requestedIdxFormat == 8) {
                        this.setFilename(this.filename);
                    } else {
                        this.dataFile = null;
                        this.setFilename(this.filename);
                    }
                }
            }
            if (this.idxFormat != 8) {
                this.dataFile.setLowLevel(true);
                boolean flag = this.dataFile.open(dataMode);
                if (!flag) {
                    returnCode = this.dataFile.priorError();
                    this.iostatus(returnCode);
                    try {
                        this.keyFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return returnCode;
                }
            }
            if (this.fileAlreadyExists) {
                if (this.idxFormat != 8 && this.dataFile.getSmartFile().isNewFile()) {
                    try {
                        this.dataFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.keyFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return -90043;
                }
            } else {
                if (!this.isWritable()) {
                    if (this.idxFormat != 8) {
                        try {
                            this.dataFile.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    try {
                        this.keyFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return openReturnCode;
                }
                if (this.idxFormat != 8 && !this.dataFile.getSmartFile().isNewFile()) {
                    try {
                        this.dataFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.keyFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return -90043;
                }
                this.keyFileHeader = null;
                this.keyInfoRecords = null;
                if (this.dataCompression != MFFile.CurrentCompression(-1)) {
                    this.dataCompression = MFFile.CurrentCompression(-1);
                    this.algorithm = MFFile.GetCompression(this.dataCompression);
                }
                returnCode = this.writeHeaderInformation();
                this.iostatus(returnCode);
                if (returnCode < 0) {
                    if (this.idxFormat != 8) {
                        try {
                            this.dataFile.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    try {
                        this.keyFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return returnCode;
                }
            }
            this.isOpen = true;
            if (this.fileAlreadyExists) {
                // empty if block
            }
        }
        return openReturnCode;
    }

    public final int close(int mode) {
        int returnCode = 0;
        this.isOpen = false;
        if ((this.idxFormat == 3 || this.idxFormat == 0 || this.idxFormat == 4) && this.dataFile.close(mode)) {
            returnCode = this.dataFile.priorError();
            this.iostatus(returnCode);
            return returnCode;
        }
        this.fileAlreadyExists = false;
        returnCode = this.keyFile.close(mode);
        this.iostatus(returnCode);
        if (this.dataLockRecord != null) {
            this.dataLockRecord.close();
        }
        if (this.idxLockRecord != null) {
            this.idxLockRecord.close();
        }
        return returnCode;
    }

    public final int close() {
        return this.close(0);
    }

    private int readHeaderInformation() {
        int returnCode = 0;
        if (this.keyFileHeader == null) {
            this.keyFileHeader = new byte[this.nodeSize];
            this.keyInfoRecords = new Vector();
        }
        returnCode = this.keyFile.seek(0L);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.keyFile.read(this.keyFileHeader, 0, this.nodeSize, true);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        int hSize = (int)this.getFileHeaderLength();
        if (this.nodeSize != hSize + 2) {
            this.nodeSize = hSize + 2;
            this.keyFileHeader = new byte[this.nodeSize];
            returnCode = this.keyFile.seek(0L);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return returnCode;
            }
            returnCode = this.keyFile.read(this.keyFileHeader, 0, this.nodeSize, true);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return returnCode;
            }
        }
        this.creationTime = this.getCreationDateAndTime();
        this.algorithm = MFFile.GetCompression(this.keyFileHeader[41]);
        if (this.algorithm != null) {
            this.dataCompression = this.keyFileHeader[41];
        }
        this.idxFormat = this.keyFileHeader[43];
        if (this.idxFormat == 3 || this.idxFormat == 0 || this.idxFormat == 4) {
            this.filePointerSize = 4;
            this.idxHeaderSize = 0;
        } else if (this.idxFormat == 8) {
            this.filePointerSize = 6;
            this.idxHeaderSize = this.getMaxRecordLength() > 4095 ? 4 : 2;
        } else {
            returnCode = -90041;
            return -90041;
        }
        this.treeHeight = this.getTreeHeight();
        this.endOfKeyFileIndex = this.getEndOfKeyFileIndex();
        this.endOfDataFileIndex = this.getEndOfDataFileIndex();
        this.startOfKeyInfoRecords = this.getStartOfKeyInfoRecords();
        this.startOfDataFreeSpaceRecords = this.getStartOfDataFreeSpaceRecords();
        this.startOfKeyFreeSpaceRecords = this.getStartOfKeyFreeSpaceRecords();
        returnCode = this.keyFile.seek(this.startOfKeyInfoRecords);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        int count = 0;
        while (true) {
            byte[] bytes = null;
            if (count >= this.keyInfoRecords.size()) {
                bytes = new byte[this.nodeSize];
                this.keyInfoRecords.addElement(bytes);
            } else {
                bytes = this.keyInfoRecords.elementAt(count);
            }
            returnCode = this.keyFile.read(bytes, 0, this.nodeSize, true);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return returnCode;
            }
            long next = this.getFilePointerFromBytes(bytes, this.idxHeaderSize + 2);
            if (next <= 0L) break;
            returnCode = this.keyFile.seek(next);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return returnCode;
            }
            ++count;
        }
        return 0;
    }

    private int writeHeaderInformation() {
        block18: {
            int returnCode = 0;
            if (!this.isWritable()) {
                return 0;
            }
            if (this.keyFileHeader == null) {
                this.keyFileHeader = new byte[this.nodeSize];
                this.keyInfoRecords = new Vector();
                returnCode = this.keyFile.write(this.keyFileHeader);
                this.iostatus(returnCode);
                if (returnCode < 0) {
                    return returnCode;
                }
                this.setRecordHeader(this.keyFileHeader, 1);
                this.creationTime = new Date();
                this.setCreationDateAndTime(this.creationTime);
                this.keyFileHeader[36] = 0;
                this.keyFileHeader[37] = 62;
                this.keyFileHeader[39] = 2;
                this.keyFileHeader[41] = (byte)this.dataCompression;
                if (this.idxFormat == 8) {
                    this.keyFileHeader[42] = 1;
                }
                this.keyFileHeader[43] = (byte)this.idxFormat;
                byte recordingMode = 0;
                if (this.recordFrom != this.recordTo) {
                    recordingMode = 1;
                }
                this.keyFileHeader[48] = recordingMode;
                this.setMaxRecordLength(this.recordTo);
                this.setMinRecordLength(this.recordFrom);
                this.keyFileHeader[76] = 2;
                this.keyFileHeader[77] = 2;
                this.keyFileHeader[78] = 1;
                this.setTreeHeight(this.treeHeight);
                this.setVersionInformation();
                this.endOfDataFileIndex = this.idxFormat == 8 ? (this.endOfKeyFileIndex = this.keyFile.getFilePointer()) : this.dataFile.getFilePointer();
                this.setEndOfDataFileIndex(this.endOfDataFileIndex);
                this.keyFileHeader[136] = this.idxFormat == 8 ? (this.recordTo > 4095 ? 6 : 4) : 2;
                this.keyFileHeader[137] = 2;
                this.keyFileHeader[138] = 4;
                this.keyFileHeader[139] = 4;
                this.setNumberOfKeys(this.numberOfKeys);
                this.keyCompression = 0;
                this.keyFileHeader[143] = 2;
                if (this.idxFormat == 3 || this.idxFormat == 0) {
                    if ((this.keyCompression & 1) != 0) {
                        this.keyFileHeader[143] = 2;
                    }
                } else if (this.idxFormat == 4) {
                    this.keyFileHeader[142] = 1;
                    if ((this.keyCompression & 1) != 0) {
                        this.keyFileHeader[143] = 4;
                    }
                } else if (this.idxFormat == 8) {
                    this.keyFileHeader[142] = 0;
                    this.keyFileHeader[143] = 4;
                }
                this.startOfKeyInfoRecords = this.nodeSize;
                this.setStartOfKeyInfoRecords(this.startOfKeyInfoRecords);
                this.startOfDataFreeSpaceRecords = 0L;
                this.setStartOfDataFreeSpaceRecords(this.startOfDataFreeSpaceRecords);
                this.startOfKeyFreeSpaceRecords = 0L;
                this.setStartOfKeyFreeSpaceRecords(this.startOfKeyFreeSpaceRecords);
                this.setKeyFileRecordLength(this.nodeSize - (this.idxFormat == 8 && this.recordTo > 4095 ? 4 : 2));
                this.createKeyInfoRecords(0);
                this.endOfKeyFileIndex = this.keyFile.getFilePointer();
                if (this.idxFormat == 8) {
                    this.endOfDataFileIndex = this.endOfKeyFileIndex;
                }
                this.setEndOfKeyFileIndex(this.endOfKeyFileIndex);
            }
            returnCode = this.keyFile.seek(0L);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return returnCode;
            }
            returnCode = this.keyFile.write(this.keyFileHeader);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return returnCode;
            }
            returnCode = this.keyFile.seek(this.startOfKeyInfoRecords);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return returnCode;
            }
            int count = 0;
            do {
                long next;
                byte[] bytes = this.keyInfoRecords.elementAt(count);
                returnCode = this.keyFile.write(bytes);
                this.iostatus(returnCode);
                if (returnCode < 0) {
                    return returnCode;
                }
                if (++count >= this.keyInfoRecords.size() || (next = this.getFilePointerFromBytes(bytes, this.idxHeaderSize + 2)) <= 0L) break block18;
                returnCode = this.keyFile.seek(next);
                this.iostatus(returnCode);
            } while (returnCode >= 0);
            return returnCode;
        }
        return 0;
    }

    private byte[] getKeyBlock(int keyIndex) {
        try {
            if (this.keyBlockCurIndex > keyIndex || this.keyBlockCurIndex < 0) {
                this.keyBlockCurIndex = 0;
                this.keyBlockOffset = this.idxHeaderSize + 2 + this.filePointerSize;
                this.keyBlockContinuationRecordNumber = 0;
            }
            return this.getKeyBlock(this.keyBlockContinuationRecordNumber, this.keyBlockCurIndex, this.keyBlockOffset, keyIndex);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private byte[] getKeyBlock(int continuationRecordNumber, int curIndex, int offset, int keyIndex) {
        byte[] bytes = null;
        bytes = this.keyInfoRecords.elementAt(continuationRecordNumber);
        int end = this.getShortFromBytes(bytes, this.idxHeaderSize) & 0xFFF;
        while (curIndex < keyIndex && offset < end) {
            offset += this.getShortFromBytes(bytes, offset);
            ++curIndex;
        }
        if (curIndex < keyIndex) {
            return this.getKeyBlock(continuationRecordNumber + 1, curIndex, this.idxFormat == 8 ? 17 : 6, keyIndex);
        }
        this.keyBlockCurIndex = curIndex;
        this.keyBlockOffset = offset;
        this.keyBlockContinuationRecordNumber = continuationRecordNumber;
        return bytes;
    }

    private int getKeyCompression(int keyIndex) {
        byte[] bytes = this.getKeyBlock(keyIndex);
        if (bytes == null) {
            return 0;
        }
        return bytes[this.keyBlockOffset + 6] & 0xFF;
    }

    public Object checkSanityX1K(Object num) {
        long lnum;
        comparableByteArray cba;
        byte[] bytes;
        if (num instanceof comparableByteArray && (bytes = (cba = (comparableByteArray)num).toByteArray()).length == 6 && (lnum = (long)(bytes[0] & 0xFF) << 40 | (long)(bytes[1] & 0xFF) << 32 | (long)(bytes[2] & 0xFF) << 24 | (long)(bytes[3] & 0xFF) << 16 | (long)(bytes[4] & 0xFF) << 8 | (long)(bytes[5] & 0xFF)) % 1024L != 0L) {
            throw new RuntimeException("*** Heirloom Computing internal error MFFile: root locations must be multiples of 1K but is  " + lnum);
        }
        return num;
    }

    public Object checkSanityX1K(long num) {
        if (num % 1024L != 0L) {
            throw new RuntimeException("*** Heirloom Computing internal error MFFile: root locations must be multiples of 1K but is  " + num);
        }
        return num;
    }

    public Object checkSanityLT1K(int num) {
        if (num >= 1024) {
            throw new RuntimeException("*** Heirloom Computing internal error MFFile: offset within buffer must be < 1K but is  " + num);
        }
        return num;
    }

    private void checkSanityGE0(long num) {
        if (num < 0L) {
            throw new RuntimeException("*** Heirloom Computing internal error MFFile:neg seek location " + num);
        }
    }

    private void checkSanity1K(long num) {
        if (num % 1024L != 0L) {
            throw new RuntimeException("*** Heirloom Computing internal error MFFile:file position not multiple of 1K " + num);
        }
    }

    public void checkSanityRT(byte[] record, int ... i) {
        int rt = (record[0] & 0xF0) >> 4;
        if ((i == null || i.length == 0) && (rt == 2 || rt != 0 && rt != 1 && rt != 3 && rt != 6) || i != null && i.length == 1 && i[0] != rt) {
            throw new RuntimeException("*** Heirloom Computing internal error bTreeNode: invalid record type  " + rt + (i != null && i.length == 1 ? " should be " + i[0] : ""));
        }
    }

    public MFFilePointer getKeyStartLocation(int keyIndex) {
        byte[] bytes = this.getKeyBlock(keyIndex);
        if (bytes == null) {
            return null;
        }
        MFFilePointer location = new MFFilePointer(this.getFilePointerFromBytes(bytes, this.idxHeaderSize + this.keyBlockOffset + (this.idxFormat == 8 ? (this.getMaxRecordLength() > 4095 ? 12 : 14) : 2)), this.idxFormat == 8);
        if (this.keyStartLocations != null) {
            this.keyStartLocations[keyIndex] = location;
        }
        return location;
    }

    private void updateKeyStartLocations() {
        byte[] bytes;
        for (int i = 0; i < this.numberOfKeys && (bytes = this.getKeyBlock(i)) != null; ++i) {
            MFFilePointer location = (MFFilePointer)this.keyStartLocations[i];
            this.setBytesFromFilePointer(bytes, this.idxHeaderSize + this.keyBlockOffset + (this.idxFormat == 8 ? (this.getMaxRecordLength() > 4095 ? 12 : 14) : 2), location.getRecordKey());
        }
    }

    private int createKeyInfoRecords(int keyIndex) {
        int len;
        if (this.numberOfKeys <= 0) {
            return 0;
        }
        int count = 1;
        int returnCode = 0;
        byte[] bytes = new byte[this.nodeSize];
        this.keyInfoRecords.addElement(bytes);
        this.setRecordHeader(bytes, 2);
        int index = this.idxHeaderSize + this.filePointerSize + 2;
        while (keyIndex < this.numberOfKeys && (len = this.createKeyBlock(bytes, index, keyIndex)) > 0) {
            index += len;
            ++keyIndex;
        }
        this.setBytesFromShort(bytes, this.idxHeaderSize, index);
        if (this.idxFormat == 8) {
            bytes[this.nodeSize - 4] = 0;
            bytes[this.nodeSize - 3] = 0;
            bytes[this.nodeSize - 2] = -1;
            bytes[this.nodeSize - 1] = 126;
        } else {
            bytes[this.nodeSize - 4] = -1;
            bytes[this.nodeSize - 3] = 126;
            bytes[this.nodeSize - 2] = 0;
            bytes[this.nodeSize - 1] = 0;
        }
        returnCode = this.keyFile.write(bytes);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        if (keyIndex < this.numberOfKeys) {
            this.setBytesFromFilePointer(bytes, this.idxFormat == 8 ? 16 : 2, this.keyFile.getFilePointer());
            count += this.createKeyInfoRecords(keyIndex);
        }
        return count;
    }

    private int createKeyBlock(byte[] bytes, int index, int keyIndex) {
        int offset = index;
        Variable[] keyComponentVariables = null;
        int keyComponents = 0;
        if (this.keyArray[keyIndex] instanceof VariableList) {
            keyComponentVariables = ((VariableList)this.keyArray[keyIndex]).getList();
            keyComponents = keyComponentVariables.length;
        } else if (this.keyLengths[keyIndex] > 0) {
            keyComponents = 1;
        } else {
            return -1;
        }
        if (this.idxFormat == 8) {
            if (offset + 24 + keyComponents * 8 >= bytes.length - 4) {
                return -keyIndex;
            }
            bytes[offset + 3] = 32;
        } else if (offset + 7 + keyComponents * 5 >= bytes.length - 4) {
            return -keyIndex;
        }
        if (this.keyStartLocations != null && this.keyStartLocations[keyIndex] instanceof MFFilePointer) {
            long location = ((MFFilePointer)this.keyStartLocations[keyIndex]).getRecordKey();
            if (this.idxFormat == 8) {
                this.setBytesFromFilePointer(bytes, offset + 16, location);
            } else {
                this.setBytesFromFilePointer(bytes, offset + 2, location);
            }
        }
        offset = this.idxFormat == 8 ? (offset += 22) : (offset += 6);
        bytes[offset] = (byte)(this.keyCompression & 0xFE);
        if (this.idxFormat == 8) {
            int n = ++offset;
            ++offset;
            bytes[n] = (byte)(this.keyDuplicatesAllowed[keyIndex] ? 64 : 16);
        } else {
            if ((this.keyCompression & 1) != 0 && this.keyDuplicatesAllowed[keyIndex]) {
                int n = offset;
                bytes[n] = (byte)(bytes[n] | 1);
            }
            ++offset;
        }
        if (keyComponentVariables != null) {
            int masterRecordAddress = this.masterRecord.getAddress();
            for (int i = 0; i < keyComponentVariables.length; ++i) {
                Variable v = keyComponentVariables[i];
                offset += this.createKeyComponentBlock(bytes, offset, keyIndex, v.length(), v.getAddress() - masterRecordAddress);
            }
        } else {
            offset += this.createKeyComponentBlock(bytes, offset, keyIndex, this.keyLengths[keyIndex], this.keyOffsets[keyIndex]);
        }
        int len = offset - index;
        this.setBytesFromShort(bytes, index, len);
        return len;
    }

    private int createKeyComponentBlock(byte[] bytes, int offset, int keyIndex, int keyLength, int keyOffset) {
        int start = offset;
        this.setBytesFromShort(bytes, offset, keyLength);
        if (this.idxFormat == 8) {
            offset += 4;
        } else {
            if (this.keyDuplicatesAllowed[keyIndex]) {
                int n = offset;
                bytes[n] = (byte)(bytes[n] | 0xFFFFFF80);
            } else {
                int n = offset;
                bytes[n] = (byte)(bytes[n] & 0x7F);
            }
            offset += 2;
        }
        this.setBytesFromShort(bytes, offset, keyOffset);
        offset += 2;
        if (this.idxFormat == 8) {
            bytes[offset++] = 0;
            bytes[offset++] = 0;
        } else {
            bytes[offset++] = 0;
        }
        return offset - start;
    }

    public boolean checkHeaderInformation() {
        if (this.keyFileHeader == null) {
            this.warning("checkHeaderInformation", "index file header missing");
            return false;
        }
        if (this.keyFileHeader[39] != 2) {
            this.warning("checkHeaderInformation", "not an index file");
            return false;
        }
        if (this.idxFormat != 0 && this.idxFormat != 3 && this.idxFormat != 8) {
            this.warning("checkHeaderInformation", "not an index file format 0, 3 or 8");
            return false;
        }
        if (this.getShortFromBytes(this.keyFileHeader, 110) < 16000) {
            this.warning("checkHeaderInformation", "unsupported file format version " + this.getShortFromBytes(this.keyFileHeader, 108) + "- EXTFH version " + this.getShortFromBytes(this.keyFileHeader, 110) + ". use MF REBUILD utility to update to EXTFH version 16000 or higher");
        }
        if (this.numberOfKeys != this.getNumberOfKeys()) {
            this.warning("checkHeaderInformation", "number of keys defined in the file specification (" + this.numberOfKeys + ") must match the number defined in the file header (" + this.getNumberOfKeys() + ")");
            return false;
        }
        if (!this.isVariable() && this.recordFrom != this.getMinRecordLength()) {
            this.warning("checkHeaderInformation", "minimum record size in the file specification (" + this.recordFrom + ") must match the record size in the file header (" + this.getMinRecordLength() + ")");
            return false;
        }
        if (this.recordTo != this.getMaxRecordLength()) {
            this.warning("checkHeaderInformation", "maximum record size in the file specification (" + this.recordTo + ") must match the record size in the file header (" + this.getMaxRecordLength() + ")");
            return false;
        }
        for (int i = 0; i < this.numberOfKeys; ++i) {
            byte[] bytes = this.getKeyBlock(i);
            if (bytes == null) {
                return false;
            }
            int keyComponentBlockOffset = this.keyBlockOffset + (this.idxFormat == 8 ? 24 : 7);
            boolean dupsAllowed = (bytes[keyComponentBlockOffset - 1] & 0x40) != 0;
            if ((bytes[this.keyBlockOffset + (this.idxFormat == 8 ? 22 : 6)] & 0xF) != 0) {
                StringBuilder err = new StringBuilder();
                int kc = bytes[this.keyBlockOffset + (this.idxFormat == 8 ? 22 : 6)] & 0xF;
                err.append("[");
                if ((kc & 1) != 0) {
                    err.append("duplicate keys, ");
                }
                if ((kc & 2) != 0) {
                    err.append("leading character, ");
                }
                if ((kc & 4) != 0) {
                    err.append("trailing space, ");
                }
                if ((kc & 8) != 0) {
                    err.append("trailing null, ");
                }
                err.append("]");
                this.warning("checkHeaderInformation", err.toString() + "key compression not supported");
                return false;
            }
            if (this.idxFormat == 8 && (bytes[this.keyBlockOffset + 22] & 8) != 0) {
                keyComponentBlockOffset += 2;
            }
            if (this.keyArray[i] instanceof VariableList) {
                Variable[] list = ((VariableList)this.keyArray[i]).getList();
                int masterRecordAddress = this.masterRecord.getAddress();
                for (int j = 0; j < list.length; ++j) {
                    int len;
                    Variable v = list[j];
                    if (this.idxFormat != 8) {
                        if (j == 0) {
                            boolean bl = dupsAllowed = (bytes[keyComponentBlockOffset] & 0xFFFFFF80) != 0;
                        }
                        if (dupsAllowed != this.keyDuplicatesAllowed[i]) {
                            this.warning("checkHeaderInformation", "index key duplicates allowed indicator for index #" + i + "in file specification does not match indicator in file header");
                            return false;
                        }
                    } else if (dupsAllowed != this.keyDuplicatesAllowed[i]) {
                        this.warning("checkHeaderInformation", "index key duplicates allowed indicator for index #" + i + "in file specification does not match indicator in file header");
                        return false;
                    }
                    if ((len = this.getShortFromBytes(bytes, keyComponentBlockOffset) & 0xFFF) != v.length()) {
                        this.warning("checkHeaderInformation", "index key length for index #" + i + "in file specification (variable " + v.getName() + " of length " + v.length() + ") does not match length in file header (" + len + ")");
                        return false;
                    }
                    int kOffset = this.getShortFromBytes(bytes, keyComponentBlockOffset + (this.idxFormat == 8 ? 4 : 2));
                    if (kOffset != v.getAddress() - masterRecordAddress) {
                        this.warning("checkHeaderInformation", "index key offset for index #" + i + "in file specification (variable " + v.getName() + " at offset within the record" + (v.getAddress() - masterRecordAddress) + ") does not match length in file header (" + kOffset + ")");
                        return false;
                    }
                    keyComponentBlockOffset += this.idxFormat == 8 ? 8 : 5;
                }
                continue;
            }
            Variable v = this.keyArray[i];
            if (this.idxFormat != 8) {
                boolean bl = dupsAllowed = (bytes[keyComponentBlockOffset] & 0xFFFFFF80) != 0;
                if (dupsAllowed != this.keyDuplicatesAllowed[i]) {
                    this.warning("checkHeaderInformation", "index key duplicates allowed indicator for index #" + i + "in file specification does not match indicator in file header");
                    return false;
                }
            } else if (dupsAllowed != this.keyDuplicatesAllowed[i]) {
                this.warning("checkHeaderInformation", "index key duplicates allowed indicator for index #" + i + "in file specification does not match indicator in file header");
                return false;
            }
            int len = this.getShortFromBytes(bytes, keyComponentBlockOffset);
            if (this.idxFormat != 8) {
                len &= 0xFFF;
            }
            if (len != this.keyLengths[i]) {
                this.warning("checkHeaderInformation", "index key length for index #" + i + "in file specification (variable " + v.getName() + " of length " + v.length() + ") does not match length in file header (" + len + ")");
                return false;
            }
            int kOffset = this.getShortFromBytes(bytes, keyComponentBlockOffset + (this.idxFormat == 8 ? 4 : 2));
            if (kOffset != this.keyOffsets[i]) {
                this.warning("checkHeaderInformation", "index key offset for index #" + i + "in file specification (variable " + v.getName() + " at offset within the record " + this.keyOffsets[i] + ") does not match length in file header (" + kOffset + ")");
                return false;
            }
            int n = keyComponentBlockOffset + (this.idxFormat == 8 ? 8 : 5);
        }
        return true;
    }

    public int updateHeaderInformation(Object[] keyStartLocations, int treeHeight) {
        if (!this.isWritable() || this.keyFileHeader == null) {
            return 0;
        }
        this.keyStartLocations = keyStartLocations;
        this.updateKeyStartLocations();
        this.treeHeight = treeHeight;
        this.setTreeHeight(treeHeight);
        this.setEndOfKeyFileIndex(this.endOfKeyFileIndex);
        this.setEndOfDataFileIndex(this.endOfDataFileIndex);
        this.setStartOfKeyInfoRecords(this.startOfKeyInfoRecords);
        this.setStartOfDataFreeSpaceRecords(this.startOfDataFreeSpaceRecords);
        this.setStartOfKeyFreeSpaceRecords(this.startOfKeyFreeSpaceRecords);
        return this.writeHeaderInformation();
    }

    public int seekToKeyRecord(long recordKey) {
        this.iostatus(0);
        if (recordKey < 0L || recordKey > this.endOfKeyFileIndex) {
            int returnCode = -90;
            this.iostatus(-90);
            this.warning("seekToKeyRecord", "record key position (" + recordKey + ") is is out of bounds with file size (" + this.endOfKeyFileIndex + ")");
            return returnCode;
        }
        int returnCode = this.keyFile.seek(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        this.currentKeyFileIndex = recordKey;
        return 0;
    }

    public final byte[] getKeyRecord(long recordKey) {
        int returnCode = this.seekToKeyRecord(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return null;
        }
        byte[] bytes = new byte[this.nodeSize];
        returnCode = this.keyFile.read(bytes, 0, this.nodeSize, true);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return null;
        }
        this.currentKeyFileIndex = recordKey + (long)this.nodeSize;
        if (this.currentKeyFileIndex > this.endOfKeyFileIndex) {
            this.endOfKeyFileIndex = this.currentKeyFileIndex;
            if (this.idxFormat == 8) {
                this.endOfDataFileIndex = this.endOfKeyFileIndex;
            }
        }
        return bytes;
    }

    public final int updateKeyRecord(long recordKey, byte[] bytes) {
        if (bytes == null || bytes.length != this.nodeSize) {
            this.warning("updateKeyRecord", "update key record failed");
            return -30;
        }
        if (!this.isWritable()) {
            this.warning("updateKeyRecord", "write operation attempted on file not open for output");
            return -48;
        }
        int returnCode = this.seekToKeyRecord(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.keyFile.write(bytes);
        if (returnCode < 0) {
            return returnCode;
        }
        this.currentKeyFileIndex = recordKey + (long)this.nodeSize;
        if (this.currentKeyFileIndex > this.endOfKeyFileIndex) {
            this.endOfKeyFileIndex = this.currentKeyFileIndex;
            if (this.idxFormat == 8) {
                this.endOfDataFileIndex = this.endOfKeyFileIndex;
            }
        }
        return returnCode;
    }

    private long allocateKeyRecordFromEndOfFile(byte[] bytes) {
        if (this.idxFormat == 8 && this.endOfKeyFileIndex % (long)this.nodeSize != 0L) {
            this.endOfKeyFileIndex = (this.endOfKeyFileIndex + (long)this.nodeSize) / (long)this.nodeSize * (long)this.nodeSize;
        }
        long recKey = this.endOfKeyFileIndex;
        int returnCode = this.keyFile.seek(this.endOfKeyFileIndex);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return -1L;
        }
        returnCode = this.keyFile.write(bytes);
        if (returnCode < 0) {
            return -1L;
        }
        this.endOfKeyFileIndex += (long)this.nodeSize;
        this.currentKeyFileIndex = this.endOfKeyFileIndex;
        if (this.idxFormat == 8) {
            this.endOfDataFileIndex = this.endOfKeyFileIndex;
        }
        return recKey;
    }

    public final long addKeyRecord(byte[] bytes) {
        if (!this.isWritable()) {
            this.warning("addKeyRecord", "write operation attempted on file not open for output");
            return -48L;
        }
        if (this.startOfKeyFreeSpaceRecords == 0L) {
            return this.allocateKeyRecordFromEndOfFile(bytes);
        }
        byte[] freeBytes = this.getKeyRecord(this.startOfKeyFreeSpaceRecords);
        if (freeBytes == null) {
            return -1L;
        }
        int val = this.getShortFromBytes(freeBytes, 0);
        int security = val & 0x8000;
        int end = val & 0xFFF;
        if (end < 10) {
            long cont = this.getFilePointerFromBytes(freeBytes, 2);
            if (cont != 0L) {
                long recKey = this.startOfKeyFreeSpaceRecords;
                this.startOfKeyFreeSpaceRecords = cont;
                int returnCode = this.updateKeyRecord(recKey, bytes);
                if (returnCode < 0) {
                    return -1L;
                }
                return recKey;
            }
            return this.allocateKeyRecordFromEndOfFile(bytes);
        }
        long recKey = this.getFilePointerFromBytes(freeBytes, end -= this.filePointerSize);
        this.setBytesFromShort(freeBytes, 0, end | security);
        int returnCode = this.updateKeyRecord(this.startOfKeyFreeSpaceRecords, freeBytes);
        if (returnCode < 0) {
            return -1L;
        }
        returnCode = this.updateKeyRecord(recKey, bytes);
        if (returnCode < 0) {
            return -1L;
        }
        return recKey;
    }

    public final int deleteKeyRecord(long recordKey) {
        byte[] freeBytes = null;
        if (this.startOfKeyFreeSpaceRecords == 0L) {
            freeBytes = new byte[this.nodeSize];
            int end = 2 + 2 * this.filePointerSize;
            this.setBytesFromShort(freeBytes, 0, end);
            this.setBytesFromFilePointer(freeBytes, end - this.filePointerSize, recordKey);
            freeBytes[this.nodeSize - 1] = 127;
            long recKey = this.addKeyRecord(freeBytes);
            if (recKey < 0L) {
                return this.status;
            }
            this.startOfKeyFreeSpaceRecords = recKey;
            return 0;
        }
        freeBytes = this.getKeyRecord(this.startOfKeyFreeSpaceRecords);
        if (freeBytes == null) {
            return this.status;
        }
        int val = this.getShortFromBytes(freeBytes, 0);
        int security = val & 0x8000;
        int end = val & 0xFFF;
        if (end + this.filePointerSize + 1 >= this.nodeSize) {
            freeBytes = new byte[this.nodeSize];
            end = 2 + this.filePointerSize;
            this.setBytesFromShort(freeBytes, 0, end);
            freeBytes[this.nodeSize - 1] = 127;
            this.setBytesFromFilePointer(freeBytes, 2, this.startOfKeyFreeSpaceRecords);
            this.startOfKeyFreeSpaceRecords = recordKey;
            int returnCode = this.updateKeyRecord(this.startOfKeyFreeSpaceRecords, freeBytes);
            return returnCode;
        }
        this.setBytesFromFilePointer(freeBytes, end, recordKey);
        this.setBytesFromShort(freeBytes, 0, (end += this.filePointerSize) | security);
        int returnCode = this.updateKeyRecord(this.startOfKeyFreeSpaceRecords, freeBytes);
        return returnCode;
    }

    public int seekToDataRecord(long recordKey) {
        int returnCode;
        if (recordKey < 0L || recordKey > this.endOfDataFileIndex) {
            this.warning("seekToDataRecord", "file position (" + recordKey + ") out of range of file (" + this.endOfDataFileIndex + ")");
            int returnCode2 = -90;
            this.iostatus(-90);
            return returnCode2;
        }
        if (this.idxFormat == 8) {
            returnCode = this.keyFile.seek(recordKey);
            this.iostatus(returnCode);
        } else {
            returnCode = this.dataFile.seek(recordKey);
            this.iostatus(returnCode);
        }
        if (returnCode < 0) {
            return returnCode;
        }
        this.currentDataFileIndex = recordKey;
        return 0;
    }

    public final byte[] getDataRecord(long recordKey) {
        int returnCode = this.seekToDataRecord(recordKey);
        if (returnCode < 0) {
            this.iostatus(returnCode);
            return null;
        }
        if (this.idxFormat == 8) {
            byte[] recordBytes;
            returnCode = this.readDataRecordHeader();
            if (returnCode < 0) {
                this.iostatus(returnCode);
                return null;
            }
            if (returnCode > this.recordTo) {
                this.warning("getDataRecord", "data record length (" + returnCode + ") is larger than what is defined in the file specification (" + this.recordTo + ")");
                this.iostatus(-4);
                returnCode = this.recordTo;
            }
            if ((returnCode = this.keyFile.read(recordBytes = new byte[returnCode], 0, returnCode)) < 0) {
                this.iostatus(returnCode);
                return null;
            }
            if (this.dataCompression != 0 && returnCode > 0) {
                recordBytes = this.algorithm.decompress(recordBytes, 0, returnCode);
            }
            return recordBytes;
        }
        byte[] recordBytes = new byte[this.recordTo];
        returnCode = this.dataFile.read(recordBytes);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return null;
        }
        int len = this.dataFile.getReadSize();
        if (len != recordBytes.length) {
            byte[] tmp = new byte[len];
            System.arraycopy(recordBytes, 0, tmp, 0, len);
            recordBytes = tmp;
        }
        return recordBytes;
    }

    public final int updateDataRecord(long recordKey, byte[] bytes) {
        return this.updateDataRecord(recordKey, bytes, 0, bytes.length);
    }

    public final int updateDataRecord(long recordKey, byte[] bytes, int offset, int length) {
        if (bytes == null) {
            this.warning("updateDataRecord", "cannot update record");
            return -30;
        }
        if (!this.isWritable()) {
            this.warning("updateDataRecord", "write operation attempted on file not open for output");
            return -48;
        }
        int returnCode = this.seekToDataRecord(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        if (this.idxFormat == 8) {
            if (this.dataCompression != 0) {
                bytes = this.algorithm.compress(bytes, offset, length);
                offset = 0;
                length = bytes.length;
            }
            returnCode = this.writeDataRecordHeader(length);
            returnCode = this.keyFile.write(bytes, offset, length);
            this.iostatus(returnCode);
            this.currentDataFileIndex = this.keyFile.getFilePointer();
        } else {
            this.dataFile.write(bytes, offset, length);
            returnCode = this.dataFile.priorError();
            this.iostatus(returnCode);
            this.currentDataFileIndex = this.dataFile.getFilePointer();
        }
        if (returnCode < 0) {
            return returnCode;
        }
        if (this.currentDataFileIndex > this.endOfDataFileIndex) {
            this.endOfDataFileIndex = this.currentDataFileIndex;
            if (this.idxFormat == 8) {
                this.endOfKeyFileIndex = this.currentDataFileIndex;
            }
        }
        return returnCode;
    }

    public final long addDataRecord(byte[] bytes) {
        return this.addDataRecord(bytes, 0, bytes.length);
    }

    public final long addDataRecord(byte[] bytes, int offset, int length) {
        if (!this.isWritable()) {
            this.warning("addDataRecord", "write operation attempted on file not open for output");
            return -48L;
        }
        if (!this.isVariable()) {
            return this.addDataRecordFixed(bytes, offset, length);
        }
        return this.addDataRecordVariable(bytes, offset, length);
    }

    private long allocateDataRecordFromEndOfFile(byte[] bytes) {
        return this.allocateDataRecordFromEndOfFile(bytes, 0, bytes.length);
    }

    private long allocateDataRecordFromEndOfFile(byte[] bytes, int offset, int length) {
        long recKey = this.endOfDataFileIndex;
        if (this.idxFormat == 8) {
            if (this.dataCompression != 0) {
                bytes = this.algorithm.compress(bytes, offset, length);
                offset = 0;
                length = bytes.length;
            }
            int returnCode = this.keyFile.seek(this.endOfDataFileIndex);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return -1L;
            }
            returnCode = this.writeDataRecordHeader(length);
            returnCode = this.keyFile.write(bytes, offset, length);
            if (returnCode < 0) {
                return -1L;
            }
            this.endOfDataFileIndex = this.endOfKeyFileIndex = this.keyFile.getFilePointer();
        } else {
            int returnCode = this.dataFile.seek(this.endOfDataFileIndex);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return -1L;
            }
            this.dataFile.write(bytes, offset, length);
            returnCode = this.dataFile.priorError();
            if (returnCode < 0) {
                return -1L;
            }
            this.endOfDataFileIndex = this.dataFile.getFilePointer();
        }
        this.currentDataFileIndex = this.endOfDataFileIndex;
        return recKey;
    }

    private long addDataRecordFixed(byte[] bytes, int offset, int length) {
        int returnCode;
        if (this.startOfDataFreeSpaceRecords == 0L) {
            return this.allocateDataRecordFromEndOfFile(bytes, offset, length);
        }
        byte[] freeBytes = this.getKeyRecord(this.startOfDataFreeSpaceRecords);
        if (freeBytes == null) {
            return -1L;
        }
        int val = this.getShortFromBytes(freeBytes, 0);
        int security = val & 0x8000;
        int end = val & 0xFFF;
        long recKey = this.getFilePointerFromBytes(freeBytes, end -= this.filePointerSize);
        if (end <= 6) {
            long cont = this.getFilePointerFromBytes(freeBytes, 2);
            returnCode = this.deleteKeyRecord(this.startOfDataFreeSpaceRecords);
            if (returnCode < 0) {
                return -1L;
            }
            this.startOfDataFreeSpaceRecords = cont;
        } else {
            this.setBytesFromShort(freeBytes, 0, end | security);
            returnCode = this.updateKeyRecord(this.startOfDataFreeSpaceRecords, freeBytes);
            if (returnCode < 0) {
                return -1L;
            }
        }
        returnCode = this.updateDataRecord(recKey, bytes, offset, length);
        if (returnCode < 0) {
            return -1L;
        }
        return recKey;
    }

    private int setDataRecordHeaderType(long recordKey, int info) {
        int headerSize;
        smartFile file2;
        if (this.idxFormat == 8) {
            file2 = this.keyFile;
            headerSize = this.getDataRecordHeaderSize();
        } else {
            file2 = this.dataFile.getSmartFile();
            headerSize = this.dataFile.MF_prefixSize();
        }
        int returnCode = file2.seek(recordKey);
        if (returnCode < 0) {
            return returnCode;
        }
        byte[] header = new byte[headerSize];
        returnCode = file2.read(header);
        if (returnCode < 0) {
            return returnCode;
        }
        header[0] = (byte)(header[0] & 0xF | info << 4);
        returnCode = file2.seek(recordKey);
        if (returnCode < 0) {
            return returnCode;
        }
        return file2.write(header);
    }

    private long addDataRecordVariable(byte[] bytes, int offset, int length) {
        int headerSize;
        smartFile file2;
        int chainOff;
        long recordKey;
        if (this.startOfDataFreeSpaceRecords == 0L) {
            return this.allocateDataRecordFromEndOfFile(bytes, offset, length);
        }
        int avertdependingonchange = this.dependingOn != null ? this.dependingOn.toInt() : -1;
        byte[] freeBytes = this.getDataRecord(this.startOfDataFreeSpaceRecords);
        if (freeBytes == null) {
            return -1L;
        }
        if (avertdependingonchange > 0) {
            this.dependingOn.move(avertdependingonchange);
        }
        if ((recordKey = (chainOff = freeBytes.length - this.filePointerSize) < 0 ? 0L : this.getFilePointerFromBytes(freeBytes, chainOff)) == 0L) {
            return this.allocateDataRecordFromEndOfFile(bytes, offset, length);
        }
        if (this.idxFormat == 8) {
            file2 = this.keyFile;
            headerSize = this.getDataRecordHeaderSize();
        } else {
            file2 = this.dataFile.getSmartFile();
            headerSize = this.dataFile.MF_prefixSize();
        }
        int returnCode = file2.seek(recordKey);
        if (returnCode < 0) {
            return returnCode;
        }
        byte[] header = new byte[headerSize + this.filePointerSize];
        returnCode = file2.read(header);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = file2.seek(recordKey);
        if (returnCode < 0) {
            return returnCode;
        }
        long next = this.getFilePointerFromBytes(header, headerSize);
        this.setBytesFromFilePointer(freeBytes, chainOff, next);
        returnCode = this.updateDataRecord(this.startOfDataFreeSpaceRecords, freeBytes);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.setDataRecordHeaderType(this.startOfDataFreeSpaceRecords, 3);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.updateDataRecord(recordKey, bytes, offset, length);
        if (returnCode < 0) {
            return returnCode;
        }
        return recordKey;
    }

    public final int deleteDataRecord(long recordKey) {
        if (!this.isVariable()) {
            return this.deleteDataRecordFixed(recordKey);
        }
        return this.deleteDataRecordVariable(recordKey);
    }

    private int deleteDataRecordFixed(long recordKey) {
        byte[] freeBytes = null;
        if (this.startOfDataFreeSpaceRecords == 0L) {
            freeBytes = new byte[this.nodeSize];
            int end = 2 + 2 * this.filePointerSize;
            this.setBytesFromShort(freeBytes, 0, end);
            this.setBytesFromFilePointer(freeBytes, end - this.filePointerSize, recordKey);
            freeBytes[this.nodeSize - 1] = 127;
            long recKey = this.addKeyRecord(freeBytes);
            if (recKey < 0L) {
                return this.status;
            }
            this.startOfDataFreeSpaceRecords = recKey;
            int returnCode = this.updateKeyRecord(this.startOfDataFreeSpaceRecords, freeBytes);
            if (returnCode < 0) {
                return returnCode;
            }
            return this.setDataRecordHeaderType(recordKey, 2);
        }
        freeBytes = this.getKeyRecord(this.startOfDataFreeSpaceRecords);
        if (freeBytes == null) {
            return this.status;
        }
        int val = this.getShortFromBytes(freeBytes, 0);
        int security = val & 0x8000;
        int end = val & 0xFFF;
        if (end >= this.nodeSize - 2) {
            freeBytes = new byte[this.nodeSize];
            end = 2 + 2 * this.filePointerSize;
            this.setBytesFromShort(freeBytes, 0, end);
            this.setBytesFromFilePointer(freeBytes, 2, this.startOfDataFreeSpaceRecords);
            this.setBytesFromFilePointer(freeBytes, end - this.filePointerSize, recordKey);
            freeBytes[this.nodeSize - 1] = 127;
            long recKey = this.addKeyRecord(freeBytes);
            if (recKey < 0L) {
                return this.status;
            }
            this.startOfDataFreeSpaceRecords = recKey;
            int returnCode = this.updateKeyRecord(this.startOfDataFreeSpaceRecords, freeBytes);
            if (returnCode < 0) {
                return returnCode;
            }
            return this.setDataRecordHeaderType(recordKey, 2);
        }
        this.setBytesFromFilePointer(freeBytes, end, recordKey);
        this.setBytesFromShort(freeBytes, 0, (end += this.filePointerSize) | security);
        int returnCode = this.updateKeyRecord(this.startOfDataFreeSpaceRecords, freeBytes);
        if (returnCode < 0) {
            return returnCode;
        }
        return this.setDataRecordHeaderType(recordKey, 2);
    }

    private int deleteDataRecordVariable(long recordKey) {
        byte[] freeBytes = null;
        if (this.startOfDataFreeSpaceRecords == 0L) {
            long key;
            int minFreeRecSize = this.recordTo;
            if (minFreeRecSize < this.filePointerSize) {
                minFreeRecSize = this.filePointerSize;
            }
            if ((key = this.allocateDataRecordFromEndOfFile(freeBytes = new byte[minFreeRecSize])) < 0L) {
                this.warning("deleteDataRecordVariable", "internal error allocating data record");
                return -30;
            }
            this.startOfDataFreeSpaceRecords = key;
        } else {
            freeBytes = this.getDataRecord(this.startOfDataFreeSpaceRecords);
        }
        if (freeBytes == null) {
            this.warning("deleteDataRecordVariable", "internal error allocating data record");
            return -30;
        }
        byte[] bytes = this.getDataRecord(recordKey);
        if (bytes == null) {
            return -1;
        }
        int offset = freeBytes.length - this.filePointerSize;
        long freeRecordKey = offset < 0 ? 0L : this.getFilePointerFromBytes(freeBytes, offset);
        this.setBytesFromFilePointer(bytes, 0, freeRecordKey);
        int returnCode = this.updateDataRecord(recordKey, bytes);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.setDataRecordHeaderType(recordKey, 2);
        if (returnCode < 0) {
            return returnCode;
        }
        this.setBytesFromFilePointer(freeBytes, offset, recordKey);
        returnCode = this.updateDataRecord(this.startOfDataFreeSpaceRecords, freeBytes);
        if (returnCode < 0) {
            return returnCode;
        }
        return this.setDataRecordHeaderType(this.startOfDataFreeSpaceRecords, 3);
    }

    private long getFileHeaderLength() {
        return this.idxFormat == 8 && this.recordTo > 4095 ? (this.getIntFromBytes(this.keyFileHeader, 0) & 0xFFFL) + 2L : (long)(this.getShortFromBytes(this.keyFileHeader, 0) & 0xFFF);
    }

    private Date getCreationDateAndTime() {
        int year = ((this.keyFileHeader[8] & 0xFF) - 48) * 10 + ((this.keyFileHeader[9] & 0xFF) - 48);
        int month = ((this.keyFileHeader[10] & 0xFF) - 48) * 10 + ((this.keyFileHeader[11] & 0xFF) - 48);
        int day = ((this.keyFileHeader[12] & 0xFF) - 48) * 10 + ((this.keyFileHeader[13] & 0xFF) - 48);
        int hour = ((this.keyFileHeader[14] & 0xFF) - 48) * 10 + ((this.keyFileHeader[15] & 0xFF) - 48);
        int min = ((this.keyFileHeader[16] & 0xFF) - 48) * 10 + ((this.keyFileHeader[17] & 0xFF) - 48);
        int sec = ((this.keyFileHeader[18] & 0xFF) - 48) * 10 + ((this.keyFileHeader[19] & 0xFF) - 48);
        int cen = ((this.keyFileHeader[20] & 0xFF) - 48) * 10 + ((this.keyFileHeader[21] & 0xFF) - 48);
        if (cen < 19 || cen > 20) {
            cen = 20;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, cen * 100 + year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(10, hour);
        cal.set(12, min);
        cal.set(13, sec);
        return cal.getTime();
    }

    private void setCreationDateAndTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int cen = cal.get(1) / 100;
        int year = cal.get(1) % 100;
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(10);
        int min = cal.get(12);
        int sec = cal.get(13);
        this.keyFileHeader[8] = (byte)(year / 10 + 48);
        this.keyFileHeader[9] = (byte)(year % 10 + 48);
        this.keyFileHeader[10] = (byte)(month / 10 + 48);
        this.keyFileHeader[11] = (byte)(month % 10 + 48);
        this.keyFileHeader[12] = (byte)(day / 10 + 48);
        this.keyFileHeader[13] = (byte)(day % 10 + 48);
        this.keyFileHeader[14] = (byte)(hour / 10 + 48);
        this.keyFileHeader[15] = (byte)(hour % 10 + 48);
        this.keyFileHeader[16] = (byte)(min / 10 + 48);
        this.keyFileHeader[17] = (byte)(min % 10 + 48);
        this.keyFileHeader[18] = (byte)(sec / 10 + 48);
        this.keyFileHeader[19] = (byte)(sec % 10 + 48);
        this.keyFileHeader[20] = (byte)(cen / 10 + 48);
        this.keyFileHeader[21] = (byte)(cen % 10 + 48);
        try {
            System.arraycopy(this.keyFileHeader, 8, this.keyFileHeader, 22, 14);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getMaxRecordLength() {
        return (int)this.getIntFromBytes(this.keyFileHeader, 54);
    }

    private void setMaxRecordLength(int length) {
        this.setBytesFromInt(this.keyFileHeader, 54, length);
    }

    private int getMinRecordLength() {
        return (int)this.getIntFromBytes(this.keyFileHeader, 58);
    }

    private void setMinRecordLength(int length) {
        this.setBytesFromInt(this.keyFileHeader, 58, length);
    }

    private int getTreeHeight() {
        return (int)this.getIntFromBytes(this.keyFileHeader, 104);
    }

    private void setTreeHeight(int height) {
        this.setBytesFromInt(this.keyFileHeader, 104, height);
    }

    private void setVersionInformation() {
        this.keyFileHeader[108] = 72;
        this.keyFileHeader[109] = 67;
        this.keyFileHeader[110] = 73;
        this.keyFileHeader[111] = 46;
        this.keyFileHeader[112] = 72;
        this.keyFileHeader[113] = 67;
        this.keyFileHeader[114] = 73;
        this.keyFileHeader[115] = 46;
    }

    private long getEndOfKeyFileIndex() {
        return this.getLongFromBytes(this.keyFileHeader, 120);
    }

    private void setEndOfKeyFileIndex(long endOfKeyFileIndex) {
        this.setBytesFromLong(this.keyFileHeader, 120, endOfKeyFileIndex);
    }

    private long getEndOfDataFileIndex() {
        return this.getLongFromBytes(this.keyFileHeader, 128);
    }

    private void setEndOfDataFileIndex(long endOfDataFileIndex) {
        this.setBytesFromLong(this.keyFileHeader, 128, endOfDataFileIndex);
    }

    private int getNumberOfKeys() {
        return this.getShortFromBytes(this.keyFileHeader, 140);
    }

    private void setNumberOfKeys(int numberOfKeys) {
        this.setBytesFromShort(this.keyFileHeader, 140, numberOfKeys);
    }

    private long getStartOfKeyInfoRecords() {
        return this.getLongFromBytes(this.keyFileHeader, 144);
    }

    private void setStartOfKeyInfoRecords(long startOfKeyInfoRecords) {
        this.setBytesFromLong(this.keyFileHeader, 144, startOfKeyInfoRecords);
    }

    private long getStartOfDataFreeSpaceRecords() {
        return this.getLongFromBytes(this.keyFileHeader, 152);
    }

    private void setStartOfDataFreeSpaceRecords(long startOfDataFreeSpaceRecords) {
        this.setBytesFromLong(this.keyFileHeader, 152, startOfDataFreeSpaceRecords);
    }

    private long getStartOfKeyFreeSpaceRecords() {
        return this.getLongFromBytes(this.keyFileHeader, 160);
    }

    private void setStartOfKeyFreeSpaceRecords(long startOfKeyFreeSpaceRecords) {
        this.setBytesFromLong(this.keyFileHeader, 160, startOfKeyFreeSpaceRecords);
    }

    private void setKeyFileRecordLength(int length) {
        this.setBytesFromShort(this.keyFileHeader, 174, length);
    }

    public void setRecordHeader(byte[] bytes, int type) {
        switch (type) {
            case 1: {
                if (this.idxFormat == 8 && this.recordTo > 4095) {
                    this.setBytesFromInt(bytes, 0, 0x30000000 | this.nodeSize - 4);
                    break;
                }
                this.setBytesFromShort(bytes, 0, 0x3000 | this.nodeSize - 2);
                break;
            }
            case 2: {
                if (this.idxFormat != 8) break;
                if (this.recordTo > 4095) {
                    this.setBytesFromInt(bytes, 0, 0x30000000 | this.nodeSize - 4);
                    break;
                }
                this.setBytesFromShort(bytes, 0, 0x3000 | this.nodeSize - 2);
                break;
            }
        }
    }

    private long getLongFromBytes(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }

    private void setBytesFromLong(byte[] bytes, int offset, long value) {
        bytes[offset] = (byte)(value >> 56 & 0xFFL);
        bytes[offset + 1] = (byte)(value >> 48 & 0xFFL);
        bytes[offset + 2] = (byte)(value >> 40 & 0xFFL);
        bytes[offset + 3] = (byte)(value >> 32 & 0xFFL);
        bytes[offset + 4] = (byte)(value >> 24 & 0xFFL);
        bytes[offset + 5] = (byte)(value >> 16 & 0xFFL);
        bytes[offset + 6] = (byte)(value >> 8 & 0xFFL);
        bytes[offset + 7] = (byte)(value & 0xFFL);
    }

    private long getIntFromBytes(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    private void setBytesFromInt(byte[] bytes, int offset, long value) {
        bytes[offset] = (byte)(value >> 24 & 0xFFL);
        bytes[offset + 1] = (byte)(value >> 16 & 0xFFL);
        bytes[offset + 2] = (byte)(value >> 8 & 0xFFL);
        bytes[offset + 3] = (byte)(value & 0xFFL);
    }

    private long getFilePointerFromBytes(byte[] bytes, int offset) {
        if (this.filePointerSize == 4) {
            return (long)(bytes[offset] & 0xFF) << 24 | (long)(bytes[offset + 1] & 0xFF) << 16 | (long)(bytes[offset + 2] & 0xFF) << 8 | (long)(bytes[offset + 3] & 0xFF);
        }
        if (this.filePointerSize == 6) {
            return (long)(bytes[offset] & 0xFF) << 40 | (long)(bytes[offset + 1] & 0xFF) << 32 | (long)(bytes[offset + 2] & 0xFF) << 24 | (long)(bytes[offset + 3] & 0xFF) << 16 | (long)(bytes[offset + 4] & 0xFF) << 8 | (long)(bytes[offset + 5] & 0xFF);
        }
        return -1L;
    }

    private void setBytesFromFilePointer(byte[] bytes, int offset, long value) {
        if (this.filePointerSize == 4) {
            bytes[offset] = (byte)(value >> 24 & 0xFFL);
            bytes[offset + 1] = (byte)(value >> 16 & 0xFFL);
            bytes[offset + 2] = (byte)(value >> 8 & 0xFFL);
            bytes[offset + 3] = (byte)(value & 0xFFL);
        } else if (this.filePointerSize == 6) {
            bytes[offset] = (byte)(value >> 40 & 0xFFL);
            bytes[offset + 1] = (byte)(value >> 32 & 0xFFL);
            bytes[offset + 2] = (byte)(value >> 24 & 0xFFL);
            bytes[offset + 3] = (byte)(value >> 16 & 0xFFL);
            bytes[offset + 4] = (byte)(value >> 8 & 0xFFL);
            bytes[offset + 5] = (byte)(value & 0xFFL);
        }
    }

    private int getShortFromBytes(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
    }

    private void setBytesFromShort(byte[] bytes, int offset, int value) {
        bytes[offset] = (byte)(value >> 8 & 0xFF);
        bytes[offset + 1] = (byte)(value & 0xFF);
    }

    public final boolean getSuppressTrailingSpaces(int bTreeIndex) {
        return (this.getKeyCompression(bTreeIndex) & 4) != 0;
    }

    public final boolean getSuppressLeadingChars(int bTreeIndex) {
        return (this.getKeyCompression(bTreeIndex) & 2) != 0;
    }

    public final boolean getSuppressDuplicateKeys(int bTreeIndex) {
        return (this.getKeyCompression(bTreeIndex) & 1) != 0;
    }

    public final int getIndexNodeRecordSize() {
        return this.nodeSize;
    }

    public final boolean getDuplicatesAllowed(int index) {
        if (this.keyDuplicatesAllowed != null) {
            return this.keyDuplicatesAllowed[index];
        }
        return false;
    }

    public boolean fileIsOpen() {
        return this.isOpen;
    }

    public boolean isInput() {
        return this.readable && !this.writable;
    }

    public boolean isOutput() {
        return this.writable && !this.readable;
    }

    public boolean isIO() {
        return this.readable && this.writable;
    }

    public boolean isExtend() {
        return this.extend;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isNewFile() {
        return !this.fileAlreadyExists;
    }

    public void flushCache() {
    }

    public void reset() {
        this.keyFileHeader = null;
        this.keyInfoRecords = null;
        this.readHeaderInformation();
        this.seekToKeyRecord(0L);
        this.seekToDataRecord(0L);
    }

    public boolean isVariable() {
        boolean override_varying;
        boolean override_variable = (this.newModes & 2) != 0;
        boolean bl = override_varying = (this.newModes & 4) != 0;
        if (override_variable) {
            return true;
        }
        if (override_varying) {
            return true;
        }
        return this.dependingOn != null;
    }

    public final void iostatus(int status) {
        this.status = status;
    }

    public final int getStatus() {
        int myStatus = this.status;
        this.status = 0;
        return myStatus;
    }

    public final int getFilePointerSize() {
        return this.filePointerSize;
    }

    public final int getIdxHeaderSize() {
        return this.idxHeaderSize;
    }

    public final boolean isIdx8() {
        return this.idxFormat == 8;
    }

    public final int getDataRecordHeaderSize() {
        return this.recordTo < 4096 ? 2 : 4;
    }

    public final int writeDataRecordHeader(int size) {
        int writingAlignment = this.getDataRecordHeaderSize();
        byte[] temporaryStorage = new byte[writingAlignment];
        if (writingAlignment == 2) {
            temporaryStorage[0] = (byte)(size >> 8 & 0xFF | 0x40);
            temporaryStorage[1] = (byte)(size & 0xFF);
        } else {
            temporaryStorage[0] = (byte)(size >> 24 & 0xFF | 0x40);
            temporaryStorage[1] = (byte)(size >> 16 & 0xFF);
            temporaryStorage[2] = (byte)(size >> 8 & 0xFF);
            temporaryStorage[3] = (byte)(size & 0xFF);
        }
        return this.keyFile.write(temporaryStorage, 0, writingAlignment);
    }

    public final int readDataRecordHeader() {
        int readingAlignment = this.getDataRecordHeaderSize();
        byte[] temporaryStorage = new byte[readingAlignment];
        int rc = this.keyFile.read(temporaryStorage, 0, readingAlignment);
        if (rc < 0) {
            return rc;
        }
        if (rc == 4) {
            return (temporaryStorage[0] & 0xF) << 24 | (temporaryStorage[1] & 0xFF) << 16 | (temporaryStorage[2] & 0xFF) << 8 | temporaryStorage[3] & 0xFF;
        }
        if (rc == 2) {
            return (temporaryStorage[0] & 0xF) << 8 | temporaryStorage[1] & 0xFF;
        }
        this.warning("deleteDataRecordVariable", "error reading data record");
        return -30;
    }

    public static void InitCompression() {
        String s;
        InittedCompression = true;
        if (BuiltinCompression == null) {
            BuiltinCompression = new CBLDC001();
        }
        if ((s = RuntimeEnvironment.getGlobalParameter("FILESYSTEMCOMPRESSION")) != null) {
            for (String t : s.split(";")) {
                String[] u = t.split(":");
                if (u.length == 2) {
                    try {
                        MFFile.SetCompression(Integer.parseInt(u[0]), u[1]);
                        MFFile.CurrentCompression(Integer.parseInt(u[0]));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (u.length != 1) continue;
                if (u[0].equalsIgnoreCase("on") || u[0].equalsIgnoreCase("yes") || u[0].equalsIgnoreCase("true") || u[0].equals("1")) {
                    MFFile.CurrentCompression(1);
                    continue;
                }
                if (!u[0].equalsIgnoreCase("off") && !u[0].equalsIgnoreCase("no") && !u[0].equalsIgnoreCase("false") && !u[0].equals("0")) continue;
                MFFile.CurrentCompression(0);
            }
        }
    }

    public static void SetCompression(int dataCompression, Compression algorithm) {
        if (dataCompression < 128 || dataCompression > 255) {
            return;
        }
        if (UserCompressions == null) {
            UserCompressions = new Compression[128];
        }
        MFFile.UserCompressions[dataCompression - 128] = algorithm;
    }

    public static boolean SetCompression(int dataCompression, String className) {
        if (dataCompression < 128 || dataCompression > 255) {
            return false;
        }
        Compression userAlgorithm = null;
        try {
            userAlgorithm = (Compression)Compression.class.cast(Class.forName(className).newInstance());
        }
        catch (InstantiationException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        MFFile.SetCompression(dataCompression, userAlgorithm);
        return true;
    }

    public static Compression GetCompression(int dataCompression) {
        if (!InittedCompression) {
            MFFile.InitCompression();
        }
        if (dataCompression == 1) {
            return BuiltinCompression;
        }
        if (dataCompression < 128 || dataCompression > 255 || UserCompressions == null) {
            return null;
        }
        return UserCompressions[dataCompression - 128];
    }

    public static int CurrentCompression(int dataCompression) {
        if (MFFile.GetCompression(dataCompression) == null) {
            return CurrentCompression;
        }
        CurrentCompression = dataCompression;
        return CurrentCompression;
    }

    public static class CBLDC001
    implements Compression {
        @Override
        public final byte[] decompress(byte[] buf, int start, int len) {
            int end = start + len;
            if (buf.length == 0 || end > buf.length) {
                return buf;
            }
            byte[] tmp = new byte[buf.length];
            int tmpidx = 0;
            for (int i = start; i < end; ++i) {
                int j;
                int m;
                int j2;
                int m2;
                byte n;
                int b = buf[i] & 0xFF;
                if (b < 32) {
                    n = buf[i + 1];
                    m2 = b + 1;
                    tmp = CBLDC001.makeroom(tmp, tmpidx, m2);
                    for (j2 = 0; j2 < m2; ++j2) {
                        tmp[tmpidx++] = n;
                    }
                    ++i;
                    continue;
                }
                if (b > 224) {
                    n = buf[i + 1];
                    m2 = b - 224 + 1;
                    tmp = CBLDC001.makeroom(tmp, tmpidx, m2);
                    for (j2 = 0; j2 < m2; ++j2) {
                        tmp[tmpidx++] = n;
                    }
                    ++i;
                    continue;
                }
                if (b > 192) {
                    m = b - 192 + 1;
                    tmp = CBLDC001.makeroom(tmp, tmpidx, m);
                    for (j = 0; j < m; ++j) {
                        tmp[tmpidx++] = 48;
                    }
                    continue;
                }
                if (b > 160) {
                    m = b - 160 + 1;
                    tmp = CBLDC001.makeroom(tmp, tmpidx, m);
                    for (j = 0; j < m; ++j) {
                        tmp[tmpidx++] = 0;
                    }
                    continue;
                }
                if (b > 128) {
                    m = b - 128 + 1;
                    tmp = CBLDC001.makeroom(tmp, tmpidx, m);
                    for (j = 0; j < m; ++j) {
                        tmp[tmpidx++] = 32;
                    }
                    continue;
                }
                tmp = CBLDC001.makeroom(tmp, tmpidx, 1);
                tmp[tmpidx++] = buf[i];
            }
            byte[] ret = new byte[tmpidx];
            System.arraycopy(tmp, 0, ret, 0, tmpidx);
            return ret;
        }

        @Override
        public byte[] compress(byte[] buf, int start, int len) {
            int end = start + len;
            if (buf.length == 0 || end > buf.length) {
                return buf;
            }
            int count = 0;
            byte[] tmp = new byte[buf.length];
            int tmpidx = 0;
            byte lastbyte = (byte)(buf[0] == 0 ? 1 : 0);
            for (int i = start; i < end; ++i) {
                byte b = buf[i];
                if (b == lastbyte) {
                    count = 1;
                    while (i < end && buf[i] == lastbyte) {
                        ++count;
                        ++i;
                    }
                    --i;
                } else {
                    count = 0;
                    if (tmpidx == tmp.length) {
                        System.arraycopy(buf, start, tmp, 0, tmpidx);
                        return tmp;
                    }
                    if (b >= 32 && b <= 127) {
                        tmp[tmpidx++] = b;
                    } else {
                        tmp[tmpidx++] = 0;
                        if (tmpidx == tmp.length) {
                            System.arraycopy(buf, start, tmp, 0, tmpidx);
                            return tmp;
                        }
                        tmp[tmpidx++] = b;
                    }
                }
                if (count > 0) {
                    --tmpidx;
                }
                while (count > 0) {
                    if (tmpidx == tmp.length) {
                        System.arraycopy(buf, start, tmp, 0, tmpidx);
                        return tmp;
                    }
                    if (lastbyte == 32) {
                        tmp[tmpidx++] = (byte)((count >= 32 ? 32 : count) - 129);
                    } else if (lastbyte == 0) {
                        int n = --tmpidx;
                        ++tmpidx;
                        tmp[n] = (byte)((count >= 32 ? 32 : count) - 97);
                    } else if (lastbyte == 48) {
                        tmp[tmpidx++] = (byte)((count >= 32 ? 32 : count) - 65);
                    } else if (lastbyte > 20 && lastbyte <= 127) {
                        tmp[tmpidx++] = (byte)((count >= 32 ? 32 : count) - 33);
                        if (tmpidx == tmp.length) {
                            System.arraycopy(buf, start, tmp, 0, tmpidx);
                            return tmp;
                        }
                        tmp[tmpidx++] = lastbyte;
                    } else {
                        int n = --tmpidx;
                        tmp[n] = (byte)(--count % 32);
                        if (++tmpidx == tmp.length) {
                            System.arraycopy(buf, start, tmp, 0, tmpidx);
                            return tmp;
                        }
                        tmp[tmpidx++] = lastbyte;
                    }
                    count -= 32;
                }
                lastbyte = b;
            }
            byte[] ret = new byte[tmpidx];
            System.arraycopy(tmp, 0, ret, 0, tmpidx);
            return ret;
        }

        private static byte[] makeroom(byte[] tmp, int current, int count) {
            int need = current + count;
            if (need >= tmp.length) {
                byte[] ttmp = new byte[need * 2];
                System.arraycopy(tmp, 0, ttmp, 0, current);
                tmp = ttmp;
            }
            return tmp;
        }

        private static String dump(byte[] in) {
            String x = "";
            for (int i = 0; i < in.length; ++i) {
                x = x + in[i] + ", ";
            }
            return x;
        }

        public static void main(String[] args) {
            CBLDC001 testComp = new CBLDC001();
            System.out.println("testing default compression algorithm CBLDC001");
            for (String anArg : args) {
                byte[] in = null;
                try {
                    in = anArg.getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                System.out.println("  test input:        '" + CBLDC001.dump(in) + "'");
                byte[] out = testComp.compress(in, 0, in.length);
                System.out.println("  test compressed:   '" + CBLDC001.dump(out) + "'");
                byte[] back = testComp.decompress(out, 0, out.length);
                System.out.println("  test decompressed: '" + CBLDC001.dump(back) + "'");
                System.out.println("  test equals: " + Arrays.equals(in, back));
                System.out.println();
            }
        }
    }

    public static interface Compression {
        public byte[] decompress(byte[] var1, int var2, int var3);

        public byte[] compress(byte[] var1, int var2, int var3);
    }
}

