/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.comparableByteArray;

public class MFFilePointer
implements comparableByteArray {
    protected static final boolean sanityCheck = false;
    private long recordKey;
    public int length;

    public long checkSanityLT6b(long num) {
        if (this.length == 6 ? num < 0L || num > 0xFFFFFFFFFFFFL : num < 0L || num > 0xFFFFFFFFL) {
            throw new RuntimeException("*** Heirloom Computing internal error MFFilePointer: recordKeys must be 6 bytes for IDX8, 4 for IDX3  " + num);
        }
        return num;
    }

    public MFFilePointer(long recordKey, boolean idx8) {
        this.length = idx8 ? 6 : 4;
        this.recordKey = recordKey;
    }

    public MFFilePointer(byte[] bytes, int offset, boolean idx8) {
        this.length = idx8 ? 6 : 4;
        this.recordKey = this.getFilePointerFromBytes(bytes, offset);
    }

    @Override
    public final int length() {
        return this.length;
    }

    public int hashCode() {
        return (int)(this.recordKey >> 32) ^ (int)this.recordKey;
    }

    public final void setPointer(long recordKey) {
        this.recordKey = recordKey;
    }

    public final void setRecordKey(long recordKey) {
        this.recordKey = recordKey;
    }

    public final long getRecordKey() {
        return this.recordKey;
    }

    @Override
    public final int compare(comparableByteArray pointer, boolean truncate) {
        return this.compare(pointer);
    }

    @Override
    public final int compare(comparableByteArray pointer) {
        MFFilePointer otherPointer = (MFFilePointer)pointer;
        if (this.recordKey == otherPointer.getRecordKey()) {
            return 0;
        }
        if (this.recordKey > otherPointer.getRecordKey()) {
            return 1;
        }
        return -1;
    }

    @Override
    public final byte[] toByteArray() {
        return this.getBytesFromFilePointer(this.recordKey);
    }

    @Override
    public final void fromByteArray(byte[] tempBytes) {
        this.recordKey = this.getFilePointerFromBytes(tempBytes, 0);
    }

    public final String toString() {
        return "{ " + this.recordKey + " }";
    }

    @Override
    public final comparableByteArray copy() {
        return new MFFilePointer(this.recordKey, this.length == 6);
    }

    public final boolean equals(Object o) {
        if (o instanceof MFFilePointer) {
            return o != null && ((MFFilePointer)o).getRecordKey() == this.getRecordKey();
        }
        return o != null && o.hashCode() == this.hashCode();
    }

    public final boolean equals(MFFilePointer p) {
        return p.recordKey == this.recordKey;
    }

    private long getFilePointerFromBytes(byte[] bytes, int offset) {
        if (this.length == 4) {
            return (long)(bytes[offset] & 0xFF) << 24 | (long)(bytes[offset + 1] & 0xFF) << 16 | (long)(bytes[offset + 2] & 0xFF) << 8 | (long)(bytes[offset + 3] & 0xFF);
        }
        return (long)(bytes[offset] & 0xFF) << 40 | (long)(bytes[offset + 1] & 0xFF) << 32 | (long)(bytes[offset + 2] & 0xFF) << 24 | (long)(bytes[offset + 3] & 0xFF) << 16 | (long)(bytes[offset + 4] & 0xFF) << 8 | (long)(bytes[offset + 5] & 0xFF);
    }

    public void writeBytes(byte[] bytes, int offset) {
        this.setBytesFromFilePointer(bytes, offset, this.recordKey);
    }

    private byte[] getBytesFromFilePointer(long value) {
        byte[] bytes = new byte[this.length];
        this.setBytesFromFilePointer(bytes, 0, value);
        return bytes;
    }

    private void setBytesFromFilePointer(byte[] bytes, int offset, long value) {
        this.checkSanityLT6b(value);
        if (this.length == 4) {
            bytes[offset] = (byte)(value >> 24 & 0xFFL);
            bytes[offset + 1] = (byte)(value >> 16 & 0xFFL);
            bytes[offset + 2] = (byte)(value >> 8 & 0xFFL);
            bytes[offset + 3] = (byte)(value & 0xFFL);
            return;
        }
        bytes[offset] = (byte)(value >> 40 & 0xFFL);
        bytes[offset + 1] = (byte)(value >> 32 & 0xFFL);
        bytes[offset + 2] = (byte)(value >> 24 & 0xFFL);
        bytes[offset + 3] = (byte)(value >> 16 & 0xFFL);
        bytes[offset + 4] = (byte)(value >> 8 & 0xFFL);
        bytes[offset + 5] = (byte)(value & 0xFFL);
    }

    @Override
    public boolean supportsCompareBytes() {
        return false;
    }

    @Override
    public int compareBytes(byte[] bytes, int offset, int len, boolean truncate) {
        return 0;
    }
}

