/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.MediaImage;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.InputStream;

class MediaImageBMP {
    InputStream is;
    int curPos = 0;
    int bitmapOffset = 0;
    int width;
    int height;
    short bitsPerPixel;
    int compression;
    int actualSizeOfBitmap;
    int scanLineSize;
    int actualColorsUsed;
    byte[] r;
    byte[] g;
    byte[] b;
    int noOfEntries;
    byte[] byteData;
    int[] intData;

    MediaImageBMP() {
    }

    private int readInt() throws IOException {
        int b1 = this.is.read();
        int b2 = this.is.read();
        int b3 = this.is.read();
        int b4 = this.is.read();
        this.curPos += 4;
        return (b4 << 24) + (b3 << 16) + (b2 << 8) + (b1 << 0);
    }

    private short readShort() throws IOException {
        int b1 = this.is.read();
        int b2 = this.is.read();
        this.curPos += 4;
        return (short)((b2 << 8) + b1);
    }

    void getFileHeader() throws IOException, Exception {
        if (this.readShort() != 19778) {
            throw new Exception("Not a BMP file");
        }
        this.readInt();
        this.readShort();
        this.readShort();
        this.bitmapOffset = this.readInt();
    }

    void getBitmapHeader() throws IOException {
        this.width = this.readInt();
        this.height = this.readInt();
        this.bitsPerPixel = this.readShort();
        this.compression = this.readInt();
        int sizeOfBitmap = this.readInt();
        int colorsUsed = this.readInt();
        this.scanLineSize = (this.width * this.bitsPerPixel + 31) / 32 * 4;
        this.actualSizeOfBitmap = sizeOfBitmap != 0 ? sizeOfBitmap : this.scanLineSize * this.height;
        this.actualColorsUsed = colorsUsed != 0 ? colorsUsed : (this.bitsPerPixel < 16 ? 1 << this.bitsPerPixel : 0);
    }

    void getPalette() throws IOException {
        this.noOfEntries = this.actualColorsUsed;
        if (this.noOfEntries > 0) {
            this.r = new byte[this.noOfEntries];
            this.g = new byte[this.noOfEntries];
            this.b = new byte[this.noOfEntries];
            int blue = 0;
            int green = 0;
            int red = 0;
            int color2 = 0;
            for (int i = 0; i < this.noOfEntries; ++i) {
                blue = this.is.read() & 0xFF;
                green = this.is.read() & 0xFF;
                red = this.is.read() & 0xFF;
                color2 = MediaImage.remapColor(red << 16 | green << 8 | blue);
                this.b[i] = (byte)(color2 & 0xFF);
                this.g[i] = (byte)(color2 >> 8 & 0xFF);
                this.r[i] = (byte)(color2 >> 16 & 0xFF);
                this.is.read();
                this.curPos += 4;
            }
        }
    }

    void unpack(byte[] rawData, int rawOffset, int[] intData, int intOffset, int w) {
        int j = intOffset;
        int k = rawOffset;
        int mask = 255;
        int b0 = 0;
        int b1 = 0;
        int b2 = 0;
        for (int i = 0; i < w; ++i) {
            b0 = rawData[k++] & mask;
            b1 = (rawData[k++] & mask) << 8;
            b2 = (rawData[k++] & mask) << 16;
            intData[j] = 0xFF000000 | b0 | b1 | b2;
            ++j;
        }
    }

    void unpack(byte[] rawData, int rawOffset, int bpp, byte[] byteData, int byteOffset, int w) throws Exception {
        int pixPerByte;
        int mask;
        int j = byteOffset;
        int k = rawOffset;
        switch (bpp) {
            case 1: {
                mask = 1;
                pixPerByte = 8;
                break;
            }
            case 4: {
                mask = 15;
                pixPerByte = 2;
                break;
            }
            case 8: {
                mask = -1;
                pixPerByte = 1;
                break;
            }
            default: {
                throw new Exception("Unsupported bits-per-pixel value");
            }
        }
        int i = 0;
        while (true) {
            int shift = 8 - bpp;
            for (int ii = 0; ii < pixPerByte; ++ii) {
                byte br = rawData[k];
                br = (byte)(br >> shift);
                byteData[j] = (byte)(br & mask);
                ++j;
                if (++i == w) {
                    return;
                }
                shift -= bpp;
            }
            ++k;
        }
    }

    void getPixelData() throws IOException, Exception {
        long skip = this.bitmapOffset - this.curPos;
        if (skip > 0L) {
            this.is.skip(skip);
            this.curPos = (int)((long)this.curPos + skip);
        }
        int len = this.scanLineSize;
        if (this.bitsPerPixel > 8) {
            this.intData = new int[this.width * this.height];
        } else {
            this.byteData = new byte[this.width * this.height];
        }
        byte[] rawData = new byte[this.actualSizeOfBitmap];
        int rawOffset = 0;
        int offset = (this.height - 1) * this.width;
        for (int i = this.height - 1; i >= 0; --i) {
            int n = this.is.read(rawData, rawOffset, len);
            if (n < len) {
                throw new Exception("Scan line ended prematurely after " + n + " bytes");
            }
            if (this.bitsPerPixel > 8) {
                this.unpack(rawData, rawOffset, this.intData, offset, this.width);
            } else {
                this.unpack(rawData, rawOffset, this.bitsPerPixel, this.byteData, offset, this.width);
            }
            rawOffset += len;
            offset -= this.width;
        }
    }

    void read(InputStream is) throws IOException, Exception {
        this.is = is;
        this.getFileHeader();
        this.getBitmapHeader();
        if (this.compression != 0) {
            throw new Exception("Compression not supported");
        }
        this.getPalette();
        this.getPixelData();
    }

    Image getImage(InputStream is) {
        try {
            MemoryImageSource mis = this.makeImageSource(is);
            if (mis == null) {
                return null;
            }
            return Toolkit.getDefaultToolkit().createImage(mis);
        }
        catch (Exception anyException) {
            return null;
        }
    }

    MemoryImageSource makeImageSource(InputStream is) throws Exception {
        this.read(is);
        return this.makeImageSource();
    }

    MemoryImageSource makeImageSource() {
        ColorModel cm = this.noOfEntries > 0 ? new IndexColorModel((int)this.bitsPerPixel, this.noOfEntries, this.r, this.g, this.b) : ColorModel.getRGBdefault();
        MemoryImageSource mis = this.bitsPerPixel > 8 ? new MemoryImageSource(this.width, this.height, cm, this.intData, 0, this.width) : new MemoryImageSource(this.width, this.height, cm, this.byteData, 0, this.width);
        return mis;
    }
}

