/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Variable;
import java.util.Hashtable;
import java.util.Properties;

public class ObjectConverter {
    public Properties getProperties(Variable v, Properties old) {
        return (Properties)this.getHashtable(v, old);
    }

    public Properties getProperties(Variable v) {
        Properties props = new Properties();
        return this.getProperties(v, props);
    }

    public Hashtable getHashtable(Variable v, Hashtable old) {
        Variable child = v.getChild();
        String id = v.getIdentifier();
        if (child != null) {
            return this.getHashtable(child, old, id + ".");
        }
        old.put(id, v.toString());
        return old;
    }

    private Hashtable getHashtable(Variable v, Hashtable old, String mainPropertyName) {
        while (v != null) {
            Variable child = v.getChild();
            String id = v.getIdentifier();
            if (child != null) {
                this.getHashtable(child, old, mainPropertyName + id + ".");
            } else {
                old.put(mainPropertyName + id, v.toString());
            }
            v = v.getSibling();
        }
        return null;
    }

    public Hashtable getHashtable(Variable v) {
        Hashtable hash = new Hashtable();
        return this.getHashtable(v, hash);
    }

    public Properties setProperties(Variable v, Properties old) {
        return (Properties)this.setHashtable(v, old);
    }

    public Hashtable setHashtable(Variable v, Hashtable old) {
        Variable child = v.getChild();
        String id = v.getIdentifier();
        if (child != null) {
            return this.getHashtable(child, old, id + ".");
        }
        Object o = old.get(id);
        if (o != null) {
            v.move(o.toString());
        }
        return old;
    }

    private Hashtable setHashtable(Variable v, Hashtable old, String mainPropertyName) {
        while (v != null) {
            Variable child = v.getChild();
            String id = v.getIdentifier();
            if (child != null) {
                this.getHashtable(child, old, mainPropertyName + id + ".");
            } else {
                Object o = old.get(mainPropertyName + id);
                if (o != null) {
                    v.move(o.toString());
                }
            }
            v = v.getSibling();
        }
        return null;
    }
}

