/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Hashtable;

public class ObjectRegistry {
    private static final Hashtable<String, Object> objects = new Hashtable();
    private static final Hashtable<String, Class<?>> classes = new Hashtable();
    private static Class<?> dialogClass;
    private static Frame dialogFrame;

    public static void setDialogFrame(Frame f) {
        dialogFrame = f;
    }

    public static Frame getDialogFrame() {
        return dialogFrame;
    }

    public static void remove(String variableName) {
        Object o = objects.get(variableName);
        if (o != null) {
            if (o instanceof Window) {
                ((Window)o).dispose();
            }
            objects.remove(variableName);
        }
    }

    public static Object get(String variableName, Class<?> className) {
        classes.put(variableName, className);
        try {
            Object o = objects.get(variableName);
            if (o != null) {
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Object set(String variableName, Object object) {
        objects.put(variableName, object);
        return object;
    }

    public static Object get(String variableName, Class<?> className, boolean create) {
        Object o = ObjectRegistry.get(variableName, className);
        if (o != null) {
            return o;
        }
        if (create) {
            return ObjectRegistry.get(variableName);
        }
        return null;
    }

    public static Object get(String variableName) {
        Object o;
        try {
            o = objects.get(variableName);
            if (o != null) {
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class<?> classType = classes.get(variableName);
            if (classType == dialogClass) {
                if (dialogFrame == null) {
                    dialogFrame = new Frame();
                }
                o = new Dialog(dialogFrame);
            } else {
                o = classType.newInstance();
            }
            objects.put(variableName, o);
            return o;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        dialogFrame = new Frame();
        try {
            dialogClass = Class.forName("java.awt.Dialog");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

