/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.BignumType;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.ZonedDescription;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public class PackedDecimal
extends BignumType
implements Cloneable,
comparableByteArray {
    private static final long serialVersionUID = 1L;
    private static boolean displayInternal = false;
    private static boolean hilorev;
    private static boolean padLeft;
    private static boolean storeUnsigned;
    protected boolean usePadding;
    protected transient char[] fillArray;

    @Override
    public String getClassName() {
        return "com.heirloomcomputing.ecs.exec.PackedDecimal";
    }

    @Override
    public String getUsage() {
        return "PackedDecimal";
    }

    @Override
    public int getStorageClass() {
        return 3;
    }

    public static void setDatatype(int n) {
        switch (n) {
            case 0: {
                hilorev = false;
                padLeft = false;
                storeUnsigned = false;
                break;
            }
            case 1: {
                hilorev = true;
                padLeft = true;
                storeUnsigned = true;
                break;
            }
            case 2: {
                hilorev = true;
                padLeft = true;
                storeUnsigned = false;
                break;
            }
            case 3: {
                hilorev = true;
                padLeft = true;
                storeUnsigned = true;
                break;
            }
            case 4: {
                hilorev = true;
                padLeft = true;
                storeUnsigned = true;
            }
        }
    }

    @Override
    public final comparableByteArray copy() {
        PackedDecimal copy = (PackedDecimal)super.copy();
        copy.fillArray = null;
        return copy;
    }

    @Override
    public final Numeric odoNumeric() {
        Variable odo = this.findOdo();
        if (odo != null) {
            int newSize = odo.itemSize * odo.occurs();
            odo = odo.parent;
            int difference = newSize - odo.itemSize;
            odo.itemSize = newSize;
            odo = odo.parent;
            while (odo != null) {
                odo.itemSize += (difference *= odo.maxIndex);
                odo = odo.parent;
            }
        }
        return this;
    }

    @Override
    public int getUsageNumber() {
        return 4;
    }

    @Override
    protected void calcPadding() {
        if ((this.picLength & 1) == 1) {
            if (storeUnsigned) {
                this.usePadding = false;
            } else if (!(this.signPosition != 0 || storeUnsigned && this.signPosition == 0)) {
                this.usePadding = true;
            }
        } else if (storeUnsigned || this.signPosition != 0) {
            this.usePadding = true;
        }
    }

    @Override
    public void flushToMemoryNow() {
        try {
            int c;
            boolean trailing;
            byte bufferPlace = this.place;
            Bignum storeValue = this.value;
            if (this.scale > 0) {
                if (this.place > 0) {
                    storeValue = this.value.movePointRight(this.scale);
                    this.place = (byte)(this.place - this.scale);
                } else {
                    storeValue = this.value.movePointLeft(this.scale);
                }
            }
            boolean negative = false;
            String absbuffer = storeValue.toString();
            int length = absbuffer.length();
            if (length > 2 && absbuffer.startsWith("0.")) {
                absbuffer = absbuffer.substring(1);
                --length;
            } else if (length > 1 && absbuffer.charAt(0) == '-') {
                negative = true;
                if (length > 3 && absbuffer.startsWith("-0.")) {
                    absbuffer = absbuffer.substring(2);
                    length -= 2;
                } else {
                    absbuffer = absbuffer.substring(1);
                    --length;
                }
            }
            int byteLow = 14;
            int byteHigh = 14;
            int store = 0;
            boolean storingNibble = false;
            int decimal = absbuffer.indexOf(46);
            if (decimal < 0) {
                decimal = length;
            }
            int rightMost = this.picLength;
            int load = decimal - (rightMost - this.place);
            boolean leading = this.signPosition == 2 || this.signPosition == 4;
            boolean bl = trailing = this.signPosition == 3 || this.signPosition == 5;
            if (leading) {
                c = negative ? 45 : 43;
                byteLow = this.charToNibble((char)c);
                storingNibble = true;
            }
            if (this.usePadding && padLeft) {
                if (!storingNibble) {
                    byteLow = 48;
                } else {
                    byteHigh = 48;
                    if (hilorev) {
                        this.pointerMemory.setByte(this.pointerAddress + store, (byte)(byteLow << 4 | byteHigh));
                    } else {
                        this.pointerMemory.setByte(this.pointerAddress + store, (byte)(byteHigh << 4 | byteLow));
                    }
                    ++store;
                }
                storingNibble = !storingNibble;
            }
            for (int i = 0; i < this.picLength; ++i) {
                if (load >= 0) {
                    if (load == decimal) {
                        ++load;
                    }
                    c = load >= length ? 48 : (int)absbuffer.charAt(load);
                } else {
                    c = 48;
                }
                if (!storingNibble) {
                    byteLow = this.charToNibble((char)c);
                } else {
                    byteHigh = this.charToNibble((char)c);
                    if (hilorev) {
                        this.pointerMemory.setByte(this.pointerAddress + store, (byte)(byteLow << 4 | byteHigh));
                    } else {
                        this.pointerMemory.setByte(this.pointerAddress + store, (byte)(byteHigh << 4 | byteLow));
                    }
                    ++store;
                }
                storingNibble = !storingNibble;
                ++load;
            }
            if (storingNibble) {
                if (trailing) {
                    byteHigh = negative ? this.charToNibble('-') : this.charToNibble('+');
                } else {
                    int n = byteHigh = this.signPosition == 0 ? 15 : 14;
                }
                if (hilorev) {
                    this.pointerMemory.setByte(this.pointerAddress + store, (byte)(byteLow << 4 | byteHigh));
                } else {
                    this.pointerMemory.setByte(this.pointerAddress + store, (byte)(byteHigh << 4 | byteLow));
                }
            } else if (this.signPosition == 3 || this.signPosition == 5) {
                byteLow = negative ? this.charToNibble('-') : this.charToNibble('+');
                byteHigh = 14;
                if (hilorev) {
                    this.pointerMemory.setByte(this.pointerAddress + store, (byte)(byteHigh | byteLow << 4));
                } else {
                    this.pointerMemory.setByte(this.pointerAddress + store, (byte)(byteLow | byteHigh << 4));
                }
            }
            this.place = bufferPlace;
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in PACKED-DECIMAL storage of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    private final byte charToNibble(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case '+': {
                return 12;
            }
            case '-': {
                return 13;
            }
        }
        return 14;
    }

    private final char nibbleToChar(byte b) {
        switch (b) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 12: {
                return '+';
            }
            case 13: {
                return '-';
            }
            case 11: {
                return PD_NUMPROCB2;
            }
        }
        return ' ';
    }

    @Override
    public void fillFromMemoryNow() {
        try {
            byte temporaryPlace = this.place;
            if (this.scale > 0 && this.place > 0) {
                temporaryPlace = (byte)(temporaryPlace - this.scale);
            }
            int itemSizeTimes2 = this.length() * 2;
            boolean negative = false;
            boolean decimalFound = false;
            boolean digitFound = false;
            int load = 0;
            byte b1 = 0;
            int decimal = this.picLength - temporaryPlace;
            if (this.usePadding && padLeft) {
                ++decimal;
            }
            int resultCounter = 0;
            if (this.fillArray == null) {
                this.fillArray = new char[itemSizeTimes2 + 4];
            }
            this.fillArray[resultCounter++] = 48;
            for (int i = 0; i < itemSizeTimes2; ++i) {
                byte b;
                if ((i & 1) == 0) {
                    b = this.pointerMemory.getByte(this.pointerAddress + load);
                    ++load;
                    if (hilorev) {
                        b1 = (byte)(b & 0xF);
                        b = (byte)(b >> 4 & 0xF);
                    } else {
                        b1 = (byte)(b >> 4 & 0xF);
                        b = (byte)(b & 0xF);
                    }
                } else {
                    b = b1;
                }
                if (this.isSignNegative((char)b)) {
                    negative = true;
                } else if (b == 14 && !storeUnsigned && !decimalFound && this.usePadding) {
                    ++decimal;
                }
                if (resultCounter - 1 == decimal) {
                    decimalFound = true;
                    this.fillArray[resultCounter++] = 46;
                }
                if (b < 0 || b > 9) continue;
                this.fillArray[resultCounter++] = (char)(b + 48);
                digitFound = true;
            }
            if (!decimalFound) {
                this.fillArray[resultCounter++] = 46;
            }
            if (negative) {
                this.fillArray[0] = 45;
            }
            if (!digitFound) {
                this.value = new Bignum();
                this.value.setiAmNotNumeric(true);
                this.dirty = false;
            } else {
                this.value = new Bignum(this.fillArray, resultCounter);
            }
            this.numericString = null;
            if (this.scale > 0) {
                this.value.movingPoint(this.scale, temporaryPlace);
            }
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in PACKED-DECIMAL retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public final String toNumericString() {
        if (!this.dirty) {
            this.updateFromMemory(false);
        }
        if (this.numericString != null) {
            return this.numericString;
        }
        if (this.alwaysFlush) {
            return this.value.toString();
        }
        this.numericString = this.value.toString();
        return this.numericString;
    }

    public final String toNumericString(int desiredLength, boolean upToNumPicLength) {
        String result;
        int numLength = upToNumPicLength ? (desiredLength > this.picLength ? this.picLength : desiredLength) : desiredLength;
        if (!this.dirty) {
            this.updateFromMemory(false);
        }
        if (this.signPosition == 4 || this.signPosition == 5) {
            --numLength;
        }
        if ((result = this.value.toString()).charAt(0) == '-') {
            int insertLength;
            if ((insertLength = ++numLength - result.length()) > 0) {
                char[] resultBuffer = new char[numLength];
                resultBuffer[0] = 45;
                int length = result.length();
                for (int i = 1; i <= insertLength; ++i) {
                    resultBuffer[i] = 48;
                }
                result.getChars(1, length, resultBuffer, insertLength + 1);
                if (this.alwaysFlush) {
                    return new String(resultBuffer);
                }
                return new String(resultBuffer);
            }
        } else {
            int insertLength = numLength - result.length();
            if (insertLength > 0) {
                int length = result.length();
                char[] resultBuffer = new char[numLength];
                for (int i = 0; i < insertLength; ++i) {
                    resultBuffer[i] = 48;
                }
                result.getChars(0, length, resultBuffer, insertLength);
                if (this.alwaysFlush) {
                    return new String(resultBuffer);
                }
                return new String(resultBuffer);
            }
        }
        return result;
    }

    @Override
    public final String toDisplayString() {
        if (displayInternal) {
            return this.toString();
        }
        return super.toDisplayString();
    }

    @Override
    public final String toInspectString() {
        return this.toDisplayString();
    }

    @Override
    public final int getAcceptSize() {
        return this.length() * 2;
    }

    @Override
    public final void calcStoreSize() {
        this.storeSize = this.picLength;
    }

    @Override
    public int getArgumentType() {
        return this.signPosition == 0 ? 8 : 9;
    }

    @Override
    public String getCompactPicture() {
        int digits = this.length() * 2;
        if (this.usePadding) {
            --digits;
        }
        digits -= this.place;
        if (this.signPosition == 0) {
            return this.place > 0 ? "9(" + digits + ")V9(" + this.place + ")" : "9(" + digits + ")";
        }
        return this.place > 0 ? "S9(" + digits + ")V9(" + this.place + ")" : "9(" + --digits + ")";
    }

    @Override
    public int getType() {
        return this.getBasicType(80);
    }

    @Override
    public boolean isNumeric(ZonedDescription zonedDescription) {
        int l = this.length();
        boolean signLeading = false;
        this.flushToMemory();
        switch (this.signPosition) {
            case 2: 
            case 4: {
                signLeading = true;
                break;
            }
        }
        for (int i = 0; i < l; ++i) {
            char c = this.pointerMemory.getChar(this.pointerAddress + i);
            String cx = String.format("%02x", c & 0xFFFF);
            try {
                Integer.parseInt(cx);
                continue;
            }
            catch (NumberFormatException e) {
                if (signLeading && i == 0) {
                    if (this.isSignValid((c & 0xF0) >> 8)) continue;
                    return false;
                }
                if (!signLeading && i == l - 1) {
                    if (this.isSignValid(c & 0xF)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void initData() {
        int e = this.pointerAddress + this.length();
        super.initData();
        if (this.signPosition == 3 || this.signPosition == 5) {
            this.pointerMemory.setByte(e - 1, (byte)-64);
        } else if (this.signPosition == 2 || this.signPosition == 4) {
            this.pointerMemory.setByte(0, (byte)-64);
        } else if (this.signPosition == 0) {
            this.pointerMemory.setByte(e - 1, (byte)-16);
        }
    }

    @Override
    public Variable reset() {
        this.fillArray = null;
        return super.reset();
    }

    static {
        String displaytype = RuntimeEnvironment.getGlobalParameter("display.3");
        if (displaytype != null && displaytype.length() > 0) {
            switch (displaytype.charAt(0)) {
                case 'I': 
                case 'i': {
                    displayInternal = true;
                    break;
                }
            }
        }
        hilorev = false;
        padLeft = false;
        storeUnsigned = false;
        PackedDecimal.setDatatype(0);
    }
}

