/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ResourceManager;
import com.heirloomcomputing.ecs.exec.Tiler;
import com.heirloomcomputing.ecs.util.Utils;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class PopupDialog
extends Frame {
    private String type;
    private Component ta;
    private Panel bp;
    private String info;
    private boolean hasField;
    private boolean isSecure;
    private boolean hasStatusBar;
    private float statusBarVal = 0.0f;
    private int statusBarBegin;
    private int statusBarEnd = 100;
    private Button[] buttonArray;
    private TextField textField;
    private int textFieldColumns = 8;
    private CustomStatusBar statusBar;
    private boolean centered;
    int result = -1;

    public void setCentered(boolean state) {
        this.centered = state;
    }

    @Override
    public final void addNotify() {
        int end;
        int begin;
        Label label;
        super.addNotify();
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.setLayout(new BorderLayout());
        Panel textPanel = new Panel();
        textPanel.setLayout(new BorderLayout());
        this.bp = new Panel();
        this.add("South", this.bp);
        this.bp.setLayout(new FlowLayout(2));
        this.addButtons(this.type);
        String lineSep = "\n";
        try {
            lineSep = System.getProperty("line.separator");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.info != null && (this.info.length() > 49 || this.info.indexOf(lineSep) >= 0)) {
            TextArea area = new TextArea(6, 50);
            area.setEditable(false);
            area.setText(this.info);
            this.ta = area;
        } else if (this.info != null) {
            label = new Label();
            if (!this.hasField && this.info != null && this.info.length() < 50) {
                while (this.info.length() < 50) {
                    this.info = "                         " + this.info + "                         ";
                }
                if (this.info.length() > 50) {
                    begin = this.info.length() / 2 - 25;
                    if (begin < 0) {
                        begin = 0;
                    }
                    if ((end = begin + 50) > this.info.length()) {
                        end = this.info.length();
                    }
                    this.info = this.info.substring(begin, end);
                }
            }
            label.setText(this.info);
            label.setAlignment(1);
            this.ta = label;
        } else {
            label = new Label();
            if (!this.hasField && this.info != null && this.info.length() < 50) {
                while (this.info.length() < 50) {
                    this.info = "                         " + this.info + "                         ";
                }
                if (this.info.length() > 50) {
                    begin = this.info.length() / 2 - 25;
                    if (begin < 0) {
                        begin = 0;
                    }
                    if ((end = begin + 50) > this.info.length()) {
                        end = this.info.length();
                    }
                    this.info = this.info.substring(begin, end);
                }
            }
            label.setText(this.info);
            label.setAlignment(1);
            this.ta = label;
        }
        if (!this.hasField) {
            textPanel.add("Center", this.ta);
        } else {
            textPanel.add("West", this.ta);
        }
        this.add("Center", textPanel);
        this.ta.setVisible(true);
        if (this.hasField) {
            this.textField = new TextField(this.textFieldColumns);
            textPanel.add("Center", this.textField);
            if (this.isSecure) {
                this.textField.setEchoChar('*');
            }
        }
        Panel filler = new Panel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(d.width, 20);
            }
        };
        textPanel.add("North", filler);
        if (this.hasStatusBar) {
            this.statusBar = new CustomStatusBar();
            textPanel.add("South", this.statusBar);
            this.updateStatusBar();
        } else {
            filler = new Panel(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    return new Dimension(d.width, 20);
                }
            };
            textPanel.add("South", filler);
        }
        this.bp.setVisible(true);
        this.pack();
        Dimension ourSize = this.getSize();
        String title = this.getTitle();
        if (title != null && title.trim().length() > 0) {
            try {
                FontMetrics fm = Utils.getFontMetrics(this.getFont());
                int titleBarWidth = fm.stringWidth(title) + 120;
                if (ourSize.width < titleBarWidth) {
                    ourSize.width = titleBarWidth;
                }
                this.setSize(ourSize);
            }
            catch (Throwable fm) {
                // empty catch block
            }
        }
        if (this.centered) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenSize.width - ourSize.width) / 2, (screenSize.height - ourSize.height) / 2);
        } else {
            this.setLocation(Tiler.getNextLocation(ourSize.width, ourSize.height));
        }
        if (this.hasField) {
            this.textField.requestFocus();
            if (this.buttonArray != null) {
                for (int i = 0; i < this.buttonArray.length; ++i) {
                    if (this.buttonArray[i] == null) continue;
                    this.buttonArray[i].transferFocus();
                }
            }
            this.textField.requestFocus();
        }
    }

    @Override
    public Component getFocusOwner() {
        return super.getFocusOwner();
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    public PopupDialog(String title, String info, String type) {
        super(title);
        this.info = info;
        this.type = type;
        this.addWindowListener(new windowAdapter());
    }

    public PopupDialog(String title, String info, String type, int textFieldColumns) {
        this(title, info, type);
        this.textFieldColumns = textFieldColumns;
        this.addWindowListener(new windowAdapter());
    }

    public PopupDialog(String title, String info) {
        super(title);
        this.info = info;
        this.type = "O";
        this.addWindowListener(new windowAdapter());
    }

    public PopupDialog(String title, String info, String type, float val, int begin, int end) {
        this(title, info, type);
        this.hasStatusBar = true;
        this.statusBarVal = val;
        this.statusBarBegin = begin;
        this.statusBarEnd = end;
        this.updateStatusBar();
        this.addWindowListener(new windowAdapter());
    }

    public void updateDialog(String title, String text) {
        super.setTitle(title);
        if (this.ta != null && this.ta instanceof TextArea) {
            ((TextArea)this.ta).setText(text);
        } else if (this.ta != null && this.ta instanceof TextField) {
            ((TextField)this.ta).setText(text);
        }
    }

    public void updateDialog(String title, String text, float val, int begin, int end) {
        super.setTitle(title);
        if (this.ta != null && this.ta instanceof TextArea) {
            ((TextArea)this.ta).setText(text);
        } else if (this.ta != null && this.ta instanceof TextField) {
            ((TextField)this.ta).setText(text);
        }
        if (!this.hasStatusBar) {
            return;
        }
        this.statusBarVal = val;
        this.statusBarBegin = begin;
        this.statusBarEnd = end;
        this.updateStatusBar();
    }

    private void updateStatusBar() {
        if (this.statusBar == null) {
            return;
        }
        this.statusBar.update(this.statusBarVal, this.statusBarBegin, this.statusBarEnd);
    }

    public final void setInfo(String text) {
        if (this.ta != null && this.ta instanceof TextArea) {
            ((TextArea)this.ta).setText(text);
        } else if (this.ta != null && this.ta instanceof TextField) {
            ((TextField)this.ta).setText(text);
        }
    }

    public final void addButtons(String typ) {
        final String type = typ.toUpperCase();
        Vector<3> buttonVector = null;
        this.buttonArray = null;
        if (type != null) {
            int size;
            if (type.trim().length() == 0) {
                return;
            }
            for (int i = 0; i < type.length(); ++i) {
                String buttonText = null;
                switch (type.charAt(i)) {
                    case 'Y': {
                        buttonText = ResourceManager.get("dialog.yes", "Yes");
                        break;
                    }
                    case 'N': {
                        buttonText = ResourceManager.get("dialog.no", "No");
                        break;
                    }
                    case 'O': {
                        buttonText = ResourceManager.get("dialog.ok", "OK");
                        break;
                    }
                    case 'C': {
                        buttonText = ResourceManager.get("dialog.cancel", "Cancel");
                        break;
                    }
                    case 'o': {
                        buttonText = ResourceManager.get("dialog.open", "Open");
                        break;
                    }
                    case 'c': {
                        buttonText = ResourceManager.get("dialog.close", "Close");
                        break;
                    }
                    case '<': {
                        buttonText = ResourceManager.get("dialog.back", "< Back");
                        break;
                    }
                    case '>': {
                        buttonText = ResourceManager.get("dialog.next", "Next >");
                        break;
                    }
                    case 'F': {
                        buttonText = ResourceManager.get("dialog.finish", "Finish");
                        break;
                    }
                    case 'A': {
                        buttonText = ResourceManager.get("dialog.apply", "Apply");
                        break;
                    }
                    case 'H': {
                        buttonText = ResourceManager.get("dialog.help", "Help");
                        break;
                    }
                    case 'S': {
                        buttonText = ResourceManager.get("dialog.stop", "Stop");
                        break;
                    }
                    case 'B': {
                        buttonText = ResourceManager.get("dialog.break", "Break");
                        break;
                    }
                    case 'b': {
                        buttonText = ResourceManager.get("dialog.browse", "Browse...");
                        break;
                    }
                    case 'X': {
                        buttonText = ResourceManager.get("dialog.exit", "Exit");
                        break;
                    }
                    case 'R': {
                        buttonText = ResourceManager.get("dialog.retry", "Retry");
                        break;
                    }
                    case 'I': {
                        this.hasField = true;
                        break;
                    }
                    case '*': {
                        this.isSecure = true;
                    }
                }
                if (buttonText == null) continue;
                Button myButton = new Button(){

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(65, 20);
                    }
                };
                myButton.setLabel(buttonText);
                this.bp.add(myButton);
                if (buttonVector == null) {
                    buttonVector = new Vector<3>();
                }
                buttonVector.addElement(myButton);
                myButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int index;
                        PopupDialog.this.setVisible(false);
                        PopupDialog.this.dispose();
                        PopupDialog.this.result = -1;
                        for (int i = 0; i < PopupDialog.this.buttonArray.length; ++i) {
                            if (e.getSource() != PopupDialog.this.buttonArray[i]) continue;
                            PopupDialog.this.result = i;
                            break;
                        }
                        if (PopupDialog.this.result == -1 && PopupDialog.this.hasField && type != null && (index = type.indexOf(73)) >= 0) {
                            PopupDialog.this.result = index;
                        }
                        PopupDialog.this.setResult(PopupDialog.this.result);
                    }
                });
            }
            if (buttonVector != null && (size = buttonVector.size()) > 0) {
                this.buttonArray = new Button[size];
                buttonVector.copyInto(this.buttonArray);
            }
        }
    }

    final synchronized void setResult(int result) {
        this.result = result;
        this.notify();
    }

    final synchronized void setResult(char result) {
        try {
            this.result = this.type.indexOf(result);
        }
        catch (Exception e) {
            this.result = -1;
        }
        this.notify();
    }

    final synchronized int getResult() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            return -1;
        }
        return this.result;
    }

    final synchronized char getResultChar() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            return 'C';
        }
        try {
            return this.type.charAt(this.result);
        }
        catch (Exception e) {
            return 'C';
        }
    }

    public final String getResultFieldString() {
        if (!this.hasField) {
            return null;
        }
        try {
            return this.textField.getText();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    class windowAdapter
    extends WindowAdapter {
        windowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
            PopupDialog.this.setVisible(false);
            PopupDialog.this.dispose();
            PopupDialog.this.setResult('C');
        }
    }

    class CustomStatusBar
    extends Panel {
        private float val;
        private int begin;
        private int end;

        CustomStatusBar() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 40);
        }

        public void update(float val, int begin, int end) {
            this.val = val;
            this.begin = begin;
            this.end = end;
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            int inset = 5;
            int width = d.width - inset * 2;
            float max = this.end - this.begin;
            float index = this.val - (float)this.begin;
            FontMetrics fm = g.getFontMetrics(g.getFont());
            g.setColor(Color.black);
            g.drawRect(inset - 1, 0, width + 1, d.height / 2);
            g.setColor(Color.blue);
            float offset = inset;
            float unit = (float)width / max;
            int barWidth = Math.round(unit - 1.0f);
            int barHeight = d.height / 2 - 1;
            int i = 1;
            while ((float)i <= index) {
                g.fillRect((int)Math.ceil(offset), 1, barWidth, barHeight);
                offset += unit;
                ++i;
            }
            int percentComplete = (int)(index / max * 100.0f);
            String s = "" + percentComplete + "%";
            int StringPixelWidth = fm.stringWidth(s);
            int x = (d.width - 10 - StringPixelWidth) / 2;
            int y = d.height / 2 - fm.getAscent() / 2;
            g.setColor(Color.black);
            g.drawString(s, x + 2, y + 1);
            g.setColor(Color.white);
            g.drawString(s, x, y);
            g.drawString(s, x + 1, y);
        }
    }
}

