/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.RegularExpression;

public class RegEx {
    public static boolean like(IDatatype thisDatatype, String likeString, String regexStyle, String escape) {
        return RegEx.like(thisDatatype.toText(), likeString, regexStyle, escape);
    }

    public static boolean like(String thisString, String likeString, String regexStyle, String escape) {
        if (regexStyle != null && regexStyle.equalsIgnoreCase("SQL")) {
            regexStyle = null;
        }
        if (regexStyle != null) {
            try {
                RegularExpression re = regexStyle.indexOf(46) >= 0 ? (RegularExpression)Class.forName(regexStyle).newInstance() : (RegularExpression)Class.forName("com.heirloomcomputing.ecs.exec.RegularExpression" + regexStyle.toUpperCase()).newInstance();
                return re.like(thisString, likeString, escape);
            }
            catch (Exception e) {
                return false;
            }
        }
        int thisStringLength = thisString.length();
        int likeStringLength = likeString.length();
        boolean hasEscape = false;
        char escapeChar = '\u0000';
        if (escape != null && escape.length() > 0) {
            escapeChar = escape.charAt(0);
        }
        int reader = 0;
        char pattern = '\u0000';
        boolean foundPattern = false;
        for (int i = 0; i < thisStringLength; ++i) {
            if (reader >= likeStringLength) {
                return false;
            }
            pattern = likeString.charAt(reader);
            switch (pattern) {
                case '_': {
                    break;
                }
                case '%': {
                    if (++reader >= likeStringLength) {
                        return true;
                    }
                    pattern = likeString.charAt(reader);
                    foundPattern = false;
                    while (i < thisStringLength) {
                        if (thisString.charAt(i) == pattern) {
                            foundPattern = true;
                            break;
                        }
                        ++i;
                    }
                    if (foundPattern) break;
                    return false;
                }
                default: {
                    if (hasEscape && pattern == escapeChar && (pattern = likeString.charAt(++reader)) != thisString.charAt(++i)) {
                        return false;
                    }
                    if (pattern == thisString.charAt(i)) break;
                    return false;
                }
            }
            ++reader;
        }
        return reader == likeStringLength;
    }

    public static boolean like(IDatatype thisDatatype, String likeString, String regexStyle) {
        return RegEx.like(thisDatatype.toText(), likeString, regexStyle);
    }

    public static boolean like(String thisString, String likeString, String regexStyle) {
        return RegEx.like(thisString, likeString, regexStyle, null);
    }

    public static boolean like(IDatatype thisDatatype, String likeString) {
        return RegEx.like(thisDatatype.toText(), likeString);
    }

    public static boolean like(String thisString, String likeString) {
        return RegEx.like(thisString, likeString, null, null);
    }
}

