/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Utilities;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class ResourceManager {
    private static Hashtable<String, String> resources = new Hashtable();
    private static Hashtable<String, String> bundles = new Hashtable();
    private static String userLanguage = "en";
    private static String userRegion = "US";

    public static void initialize() {
        resources = new Hashtable();
        bundles = new Hashtable();
        try {
            userLanguage = System.getProperty("user.language");
            if (userLanguage == null) {
                userLanguage = "en";
            }
            userLanguage = userLanguage.toLowerCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            userRegion = System.getProperty("user.region");
            if (userRegion == null) {
                userRegion = "US";
            }
            userRegion = userRegion.toUpperCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static InputStream getInputStream(ClassLoader classLoader, String filename) {
        return Utilities.getInputStream(classLoader, filename);
    }

    public static void load(ClassLoader classLoader, String resourceBundle) {
        if (resourceBundle == null) {
            return;
        }
        String oldBundle = bundles.get(resourceBundle);
        if (oldBundle != null) {
            return;
        }
        bundles.put(resourceBundle, resourceBundle);
        String withLang = resourceBundle + "_" + userLanguage;
        String withRegion = withLang + "_" + userRegion;
        InputStream is = ResourceManager.getInputStream(classLoader, withRegion + ".properties");
        if (is != null) {
            ResourceManager.parseResources(is);
        }
        if ((is = ResourceManager.getInputStream(classLoader, withRegion)) != null) {
            ResourceManager.parseResources(is);
        }
        if ((is = ResourceManager.getInputStream(classLoader, withLang + ".properties")) != null) {
            ResourceManager.parseResources(is);
        }
        if ((is = ResourceManager.getInputStream(classLoader, withLang)) != null) {
            ResourceManager.parseResources(is);
        }
        if ((is = ResourceManager.getInputStream(classLoader, resourceBundle + ".properties")) != null) {
            ResourceManager.parseResources(is);
        }
        if ((is = ResourceManager.getInputStream(classLoader, resourceBundle)) != null) {
            ResourceManager.parseResources(is);
        }
    }

    private static void parseResources(InputStream fin) {
        if (fin == null) {
            return;
        }
        try {
            BufferedReader d = new BufferedReader(new InputStreamReader(fin));
            String line = null;
            String keyword = null;
            String value = null;
            int length = 0;
            char c = '\u0000';
            boolean stripping = false;
            int stripped = 0;
            try {
                block8: do {
                    if ((line = d.readLine()) != null) {
                        line = line.trim();
                    }
                    if (line == null || line.startsWith("#") || line.startsWith("[")) continue;
                    try {
                        length = line.length();
                        stripping = true;
                        stripped = 0;
                        for (int i = 0; i < length; ++i) {
                            c = line.charAt(i);
                            if (c == ' ' || c == '\t' || c == ':' || c == '=') {
                                if (!stripping) {
                                    keyword = line.substring(stripped, i);
                                    value = line.substring(i + 1).trim();
                                    value = value.replace('\t', ' ');
                                    if (resources.get(keyword) != null) continue block8;
                                    resources.put(keyword, value);
                                    continue block8;
                                }
                                stripped = i + 1;
                                continue;
                            }
                            stripping = false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } while (line != null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                d.close();
                fin.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String get(String name) {
        if (name == null) {
            return null;
        }
        String value = resources.get(name.trim());
        return value != null ? String.valueOf(value) : name;
    }

    public static String get(String name, String defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        String value = resources.get(name.trim());
        if (value != null) {
            return String.valueOf(value);
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return name;
    }

    static void setConfigurationText(int resource, String value) {
    }

    static {
        ResourceManager.initialize();
    }
}

