/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Memory;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;

public class SharedMemory {
    private static SharedMemory instance;
    private Map<Integer, Memory> sharedMemoryHandles;
    private Map<Memory, Integer> sharedMemoryObjects;
    private Context namingContext;
    private int retryCnt = 0;

    private SharedMemory() {
        this.getsharedMemoryHandles();
        this.getsharedMemoryObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SharedMemory getInstance() {
        if (instance != null) return instance;
        Class<SharedMemory> clazz = SharedMemory.class;
        synchronized (SharedMemory.class) {
            if (instance != null) return instance;
            instance = new SharedMemory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int makeSharedMemory(Memory mem) {
        int id = this.sharedMemoryHandles.size() + 1;
        this.sharedMemoryHandles.put(id, mem);
        this.sharedMemoryObjects.put(mem, id);
        return id;
    }

    public int getSharedMemoryIndex(Memory mem) {
        return this.sharedMemoryObjects.get(mem);
    }

    public Memory getSharedMemory(Integer id) {
        return this.sharedMemoryHandles.get(id);
    }

    public int freeSharedMemory(Integer id) {
        int rc = 0;
        if (id != null) {
            try {
                this.sharedMemoryObjects.remove(this.getSharedMemory(id));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.sharedMemoryHandles.remove(id);
        }
        return rc;
    }

    public int freeSharedMemory(Memory mem) {
        int rc = 0;
        if (mem != null) {
            try {
                this.sharedMemoryHandles.remove(this.getSharedMemoryIndex(mem));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.sharedMemoryObjects.remove(mem);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getsharedMemoryHandles() {
        String sharedMemoryJndi = "sharedMemoryHandles";
        Context context = this.getNamingContext(null);
        try {
            Object result = context.lookup(sharedMemoryJndi);
            if (result != null) {
                this.sharedMemoryHandles = result instanceof ConcurrentHashMap ? (Map<Object, Object>)result : new ConcurrentHashMap<Integer, Memory>(500);
            }
            return;
        }
        catch (NamingException namingException) {
            SharedMemory sharedMemory = this;
            synchronized (sharedMemory) {
                block15: {
                    if (this.sharedMemoryHandles == null) {
                        this.sharedMemoryHandles = new ConcurrentHashMap<Integer, Memory>(500);
                        try {
                            context.bind(sharedMemoryJndi, this.sharedMemoryHandles);
                        }
                        catch (NameAlreadyBoundException nabe) {
                            if (this.retryCnt == 0) {
                                ++this.retryCnt;
                                this.getsharedMemoryHandles();
                                break block15;
                            }
                            try {
                                throw new Exception("Not able to bind to JNDI.1");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e1) {
                            try {
                                throw new Exception("Not able to bind to JNDI.2");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getsharedMemoryObjects() {
        String sharedMemoryJndi = "sharedMemoryObjects";
        Context context = this.getNamingContext(null);
        try {
            Object result = context.lookup(sharedMemoryJndi);
            if (result != null) {
                this.sharedMemoryObjects = result instanceof ConcurrentHashMap ? (Map<Object, Object>)result : new ConcurrentHashMap<Memory, Integer>(500);
            }
            return;
        }
        catch (NamingException namingException) {
            SharedMemory sharedMemory = this;
            synchronized (sharedMemory) {
                block15: {
                    if (this.sharedMemoryObjects == null) {
                        this.sharedMemoryObjects = new ConcurrentHashMap<Memory, Integer>(500);
                        try {
                            context.bind(sharedMemoryJndi, this.sharedMemoryObjects);
                        }
                        catch (NameAlreadyBoundException nabe) {
                            if (this.retryCnt == 0) {
                                ++this.retryCnt;
                                this.getsharedMemoryObjects();
                                break block15;
                            }
                            try {
                                throw new Exception("Not able to bind to JNDI.1");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e1) {
                            try {
                                throw new Exception("Not able to bind to JNDI.2");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            return;
        }
    }

    public Context getNamingContext(Hashtable<?, ?> initialProperties) {
        if (this.namingContext != null) {
            return this.namingContext;
        }
        try {
            this.namingContext = initialProperties != null && !initialProperties.isEmpty() ? new InitialContext(initialProperties) : new InitialContext();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return this.namingContext;
    }
}

