/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.Variable;

public class SortTable {
    private static final int MAX_KEYS = 32;
    private Object[] originalTable;
    private Object[] table;
    private boolean nextKeyIsAscending = true;
    private Object[][] keys = new Object[32][];
    private boolean[] ascending = new boolean[32];
    private int[] originalOrder;
    private int keyCount;
    private boolean duplicates;
    private String collatingSequence;

    public SortTable(Object[] originalTable) {
        this.originalTable = originalTable;
        int tableLength = originalTable.length;
        this.table = new Object[tableLength];
        System.arraycopy(originalTable, 0, this.table, 0, tableLength);
    }

    public SortTable sort(int duplicates, String collatingSequence) {
        if (this.keyCount == 0) {
            this.key(this.table);
        }
        return this.sort(duplicates == 512, collatingSequence);
    }

    public SortTable ascend() {
        this.nextKeyIsAscending = true;
        return this;
    }

    public SortTable descend() {
        this.nextKeyIsAscending = false;
        return this;
    }

    public SortTable key(Object[] key) {
        if (this.keyCount >= 32) {
            throw new RuntimeException("Cannot sort more than 32 keys.");
        }
        this.keys[this.keyCount] = key;
        this.ascending[this.keyCount] = this.nextKeyIsAscending;
        ++this.keyCount;
        return this;
    }

    private SortTable sort(boolean duplicates, String collatingSequence) {
        int i;
        this.duplicates = duplicates;
        this.collatingSequence = collatingSequence;
        int tableLength = this.table.length;
        if (duplicates) {
            this.originalOrder = new int[tableLength];
            for (i = 0; i < tableLength; ++i) {
                this.originalOrder[i] = i;
            }
        }
        this.quicksort(1, tableLength - 1);
        this.originalOrder = null;
        this.keys = null;
        this.ascending = null;
        for (i = 1; i < tableLength; ++i) {
            if (this.table[i] == this.originalTable[i]) continue;
            this.table[i] = ((Variable)this.table[i]).copy();
        }
        for (i = 1; i < tableLength; ++i) {
            if (this.table[i] == this.originalTable[i]) continue;
            ((Variable)this.originalTable[i]).move((Variable)this.table[i]);
        }
        this.table = null;
        this.originalTable = null;
        return this;
    }

    private void quicksort(int l, int r) {
        if (r > l) {
            int i = l - 1;
            int j = r;
            while (true) {
                if (i < r && this.compareRecords(++i, r) < 0) {
                    continue;
                }
                while (j > 0 && this.compareRecords(--j, r) > 0) {
                }
                if (i >= j) break;
                this.swapRecords(i, j);
            }
            this.swapRecords(i, r);
            this.quicksort(l, i - 1);
            this.quicksort(i + 1, r);
        }
    }

    private void swapRecords(int left, int right) {
        Object originalLeft = this.table[left];
        this.table[left] = this.table[right];
        this.table[right] = originalLeft;
        if (this.originalOrder != null) {
            int origLeft = this.originalOrder[left];
            this.originalOrder[left] = this.originalOrder[right];
            this.originalOrder[right] = origLeft;
        }
        int keysLength = this.keyCount;
        for (int i = 0; i < keysLength; ++i) {
            Object[] selectedKey = this.keys[i];
            if (selectedKey == this.table) continue;
            originalLeft = selectedKey[left];
            selectedKey[left] = selectedKey[right];
            selectedKey[right] = originalLeft;
        }
    }

    private int compareRecords(int left, int right) {
        int result = 0;
        for (int k = 0; k < this.keyCount; ++k) {
            Numeric keyan = null;
            Numeric keybn = null;
            Variable keya = (Variable)this.keys[k][left];
            Variable keyb = (Variable)this.keys[k][right];
            if (keya.isNumericInstance()) {
                keyan = (Numeric)keya;
                if (keyb.isNumericInstance()) {
                    keybn = (Numeric)keyb;
                    result = keyan.compare(keybn, this.collatingSequence);
                } else {
                    result = keyan.compare(keyb, this.collatingSequence);
                }
            } else if (keyb.isNumericInstance()) {
                keybn = (Numeric)keyb;
                result = keya.compare(keybn, this.collatingSequence);
            } else {
                result = keya.compare(keyb, this.collatingSequence);
            }
            if (result == 0) continue;
            return this.ascending[k] ? result : -result;
        }
        if (this.duplicates) {
            int origi = this.originalOrder[left];
            int origj = this.originalOrder[right];
            if (origi > origj) {
                return -1;
            }
            if (origi < origj) {
                return 1;
            }
        }
        return 0;
    }
}

