/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.PropertiesUtil;
import com.heirloomcomputing.ecs.exec.SqlConnectionFactory;
import com.heirloomcomputing.ecs.exec.SqlCursors;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.Context;

public class SqlContext {
    public static final int CAN_STORE_OK = 0;
    public static final int CAN_STORE_WARNING_SPACES = 1;
    public static final int CAN_STORE_WARNING_TRUNCATION = 2;
    public static final int CAN_STORE_ERROR_NUMERIC_DECIMAL = 4;
    public static final int CAN_STORE_ERROR_NUMERIC_WHOLE = 8;
    public static final int CAN_STORE_ERROR_STRING = 16;
    public static final int CAN_STORE_WARNING = 2;
    public static final int CAN_STORE_ERROR = 4;
    private static final Object[][] SQLCODESTATE = new Object[][]{{305, "22002"}, {501, "24501"}, {502, "24502"}, {803, "23505"}, {911, "40001"}, {913, "57033"}};
    public static final int CAN_STORE_WARNING_MASK = 3;
    public static final int CAN_STORE_ERROR_MASK = 28;
    public static String CURRENT_SQL_CONNECTION_NAME = "default";
    public static final String DEFAULT_SQL_CONNECTION_NAME = "default";
    private boolean sqlImplicitTransaction = true;
    private boolean sqlLoggingMode;
    private boolean isTransactionManaged;
    private static Class<?> xaEnvKlazz = null;
    private static Method xaCommitMethod = null;
    private static Method xaRollbackMethod = null;
    private static PrintWriter logStream = new PrintWriter(System.out);
    private final SqlCursors sqlCursors = new SqlCursors();
    private final Hashtable<String, Object> sqlPStatements = new Hashtable();
    public static boolean implicitTransactions = true;
    private static boolean DisconnectConnectionsUponExit = true;
    private Connection currentSqlConnection;
    private final Hashtable<String, Connection> sqlConnections = new Hashtable();

    public SqlContext() {
        Properties props = null;
        String filename = "deploy.properties";
        try {
            props = PropertiesUtil.loadProperties(filename);
        }
        catch (IllegalArgumentException err) {
            filename = "deploy_settings";
            try {
                props = PropertiesUtil.loadProperties(filename);
            }
            catch (Exception ignore) {
                return;
            }
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.info("Loaded properties file:" + filename);
            LogSetup.LOGGER.finest(" displays properties file: ");
            LogSetup.LOGGER.finest(props.toString() + "\n");
        }
        props = PropertiesUtil.swapProperties(props);
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            System.setProperty(key, props.getProperty(key));
        }
    }

    public void setLogMode(int value) {
        this.sqlLoggingMode = value >= 2;
        this.sqlCursors.setLogMode(this.sqlLoggingMode);
    }

    public void setDriverLogMode(int value) {
        try {
            DriverManager.setLogWriter(value >= 1 ? logStream : null);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public SqlCursors getCursors() {
        return this.sqlCursors;
    }

    public Object putPreparedStatement(String name, Object value) {
        this.sqlPStatements.put(name, value);
        return value;
    }

    public Object getPreparedStatementObject(Object name) {
        return this.sqlPStatements.get(name);
    }

    public String getPreparedStatement(Object name) {
        Object result = this.sqlPStatements.get(name);
        if (result == null) {
            return "";
        }
        String resultString = String.valueOf(result);
        if (resultString == null) {
            return "";
        }
        return resultString.trim();
    }

    public Object removePreparedStatement(Object name) {
        this.sqlPStatements.remove(name);
        return name;
    }

    private static final void beginTransaction(Connection con) throws SQLException {
        if (con != null && SqlContext.isImplicitTransactions()) {
            Statement beginTransaction = con.createStatement();
            beginTransaction.execute("BEGIN TRANSACTION");
            beginTransaction.close();
        }
    }

    public final void beginTransaction() throws SQLException {
        SqlContext.beginTransaction(this.currentSqlConnection);
    }

    public final void disconnect() throws SQLException {
        if (this.currentSqlConnection != null) {
            if (!this.currentSqlConnection.getAutoCommit() && this.sqlImplicitTransaction) {
                try {
                    this.currentSqlConnection.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (DisconnectConnectionsUponExit) {
                this.currentSqlConnection.close();
                this.currentSqlConnection = null;
            }
        }
    }

    public final void disconnect(Object connectionRef) throws SQLException {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("disconnect(Object): connectionRef=" + String.valueOf(connectionRef) + ".");
        }
        if (connectionRef == null) {
            if (this.currentSqlConnection == null) {
                throw new SQLException("Elastic COBOL SQL: 08002.R7: Cannot disconnect from null object. Connection=" + String.valueOf(connectionRef) + ".");
            }
            if (!this.currentSqlConnection.getAutoCommit() && this.sqlImplicitTransaction) {
                try {
                    this.currentSqlConnection.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (DisconnectConnectionsUponExit) {
                this.currentSqlConnection.close();
                this.currentSqlConnection = null;
            }
            return;
        }
        if (DisconnectConnectionsUponExit && connectionRef instanceof Connection) {
            ((Connection)connectionRef).close();
            return;
        }
        if (DisconnectConnectionsUponExit) {
            String connectionName = this.connectionName(String.valueOf(connectionRef));
            this.getConnection(connectionName).close();
            this.sqlConnections.remove(connectionName);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("Connection closed. Number of open connections = " + this.sqlConnections.size() + ".");
            }
        }
    }

    public final void disconnectAll() throws SQLException {
        if (!this.isTransactionManaged()) {
            try {
                Enumeration<Connection> e = this.sqlConnections.elements();
                while (e.hasMoreElements()) {
                    try {
                        Connection next = e.nextElement();
                        if (!this.currentSqlConnection.getAutoCommit() && this.sqlImplicitTransaction) {
                            try {
                                this.currentSqlConnection.commit();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!DisconnectConnectionsUponExit) continue;
                        next.close();
                        if (next != this.currentSqlConnection) continue;
                        this.currentSqlConnection = null;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (DisconnectConnectionsUponExit) {
            this.sqlConnections.clear();
        }
    }

    final void exit() {
        block2: {
            try {
                this.disconnectAll();
            }
            catch (Exception e) {
                LogSetup.LOGGER.warning("SqlContext.disconnectAll() has Exception. ");
                if (!LogSetup.LOGGER.isLoggable(Level.WARNING)) break block2;
                e.printStackTrace();
            }
        }
    }

    private final String connectionName(String name) {
        if (name == null) {
            return CURRENT_SQL_CONNECTION_NAME;
        }
        if ((name = name.trim()).length() == 0) {
            return CURRENT_SQL_CONNECTION_NAME;
        }
        return name.toLowerCase();
    }

    public final Connection getConnection() throws SQLException {
        return this.getConnection(true);
    }

    public final Connection getConnection(String name, boolean create) throws SQLException {
        name = name == null ? DEFAULT_SQL_CONNECTION_NAME : name;
        this.currentSqlConnection = this.sqlConnections.get(name);
        if (create) {
            try {
                if (this.currentSqlConnection == null) {
                    String alias = System.getProperty("sql." + name + ".alias");
                    if (alias != null) {
                        this.currentSqlConnection = this.sqlConnections.get(alias);
                    } else {
                        String url2 = System.getProperty("sql." + name + ".url");
                        String driverName = System.getProperty("sql." + name + ".driver");
                        String username = System.getProperty("sql." + name + ".user");
                        String password = System.getProperty("sql." + name + ".password");
                        this.currentSqlConnection = SqlConnectionFactory.create(url2, driverName, username, password);
                        String autocommit = System.getProperty("sql." + name + ".autocommit");
                        String isolation = System.getProperty("sql." + name + ".isolation");
                        String implicit = System.getProperty("sql." + name + ".implicit");
                        if (this.currentSqlConnection != null) {
                            this.currentSqlConnection.setAutoCommit("true".equalsIgnoreCase(autocommit) || "on".equalsIgnoreCase(autocommit) || "yes".equalsIgnoreCase(autocommit) || "1".equals(autocommit));
                            this.sqlImplicitTransaction = implicit == null || "true".equalsIgnoreCase(implicit) || "on".equalsIgnoreCase(implicit) || "yes".equalsIgnoreCase(implicit) || "1".equals(implicit);
                            int level = 4;
                            if (isolation != null && isolation.length() > 0) {
                                if (isolation.toLowerCase().contains("uncommitted")) {
                                    level = 1;
                                } else if (isolation.toLowerCase().contains("committed")) {
                                    level = 2;
                                } else if (isolation.toLowerCase().contains("repeat")) {
                                    level = 4;
                                } else if (isolation.toLowerCase().contains("serial")) {
                                    level = 8;
                                }
                            }
                            this.currentSqlConnection.setTransactionIsolation(level);
                        }
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            this.sqlConnections.put(name, this.currentSqlConnection);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("getConnection(boolean): Add an SQL connection.");
            }
        }
        if (this.currentSqlConnection == null) {
            throw new SQLException("Elastic COBOL SQL: 08003.R9: Connection does not exist", "08003");
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("getConnection(boolean): Number of open connections = " + this.sqlConnections.size() + ".");
        }
        return this.currentSqlConnection;
    }

    public final Connection getConnection(Object connectionName) throws SQLException {
        if (connectionName == null) {
            return this.getConnection(CURRENT_SQL_CONNECTION_NAME, true);
        }
        if (connectionName instanceof Connection) {
            return (Connection)connectionName;
        }
        Connection connection = this.sqlConnections.get(this.connectionName(String.valueOf(connectionName)));
        if (connection == null && (connection = this.getConnection(String.valueOf(connectionName), true)) == null) {
            throw new SQLException("Elastic COBOL SQL: 08003.R5: Connection does not exist.", "08003");
        }
        return connection;
    }

    public final Connection setConnection(Object connectionRef) throws SQLException {
        if (connectionRef == null) {
            return this.setConnection(DEFAULT_SQL_CONNECTION_NAME, connectionRef);
        }
        if (connectionRef instanceof Connection) {
            return this.setConnection(DEFAULT_SQL_CONNECTION_NAME, connectionRef);
        }
        String holdName = this.connectionName(connectionRef.toString());
        return this.setConnection(holdName, this.getConnection(holdName));
    }

    public final Connection setConnection(String connectionName, Object connectionRef) throws SQLException {
        CURRENT_SQL_CONNECTION_NAME = connectionName;
        if (connectionRef == null) {
            this.currentSqlConnection = null;
        } else if (connectionRef instanceof Connection) {
            Connection con;
            this.currentSqlConnection = con = (Connection)connectionRef;
            this.sqlConnections.put(connectionName == null ? DEFAULT_SQL_CONNECTION_NAME : connectionName, con);
        }
        return this.currentSqlConnection;
    }

    public final boolean setConnections(Map<String, Object> connectionMap) throws SQLException {
        boolean loaded = false;
        for (Map.Entry<String, Object> entry : connectionMap.entrySet()) {
            this.setConnection(entry.getKey().toLowerCase(), entry.getValue());
        }
        loaded = true;
        CURRENT_SQL_CONNECTION_NAME = DEFAULT_SQL_CONNECTION_NAME;
        return loaded;
    }

    public Connection connect(String connectionName, Object connectionRef, String driverName, Object username, Object password, Object namingContext) throws SQLException {
        Connection connection = null;
        boolean connectionAllowed = false;
        connectionName = this.connectionName(connectionName);
        if (connectionRef instanceof Connection) {
            connectionAllowed = true;
            connection = (Connection)connectionRef;
        } else {
            String url2 = String.valueOf(connectionRef);
            if (namingContext != null) {
                try {
                    connection = SqlConnectionFactory.create(url2, driverName, username, password, (Context)namingContext);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
            try {
                if (connection == null) {
                    connection = SqlConnectionFactory.create(url2, driverName, username, password);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        Connection currentConnection = this.sqlConnections.get(connectionName);
        if (currentConnection != null && connection != null && currentConnection == connection) {
            this.currentSqlConnection = connection;
            return this.currentSqlConnection;
        }
        if (!connectionAllowed && currentConnection != null && !currentConnection.isClosed()) {
            this.currentSqlConnection = currentConnection;
            throw new SQLException("Elastic COBOL SQL: 08002.R4: Connection name in use", "08002");
        }
        if (connection != null) {
            this.setConnection(connectionName, connection);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("getConnection(boolean): Add an SQL connection.");
            }
            if (!implicitTransactions) {
                SqlContext.beginTransaction(currentConnection);
            }
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(" Number of open connections = " + this.sqlConnections.size() + ".");
        }
        return connection;
    }

    public static final void setExplicitTransactions() {
        implicitTransactions = false;
    }

    public static final void setImplicitTransactions() {
        implicitTransactions = true;
    }

    public static final boolean isImplicitTransactions() {
        return implicitTransactions;
    }

    public final void commit() throws SQLException {
        this.commit(true);
    }

    public final void commit(boolean closeCursors) throws SQLException {
        if (closeCursors) {
            this.getCursors().closeAllNotHeld();
        }
        if (this.isTransactionManaged()) {
            try {
                if (xaEnvKlazz == null) {
                    xaEnvKlazz = Class.forName("com.heirloomcomputing.ecs.exec.XAEnvironment");
                }
                if (xaCommitMethod == null) {
                    xaCommitMethod = xaEnvKlazz.getDeclaredMethod("commit", null);
                }
                xaCommitMethod.invoke(null, (Object[])null);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                System.err.println("SqlContext.commit() error loading " + e);
                throw new SQLException(e);
            }
        } else if (this.currentSqlConnection != null) {
            this.currentSqlConnection.commit();
        }
    }

    public final void rollback() throws SQLException {
        this.rollback(true);
    }

    public final void rollback(boolean closeCursors) throws SQLException {
        if (closeCursors) {
            this.getCursors().closeAllNotHeld();
        }
        if (this.isTransactionManaged()) {
            try {
                if (xaEnvKlazz == null) {
                    xaEnvKlazz = Class.forName("com.heirloomcomputing.ecs.exec.XAEnvironment");
                }
                if (xaRollbackMethod == null) {
                    xaRollbackMethod = xaEnvKlazz.getDeclaredMethod("rollback", null);
                }
                xaRollbackMethod.invoke(null, (Object[])null);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                System.err.println("SqlContext.rollback() error loading " + e);
                throw new SQLException(e);
            }
        } else if (this.currentSqlConnection != null) {
            this.currentSqlConnection.rollback();
        }
    }

    public static final void log(String msg) {
        logStream.println("[SQL] " + msg);
        logStream.flush();
    }

    public static final void log(Throwable t) {
        if (t instanceof SQLException) {
            SqlContext.log((SQLException)t);
        } else {
            SqlContext.log("EXCEPTION: '" + t + "'");
            SqlContext.log("CLASS    : " + t.getClass());
            SqlContext.log("MESSAGE  : '" + t.getMessage() + "'");
            t.printStackTrace(logStream);
        }
    }

    public static final void log(SQLException e) {
        SqlContext.log("EXCEPTION : '" + e + "'");
        SqlContext.log("CLASS     : " + e.getClass());
        SqlContext.log("MESSAGE   : '" + e.getMessage() + "'");
        SqlContext.log("ERROR CODE: " + e.getErrorCode());
        SqlContext.log("SQLSTATE  : " + SqlContext.obtainSqlState(e));
    }

    public static final String obtainSqlState(SQLException e) {
        if (e != null) {
            SQLException originalException = e;
            for (int recursionChecker = 0; recursionChecker < 10; ++recursionChecker) {
                String result = e.getSQLState();
                if (result != null && result.length() >= 2) {
                    return result;
                }
                SQLException nextException = null;
                nextException = e.getNextException();
                if (nextException == null) break;
                e = nextException;
            }
            int errorCode = originalException.getErrorCode();
            switch (errorCode) {
                case 0: {
                    return "00000";
                }
                case 1095: 
                case 1403: {
                    return "02000";
                }
                case 2126: {
                    return "07008";
                }
                case 2121: {
                    return "08003";
                }
                case 1427: 
                case 2112: {
                    return "21000";
                }
                case 1401: 
                case 1406: {
                    return "22001";
                }
                case 1405: 
                case 2124: {
                    return "22002";
                }
                case 1426: 
                case 1438: 
                case 1455: 
                case 1457: {
                    return "22003";
                }
                case 1476: {
                    return "22012";
                }
                case 911: 
                case 1425: {
                    return "22019";
                }
                case 1411: {
                    return "22022";
                }
                case 1024: 
                case 1488: {
                    return "22023";
                }
                case 1479: 
                case 1480: {
                    return "22024";
                }
                case 1424: {
                    return "22025";
                }
                case 1: {
                    return "23000";
                }
                case 1001: 
                case 1002: 
                case 1003: 
                case 1410: 
                case 2114: 
                case 2117: 
                case 2118: 
                case 2122: {
                    return "24000";
                }
                case 2091: 
                case 2092: {
                    return "40000";
                }
                case 22: 
                case 251: 
                case 1031: 
                case 1490: 
                case 1491: 
                case 1492: 
                case 1493: {
                    return "42000";
                }
                case 1402: {
                    return "44000";
                }
                case 2100: {
                    return "82100";
                }
                case 2101: {
                    return "82101";
                }
                case 2102: {
                    return "82102";
                }
                case 2103: {
                    return "82103";
                }
                case 2104: {
                    return "82104";
                }
                case 2105: {
                    return "82105";
                }
                case 2106: {
                    return "82106";
                }
                case 2107: {
                    return "82107";
                }
                case 2108: {
                    return "82108";
                }
                case 2109: {
                    return "82109";
                }
                case 2110: {
                    return "82110";
                }
                case 2111: {
                    return "82111";
                }
                case 2113: {
                    return "82112";
                }
                case 2115: {
                    return "82113";
                }
                case 2116: {
                    return "82114";
                }
                case 2119: {
                    return "82115";
                }
                case 2120: {
                    return "82116";
                }
                case 2123: {
                    return "82118";
                }
                case 2125: {
                    return "82119";
                }
                case 2127: {
                    return "81120";
                }
                case 2129: {
                    return "82121";
                }
                case 2130: {
                    return "82122";
                }
            }
            if (errorCode >= 3000 && errorCode <= 3099) {
                return "0A000";
            }
            if (errorCode >= 1800 && errorCode <= 1899) {
                return "22008";
            }
            if (errorCode >= 4000 && errorCode <= 4019) {
                return "22023";
            }
            if (errorCode >= 2290 && errorCode <= 2299) {
                return "23000";
            }
            if (errorCode >= 900 && errorCode <= 999) {
                return "42000";
            }
            if (errorCode >= 1700 && errorCode <= 1799) {
                return "42000";
            }
            if (errorCode >= 1900 && errorCode <= 2099) {
                return "42000";
            }
            if (errorCode >= 2140 && errorCode <= 2289) {
                return "42000";
            }
            if (errorCode >= 2420 && errorCode <= 2424) {
                return "42000";
            }
            if (errorCode >= 2450 && errorCode <= 2499) {
                return "42000";
            }
            if (errorCode >= 3276 && errorCode <= 3299) {
                return "42000";
            }
            if (errorCode >= 4040 && errorCode <= 4059) {
                return "42000";
            }
            if (errorCode >= 4070 && errorCode <= 4099) {
                return "42000";
            }
            if (errorCode >= 370 && errorCode <= 429) {
                return "60000";
            }
            if (errorCode >= 600 && errorCode <= 899) {
                return "60000";
            }
            if (errorCode >= 6430 && errorCode <= 6449) {
                return "60000";
            }
            if (errorCode >= 7200 && errorCode <= 7999) {
                return "60000";
            }
            if (errorCode >= 9700 && errorCode <= 9999) {
                return "60000";
            }
            if (errorCode >= 18 && errorCode <= 35) {
                return "61000";
            }
            if (errorCode >= 50 && errorCode <= 68) {
                return "61000";
            }
            if (errorCode >= 2376 && errorCode <= 2399) {
                return "61000";
            }
            if (errorCode >= 4020 && errorCode <= 4039) {
                return "61000";
            }
            if (errorCode >= 100 && errorCode <= 120) {
                return "62000";
            }
            if (errorCode >= 440 && errorCode <= 569) {
                return "62000";
            }
            if (errorCode >= 150 && errorCode <= 159) {
                return "63000";
            }
            if (errorCode == 2128) {
                return "63000";
            }
            if (errorCode >= 2700 && errorCode <= 2899) {
                return "63000";
            }
            if (errorCode >= 3100 && errorCode <= 3199) {
                return "63000";
            }
            if (errorCode >= 6200 && errorCode <= 6249) {
                return "63000";
            }
            if (errorCode >= 200 && errorCode <= 369) {
                return "64000";
            }
            if (errorCode >= 1100 && errorCode <= 1250) {
                return "64000";
            }
            if (errorCode >= 6500 && errorCode <= 6599) {
                return "65000";
            }
            if (errorCode >= 6000 && errorCode <= 6149) {
                return "66000";
            }
            if (errorCode >= 6250 && errorCode <= 6429) {
                return "66000";
            }
            if (errorCode >= 6600 && errorCode <= 6999) {
                return "66000";
            }
            if (errorCode >= 12100 && errorCode <= 12299) {
                return "66000";
            }
            if (errorCode >= 12500 && errorCode <= 12599) {
                return "66000";
            }
            if (errorCode >= 430 && errorCode <= 439) {
                return "67000";
            }
            if (errorCode >= 570 && errorCode <= 599) {
                return "69000";
            }
            if (errorCode >= 7000 && errorCode <= 7199) {
                return "69000";
            }
            if (errorCode >= 1000 && errorCode <= 1099) {
                return "72000";
            }
            if (errorCode >= 1400 && errorCode <= 1489) {
                return "72000";
            }
            if (errorCode >= 1495 && errorCode <= 1499) {
                return "72000";
            }
            if (errorCode >= 1500 && errorCode <= 1699) {
                return "72000";
            }
            if (errorCode >= 2400 && errorCode <= 2419) {
                return "72000";
            }
            if (errorCode >= 2425 && errorCode <= 2449) {
                return "72000";
            }
            if (errorCode >= 4060 && errorCode <= 4069) {
                return "72000";
            }
            if (errorCode >= 8000 && errorCode <= 8190) {
                return "72000";
            }
            if (errorCode >= 12000 && errorCode <= 12019) {
                return "72000";
            }
            if (errorCode >= 12300 && errorCode <= 12499) {
                return "72000";
            }
            if (errorCode >= 12700 && errorCode <= 21999) {
                return "72000";
            }
            if (errorCode >= 10000 && errorCode <= 10999) {
                return "90000";
            }
            if (originalException instanceof SQLWarning) {
                return "00000";
            }
            return "99999";
        }
        if (e instanceof SQLWarning) {
            return "00000";
        }
        return "99999";
    }

    public static final int mapSqlCode(SQLException e) {
        String sqlState = null;
        if (e != null) {
            sqlState = e.getSQLState();
        }
        if (sqlState == null) {
            return e.getErrorCode();
        }
        for (int i = 0; i < SQLCODESTATE.length; ++i) {
            if (!sqlState.equalsIgnoreCase((String)SQLCODESTATE[i][1])) continue;
            return (Integer)SQLCODESTATE[i][0];
        }
        return e.getErrorCode();
    }

    public SQLWarning executeImmediate(Connection connection, String command, Object[] params) throws SQLException {
        if (command == null) {
            return null;
        }
        if (connection == null && (connection = this.getConnection(null)) == null) {
            throw new SQLException("Elastic COBOL SQL: 08003.R9: Connection does not exist", "08003");
        }
        command = command.trim();
        String uppercase = command.toUpperCase();
        PreparedStatement preparedStatement = connection.prepareStatement(command);
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                if (param == null) {
                    preparedStatement.setString(i + 1, null);
                    continue;
                }
                if (param instanceof Variable) {
                    preparedStatement.setObject(i + 1, ((Variable)param).getSqlObject());
                    continue;
                }
                if (!(param instanceof IDatatype)) continue;
                preparedStatement.setString(i + 1, ((IDatatype)param).toText());
            }
        }
        if (uppercase.startsWith("UPDATE") || uppercase.startsWith("INSERT") || uppercase.startsWith("DELETE")) {
            int count = preparedStatement.executeUpdate();
            if (count == 0) {
                throw new SQLException("Elastic COBOL SQL: 02000.C8: No rows affected", "02000");
            }
        } else {
            preparedStatement.execute();
        }
        SQLWarning warning = preparedStatement.getWarnings();
        preparedStatement.close();
        return warning;
    }

    public SQLWarning executeImmediate(Connection connection, IDatatype command, Object[] params) throws SQLException {
        return this.executeImmediate(connection, command.toText(), null);
    }

    public SQLWarning executeImmediate(Connection connection, Object command, Object[] params) throws SQLException {
        if (command == null) {
            return null;
        }
        if (command instanceof IDatatype) {
            return this.executeImmediate(connection, (IDatatype)command, null);
        }
        return this.executeImmediate(connection, String.valueOf(command), null);
    }

    public SQLWarning executeImmediate(Connection connection, String command, Object[] params, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (command == null) {
            return null;
        }
        if (connection == null && (connection = this.getConnection(null)) == null) {
            throw new SQLException("Elastic COBOL SQL: 08003.R9: Connection does not exist", "08003");
        }
        command = command.trim();
        String uppercase = command.toUpperCase();
        PreparedStatement preparedStatement = connection.prepareStatement(command, resultSetType, resultSetConcurrency);
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                if (param == null) {
                    preparedStatement.setString(i + 1, null);
                    continue;
                }
                if (param instanceof Variable) {
                    preparedStatement.setObject(i + 1, ((Variable)param).getSqlObject());
                    continue;
                }
                if (!(param instanceof IDatatype)) continue;
                preparedStatement.setString(i + 1, ((IDatatype)param).toText());
            }
        }
        if (uppercase.startsWith("UPDATE") || uppercase.startsWith("INSERT") || uppercase.startsWith("DELETE")) {
            int count = preparedStatement.executeUpdate();
            if (count == 0) {
                throw new SQLException("Elastic COBOL SQL: 02000.C8: No rows affected", "02000");
            }
        } else {
            preparedStatement.execute();
        }
        SQLWarning warning = preparedStatement.getWarnings();
        preparedStatement.close();
        return warning;
    }

    public SQLWarning executeImmediate(Connection connection, IDatatype command, Object[] params, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.executeImmediate(connection, command.toText(), null, resultSetType, resultSetConcurrency);
    }

    public SQLWarning executeImmediate(Connection connection, Object command, Object[] params, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (command == null) {
            return null;
        }
        if (command instanceof IDatatype) {
            return this.executeImmediate(connection, (IDatatype)command, null);
        }
        return this.executeImmediate(connection, String.valueOf(command), null, resultSetType, resultSetConcurrency);
    }

    public static void setReconnectConnections(boolean disconnectReconnectConnections) {
        DisconnectConnectionsUponExit = disconnectReconnectConnections;
    }

    public boolean isTransactionManaged() {
        return this.isTransactionManaged;
    }

    public void setTransactionManaged(boolean isTransactionManaged) {
        this.isTransactionManaged = isTransactionManaged;
    }
}

