/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.DataPointer;
import com.heirloomcomputing.ecs.exec.Variable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SqlDataArea {
    public static Short SQLVAR_MAX_SIZE = 750;
    public static Integer SQLVAR_DATA_MAX_LENGTH = 30;
    private String sqldaid = "SQLDA   ";
    private Long sqldabc;
    private Short sqln;
    private Short sqld;
    List<SqlDataAreaSqlVar> sqlvar = new ArrayList<SqlDataAreaSqlVar>();

    public SqlDataArea() {
    }

    public SqlDataArea(IDatatype sqlda) throws Exception {
        this.populateFromSqlda(sqlda);
    }

    public void populateIntoSqlda(IDatatype sqlda) throws SQLException {
        IDatatype sqldField = (IDatatype)sqlda.getElements()[3];
        sqldField.fromShort(this.sqld);
        IDatatype[] sqlvarTable = (IDatatype[])((IDatatype)sqlda.getElements()[4]).getElements();
        IDatatype[] sqltypeTable = (IDatatype[])((Variable)sqlvarTable[1]).getChild(1).getElements();
        IDatatype[] sqllenTable = (IDatatype[])((Variable)sqlvarTable[1]).getChild(2).getElements();
        DataPointer[] sqldataTable = (DataPointer[])((Variable)sqlvarTable[1]).getChild(3).getElements();
        DataPointer[] sqlindTable = (DataPointer[])((Variable)sqlvarTable[1]).getChild(4).getElements();
        IDatatype[] sqlnameTable = (IDatatype[])((Variable)sqlvarTable[1]).getChild(5).getElements();
        IDatatype[] sqlname_lenTable = (IDatatype[])((Variable)sqlnameTable[1]).getChild(1).getElements();
        IDatatype[] sqlname_dataTable = (IDatatype[])((Variable)sqlnameTable[1]).getChild(2).getElements();
        int i = 0;
        for (SqlDataAreaSqlVar elmnt : this.sqlvar) {
            sqltypeTable[++i].fromInt(elmnt.getSqltype());
            sqllenTable[i].fromInt(elmnt.getSqllen());
            if (elmnt.getSqldata() != null) {
                sqldataTable[i].setPointerToBytes(elmnt.getSqldata());
            }
            if (elmnt.getSqlind() != null) {
                sqlindTable[i].setPointerToBytes(elmnt.getSqlind());
            }
            sqlname_lenTable[i].fromInt(elmnt.getSqlname().getLength());
            sqlname_dataTable[i].fromText(elmnt.getSqlname().getData());
        }
    }

    public void populateFromSqlda(IDatatype sqlda) throws Exception {
        block7: for (int i = 0; i < sqlda.getElements().length; ++i) {
            switch (i) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    this.setSqldabc(0L);
                    continue block7;
                }
                case 2: {
                    short sqln = ((IDatatype)sqlda.getElements()[i]).toShort();
                    this.setSqln(sqln);
                    continue block7;
                }
                case 3: {
                    this.setSqld((short)0);
                    continue block7;
                }
                case 4: {
                    continue block7;
                }
                default: {
                    throw new SQLException("Elastic COBOL SQL: 07000.R1:SQLDA group item layout is invalid.  Too many child items for SQLDA.", "07000");
                }
            }
        }
    }

    public void populateFromRsmd(ResultSetMetaData rsmd) throws SQLException {
        this.populate(rsmd, null);
    }

    public void populateFromRs(ResultSet rs) throws SQLException {
        this.populate(rs.getMetaData(), rs);
    }

    private void populate(ResultSetMetaData rsmd, ResultSet rs) throws SQLException {
        this.sqld = (short)rsmd.getColumnCount();
        for (int i = 1; i <= rsmd.getColumnCount() && i <= SQLVAR_MAX_SIZE; ++i) {
            String sqlnameHold;
            SqlDataAreaSqlVar sqlvarNew = new SqlDataAreaSqlVar();
            SqlDataAreaSqlType sqltypeResolver = SqlDataAreaSqlType.valueFromJdbctype(rsmd.getColumnType(i), rsmd.getColumnTypeName(i));
            sqlvarNew.setSqltype(sqltypeResolver.specificSqltype(rsmd.isNullable(i)));
            sqlvarNew.setSqllen(sqltypeResolver.computeSqllen(rsmd.getPrecision(i), rsmd.getScale(i)));
            if (rs != null) {
                sqlvarNew.setSqldata(rs.getObject(i).toString().getBytes());
                sqlvarNew.setSqlind(rs.getObject(i).toString().getBytes());
            }
            int lengthOfsqlname = (sqlnameHold = rsmd.getColumnName(i)).length() <= SQLVAR_DATA_MAX_LENGTH ? sqlnameHold.length() : SQLVAR_DATA_MAX_LENGTH.intValue();
            sqlvarNew.getSqlname().setLength(lengthOfsqlname);
            sqlvarNew.getSqlname().setData(sqlnameHold.substring(0, lengthOfsqlname));
            this.getSqlvar().add(sqlvarNew);
        }
    }

    public String getSqldaid() {
        return this.sqldaid;
    }

    public void setSqldaid(String sqldaid) {
        this.sqldaid = sqldaid;
    }

    public Long getSqldabc() {
        return this.sqldabc;
    }

    public void setSqldabc(Long sqldabc) {
        this.sqldabc = sqldabc;
    }

    public Short getSqln() {
        return this.sqln;
    }

    public void setSqln(Short sqln) {
        this.sqln = sqln;
    }

    public Short getSqld() {
        return this.sqld;
    }

    public void setSqld(Short sqld) {
        this.sqld = sqld;
    }

    public List<SqlDataAreaSqlVar> getSqlvar() {
        return this.sqlvar;
    }

    public void setSqlvar(List<SqlDataAreaSqlVar> sqlvar) {
        this.sqlvar = sqlvar;
    }

    private static enum SqlDataAreaSqlType {
        SQLTYPE_ARRAY(2003, -1, 998, 999),
        SQLTYPE_DATALINK(70, -1, 998, 999),
        SQLTYPE_JAVA_OBJECT(2000, -1, 998, 999),
        SQLTYPE_NULL(0, -1, 998, 999),
        SQLTYPE_OTHER(1111, -1, 998, 999),
        SQLTYPE_REF(2006, -1, 998, 999),
        SQLTYPE_DISTINCT(2001, -1, 998, 999),
        SQLTYPE_STRUCT(2002, -1, 998, 999),
        SQLTYPE_BIGINT(-5, 8, 492, 493),
        SQLTYPE_BLOB(2004, 0, 404, 405),
        SQLTYPE_DATE(91, 10, 384, 385),
        SQLTYPE_DOUBLE(8, 8, 480, 481),
        SQLTYPE_INTEGER(4, 4, 496, 497),
        SQLTYPE_ROWID(-8, 40, 904, 905),
        SQLTYPE_XML(2009, 0, 988, 989),
        SQLTYPE_TIME(92, 8, 388, 389),
        SQLTYPE_TIMESTAMP(93, -1, 392, 393),
        SQLTYPE_LONGVARGRAPHIC(1111, -1, 472, 473),
        SQLTYPE_LONGNVARCHAR(-16, -1, 456, 457),
        SQLTYPE_LONGVARCHAR(-1, -1, 456, 457),
        SQLTYPE_CHAR(1, -1, 452, 453),
        SQLTYPE_NCHAR(-15, -1, 452, 453),
        SQLTYPE_BINARY(-2, -1, 452, 453),
        SQLTYPE_CLOB(2005, 0, 408, 409),
        SQLTYPE_NCLOB(2011, 0, 408, 409),
        SQLTYPE_NUMERIC(2, -1, 484, 485),
        SQLTYPE_DECIMAL(3, -1, 484, 485),
        SQLTYPE_REAL(7, 4, 480, 481),
        SQLTYPE_FLOATT(6, 4, 480, 481),
        SQLTYPE_TINYINT(-6, 2, 500, 501),
        SQLTYPE_BIT(-7, 2, 500, 501),
        SQLTYPE_SMALLINT(5, 2, 500, 501),
        SQLTYPE_BOOLEAN(16, 2, 500, 501),
        SQLTYPE_LONGVARBINARY(-4, -1, 448, 449),
        SQLTYPE_VARBINARY(-3, -1, 448, 449),
        SQLTYPE_NVARCHAR(-9, -1, 448, 449),
        SQLTYPE_VARCHAR(12, -1, 448, 449);

        private final Integer jdbcType;
        private final Integer sqllen;
        private final List<Integer> sqltype;

        private SqlDataAreaSqlType(int t, int sqllen, Integer ... sqltypeA) {
            this.jdbcType = t;
            this.sqllen = sqllen;
            this.sqltype = Arrays.asList(sqltypeA);
        }

        public static SqlDataAreaSqlType valueFromJdbctype(int columnType, String columnTypeName) {
            if (columnType == 12 && columnTypeName.equalsIgnoreCase("VARCHARGRAPHIC")) {
                return SQLTYPE_LONGVARGRAPHIC;
            }
            for (SqlDataAreaSqlType v : SqlDataAreaSqlType.values()) {
                if (!v.getJdbcType().equals(columnType)) continue;
                return v;
            }
            return SQLTYPE_OTHER;
        }

        public Integer getJdbcType() {
            return this.jdbcType;
        }

        public Integer computeSqllen(int colPrecision, int colScale) {
            Integer retVal;
            if (this.sqllen < 0) {
                switch (this.jdbcType) {
                    case 2: 
                    case 3: {
                        byte precision = (byte)colPrecision;
                        byte scale = (byte)colScale;
                        retVal = precision << 8 | scale;
                        break;
                    }
                    case -16: 
                    case -15: 
                    case -9: {
                        retVal = colPrecision * 2;
                        break;
                    }
                    default: {
                        retVal = colPrecision;
                        break;
                    }
                }
            } else {
                retVal = this.sqllen;
            }
            return retVal;
        }

        public List<Integer> getSqltype() {
            return this.sqltype;
        }

        public Integer specificSqltype(int nullability) {
            Integer result;
            switch (nullability) {
                case 0: {
                    result = this.getSqltype().get(0);
                    break;
                }
                case 2: {
                    result = this.getSqltype().get(0);
                    break;
                }
                case 1: {
                    result = this.getSqltype().get(1);
                }
                default: {
                    result = this.getSqltype().get(0);
                }
            }
            return result;
        }
    }

    private class SqlDataAreaSqlName {
        private Integer length;
        private String data;

        private SqlDataAreaSqlName() {
        }

        public Integer getLength() {
            return this.length;
        }

        public void setLength(Integer length) {
            this.length = length;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }

    private class SqlDataAreaSqlVar {
        private Integer sqltype;
        private Integer sqllen;
        private byte[] sqldata;
        private byte[] sqlind;
        SqlDataAreaSqlName sqlname;

        private SqlDataAreaSqlVar() {
            this.sqlname = new SqlDataAreaSqlName();
        }

        public Integer getSqltype() {
            return this.sqltype;
        }

        public void setSqltype(Integer sqltype) {
            this.sqltype = sqltype;
        }

        public Integer getSqllen() {
            return this.sqllen;
        }

        public void setSqllen(Integer sqllen) {
            this.sqllen = sqllen;
        }

        public byte[] getSqldata() {
            return this.sqldata;
        }

        public void setSqldata(byte[] sqldata) {
            this.sqldata = sqldata;
        }

        public byte[] getSqlind() {
            return this.sqlind;
        }

        public void setSqlind(byte[] sqlind) {
            this.sqlind = sqlind;
        }

        public SqlDataAreaSqlName getSqlname() {
            return this.sqlname;
        }

        public void setSqlname(SqlDataAreaSqlName sqlname) {
            this.sqlname = sqlname;
        }
    }
}

