/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ColorProvider;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.ICobolInterface;
import com.heirloomcomputing.ecs.exec.MediaImage;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.Shutdown;
import com.heirloomcomputing.ecs.exec.SynkronixGuiGrid;
import com.heirloomcomputing.ecs.exec.Tiler;
import com.heirloomcomputing.ecs.exec.UnwindException;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.util.Utils;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageObserver;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

class SynkronixGuiImpl
implements Cloneable {
    private static final int EVENTME = 1;
    private static final int EVENTMX = 2;
    private static final int EVENTMM = 4;
    private static final int EVENTMG = 8;
    private static final int EVENTMD = 16;
    private static final int EVENTMU = 32;
    private static final int EVENTKP = 64;
    private static final int EVENTKR = 128;
    private static final int EVENTFG = 256;
    private static final int EVENTFL = 512;
    private static final int EVENTWX = 1024;
    private static final int EVENTWE = 2048;
    private static final int EVENTWI = 4096;
    private static final int EVENTWD = 8192;
    private static final int EVENTSU = 16384;
    private static final int EVENTSD = 32768;
    private static final int EVENTSP = 65536;
    private static final int EVENTSN = 131072;
    private static final int EVENTSA = 262144;
    private static final int EVENTLS = 524288;
    private static final int EVENTLD = 0x100000;
    private static final int EVENTAE = 0x200000;
    public static final String EVENTTYPE = "EVENTTYPE";
    public static final String EVENTARG = "EVENTARG";
    private static Hashtable<Object, Variable> eventMapper = new Hashtable();
    private static Hashtable<Variable, ICobolInterface> programMapper = new Hashtable();
    private static Hashtable<Object, Integer> eventTypeMapper = new Hashtable();
    private static Hashtable<Object, Variable> eventTypeVarMapper = new Hashtable();
    private static Hashtable<Object, Variable> eventArgVarMapper = new Hashtable();
    private static Hashtable<String, Integer> eventByName = new Hashtable();
    private CheckboxGroup cgContext = null;
    private FrameComponent frameContext = null;
    private Panel panelContext = null;
    private Container beanContext = null;
    private Window windowContext = null;
    private LayoutManager layoutContext = null;
    private String constraint = null;
    public boolean rebuild = true;
    private static Properties printProps;
    static Object syncObject;

    private static final void removeEventTarget(Object o) {
        if (o != null) {
            eventMapper.remove(o);
            eventTypeMapper.remove(o);
            eventTypeVarMapper.remove(o);
            eventArgVarMapper.remove(o);
        }
    }

    public static final Variable findEventVariable(Object target) {
        if (target == null) {
            return null;
        }
        Variable result = eventMapper.get(target);
        return result != null ? result : null;
    }

    public static final int findEventType(Object target) {
        if (target == null) {
            return 0;
        }
        Integer result = eventTypeMapper.get(target);
        return result != null ? result : 0;
    }

    public static final Variable findEventTypeVar(Object target) {
        if (target == null) {
            return null;
        }
        Variable result = eventTypeVarMapper.get(target);
        return result != null ? result : null;
    }

    public static final Variable findEventArgVar(Object target) {
        if (target == null) {
            return null;
        }
        Variable result = eventArgVarMapper.get(target);
        return result != null ? result : null;
    }

    private static void initializeEventByName() {
        eventByName.put("EVENTME", new Integer(1));
        eventByName.put("EVENTMX", new Integer(2));
        eventByName.put("EVENTMM", new Integer(4));
        eventByName.put("EVENTMG", new Integer(8));
        eventByName.put("EVENTMD", new Integer(16));
        eventByName.put("EVENTMU", new Integer(32));
        eventByName.put("EVENTM", new Integer(63));
        eventByName.put("EVENTKP", new Integer(64));
        eventByName.put("EVENTKR", new Integer(128));
        eventByName.put("EVENTK", new Integer(192));
        eventByName.put("EVENTFG", new Integer(256));
        eventByName.put("EVENTFL", new Integer(512));
        eventByName.put("EVENTF", new Integer(768));
        eventByName.put("EVENTWX", new Integer(1024));
        eventByName.put("EVENTWE", new Integer(2048));
        eventByName.put("EVENTWI", new Integer(4096));
        eventByName.put("EVENTWD", new Integer(8192));
        eventByName.put("EVENTW", new Integer(15360));
        eventByName.put("EVENTSU", new Integer(16384));
        eventByName.put("EVENTSD", new Integer(32768));
        eventByName.put("EVENTSP", new Integer(65536));
        eventByName.put("EVENTSN", new Integer(131072));
        eventByName.put("EVENTSA", new Integer(262144));
        eventByName.put("EVENTS", new Integer(507904));
        eventByName.put("EVENTLS", new Integer(524288));
        eventByName.put("EVENTLD", new Integer(0x100000));
        eventByName.put("EVENTL", new Integer(0x180000));
        eventByName.put("EVENTAE", new Integer(0x200000));
        eventByName.put("EVENTA", new Integer(0x200000));
    }

    public static final Variable buildComponentProperties(Component target, Variable node) {
        int x = -1;
        int y = -1;
        int width = -1;
        int height = -1;
        while (node != null) {
            String stringParam2;
            Variable innerNode;
            String stringParam;
            String hyphen = node.getHyphenName();
            if (hyphen.equals("FOREGROUND") || hyphen.equals("BACKGROUND")) {
                Color setColor;
                stringParam = hyphen;
                x = -1;
                y = -1;
                width = -1;
                float h = -1.0f;
                float s = -1.0f;
                float b = -1.0f;
                for (innerNode = node.getChild(); innerNode != null; innerNode = innerNode.getSibling()) {
                    hyphen = innerNode.getName().toUpperCase();
                    if (hyphen.startsWith("AWT")) {
                        hyphen = hyphen.substring(3);
                    }
                    if (hyphen.equals("RED")) {
                        x = innerNode.toInt();
                        continue;
                    }
                    if (hyphen.equals("GREEN")) {
                        y = innerNode.toInt();
                        continue;
                    }
                    if (hyphen.equals("BLUE")) {
                        width = innerNode.toInt();
                        continue;
                    }
                    if (hyphen.equals("HUE")) {
                        h = innerNode.toFloat();
                        continue;
                    }
                    if (hyphen.equals("SATURATION")) {
                        s = innerNode.toFloat();
                        continue;
                    }
                    if (!hyphen.equals("BRIGHTNESS")) continue;
                    b = innerNode.toFloat();
                }
                if (x >= 0) {
                    setColor = new Color(x, y, width);
                } else if ((double)h >= 0.0) {
                    setColor = Color.getHSBColor(h, s, b);
                } else {
                    stringParam2 = node.toString().trim().toUpperCase();
                    setColor = ColorProvider.getColor(stringParam2);
                    if (setColor == null) {
                        setColor = Color.gray;
                    }
                }
                node.setGuiObject(setColor);
                if (stringParam.equals("FOREGROUND")) {
                    target.setForeground(setColor);
                } else {
                    target.setBackground(setColor);
                }
            } else if (hyphen.equals("FONT")) {
                stringParam = node.toString().trim();
                y = 12;
                x = 0;
                width = -1;
                Font setFont = null;
                FontMetrics fm = null;
                for (innerNode = node.getChild(); innerNode != null; innerNode = innerNode.getSibling()) {
                    hyphen = innerNode.getHyphenName();
                    if (hyphen.equals("ITALIC")) {
                        x |= 2;
                    } else if (hyphen.equals("BOLD")) {
                        x |= 1;
                    } else if (hyphen.equals("SIZE")) {
                        y = innerNode.toInt();
                    } else if (hyphen.equals("STYLE")) {
                        stringParam2 = node.toString().toUpperCase();
                        if (stringParam2.indexOf(73) >= 0) {
                            x |= 2;
                        }
                        if (stringParam2.indexOf(66) >= 0) {
                            x |= 1;
                        }
                        stringParam2 = null;
                    }
                    if (hyphen.equals("LEADING")) {
                        width = 1;
                    } else if (hyphen.equals("ASCENT")) {
                        width = 2;
                    } else if (hyphen.equals("MAXASCENT")) {
                        width = 3;
                    } else if (hyphen.equals("DESCENT")) {
                        width = 4;
                    } else if (hyphen.equals("MAXDESCENT")) {
                        width = 5;
                    } else if (hyphen.equals("HEIGHT")) {
                        width = 6;
                    } else if (hyphen.equals("MAXADVANCE")) {
                        width = 7;
                    }
                    if (width >= 0 && fm == null) {
                        setFont = new Font(stringParam, x, y);
                        fm = Utils.getFontMetrics(setFont);
                    }
                    switch (width) {
                        case 1: {
                            innerNode.move(fm.getLeading());
                            break;
                        }
                        case 2: {
                            innerNode.move(fm.getAscent());
                            break;
                        }
                        case 3: {
                            innerNode.move(fm.getMaxAscent());
                            break;
                        }
                        case 4: {
                            innerNode.move(fm.getDescent());
                            break;
                        }
                        case 5: {
                            innerNode.move(fm.getMaxDescent());
                            break;
                        }
                        case 6: {
                            innerNode.move(fm.getHeight());
                            break;
                        }
                        case 7: {
                            innerNode.move(fm.getMaxAdvance());
                        }
                    }
                    width = -1;
                }
                if (setFont == null) {
                    setFont = new Font(stringParam, x, y);
                }
                target.setFont(setFont);
                node.setGuiObject(setFont);
            } else if (hyphen.equals("CURSOR")) {
                try {
                    if (node.length() == 2 && !(node instanceof Numeric)) {
                        stringParam = node.toString().toUpperCase().substring(0, 2).trim();
                        Cursor setCursor = null;
                        if (stringParam.equals("DE")) {
                            setCursor = new Cursor(0);
                        } else if (stringParam.equals("CR")) {
                            setCursor = new Cursor(1);
                        } else if (stringParam.equals("TE")) {
                            setCursor = new Cursor(2);
                        } else if (stringParam.equals("WA")) {
                            setCursor = new Cursor(3);
                        } else if (stringParam.equals("HA")) {
                            setCursor = new Cursor(12);
                        } else if (stringParam.equals("MO")) {
                            setCursor = new Cursor(13);
                        } else if (stringParam.equals("N") || stringParam.equals("NO")) {
                            setCursor = new Cursor(8);
                        } else if (stringParam.equals("S") || stringParam.equals("SO")) {
                            setCursor = new Cursor(9);
                        } else if (stringParam.equals("E") || stringParam.equals("EA")) {
                            setCursor = new Cursor(11);
                        } else if (stringParam.equals("W") || stringParam.equals("WE")) {
                            setCursor = new Cursor(10);
                        } else if (stringParam.equals("NE")) {
                            setCursor = new Cursor(7);
                        } else if (stringParam.equals("NW")) {
                            setCursor = new Cursor(6);
                        } else if (stringParam.equals("SE")) {
                            setCursor = new Cursor(5);
                        } else if (stringParam.equals("SW")) {
                            setCursor = new Cursor(4);
                        }
                        target.setCursor(setCursor);
                        node.setGuiObject(setCursor);
                    }
                }
                catch (Throwable setCursor) {}
            } else if (hyphen.equals("X")) {
                if (node instanceof Numeric) {
                    x = node.toInt();
                    if (y >= 0 && x >= 0) {
                        try {
                            target.setLocation(x, y);
                        }
                        catch (Throwable t1) {
                            try {
                                target.setLocation(x, y);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            } else if (hyphen.equals("Y")) {
                if (node instanceof Numeric) {
                    y = node.toInt();
                    if (x >= 0 && y >= 0) {
                        try {
                            target.setLocation(x, y);
                        }
                        catch (Throwable t1) {
                            try {
                                target.setLocation(x, y);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            } else if (hyphen.equals("WIDTH")) {
                if (node instanceof Numeric) {
                    width = node.toInt();
                    if (height >= 0 && width >= 0) {
                        try {
                            target.setSize(width, height);
                        }
                        catch (Throwable t1) {
                            try {
                                target.setSize(width, height);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            } else if (hyphen.equals("HEIGHT")) {
                if (node instanceof Numeric && (height = node.toInt()) >= 0 && width >= 0) {
                    try {
                        target.setSize(width, height);
                    }
                    catch (Throwable t1) {
                        try {
                            target.setSize(width, height);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            } else if (hyphen.equals("VISIBLE")) {
                if (node.length() == 1) {
                    try {
                        target.setVisible(node.toBoolean());
                    }
                    catch (Throwable t1) {
                        try {
                            target.setVisible(node.toBoolean());
                        }
                        catch (Throwable throwable) {}
                    }
                }
            } else if (hyphen.equals("ENABLED")) {
                if (node.length() == 1) {
                    try {
                        target.setEnabled(node.toBoolean());
                    }
                    catch (Throwable t1) {
                        try {
                            target.setEnabled(node.toBoolean());
                        }
                        catch (Throwable throwable) {}
                    }
                }
            } else if (hyphen.equals("NAME")) {
                try {
                    target.setName(node.toString().trim());
                }
                catch (Throwable throwable) {}
            } else {
                return node;
            }
            node = node.getSibling();
        }
        return node;
    }

    public static final int buildEvent(Variable node) {
        if (node == null) {
            return -1;
        }
        String hyphen = node.getHyphenName();
        Integer result = eventByName.get(hyphen);
        return result != null ? result : -1;
    }

    public static final void mapEventVariable(Object target, Variable cobolVar, int events, Variable eventType, Variable eventArg) {
        if (target != null) {
            if (cobolVar != null) {
                eventMapper.put(target, cobolVar);
            }
            eventTypeMapper.put(target, new Integer(events));
            if (eventType != null) {
                eventTypeVarMapper.put(target, eventType);
            }
            if (eventArg != null) {
                eventArgVarMapper.put(target, eventArg);
            }
        }
    }

    public static final void mapEventVariable(Object target, Variable cobolVar) {
        SynkronixGuiImpl.mapEventVariable(target, cobolVar, 0, null, null);
    }

    public static final void mapVariableToProgram(Variable cobolVar, ICobolInterface program) {
        if (cobolVar != null && program != null) {
            programMapper.put(cobolVar, program);
        }
    }

    public static final ICobolInterface findVariableProgram(Variable cobolVar) {
        ICobolInterface result;
        ICobolInterface program = result = programMapper.get(cobolVar);
        if (result != null) {
            return program;
        }
        return null;
    }

    public static final String format(int value, int digits) {
        String result = value < 0 ? "-0000" + -value : "0000" + value;
        return result.substring(result.length() - 4);
    }

    private static void startThread(ICobolInterface program, int handler) {
        if (program == null) {
            return;
        }
        try {
            Class<?> c = program.getClass();
            Object newInstance = c.newInstance();
            try {
                Field _contextField = c.getField("_context");
                Context _context = (Context)_contextField.get(program);
                Context _threadContext = _context == null ? new Context(_context) : _context.create(_context);
                _threadContext.defaultThread();
                Method setupMethod = c.getMethod("setup", Context.class);
                setupMethod.invoke(newInstance, _threadContext);
                _threadContext.moveEvent(_context);
                _threadContext.setEntryParagraph(handler);
                _threadContext.getAssociatedThreadQueue().start();
            }
            catch (UnwindException _unwindException) {
                return;
            }
            catch (Exception exception) {
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static final boolean handleEvent(Event evt) {
        Variable cobolVar = SynkronixGuiImpl.findEventVariable(evt.target);
        boolean handled = false;
        if (cobolVar != null) {
            String type = null;
            String param = null;
            int types = SynkronixGuiImpl.findEventType(evt.target);
            Variable eventType = SynkronixGuiImpl.findEventTypeVar(evt.target);
            Variable eventArg = SynkronixGuiImpl.findEventArgVar(evt.target);
            int eventTypeInt = SynkronixGuiImpl.findEventType(evt.target);
            ICobolInterface program = SynkronixGuiImpl.findVariableProgram(cobolVar);
            int handler = cobolVar.getEventHandler();
            switch (evt.id) {
                case 504: {
                    type = "ME";
                }
                case 505: {
                    if (type == null) {
                        type = "MX";
                    }
                }
                case 503: {
                    if (type == null) {
                        type = "MM";
                    }
                }
                case 506: {
                    if (type == null) {
                        type = "MG";
                    }
                }
                case 501: {
                    if (type == null) {
                        type = "MD";
                    }
                }
                case 502: {
                    if (type == null) {
                        type = "MU";
                    }
                    if (handler == 0) break;
                    if (eventArg != null) {
                        param = "" + evt.clickCount;
                        param = (evt.modifiers & 8) != 0 ? param + "M" : param + " ";
                        param = (evt.modifiers & 4) != 0 ? param + "R" : param + " ";
                        param = param + SynkronixGuiImpl.format(evt.x, 4);
                        param = param + SynkronixGuiImpl.format(evt.y, 4);
                        eventArg.move(param);
                    }
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    if ((eventTypeInt & 1) != 0 && evt.id == 504) {
                        SynkronixGuiImpl.startThread(program, handler);
                        handled = true;
                        break;
                    }
                    if ((eventTypeInt & 2) != 0 && evt.id == 505) {
                        SynkronixGuiImpl.startThread(program, handler);
                        handled = true;
                        break;
                    }
                    if ((eventTypeInt & 4) != 0 && evt.id == 503) {
                        SynkronixGuiImpl.startThread(program, handler);
                        handled = true;
                        break;
                    }
                    if ((eventTypeInt & 8) != 0 && evt.id == 506) {
                        SynkronixGuiImpl.startThread(program, handler);
                        handled = true;
                        break;
                    }
                    if ((eventTypeInt & 0x10) != 0 && evt.id == 501) {
                        SynkronixGuiImpl.startThread(program, handler);
                        handled = true;
                        break;
                    }
                    if ((eventTypeInt & 0x20) == 0 || evt.id != 502) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 401: 
                case 403: {
                    type = "KP";
                }
                case 402: 
                case 404: {
                    if (type == null) {
                        type = "KR";
                    }
                    if (handler == 0) break;
                    if (eventArg != null) {
                        boolean kshift = (evt.modifiers & 1) != 0;
                        boolean kalt = (evt.modifiers & 8) != 0;
                        boolean kctrl = (evt.modifiers & 2) != 0;
                        boolean kmeta = (evt.modifiers & 4) != 0;
                        switch (evt.key) {
                            case 1000: {
                                param = "HM";
                                break;
                            }
                            case 1001: {
                                param = "EN";
                                break;
                            }
                            case 1002: {
                                param = "PU";
                                break;
                            }
                            case 1003: {
                                param = "PD";
                                break;
                            }
                            case 1004: {
                                param = "CU";
                                break;
                            }
                            case 1005: {
                                param = "CD";
                                break;
                            }
                            case 1006: {
                                param = "CL";
                                break;
                            }
                            case 1007: {
                                param = "CR";
                                break;
                            }
                            case 1008: {
                                if (kshift) {
                                    param = "F!";
                                    break;
                                }
                                param = "F1";
                                break;
                            }
                            case 1009: {
                                if (kshift) {
                                    param = "F@";
                                    break;
                                }
                                param = "F2";
                                break;
                            }
                            case 1010: {
                                if (kshift) {
                                    param = "F#";
                                    break;
                                }
                                param = "F3";
                                break;
                            }
                            case 1011: {
                                if (kshift) {
                                    param = "F$";
                                    break;
                                }
                                param = "F4";
                                break;
                            }
                            case 1012: {
                                if (kshift) {
                                    param = "F%";
                                    break;
                                }
                                param = "F5";
                                break;
                            }
                            case 1013: {
                                if (kshift) {
                                    param = "F^";
                                    break;
                                }
                                param = "F6";
                                break;
                            }
                            case 1014: {
                                if (kshift) {
                                    param = "F&";
                                    break;
                                }
                                param = "F7";
                                break;
                            }
                            case 1015: {
                                if (kshift) {
                                    param = "F*";
                                    break;
                                }
                                param = "F8";
                                break;
                            }
                            case 1016: {
                                if (kshift) {
                                    param = "F(";
                                    break;
                                }
                                param = "F9";
                                break;
                            }
                            case 1017: {
                                if (kshift) {
                                    param = "F)";
                                    break;
                                }
                                param = "F0";
                                break;
                            }
                            case 1018: {
                                if (kshift) {
                                    param = "F_";
                                    break;
                                }
                                param = "F-";
                                break;
                            }
                            case 1019: {
                                if (kshift) {
                                    param = "F+";
                                    break;
                                }
                                param = "F=";
                                break;
                            }
                            case 1020: {
                                param = "PS";
                                break;
                            }
                            case 1021: {
                                param = "SL";
                                break;
                            }
                            case 1022: {
                                param = "CL";
                                break;
                            }
                            case 1023: {
                                param = "NL";
                                break;
                            }
                            case 1024: {
                                param = "PA";
                                break;
                            }
                            case 1025: {
                                param = "IN";
                                break;
                            }
                            case 10: {
                                param = "EN";
                                break;
                            }
                            case 8: {
                                param = "BS";
                                break;
                            }
                            case 9: {
                                param = "TB";
                                break;
                            }
                            case 27: {
                                param = "ES";
                                break;
                            }
                            case 127: {
                                param = "DL";
                                break;
                            }
                            default: {
                                param = (char)evt.key + " ";
                            }
                        }
                        param = kalt ? param + "A" : param + " ";
                        param = kctrl ? param + "C" : param + " ";
                        param = kmeta ? param + "M" : param + " ";
                        param = kshift ? param + "S" : param + " ";
                        eventArg.move(param);
                    }
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    if ((eventTypeInt & 0x40) != 0 && (evt.id == 401 || evt.id == 403)) {
                        SynkronixGuiImpl.startThread(program, handler);
                        handled = true;
                        break;
                    }
                    if ((eventTypeInt & 0x80) == 0 || evt.id != 402 && evt.id != 404) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 1004: {
                    type = "FG";
                    if (evt.target instanceof TextFieldComponent) {
                        ((TextFieldComponent)evt.target).selectAll();
                        handled = true;
                    }
                    if (handler == 0) break;
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    if ((eventTypeInt & 0x100) != 0) {
                        SynkronixGuiImpl.startThread(program, handler);
                    }
                    handled = true;
                    break;
                }
                case 1005: {
                    type = "FL";
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    if (evt.target instanceof TextFieldComponent) {
                        cobolVar.move(((TextFieldComponent)evt.target).getText());
                        ((TextFieldComponent)evt.target).setText(cobolVar.toString());
                        ((TextFieldComponent)evt.target).setVisible(true);
                        handled = true;
                    }
                    if (evt.target instanceof TextArea) {
                        cobolVar.move(((TextArea)evt.target).getText());
                        ((TextArea)evt.target).setText(cobolVar.toString());
                        ((TextArea)evt.target).setVisible(true);
                        handled = true;
                    }
                    if (handler == 0 || (eventTypeInt & 0x200) == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 201: {
                    type = "WX";
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    if (handler == 0 || (eventTypeInt & 0x400) == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 202: {
                    type = "WE";
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    if (handler == 0 || (eventTypeInt & 0x800) == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 203: {
                    type = "WI";
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    if (handler == 0 || (eventTypeInt & 0x1000) == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 204: {
                    type = "WD";
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    if (handler == 0 || (eventTypeInt & 0x2000) == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 601: {
                    type = "SU";
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    cobolVar.move(((Scrollbar)evt.target).getValue());
                    if (handler == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 602: {
                    type = "SD";
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    cobolVar.move(((Scrollbar)evt.target).getValue());
                    if (handler == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 603: {
                    type = "SP";
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    cobolVar.move(((Scrollbar)evt.target).getValue());
                    if (handler == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 604: {
                    type = "SN";
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    cobolVar.move(((Scrollbar)evt.target).getValue());
                    if (handler == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 605: {
                    type = "SA";
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    cobolVar.move(((Scrollbar)evt.target).getValue());
                    if (handler == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 701: {
                    type = "LS";
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    if (evt.target instanceof List) {
                        Integer templI = (Integer)evt.arg;
                        int templi = templI;
                        cobolVar.move(templi + 1);
                        handled = true;
                    }
                    if (handler == 0 || (types & 0x80000) == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 702: {
                    if (type == null) {
                        type = "LD";
                    }
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    if (handler == 0 || (types & 0x100000) == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                    break;
                }
                case 1001: {
                    int i;
                    String text;
                    type = "AE";
                    if (eventType != null) {
                        eventType.move(type);
                    }
                    if (evt.target instanceof TextFieldComponent) {
                        cobolVar.move(((TextFieldComponent)evt.target).getText());
                        ((TextFieldComponent)evt.target).setText(cobolVar.toString());
                        ((TextFieldComponent)evt.target).setVisible(true);
                        handled = true;
                    }
                    if (evt.target instanceof TextArea) {
                        cobolVar.move(((TextArea)evt.target).getText());
                        ((TextArea)evt.target).setText(cobolVar.toString());
                        ((TextArea)evt.target).setVisible(true);
                        handled = true;
                    }
                    if (evt.target instanceof Choice) {
                        text = (String)evt.arg;
                        Choice tempc = (Choice)evt.target;
                        for (i = 0; i < tempc.getItemCount(); ++i) {
                            if (tempc.getItem(i) != text) continue;
                            cobolVar.move(i + 1);
                        }
                        handled = true;
                    }
                    if (evt.target instanceof List) {
                        text = (String)evt.arg;
                        List templ = (List)evt.target;
                        for (i = 0; i < templ.getItemCount(); ++i) {
                            if (templ.getItem(i) != text) continue;
                            cobolVar.move(i + 1);
                        }
                        handled = true;
                    }
                    if (evt.target instanceof Checkbox) {
                        cobolVar.move(((Checkbox)evt.target).getState());
                        handled = true;
                    }
                    if (handler == 0) break;
                    SynkronixGuiImpl.startThread(program, handler);
                    handled = true;
                }
            }
        }
        return handled;
    }

    public final String toString() {
        return "rebuild=" + this.rebuild;
    }

    public final Object clone() {
        SynkronixGuiImpl copy = new SynkronixGuiImpl();
        copy.cgContext = this.cgContext;
        copy.frameContext = this.frameContext;
        copy.panelContext = this.panelContext;
        copy.beanContext = this.beanContext;
        copy.layoutContext = this.layoutContext;
        copy.windowContext = this.windowContext;
        copy.constraint = this.constraint;
        copy.rebuild = false;
        return copy;
    }

    public final SynkronixGuiImpl guiclone() {
        return (SynkronixGuiImpl)this.clone();
    }

    public final Container getContainer() {
        if (this.beanContext != null) {
            return this.beanContext;
        }
        if (this.panelContext != null) {
            return this.panelContext;
        }
        if (this.windowContext != null) {
            return this.windowContext;
        }
        if (this.frameContext != null) {
            return this.frameContext;
        }
        return null;
    }

    public final Container getContainer(Variable node) {
        for (Variable frameNode = node; frameNode != null; frameNode = frameNode.getParent()) {
            Object o = frameNode.getGuiObject();
            if (o == null || !(o instanceof Container)) continue;
            return (Container)o;
        }
        return null;
    }

    private final int extract(String s, int offset) {
        char c2;
        int n2;
        char c1 = s.charAt(offset);
        int n1 = c1 - 48;
        int result = n1 * 10 + (n2 = (c2 = s.charAt(offset + 1)) - 48);
        if (result < 0) {
            result = 0;
        }
        if (result > 99) {
            result = 99;
        }
        return result;
    }

    public final void add(Component component, SynkronixGuiImpl context) {
        String constraint = context.constraint;
        int cl = constraint != null ? constraint.length() : 0;
        if (cl == 1 && context.layoutContext instanceof BorderLayout) {
            constraint = constraint.toUpperCase();
            char c = constraint.charAt(0);
            switch (c) {
                case 'N': {
                    context.getContainer().add("North", component);
                    break;
                }
                case 'S': {
                    context.getContainer().add("South", component);
                    break;
                }
                case 'E': {
                    context.getContainer().add("East", component);
                    break;
                }
                case 'W': {
                    context.getContainer().add("West", component);
                    break;
                }
                default: {
                    context.getContainer().add("Center", component);
                    break;
                }
            }
        } else if (cl >= 4 && context.layoutContext instanceof GridBagLayout) {
            constraint = constraint + "00000000000";
            constraint = constraint.substring(0, 11);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = this.extract(constraint, 0);
            gbc.gridy = this.extract(constraint, 2);
            gbc.gridwidth = this.extract(constraint, 4);
            gbc.gridheight = this.extract(constraint, 6);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            char fill = Character.toUpperCase(constraint.charAt(8));
            if (fill == 'N') {
                gbc.fill = 0;
            } else if (fill == 'B') {
                gbc.fill = 1;
            } else if (fill == 'H') {
                gbc.fill = 2;
            } else if (fill == 'V') {
                gbc.fill = 3;
            }
            String anchor = constraint.substring(9, 11).toLowerCase();
            if (anchor.charAt(1) == ' ' || anchor.charAt(1) == '0') {
                anchor = anchor.substring(0, 1);
            }
            if (anchor.equals("c")) {
                gbc.anchor = 10;
            } else if (anchor.equals("n")) {
                gbc.anchor = 11;
            } else if (anchor.equals("s")) {
                gbc.anchor = 15;
            } else if (anchor.equals("e")) {
                gbc.anchor = 13;
            } else if (anchor.equals("w")) {
                gbc.anchor = 17;
            } else if (anchor.equals("ne")) {
                gbc.anchor = 12;
            } else if (anchor.equals("nw")) {
                gbc.anchor = 18;
            } else if (anchor.equals("se")) {
                gbc.anchor = 14;
            } else if (anchor.equals("sw")) {
                gbc.anchor = 16;
            }
            ((GridBagLayout)context.layoutContext).setConstraints(component, gbc);
            this.getContainer().add(component);
        } else if (context != null) {
            Container alpha = context.getContainer();
            alpha.add(component);
        }
    }

    public static final void show(Variable node) {
        if (node.isScreen()) {
            SynkronixGuiImpl.showScreen(node);
            return;
        }
        Object o = node.getGuiObject();
        if (o == null) {
            SynkronixGuiImpl.update(node);
        }
        if (o != null && o instanceof Component) {
            Component c = (Component)o;
            if (c != null) {
                c.setVisible(true);
            }
            if (c instanceof Window) {
                ((Window)c).pack();
            }
        }
    }

    public static final synchronized void hide(Variable node) {
        Object o = node.getGuiObject();
        if (o != null && o instanceof Component) {
            Component c = (Component)o;
            if (c != null) {
                c.setVisible(false);
            }
            if (c instanceof Window) {
                ((Window)c).dispose();
                SynkronixGuiImpl.clearGuiObject(node.getChild());
                node.setGuiObject(null);
            }
            if (c instanceof AppletComponent) {
                AppletComponent appletPanel = (AppletComponent)c;
                Container parent = appletPanel.getParent();
                parent.remove(appletPanel);
                SynkronixGuiImpl.clearGuiObject(node.getChild());
                node.setGuiObject(null);
            }
        }
    }

    public static final void clearGuiObject(Variable node) {
        while (node != null) {
            if (node.getChild() != null) {
                SynkronixGuiImpl.clearGuiObject(node.getChild());
            }
            Object o = node.getGuiObject();
            node.setGuiObject(null);
            if (o != null) {
                SynkronixGuiImpl.removeEventTarget(o);
            }
            node = node.getSibling();
        }
    }

    public static final void print(Variable node) {
        if (node.isScreen()) {
            SynkronixGuiImpl.printScreen(node);
            return;
        }
        Window f = null;
        boolean newFrame = false;
        try {
            Variable nodef;
            for (nodef = node; nodef != null && !(nodef.getGuiObject() instanceof Frame); nodef = nodef.getParent()) {
            }
            if (nodef != null) {
                f = (Frame)nodef.getGuiObject();
            } else {
                f = new Frame();
                newFrame = true;
            }
            Component cnode = (Component)node.getGuiObject();
            if (f != null) {
                try {
                    PrintJob job;
                    Toolkit t = cnode.getToolkit();
                    if (printProps == null) {
                        printProps = new Properties();
                    }
                    if ((job = t.getPrintJob((Frame)f, "Print Graphics", printProps)) == null) {
                        throw new Exception("Canceled");
                    }
                    Graphics page = job.getGraphics();
                    Dimension size = cnode.getSize();
                    Dimension pageSize = job.getPageDimension();
                    page.translate((pageSize.width - size.width) / 2, (pageSize.height - size.height) / 2);
                    page.setClip(0, 0, size.width, size.height);
                    if (cnode instanceof Container) {
                        ((Container)cnode).printComponents(page);
                    } else {
                        cnode.print(page);
                    }
                    page.dispose();
                    job.end();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newFrame) {
            f.dispose();
        }
    }

    public static void printScreen(Variable screen) {
        try {
            Handle.printScreen(screen);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void showScreen(Variable screen) {
        try {
            Handle.showScreen(screen);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final void updateQuiet(Variable node) {
        try {
            SynkronixGuiImpl.update(node, null, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void update(Variable node) {
        Component target;
        Object o;
        String parentName;
        node.flushToMemory();
        Variable parent = node.getParent();
        if (parent != null && (parentName = parent.getName()) != null && parentName.toUpperCase().indexOf("BEAN") == 0 && (o = parent.getGuiObject()) != null && o instanceof Component && (target = (Component)o) != null) {
            block26: {
                try {
                    Class<?>[] parameters;
                    Method propertyMethodWrite;
                    PropertyDescriptor possiblePropertyDescriptor;
                    BeanInfo beanInfo = Introspector.getBeanInfo(target.getClass(), null);
                    String propertyName = node.getName();
                    int hyphen = propertyName.indexOf(95);
                    if (hyphen >= 0) {
                        propertyName = propertyName.substring(0, hyphen);
                    }
                    if ((hyphen = propertyName.indexOf(45)) >= 0) {
                        propertyName = propertyName.substring(0, hyphen);
                    }
                    if ((possiblePropertyDescriptor = SynkronixGuiImpl.getPropertyDescriptor(beanInfo, propertyName)) == null || (propertyMethodWrite = possiblePropertyDescriptor.getWriteMethod()) == null || (parameters = propertyMethodWrite.getParameterTypes()).length != 1) break block26;
                    Class<?> param = parameters[0];
                    try {
                        if (param == Boolean.TYPE) {
                            propertyMethodWrite.invoke((Object)target, new Boolean(node.toBoolean()));
                        } else if (param == Byte.TYPE) {
                            propertyMethodWrite.invoke((Object)target, new Byte(node.toByte()));
                        } else if (param == Short.TYPE) {
                            propertyMethodWrite.invoke((Object)target, new Short(node.toShort()));
                        } else if (param == Integer.TYPE) {
                            propertyMethodWrite.invoke((Object)target, new Integer(node.toInt()));
                        } else if (param == Long.TYPE) {
                            propertyMethodWrite.invoke((Object)target, new Long(node.toLong()));
                        } else if (param == Character.TYPE) {
                            propertyMethodWrite.invoke((Object)target, new Character(node.toChar()));
                        } else if (param == Float.TYPE) {
                            propertyMethodWrite.invoke((Object)target, new Float(node.toFloat()));
                        } else if (param == Double.TYPE) {
                            propertyMethodWrite.invoke((Object)target, new Double(node.toDouble()));
                        } else if (param == String.class) {
                            propertyMethodWrite.invoke((Object)target, new String(node.toString().trim()));
                        } else if (node.getGuiObject() != null) {
                            propertyMethodWrite.invoke((Object)target, node.getGuiObject());
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        Shutdown.exitWhenFinished(false);
        SynkronixGuiImpl.update(node, null, false);
    }

    public static final synchronized void update(Variable node, SynkronixGuiImpl context) {
        SynkronixGuiImpl.update(node, context, false);
    }

    public static final synchronized void update(Variable node, SynkronixGuiImpl context, boolean quietShow) {
        try {
            SynkronixGuiImpl.updateInner(node, context, quietShow);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final synchronized void updateMenu(FrameComponent target, Variable node, SynkronixGuiImpl context) {
        while (node != null) {
            if (node.getHyphenName().equals("MENU")) {
                target.validate();
                SynkronixGuiImpl.menu(target, node, context);
                target.pack();
                return;
            }
            node = node.getSibling();
        }
    }

    public static final synchronized void updateInner(Variable node, SynkronixGuiImpl context, boolean quietShow) {
        if (context == null) {
            context = new SynkronixGuiImpl();
        }
        while (node != null) {
            String name = "";
            try {
                name = node.getHyphenName();
            }
            catch (Exception e) {
                name = "";
            }
            if (name.startsWith("AWT")) {
                name = name.substring(3);
            }
            if (name.equals("BEAN")) {
                SynkronixGuiImpl.bean(node, context, quietShow);
            } else if (name.equals("APPLET")) {
                FrameComponent thisFrame;
                Container c = SynkronixGuiImpl.applet(node, context, quietShow);
                if (c instanceof FrameComponent && (thisFrame = (FrameComponent)c) != null) {
                    SynkronixGuiImpl.updateMenu(thisFrame, node.getChild(), context);
                }
            } else if (name.equals("CHOICE")) {
                SynkronixGuiImpl.choice(node, context);
            } else if (name.equals("LIST")) {
                SynkronixGuiImpl.list(node, context);
            } else if (name.equals("CHECKBOX")) {
                SynkronixGuiImpl.checkbox(node, context);
            } else if (!name.equals("MENU")) {
                SynkronixGuiImpl cloned;
                if (name.equals("HSCROLLBAR")) {
                    SynkronixGuiImpl.hscrollbar(node, context);
                } else if (name.equals("VSCROLLBAR")) {
                    SynkronixGuiImpl.vscrollbar(node, context);
                } else if (name.equals("BUTTON")) {
                    SynkronixGuiImpl.button(node, context);
                } else if (name.equals("CANVAS")) {
                    SynkronixGuiImpl.canvas(node, context);
                } else if (name.equals("TEXTFIELD")) {
                    SynkronixGuiImpl.textfield(node, context);
                } else if (name.equals("TEXTAREA")) {
                    SynkronixGuiImpl.textarea(node, context);
                } else if (name.equals("IMAGE")) {
                    SynkronixGuiImpl.image(node, context);
                } else if (name.equals("TEXTLABEL")) {
                    SynkronixGuiImpl.label(node, context);
                } else if (name.equals("GRID") || name.equals("TABLE") || name.equals("SPREADSHEET")) {
                    SynkronixGuiGrid.grid(node, context);
                } else if (name.equals("PANEL")) {
                    SynkronixGuiImpl.panel(node, context);
                } else if (name.equals("FRAME")) {
                    FrameComponent thisFrame = SynkronixGuiImpl.frame(node, context, quietShow);
                    if (thisFrame != null) {
                        SynkronixGuiImpl.updateMenu(thisFrame, node.getChild(), context);
                    }
                } else if (name.equals("WINDOW")) {
                    SynkronixGuiImpl.window(node, context);
                } else if (name.equals("DIALOG")) {
                    SynkronixGuiImpl.dialog(node, context);
                } else if (name.equals("FLOW")) {
                    cloned = context.guiclone();
                    cloned.layoutContext = new FlowLayout();
                    node.setGuiObject(cloned.layoutContext);
                    cloned.getContainer(node).setLayout((FlowLayout)cloned.layoutContext);
                    SynkronixGuiImpl.update(node.getChild(), cloned);
                } else if (name.equals("BORDER")) {
                    Variable thechild = node.getChild();
                    if (thechild != null) {
                        cloned = context.guiclone();
                        cloned.layoutContext = new BorderLayout();
                        node.setGuiObject(cloned.layoutContext);
                        Container alpha = cloned.getContainer(node);
                        if (alpha != null) {
                            try {
                                alpha.setLayout((BorderLayout)cloned.layoutContext);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            SynkronixGuiImpl.update(thechild, cloned);
                        }
                    }
                } else if (name.equals("GRIDLAYOUT")) {
                    try {
                        cloned = context.guiclone();
                        cloned.layoutContext = new GridLayout(10, 10);
                        node.setGuiObject(cloned.layoutContext);
                        cloned.getContainer(node).setLayout((GridLayout)cloned.layoutContext);
                        SynkronixGuiImpl.update(node.getChild(), cloned);
                    }
                    catch (Throwable thechild) {}
                } else if (name.equals("CARD")) {
                    cloned = context.guiclone();
                    cloned.layoutContext = new CardLayout();
                    node.setGuiObject(cloned.layoutContext);
                    cloned.getContainer(node).setLayout((CardLayout)cloned.layoutContext);
                    SynkronixGuiImpl.update(node.getChild(), cloned);
                } else if (name.equals("GRIDBAG")) {
                    cloned = context.guiclone();
                    cloned.layoutContext = new GridBagLayout();
                    node.setGuiObject(cloned.layoutContext);
                    cloned.getContainer(node).setLayout((GridBagLayout)cloned.layoutContext);
                    SynkronixGuiImpl.update(node.getChild(), cloned);
                } else if (name.equals("LAYOUT")) {
                    cloned = context.guiclone();
                    try {
                        cloned.layoutContext = (LayoutManager)Class.forName(node.toString().trim()).newInstance();
                        node.setGuiObject(cloned.layoutContext);
                        cloned.getContainer(node).setLayout(cloned.layoutContext);
                        SynkronixGuiImpl.update(node.getChild(), cloned);
                    }
                    catch (Exception e) {
                        try {
                            cloned.layoutContext = null;
                            cloned.getContainer(node).setLayout(null);
                            SynkronixGuiImpl.update(node.getChild(), cloned);
                        }
                        catch (Exception exception) {}
                    }
                } else if (name.equals("CONSTRAINT")) {
                    cloned = context.guiclone();
                    cloned.constraint = node.toString();
                    SynkronixGuiImpl.update(node.getChild(), cloned);
                } else if (name.equals("NORTH") || name.equals("UP")) {
                    cloned = context.guiclone();
                    cloned.constraint = "N";
                    SynkronixGuiImpl.update(node.getChild(), cloned);
                } else if (name.equals("SOUTH") || name.equals("DOWN")) {
                    cloned = context.guiclone();
                    cloned.constraint = "S";
                    SynkronixGuiImpl.update(node.getChild(), cloned);
                } else if (name.equals("EAST") || name.equals("RIGHT")) {
                    cloned = context.guiclone();
                    cloned.constraint = "E";
                    SynkronixGuiImpl.update(node.getChild(), cloned);
                } else if (name.equals("WEST") || name.equals("LEFT")) {
                    cloned = context.guiclone();
                    cloned.constraint = "W";
                    SynkronixGuiImpl.update(node.getChild(), cloned);
                } else if (name.equals("CENTER") || name.equals("MIDDLE")) {
                    cloned = context.guiclone();
                    cloned.constraint = "C";
                    SynkronixGuiImpl.update(node.getChild(), cloned);
                } else if (name.equals("CHECKBOXGROUP")) {
                    cloned = context.guiclone();
                    cloned.cgContext = new CheckboxGroup();
                    node.setGuiObject(cloned.cgContext);
                    SynkronixGuiImpl.mapEventVariable(cloned.cgContext, node, 0, null, null);
                    SynkronixGuiImpl.update(node.getChild(), cloned);
                } else if (node.getChild() != null) {
                    SynkronixGuiImpl.update(node.getChild(), context);
                }
            }
            context.rebuild = false;
            node = node.getSibling();
        }
    }

    public static final void canvas(Variable node, SynkronixGuiImpl context) {
        Canvas target;
        boolean newitem = false;
        if (node.getGuiObject() == null) {
            target = new Canvas();
            newitem = true;
            context.add(target, context);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (Canvas)node.getGuiObject();
        }
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else {
                    SynkronixGuiImpl.update(node, context);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        if (newitem) {
            target.setVisible(true);
        }
    }

    private static PropertyDescriptor getPropertyDescriptor(BeanInfo beanInfo, String propertyName) {
        PropertyDescriptor[] propertyDescriptor = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptor.length; ++i) {
            if (!propertyDescriptor[i].getName().equals(propertyName)) continue;
            return propertyDescriptor[i];
        }
        return null;
    }

    public static final void bean(Variable node, SynkronixGuiImpl context, boolean quietShow) {
        Component target;
        boolean newitem = false;
        BeanInfo beanInfo = null;
        if (node.getGuiObject() == null) {
            Applet alpha = Utilities.getApplet();
            try {
                target = alpha == null ? (Component)Beans.instantiate(SynkronixGuiImpl.class.getClassLoader(), node.toString().trim()) : (Component)Beans.instantiate(alpha.getClass().getClassLoader(), node.toString().trim());
            }
            catch (Throwable t) {
                Object target2 = null;
                return;
            }
            newitem = true;
            if (!(target instanceof Frame)) {
                context.add(target, context);
            }
            node.setGuiObject(target);
            try {
                beanInfo = Introspector.getBeanInfo(target.getClass(), null);
                for (Variable possibleProperty = node.getChild(); possibleProperty != null; possibleProperty = possibleProperty.getSibling()) {
                    Method propertyMethodRead;
                    Class<?>[] parameters;
                    Method propertyMethodWrite;
                    PropertyDescriptor possiblePropertyDescriptor;
                    String propertyName = possibleProperty.getName();
                    int hyphen = propertyName.indexOf(95);
                    if (hyphen >= 0) {
                        propertyName = propertyName.substring(0, hyphen);
                    }
                    if ((hyphen = propertyName.indexOf(45)) >= 0) {
                        propertyName = propertyName.substring(0, hyphen);
                    }
                    if ((possiblePropertyDescriptor = SynkronixGuiImpl.getPropertyDescriptor(beanInfo, propertyName)) == null) continue;
                    if (possibleProperty.hasInitialValue() && (propertyMethodWrite = possiblePropertyDescriptor.getWriteMethod()) != null && (parameters = propertyMethodWrite.getParameterTypes()).length == 1) {
                        Class<?> param = parameters[0];
                        try {
                            if (param == Boolean.TYPE) {
                                propertyMethodWrite.invoke((Object)target, new Boolean(possibleProperty.toBoolean()));
                            } else if (param == Byte.TYPE) {
                                propertyMethodWrite.invoke((Object)target, new Byte(possibleProperty.toByte()));
                            } else if (param == Short.TYPE) {
                                propertyMethodWrite.invoke((Object)target, new Short(possibleProperty.toShort()));
                            } else if (param == Integer.TYPE) {
                                propertyMethodWrite.invoke((Object)target, new Integer(possibleProperty.toInt()));
                            } else if (param == Long.TYPE) {
                                propertyMethodWrite.invoke((Object)target, new Long(possibleProperty.toLong()));
                            } else if (param == Character.TYPE) {
                                propertyMethodWrite.invoke((Object)target, new Character(possibleProperty.toChar()));
                            } else if (param == Float.TYPE) {
                                propertyMethodWrite.invoke((Object)target, new Float(possibleProperty.toFloat()));
                            } else if (param == Double.TYPE) {
                                propertyMethodWrite.invoke((Object)target, new Double(possibleProperty.toDouble()));
                            } else if (param == String.class) {
                                propertyMethodWrite.invoke((Object)target, new String(possibleProperty.toString().trim()));
                            } else if (possibleProperty.getGuiObject() != null) {
                                propertyMethodWrite.invoke((Object)target, possibleProperty.getGuiObject());
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if ((propertyMethodRead = possiblePropertyDescriptor.getReadMethod()) == null) continue;
                    parameters = propertyMethodRead.getParameterTypes();
                    Object[] args = new Object[parameters.length];
                    if (parameters.length != 0) continue;
                    try {
                        Object o = propertyMethodRead.invoke((Object)target, args);
                        if (o != null) {
                            possibleProperty.move(o.toString());
                        }
                        possibleProperty.setGuiObject(o);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception possibleProperty) {}
        } else {
            target = (Component)node.getGuiObject();
            if (target instanceof Frame) {
                ((Frame)target).pack();
            }
            if (!context.rebuild) {
                return;
            }
            try {
                beanInfo = Introspector.getBeanInfo(target.getClass(), null);
                for (Variable possibleProperty = node.getChild(); possibleProperty != null; possibleProperty = possibleProperty.getSibling()) {
                    Method propertyMethodRead;
                    PropertyDescriptor possiblePropertyDescriptor;
                    String propertyName = possibleProperty.getName();
                    int hyphen = propertyName.indexOf(95);
                    if (hyphen >= 0) {
                        propertyName = propertyName.substring(0, hyphen);
                    }
                    if ((hyphen = propertyName.indexOf(45)) >= 0) {
                        propertyName = propertyName.substring(0, hyphen);
                    }
                    if ((possiblePropertyDescriptor = SynkronixGuiImpl.getPropertyDescriptor(beanInfo, propertyName)) == null || (propertyMethodRead = possiblePropertyDescriptor.getReadMethod()) == null) continue;
                    Class<?>[] parameters = propertyMethodRead.getParameterTypes();
                    Object[] args = new Object[parameters.length];
                    if (parameters.length != 0) continue;
                    try {
                        Object o = propertyMethodRead.invoke((Object)target, args);
                        if (o != null) {
                            possibleProperty.move(o.toString());
                        }
                        possibleProperty.setGuiObject(o);
                        continue;
                    }
                    catch (Exception o) {
                        // empty catch block
                    }
                }
            }
            catch (Exception possibleProperty) {
                // empty catch block
            }
            target.repaint();
        }
        SynkronixGuiImpl cloned = null;
        if (target instanceof Container) {
            cloned = context.guiclone();
            boolean jframe = false;
            try {
                Method m = target.getClass().getMethod("getContentPane", new Class[0]);
                if (m != null) {
                    Object[] passObject = new Object[]{};
                    cloned.beanContext = (Container)m.invoke((Object)target, passObject);
                    jframe = true;
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
            if (!jframe) {
                cloned.beanContext = (Container)target;
            }
        }
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else {
                    SynkronixGuiImpl.update(node, cloned);
                    node = null;
                }
                if (node != null) {
                    node = node.getSibling();
                }
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        if (newitem) {
            if (target instanceof Frame) {
                target.invalidate();
                try {
                    ((Frame)target).pack();
                }
                catch (Throwable o) {
                    // empty catch block
                }
            }
            if (!quietShow || !(target instanceof Frame)) {
                target.setVisible(true);
            }
            if (target instanceof Applet) {
                Applet targetApplet = (Applet)target;
                targetApplet.start();
            }
        }
    }

    public static final void button(Variable node, SynkronixGuiImpl context) {
        Button target;
        boolean newitem = false;
        if (node.getGuiObject() == null) {
            target = new Button();
            newitem = true;
            context.add(target, context);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (Button)node.getGuiObject();
        }
        target.setLabel(node.toString().trim());
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else {
                    SynkronixGuiImpl.update(node, context);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        if (newitem) {
            target.setVisible(true);
        }
    }

    public static final void label(Variable node, SynkronixGuiImpl context) {
        Label target;
        boolean newitem = false;
        if (node.getGuiObject() == null) {
            target = new Label();
            newitem = true;
            context.add(target, context);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (Label)node.getGuiObject();
        }
        target.setText(node.toString());
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else if (hyphen.equals("ALIGNMENT")) {
                    char c = Character.toUpperCase(node.toString().charAt(0));
                    if (c == 'L' || c == 'W') {
                        target.setAlignment(0);
                    } else if (c == 'R' || c == 'E') {
                        target.setAlignment(2);
                    } else if (c == 'C' || c == 'M') {
                        target.setAlignment(1);
                    }
                } else {
                    SynkronixGuiImpl.update(node, context);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        if (newitem) {
            target.setVisible(true);
        }
    }

    public static final void image(Variable node, SynkronixGuiImpl context) {
        ImageComponent target;
        boolean newitem = false;
        if (node.getGuiObject() == null) {
            target = new ImageComponent();
            newitem = true;
            context.add(target, context);
            try {
                target.addNotify();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (ImageComponent)node.getGuiObject();
        }
        String name = "DefaultImage.jpg";
        try {
            name = node.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        target.setName(name);
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else {
                    SynkronixGuiImpl.update(node, context);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        if (newitem) {
            target.setVisible(true);
        }
    }

    public static final void textarea(Variable node, SynkronixGuiImpl context) {
        TextArea target;
        boolean newitem = false;
        if (node.getGuiObject() == null) {
            target = new TextArea();
            newitem = true;
            context.add(target, context);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (TextArea)node.getGuiObject();
        }
        target.setText(node.toString());
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else if (hyphen.equals("EDITABLE")) {
                    target.setEditable(node.toBoolean());
                } else if (hyphen.equals("ROWS")) {
                    try {
                        target.setRows(node.toInt());
                    }
                    catch (Throwable throwable) {}
                } else if (hyphen.equals("COLUMNS")) {
                    try {
                        target.setColumns(node.toInt());
                    }
                    catch (Throwable throwable) {}
                } else {
                    SynkronixGuiImpl.update(node, context);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        if (newitem) {
            target.setVisible(true);
        }
    }

    public static final void textfield(Variable node, SynkronixGuiImpl context) {
        TextFieldComponent target;
        boolean newitem = false;
        if (node.getGuiObject() == null) {
            int defaultColumns = 1;
            if (node != null) {
                defaultColumns = node.toString().length();
            }
            if (defaultColumns < 0) {
                defaultColumns = 1;
            }
            target = new TextFieldComponent(node.toString().length());
            newitem = true;
            context.add(target, context);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (TextFieldComponent)node.getGuiObject();
        }
        target.setText(node.toString().trim());
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else if (hyphen.equals("COLUMNS")) {
                    try {
                        target.setColumns(node.toInt());
                    }
                    catch (Throwable throwable) {}
                } else if (hyphen.equals("ECHOCHAR")) {
                    target.setEchoChar(node.toChar());
                } else if (hyphen.equals("EDITABLE")) {
                    target.setEditable(node.toBoolean());
                } else if (hyphen.equals("MODE")) {
                    target.setMode(node.toString());
                } else {
                    SynkronixGuiImpl.update(node, context);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        if (newitem) {
            target.setVisible(true);
        }
    }

    public static final void choice(Variable node, SynkronixGuiImpl context) {
        Choice target;
        boolean newitem = false;
        if (node.getGuiObject() == null) {
            target = new Choice();
            newitem = true;
            context.add(target, context);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (Choice)node.getGuiObject();
            target.removeAll();
        }
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        Variable oldNode = null;
        boolean children = false;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            oldNode = node;
            children = false;
            if (node.getChild() != null) {
                node = node.getChild();
                children = true;
            }
            do {
                if (node == null) continue;
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else if (node.occurs() != 1) {
                    for (int i = 1; i <= node.occurs(); ++i) {
                        target.addItem(node.subscript(i).toString());
                    }
                } else {
                    target.addItem(node.toString());
                }
                node = node.getSibling();
            } while (children && node != null);
            node = oldNode;
            if (node != null) {
                node = node.getSibling();
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        if (newitem) {
            target.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void list(Variable node, SynkronixGuiImpl context) {
        List target;
        if (node == null) {
            return;
        }
        boolean newitem = false;
        if (node.getGuiObject() == null) {
            target = new List();
            newitem = true;
            context.add(target, context);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (List)node.getGuiObject();
            target.removeAll();
        }
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        Variable oldNode = null;
        boolean children = false;
        int eventlistens = 0;
        node = node.getChild();
        while (node != null) {
            int temp;
            do {
                if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) == -1) continue;
                eventlistens |= temp;
                node = node.getSibling();
            } while (temp != -1);
            oldNode = node;
            children = false;
            if (node.getChild() != null) {
                node = node.getChild();
                children = true;
            }
            do {
                if (node == null) continue;
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else if (hyphen.equals("MULTIPLE")) {
                    target.setMultipleMode(node.toBoolean());
                } else if (node.occurs() != 1) {
                    for (int i = 1; i <= node.occurs(); ++i) {
                        Object object = syncObject;
                        synchronized (object) {
                            try {
                                Variable v = node.subscript(i);
                                if (v != null) {
                                    String addition = v.toString();
                                    target.add(addition);
                                    v.releaseSubscript();
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                } else {
                    Object object = syncObject;
                    synchronized (object) {
                        try {
                            target.add(node.toString());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                node = node.getSibling();
            } while (children && node != null);
            node = oldNode;
            if (node == null) continue;
            node = node.getSibling();
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        target.setVisible(true);
        if (newitem) {
            target.setVisible(true);
        }
    }

    public static final void checkbox(Variable node, SynkronixGuiImpl context) {
        Checkbox target;
        boolean newitem = false;
        if (node.getGuiObject() == null) {
            target = new Checkbox();
            newitem = true;
            context.add(target, context);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (Checkbox)node.getGuiObject();
        }
        target.setState(node.toBoolean());
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else if (hyphen.equals("TEXTLABEL")) {
                    target.setLabel(node.toString().trim());
                } else {
                    SynkronixGuiImpl.update(node, context);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        if (newitem) {
            target.setVisible(true);
        }
    }

    public static final void hscrollbar(Variable node, SynkronixGuiImpl context) {
        Scrollbar target;
        boolean newitem = false;
        if (node.getGuiObject() == null) {
            target = new Scrollbar(0);
            newitem = true;
            context.add(target, context);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (Scrollbar)node.getGuiObject();
        }
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else if (hyphen.equals("MIN")) {
                    try {
                        target.setMinimum(node.toInt());
                    }
                    catch (Throwable throwable) {}
                } else if (hyphen.equals("MAX")) {
                    try {
                        target.setMaximum(node.toInt());
                    }
                    catch (Throwable throwable) {}
                } else {
                    SynkronixGuiImpl.update(node, context);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        target.setValue(parent.toInt());
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        if (newitem) {
            target.setVisible(true);
        }
    }

    public static final void vscrollbar(Variable node, SynkronixGuiImpl context) {
        Scrollbar target;
        boolean newitem = false;
        if (node.getGuiObject() == null) {
            target = new Scrollbar(1);
            newitem = true;
            context.add(target, context);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (Scrollbar)node.getGuiObject();
        }
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else if (hyphen.equals("MIN")) {
                    try {
                        target.setMinimum(node.toInt());
                    }
                    catch (Throwable throwable) {}
                } else if (hyphen.equals("MAX")) {
                    try {
                        target.setMaximum(node.toInt());
                    }
                    catch (Throwable throwable) {}
                } else {
                    SynkronixGuiImpl.update(node, context);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        target.setValue(parent.toInt());
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        if (newitem) {
            target.setVisible(true);
        }
    }

    public static final Container applet(Variable node, SynkronixGuiImpl context, boolean quietShow) {
        FrameComponent target = null;
        AppletComponent targetpanel = null;
        Container appletPanel = Utilities.getTrackPanel();
        if (node.getGuiObject() == null) {
            String title = null;
            if (node != null) {
                try {
                    title = node.toString();
                }
                catch (Exception e) {
                    title = "Default Frame Exception";
                }
            }
            if (title.length() > 80) {
                title = title.substring(20) + "...";
            }
            if (appletPanel != null && Utilities.isApplet()) {
                int number;
                try {
                    number = appletPanel.getComponentCount();
                }
                catch (Exception e) {
                    number = appletPanel.getComponentCount();
                }
                if (number == 0) {
                    targetpanel = new AppletComponent();
                    appletPanel.setLayout(new BorderLayout());
                    appletPanel.add((Component)targetpanel, "Center");
                    appletPanel.invalidate();
                    node.setGuiObject(targetpanel);
                } else {
                    target = new FrameComponent(title);
                    target.toFront();
                }
            } else {
                target = new FrameComponent(title);
                target.toFront();
            }
            if (target != null) {
                target.setSize(10, 10);
                node.setGuiObject(target);
            }
        } else {
            Object o = node.getGuiObject();
            if (o instanceof Frame) {
                target = (FrameComponent)o;
            } else if (o instanceof Panel) {
                targetpanel = (AppletComponent)o;
            }
            if (!context.rebuild) {
                if (target != null) {
                    return target;
                }
                return targetpanel;
            }
        }
        try {
            if (target != null) {
                target.addNotify();
            }
            if (targetpanel != null) {
                try {
                    targetpanel.addNotify();
                }
                catch (Exception o) {}
            }
        }
        catch (Exception o) {
            // empty catch block
        }
        SynkronixGuiImpl cloned = context.guiclone();
        if (target != null) {
            cloned.frameContext = target;
        }
        if (targetpanel != null) {
            cloned.panelContext = targetpanel;
        }
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = target != null ? SynkronixGuiImpl.buildComponentProperties(target, node) : SynkronixGuiImpl.buildComponentProperties(targetpanel, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else if (!hyphen.equals("MENU")) {
                    SynkronixGuiImpl.update(node, cloned);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        if (target != null) {
            SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        } else {
            SynkronixGuiImpl.mapEventVariable(targetpanel, parent, eventlistens, eventtype, eventarg);
        }
        try {
            if (target != null) {
                try {
                    target.invalidate();
                    target.addNotify();
                    try {
                        target.pack();
                    }
                    catch (Throwable throwable) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!quietShow) {
                        target.setVisible(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return target;
            }
            targetpanel.invalidate();
            try {
                targetpanel.addNotify();
            }
            catch (Exception exception) {
                // empty catch block
            }
            targetpanel.setVisible(true);
            appletPanel.validate();
            appletPanel.repaint();
            return targetpanel;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static final void panel(Variable node, SynkronixGuiImpl context) {
        Panel target;
        boolean newitem = false;
        if (node.getGuiObject() == null) {
            target = new Panel();
            newitem = true;
            context.add(target, context);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (Panel)node.getGuiObject();
        }
        SynkronixGuiImpl cloned = context.guiclone();
        cloned.panelContext = target;
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else {
                    SynkronixGuiImpl.update(node, cloned);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        if (newitem) {
            target.setVisible(true);
        }
    }

    public static final FrameComponent frame(Variable node, SynkronixGuiImpl context, boolean quietShow) {
        FrameComponent target;
        if (node.getGuiObject() == null) {
            String title = null;
            if (node != null) {
                try {
                    title = node.toString();
                }
                catch (Exception e) {
                    title = "Default Frame Exception";
                }
            }
            if (title.length() > 80) {
                title = title.substring(20);
            }
            target = new FrameComponent(title);
            target.toFront();
            target.setSize(10, 10);
            node.setGuiObject(target);
        } else {
            target = (FrameComponent)node.getGuiObject();
            if (!context.rebuild) {
                return target;
            }
        }
        try {
            target.addNotify();
        }
        catch (Exception title) {
            // empty catch block
        }
        SynkronixGuiImpl cloned = context.guiclone();
        cloned.frameContext = target;
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else if (!hyphen.equals("MENU")) {
                    SynkronixGuiImpl.update(node, cloned);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        try {
            target.invalidate();
            try {
                target.addNotify();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                target.pack();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!quietShow) {
                target.setVisible(true);
            }
            return target;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static final void window(Variable node, SynkronixGuiImpl context) {
        Window target;
        if (node.getGuiObject() == null) {
            target = new Window(context.frameContext);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (Window)node.getGuiObject();
        }
        SynkronixGuiImpl cloned = context.guiclone();
        cloned.windowContext = target;
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else {
                    SynkronixGuiImpl.update(node, cloned);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        try {
            target.invalidate();
            target.pack();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final void dialog(Variable node, SynkronixGuiImpl context) {
        Dialog target;
        if (node.getGuiObject() == null) {
            target = new Dialog((Frame)context.frameContext, false);
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (Dialog)node.getGuiObject();
        }
        SynkronixGuiImpl cloned = context.guiclone();
        cloned.windowContext = target;
        Variable parent = node;
        Variable eventtype = null;
        Variable eventarg = null;
        int eventlistens = 0;
        node = node.getChild();
        while (true) {
            int temp;
            if ((temp = SynkronixGuiImpl.buildEvent(node = SynkronixGuiImpl.buildComponentProperties(target, node))) != -1) {
                eventlistens |= temp;
                node = node.getSibling();
            }
            if (temp != -1) continue;
            if (node != null) {
                String hyphen = node.getHyphenName();
                if (hyphen.equals(EVENTTYPE)) {
                    eventtype = node;
                } else if (hyphen.equals(EVENTARG)) {
                    eventarg = node;
                } else if (hyphen.equals("MODAL")) {
                    try {
                        target.setModal(node.toBoolean());
                    }
                    catch (Throwable throwable) {}
                } else {
                    SynkronixGuiImpl.update(node, cloned);
                }
                node = node.getSibling();
            }
            if (node == null) break;
        }
        SynkronixGuiImpl.mapEventVariable(target, parent, eventlistens, eventtype, eventarg);
        try {
            target.invalidate();
            target.pack();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final void menu(FrameComponent frameTarget, Variable node, SynkronixGuiImpl context) {
        MenuBar target;
        if (node.getGuiObject() == null) {
            target = new MenuBar();
            node.setGuiObject(target);
        } else {
            if (!context.rebuild) {
                return;
            }
            target = (MenuBar)node.getGuiObject();
        }
        Variable menuPointer = node;
        int shortcut = -1;
        boolean checkbox = false;
        boolean checkboxstate = false;
        if (menuPointer.getChild() != null) {
            menuPointer = menuPointer.getChild();
            do {
                Menu menuTop = new Menu(menuPointer.toString().trim());
                if (menuPointer.isGroup()) {
                    Variable innerMenuPointer = menuPointer.getChild();
                    do {
                        if (innerMenuPointer.isGroup()) {
                            for (Variable specialPointer = innerMenuPointer.getChild(); specialPointer != null; specialPointer = specialPointer.getSibling()) {
                                String name = specialPointer.getHyphenName();
                                if (name.equals("MENUSHORTCUT")) {
                                    shortcut = specialPointer.toInt();
                                    continue;
                                }
                                if (!name.equals("CHECKBOX")) continue;
                                checkboxstate = specialPointer.toBoolean();
                                checkbox = true;
                            }
                        }
                        if (!checkbox) {
                            MenuItem mi = new MenuItem(innerMenuPointer.toString().trim());
                            try {
                                if (shortcut != -1) {
                                    mi.setShortcut(new MenuShortcut(shortcut));
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            menuTop.add(mi);
                            SynkronixGuiImpl.mapEventVariable(mi, innerMenuPointer);
                        } else {
                            CheckboxMenuItem cbmi = new CheckboxMenuItem(innerMenuPointer.toString().trim(), checkboxstate);
                            try {
                                if (shortcut != -1) {
                                    cbmi.setShortcut(new MenuShortcut(shortcut));
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            menuTop.add(cbmi);
                            SynkronixGuiImpl.mapEventVariable(cbmi, innerMenuPointer);
                        }
                        innerMenuPointer = innerMenuPointer.getSibling();
                        shortcut = -1;
                        checkbox = false;
                    } while (innerMenuPointer != null);
                }
                target.add(menuTop);
            } while ((menuPointer = menuPointer.getSibling()) != null);
            if (frameTarget == null) {
                frameTarget = context.frameContext;
            }
            if (frameTarget != null) {
                frameTarget.setMenuBar(target);
            }
        }
    }

    static {
        SynkronixGuiImpl.initializeEventByName();
        printProps = null;
        syncObject = new Object();
    }

    private static class TextFieldComponent
    extends TextField {
        private static final Object lockObject = new Object();
        private static Event priorEvent = null;
        private int length = 0;
        private int oldLength = 0;
        private boolean next = false;
        private int columns = 0;
        private boolean MODE_SAVE_KEY = true;
        private boolean MODE_COLUMN_DELIMITED = true;
        private boolean MODE_REQUIRED = true;
        private boolean MODE_UPPERCASE = false;
        private String mode = null;

        private boolean isStandard() {
            return !this.MODE_SAVE_KEY && !this.MODE_COLUMN_DELIMITED && !this.MODE_REQUIRED && !this.MODE_UPPERCASE;
        }

        @Override
        public boolean isFocusTraversable() {
            return this.isEditable();
        }

        public void setMode(String mode) {
            this.mode = mode;
            if (mode != null) {
                if (mode.indexOf(83) >= 0) {
                    this.MODE_SAVE_KEY = true;
                }
                if (mode.indexOf(115) >= 0) {
                    this.MODE_SAVE_KEY = false;
                }
                if (mode.indexOf(67) >= 0) {
                    this.MODE_COLUMN_DELIMITED = true;
                }
                if (mode.indexOf(99) >= 0) {
                    this.MODE_COLUMN_DELIMITED = false;
                }
                if (mode.indexOf(82) >= 0) {
                    this.MODE_REQUIRED = true;
                }
                if (mode.indexOf(114) >= 0) {
                    this.MODE_REQUIRED = false;
                }
                if (mode.indexOf(85) >= 0) {
                    this.MODE_UPPERCASE = true;
                }
                if (mode.indexOf(117) >= 0) {
                    this.MODE_UPPERCASE = false;
                }
            }
        }

        public String getMode() {
            return this.mode;
        }

        public TextFieldComponent() {
        }

        public TextFieldComponent(int cols) {
            super(cols);
            this.columns = cols;
            this.oldLength = cols;
        }

        public TextFieldComponent(String l) {
            super(l);
            this.columns = l.length();
            this.oldLength = l.length();
        }

        public TextFieldComponent(String l, int cols) {
            super(l, cols);
            this.columns = cols;
            this.oldLength = l.length();
        }

        @Override
        public synchronized Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (this.columns > 0) {
                FontMetrics fm = Utils.getFontMetrics(this.getFont());
                int widthOfFont = fm.getMaxAdvance();
                int widthOfW = fm.charWidth('W');
                if (widthOfW > widthOfFont) {
                    widthOfFont = widthOfW;
                }
                if (widthOfFont > widthOfW + 1) {
                    widthOfFont = widthOfW + 1;
                }
                d = new Dimension(widthOfFont * this.columns + 2, d.height);
            }
            return d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleEvent(Event evt) {
            if (!(this.MODE_SAVE_KEY || this.MODE_COLUMN_DELIMITED || this.MODE_REQUIRED || this.MODE_UPPERCASE)) {
                return super.handleEvent(evt);
            }
            try {
                Object text;
                Event myEvent = null;
                if (this.MODE_UPPERCASE && evt.key >= 97 && evt.key <= 122) {
                    evt.key = Character.toUpperCase((char)evt.key);
                }
                if (evt.id == 1005 && ((text = this.getText()) == null || ((String)text).trim().equals(""))) {
                    Toolkit.getDefaultToolkit().beep();
                }
                if (priorEvent != null && evt.id != 1005) {
                    text = lockObject;
                    synchronized (text) {
                        myEvent = priorEvent;
                        priorEvent = null;
                    }
                }
                boolean cache = false;
                if (evt.id == 1004 && myEvent != null && myEvent != null) {
                    switch (myEvent.key) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 27: 
                        case 127: 
                        case 1006: 
                        case 1007: 
                        case 1008: 
                        case 1009: 
                        case 1010: 
                        case 1011: 
                        case 1012: 
                        case 1013: 
                        case 1014: 
                        case 1015: 
                        case 1016: 
                        case 1017: 
                        case 1018: 
                        case 1019: 
                        case 1020: 
                        case 1022: 
                        case 1023: 
                        case 1025: {
                            if (this.isStandard()) break;
                            this.selectAll();
                            break;
                        }
                        default: {
                            if (!this.isStandard()) {
                                this.setText("" + (char)myEvent.key);
                                this.select(0, 0);
                                this.setCaretPosition(1);
                            }
                            return true;
                        }
                    }
                }
                if (evt.id != 402 && evt.id != 404 && evt.id != 403 && evt.id != 401) {
                    boolean result = super.handleEvent(evt);
                    if (cache && !this.isStandard()) {
                        this.select(0, 0);
                        this.setCaretPosition(1);
                    }
                    return result;
                }
                boolean result = true;
                switch (evt.key) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 27: 
                    case 127: 
                    case 1006: 
                    case 1007: 
                    case 1008: 
                    case 1009: 
                    case 1010: 
                    case 1011: 
                    case 1012: 
                    case 1013: 
                    case 1014: 
                    case 1015: 
                    case 1016: 
                    case 1017: 
                    case 1018: 
                    case 1019: 
                    case 1020: 
                    case 1022: 
                    case 1023: 
                    case 1025: {
                        result = super.handleEvent(evt);
                        break;
                    }
                    default: {
                        String text2 = this.getText();
                        this.oldLength = this.length;
                        this.length = text2.length();
                        if (text2 != null && this.oldLength < this.length) {
                            Object object = lockObject;
                            synchronized (object) {
                                if (text2.length() > this.columns && this.MODE_COLUMN_DELIMITED) {
                                    this.next = true;
                                }
                            }
                        }
                        if (this.next) break;
                        result = super.handleEvent(evt);
                    }
                }
                if (this.next && this.MODE_COLUMN_DELIMITED) {
                    this.next = false;
                    try {
                        this.transferFocus();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.MODE_SAVE_KEY) {
                        priorEvent = evt;
                    }
                    return false;
                }
                return result;
            }
            catch (Exception handleEventException) {
                return true;
            }
        }
    }

    private static class AppletComponent
    extends Panel {
        private Vector<Image> images = new Vector();
        private Vector<Rectangle> rectangles = new Vector();

        public AppletComponent() {
        }

        public AppletComponent(String title) {
        }

        @Override
        public boolean handleEvent(Event evt) {
            if (SynkronixGuiImpl.handleEvent(evt)) {
                return true;
            }
            boolean handled = false;
            switch (evt.id) {
                case 504: {
                    handled = this.mouseEnter(evt, evt.x, evt.y);
                    break;
                }
                case 505: {
                    handled = this.mouseExit(evt, evt.x, evt.y);
                    break;
                }
                case 503: {
                    handled = this.mouseMove(evt, evt.x, evt.y);
                    break;
                }
                case 506: {
                    handled = this.mouseDrag(evt, evt.x, evt.y);
                    break;
                }
                case 501: {
                    handled = this.mouseDown(evt, evt.x, evt.y);
                    break;
                }
                case 502: {
                    handled = this.mouseUp(evt, evt.x, evt.y);
                    break;
                }
                case 401: 
                case 403: {
                    handled = this.keyDown(evt, evt.key);
                    break;
                }
                case 402: 
                case 404: {
                    handled = this.keyUp(evt, evt.key);
                    break;
                }
                case 1004: {
                    handled = this.gotFocus(evt, evt.target);
                    break;
                }
                case 1005: {
                    handled = this.lostFocus(evt, evt.target);
                    break;
                }
                case 1001: {
                    handled = this.action(evt, evt.target);
                }
            }
            return handled ? true : super.handleEvent(evt);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.drawImages(g);
        }

        @Override
        public boolean imageUpdate(Image img, int info, int x, int y, int width, int height) {
            if ((info & 0x20) != 0) {
                this.repaint();
                return false;
            }
            return true;
        }

        public synchronized void registerImage(Image img, Rectangle r) {
            this.images.addElement(img);
            this.rectangles.addElement(r);
        }

        public synchronized void unregisterImage(Image img) {
            for (int i = 0; i < this.images.size(); ++i) {
                Image myi = this.images.elementAt(i);
                if (myi != img) continue;
                this.images.removeElementAt(i);
                this.rectangles.removeElementAt(i);
            }
        }

        public synchronized void drawImages(Graphics g) {
            for (int i = 0; i < this.images.size(); ++i) {
                Image myi = this.images.elementAt(i);
                Rectangle r = this.rectangles.elementAt(i);
                int x = r.x;
                int y = r.y;
                int w = r.width;
                int h = r.height;
                if (w >= 0 && h >= 0) {
                    g.drawImage(myi, x, y, w, h, this);
                    continue;
                }
                g.drawImage(myi, x, y, this);
            }
        }
    }

    private static class FrameComponent
    extends Frame
    implements WindowListener {
        private Variable graphics = null;
        private ICobolInterface program = null;
        private int paragraph = -1;
        private Vector<Image> images = new Vector();
        private Vector<Rectangle> rectangles = new Vector();
        private boolean tiled = false;

        @Override
        public void setVisible(boolean state) {
            if (state && !this.tiled) {
                Dimension d = this.getSize();
                this.setLocation(Tiler.getNextLocation(d.width, d.height));
                this.tiled = true;
            }
            super.setVisible(state);
        }

        @Override
        public void setSize(int width, int height) {
            if (!this.tiled) {
                Dimension d = this.getSize();
                this.setLocation(Tiler.getNextLocation(d.width, d.height));
                this.tiled = true;
            }
            super.setSize(width, height);
        }

        public FrameComponent() {
            this.addNotify();
            this.addWindowListener(this);
            Image iconImage = Utilities.getIconImage();
            if (iconImage != null) {
                this.setIconImage(iconImage);
            }
        }

        public FrameComponent(String title) {
            this.setTitle(title);
            this.addNotify();
            this.addWindowListener(this);
            Image iconImage = Utilities.getIconImage();
            if (iconImage != null) {
                this.setIconImage(iconImage);
            }
        }

        public FrameComponent(String title, Variable graphics, ICobolInterface program, int paragraph) {
            this.setTitle(title);
            this.addNotify();
            this.graphics = graphics;
            this.program = program;
            this.paragraph = paragraph;
            this.addWindowListener(this);
            Image iconImage = Utilities.getIconImage();
            if (iconImage != null) {
                this.setIconImage(iconImage);
            }
        }

        @Override
        public boolean handleEvent(Event evt) {
            if (SynkronixGuiImpl.handleEvent(evt)) {
                return true;
            }
            boolean handled = false;
            switch (evt.id) {
                case 504: {
                    handled = this.mouseEnter(evt, evt.x, evt.y);
                    break;
                }
                case 505: {
                    handled = this.mouseExit(evt, evt.x, evt.y);
                    break;
                }
                case 503: {
                    handled = this.mouseMove(evt, evt.x, evt.y);
                    break;
                }
                case 506: {
                    handled = this.mouseDrag(evt, evt.x, evt.y);
                    break;
                }
                case 501: {
                    handled = this.mouseDown(evt, evt.x, evt.y);
                    break;
                }
                case 502: {
                    handled = this.mouseUp(evt, evt.x, evt.y);
                    break;
                }
                case 401: 
                case 403: {
                    handled = this.keyDown(evt, evt.key);
                    break;
                }
                case 402: 
                case 404: {
                    handled = this.keyUp(evt, evt.key);
                    break;
                }
                case 1004: {
                    handled = this.gotFocus(evt, evt.target);
                    break;
                }
                case 1005: {
                    handled = this.lostFocus(evt, evt.target);
                    break;
                }
                case 1001: {
                    handled = this.action(evt, evt.target);
                }
            }
            return handled ? true : super.handleEvent(evt);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.graphics != null) {
                this.graphics.setGuiObject(g);
                if (this.paragraph != -1) {
                    try {
                        this.program.run(-1, this.paragraph);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.drawImages(g);
        }

        @Override
        public boolean imageUpdate(Image img, int info, int x, int y, int width, int height) {
            if ((info & 0x20) != 0) {
                this.repaint();
                return false;
            }
            return true;
        }

        public synchronized void registerImage(Image img, Rectangle r) {
            this.images.addElement(img);
            this.rectangles.addElement(r);
        }

        public synchronized void unregisterImage(Image img) {
            for (int i = 0; i < this.images.size(); ++i) {
                Image myi = this.images.elementAt(i);
                if (myi != img) continue;
                this.images.removeElementAt(i);
                this.rectangles.removeElementAt(i);
            }
        }

        public synchronized void drawImages(Graphics g) {
            for (int i = 0; i < this.images.size(); ++i) {
                Image myi = this.images.elementAt(i);
                Rectangle r = this.rectangles.elementAt(i);
                int x = r.x;
                int y = r.y;
                int w = r.width;
                int h = r.height;
                if (w >= 0 && h >= 0) {
                    g.drawImage(myi, x, y, w, h, this);
                    continue;
                }
                g.drawImage(myi, x, y, this);
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.handleEvent(new Event(this, 201, e.getWindow()));
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            this.handleEvent(new Event(this, 204, e.getWindow()));
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.handleEvent(new Event(this, 203, e.getWindow()));
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.handleEvent(new Event(this, 202, e.getWindow()));
        }
    }

    private static class ImageComponent
    extends Canvas
    implements ImageObserver {
        private int width = 1;
        private int height = 1;
        private Image img = null;
        private String filename = "unknown.jpg";

        public ImageComponent() {
        }

        public ImageComponent(int w, int h) {
            this.width = w;
            this.height = h;
        }

        public ImageComponent(String filename, int w, int h) {
            this.width = w;
            this.height = h;
            this.setName(filename);
        }

        public void setWidth(int w) {
            this.width = w;
        }

        public void setHeight(int h) {
            this.height = h;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void setSize(int w, int h) {
            this.width = w;
            this.height = h;
            super.setSize(w, h);
        }

        @Override
        public String getName() {
            return this.filename;
        }

        @Override
        public void setName(String filename) {
            this.filename = filename;
            try {
                this.addNotify();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.img = MediaImage.getImage(filename, this);
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            try {
                if (this.img != null) {
                    g.drawImage(this.img, 0, 0, this.width, this.height, this);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public boolean imageUpdate(Image img, int info, int x, int y, int width, int height) {
            if ((info & 0x20) != 0) {
                this.repaint();
                return false;
            }
            return true;
        }

        @Override
        public Dimension preferredSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public Dimension minimumSize() {
            return this.preferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.preferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.preferredSize();
        }
    }
}

