/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.BTreeHandler;
import com.heirloomcomputing.ecs.exec.BTreeIndexedFile;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.RecordBlockFileBTreeHandler;
import com.heirloomcomputing.ecs.exec.recordBlockFile;
import com.heirloomcomputing.ecs.exec.recordPointer;

public class SynkronixIndexedFile
extends BTreeIndexedFile {
    public static final byte fileMajorVersion = 1;
    public static final byte fileMinorVersion = 0;
    private recordBlockFile file = null;
    private int headerSize = -1;
    private int numHandlers = 0;

    public static void debug(String text) {
        LogSetup.LOGGER.finer("SynkronixIndexedFile: " + text);
    }

    private final byte[] toHeaderBytes() {
        byte[] tempInt;
        byte[] extendedHeader = new byte[this.headerSize];
        int index = 1;
        extendedHeader[0] = (byte)(this.numberOfKeys - 128);
        for (int count = 0; count < this.numberOfKeys; ++count) {
            tempInt = ConvertData.intToBytes(this.keyLength[count]);
            System.arraycopy(tempInt, 0, extendedHeader, index, 4);
            Object startLocation = this.keyStartLocation[count];
            long startBlock = 0L;
            int recKey = 0;
            if (startLocation instanceof recordPointer) {
                startBlock = ((recordPointer)startLocation).getBlockNumber();
                recKey = ((recordPointer)startLocation).getRecordKey();
            }
            byte[] tempLong = ConvertData.longToBytes(startBlock);
            System.arraycopy(tempLong, 0, extendedHeader, index + 4, 8);
            tempInt = ConvertData.intToBytes(recKey);
            System.arraycopy(tempInt, 0, extendedHeader, index + 12, 4);
            extendedHeader[index + 16] = this.keyDuplicates[count] ? (byte)1 : 0;
            index += 17;
        }
        tempInt = ConvertData.intToBytes(this.maximum);
        System.arraycopy(tempInt, 0, extendedHeader, index, 4);
        tempInt = ConvertData.intToBytes(this.minimum);
        System.arraycopy(tempInt, 0, extendedHeader, index + 4, 4);
        return extendedHeader;
    }

    private final boolean fromHeaderBytes(byte[] extendedHeader) {
        byte[] tempInt = new byte[4];
        byte[] tempLong = new byte[8];
        int index = 1;
        if (extendedHeader.length != this.headerSize) {
            return false;
        }
        int tempNumberOfKeys = extendedHeader[0] + 128;
        if (this.numberOfKeys != tempNumberOfKeys) {
            return false;
        }
        for (int count = 0; count < this.numberOfKeys; ++count) {
            boolean Duplicates;
            System.arraycopy(extendedHeader, index, tempInt, 0, 4);
            int length = ConvertData.bytesToInt(tempInt);
            if (this.keyLength[count] != length) {
                return false;
            }
            boolean bl = Duplicates = extendedHeader[index + 16] == 1;
            if (this.keyDuplicates[count] != Duplicates) {
                return false;
            }
            System.arraycopy(extendedHeader, index + 4, tempLong, 0, 8);
            long startBlock = ConvertData.bytesToLong(tempLong);
            System.arraycopy(extendedHeader, index + 12, tempInt, 0, 4);
            int startKey = ConvertData.bytesToInt(tempInt);
            this.keyStartLocation[count] = new recordPointer(startBlock, startKey);
            index += 17;
        }
        System.arraycopy(extendedHeader, index, tempInt, 0, 4);
        int max = ConvertData.bytesToInt(tempInt);
        if (max != this.maximum) {
            return false;
        }
        System.arraycopy(extendedHeader, index + 4, tempInt, 0, 4);
        int min = ConvertData.bytesToInt(tempInt);
        return min == this.minimum;
    }

    @Override
    boolean file_init(String filename) {
        int bSize;
        this.file = null;
        this.headerSize = -1;
        this.numHandlers = 0;
        int blockSize = 512;
        if (this.maximum > 0) {
            int maxr;
            int maxb;
            int desiredRecsPerBlock;
            if (this.blockTo > 0) {
                if (this.isRecords) {
                    blockSize = this.blockTo * this.maximum;
                } else if (this.blockTo > this.maximum) {
                    blockSize = this.blockTo;
                }
            }
            if ((desiredRecsPerBlock = ((maxb = 16351) - (maxr = this.maximum + 5)) / (maxb / 5) + 1) < 1) {
                desiredRecsPerBlock = 1;
            }
            blockSize = desiredRecsPerBlock * (this.maximum + 5) + 33;
        }
        this.headerSize = 1 + 17 * this.numberOfKeys + 8;
        if (this.headerSize + 52 > blockSize) {
            blockSize = this.headerSize + 52;
        }
        for (bSize = 512; blockSize > bSize; bSize <<= 1) {
        }
        int fileBlockSize = blockSize = bSize;
        short fileHeaderSize = (short)(32 + this.headerSize);
        byte[] extendedHeader = this.toHeaderBytes();
        this.file = new recordBlockFile(1, 0, fileHeaderSize, fileBlockSize, extendedHeader, this.dataLockRecord, this.idxLockRecord);
        this.file_setFilename(filename);
        return true;
    }

    @Override
    boolean file_setFilename(String filename) {
        if (this.file == null) {
            return false;
        }
        this.file.setFilename(filename);
        return true;
    }

    @Override
    int file_open(int mode) {
        if (this.readOnlyCaching) {
            this.file.setReadOnlyCaching(true);
        }
        this.file.setCharsetName(this.getCharsetName());
        return this.file.open(mode);
    }

    @Override
    int file_close(int mode) {
        int status = this.file.close(mode);
        if (status == 0) {
            this.numHandlers = 0;
        }
        return status;
    }

    @Override
    int file_close() {
        int status = this.file.close();
        if (status == 0) {
            this.numHandlers = 0;
        }
        return status;
    }

    @Override
    int file_setHeaderInformation() {
        byte[] extendedHeader = this.toHeaderBytes();
        this.file.setExtendedHeader(extendedHeader);
        return this.file.updateHeaderInformation();
    }

    @Override
    boolean file_getHeaderInformation() {
        byte[] myExtendedHeader = this.file.getExtendedHeader();
        return this.fromHeaderBytes(myExtendedHeader);
    }

    @Override
    BTreeHandler file_getBTreeHandler() {
        return new RecordBlockFileBTreeHandler(this.file, this.numHandlers++);
    }

    @Override
    Object file_addData(byte[] data) {
        return this.file_addData(data, 0, data.length);
    }

    @Override
    Object file_addData(byte[] data, int offset, int length) {
        try {
            int recordKey;
            long blockNumber;
            if (LogSetup.IS_LOGGING) {
                SynkronixIndexedFile.debug("Called file_addData");
            }
            if ((blockNumber = this.file.findRecordBlock(length)) < 0L) {
                if (LogSetup.IS_LOGGING) {
                    SynkronixIndexedFile.debug("blockNumber < 0!, blockNumber=" + blockNumber);
                }
                return null;
            }
            if (LogSetup.IS_LOGGING) {
                SynkronixIndexedFile.debug("Calling addRecord(" + blockNumber + ", " + new String(data) + ")");
            }
            if ((recordKey = this.file.addRecord(blockNumber, data, offset, length)) < 0) {
                if (LogSetup.IS_LOGGING) {
                    SynkronixIndexedFile.debug("recordKey < 0!, recordKey=" + recordKey);
                }
                return null;
            }
            return new recordPointer(blockNumber, recordKey);
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error adding record to indexed file", t);
            return null;
        }
    }

    @Override
    int file_removeData(Object location) {
        if (!(location instanceof recordPointer)) {
            return -30;
        }
        recordPointer p = (recordPointer)location;
        long blockNumber = p.getBlockNumber();
        int recordKey = p.getRecordKey();
        int result = this.file.deleteRecord(blockNumber, recordKey);
        return result;
    }

    @Override
    boolean file_isOpen() {
        if (this.file == null) {
            return false;
        }
        return this.file.fileIsOpen();
    }

    @Override
    boolean file_isInput() {
        if (this.file == null) {
            return false;
        }
        return this.file.isInput();
    }

    @Override
    boolean file_isOutput() {
        if (this.file == null) {
            return false;
        }
        return this.file.isOutput();
    }

    @Override
    boolean file_isIO() {
        if (this.file == null) {
            return false;
        }
        return this.file.isIO();
    }

    @Override
    boolean file_isExtend() {
        if (this.file == null) {
            return false;
        }
        return this.file.isExtend();
    }

    @Override
    boolean file_isWritable() {
        if (this.file == null) {
            return false;
        }
        return this.file.isWritable();
    }

    @Override
    boolean file_isReadable() {
        if (this.file == null) {
            return false;
        }
        return this.file.isReadable();
    }

    @Override
    boolean file_isNewFile() {
        if (this.file == null) {
            return false;
        }
        return this.file.isNewFile();
    }

    @Override
    void file_flushCache() {
        if (this.file != null) {
            this.file.flushCache();
        }
    }

    @Override
    void file_reset() {
        if (this.file != null) {
            this.file.reset();
        }
    }

    @Override
    boolean file_deleteFile() {
        if (this.file != null) {
            return this.file.deleteFile();
        }
        return false;
    }

    @Override
    boolean file_dataLock(Object lockObject) {
        if (!(lockObject instanceof recordPointer)) {
            return false;
        }
        recordPointer p = (recordPointer)lockObject;
        long blockNum = p.getBlockNumber();
        int key = p.getRecordKey();
        long val = (blockNum + 1L << 8 | (long)(key & 0xFF)) + 1L;
        return this.dataLockRecord.lock(val);
    }

    @Override
    boolean file_dataUnlock(Object lockObject) {
        if (!(lockObject instanceof recordPointer)) {
            return false;
        }
        recordPointer p = (recordPointer)lockObject;
        long blockNum = p.getBlockNumber();
        int key = p.getRecordKey();
        long val = (blockNum + 1L << 8 | (long)(key & 0xFF)) + 1L;
        this.dataLockRecord.unlock(val);
        return true;
    }

    @Override
    int file_mapStatusCode(int status) {
        return status;
    }
}

