/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.ExitProgramException;
import com.heirloomcomputing.ecs.exec.ProcedurePointer;
import com.heirloomcomputing.ecs.exec.SqlContext;

public class UnwindException
extends RuntimeException {
    public static final int UNWIND = 0;
    public static final int XCTL = 3588;
    public static final int RETURN = 3592;
    public static final int ABEND_PROGRAM = 3598;
    private ProcedurePointer procPointer;
    private int eibfn;

    public UnwindException(int eibfn) {
        this.eibfn = eibfn;
    }

    public UnwindException(ProcedurePointer procPointer) {
        this.procPointer = procPointer;
    }

    public int getFN() {
        return this.eibfn;
    }

    public ProcedurePointer getProcedurePointer() {
        return this.procPointer;
    }

    public int getEntryPoint() {
        if (this.procPointer != null) {
            return this.procPointer.getParagraph();
        }
        return -1;
    }

    public Object getProgram() {
        if (this.procPointer != null) {
            return this.procPointer.getProgramObject();
        }
        return null;
    }

    public Context getContext() {
        if (this.procPointer != null) {
            return this.procPointer.getContext();
        }
        return null;
    }

    public int unwind(Context context, Object program) throws UnwindException {
        SqlContext sqlContext = context.getExistingSqlContext();
        if (sqlContext != null && !context.isProgramCalled()) {
            sqlContext.exit();
        }
        switch (this.eibfn) {
            case 3588: {
                throw new ExitProgramException("UNWIND XCTL");
            }
            case 3592: {
                throw new ExitProgramException("UNWIND RETURN");
            }
            case 3598: {
                throw new ExitProgramException("UNWIND ABEND PROGRAM");
            }
        }
        Context otherContext = this.getContext();
        if (context != null && otherContext != null) {
            if (context != otherContext) {
                throw this;
            }
            return this.getEntryPoint();
        }
        if (program != this.getProgram()) {
            throw this;
        }
        return this.getEntryPoint();
    }

    public int unwind(Context context) throws UnwindException {
        switch (this.eibfn) {
            case 3588: 
            case 3592: 
            case 3598: {
                return -1;
            }
        }
        Context otherContext = this.getContext();
        if (context != otherContext) {
            throw this;
        }
        return this.getEntryPoint();
    }
}

