/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.UtilitiesJFCFrame;
import com.heirloomcomputing.ecs.jfc.LWindow;
import com.heirloomcomputing.term.ScreenHandler;
import java.awt.Component;
import java.awt.Container;

class UtilitiesJFC {
    public boolean addTextPaneToSomething(String defaultTitle, ScreenHandler term, Container textPane, boolean mainConsoleExists, boolean useWindowColor) {
        Handle h = null;
        h = IO.getCurrentlyRegisteredWindow();
        if (h != null) {
            try {
                ((LWindow)h.getComponent()).setTextPane(term, textPane);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (mainConsoleExists || !mainConsoleExists && !Utilities.isApplet()) {
            boolean created = false;
            if (h != null) {
                try {
                    LWindow w = (LWindow)h.getComponent();
                    created = !w.isSecondaryWindow() ? w.createContainingWindow(defaultTitle) != null : true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!created) {
                this.createGenericWindow(defaultTitle, textPane, useWindowColor);
            }
        } else {
            if (h != null) {
                Utilities.setMainWindowHandle(h);
            }
            Utilities.reset();
        }
        return true;
    }

    public void createGenericWindow(String defaultTitle, Container textPane, boolean useWindowColor) {
        String useTitle = defaultTitle;
        if (useTitle == null || useTitle.trim().length() == 0) {
            useTitle = Utilities.getDefaultTitle("Application");
        }
        Utilities.setMainWindow(new UtilitiesJFCFrame(useTitle, textPane, useWindowColor), true, Utilities.getIconImage());
    }

    public void createGenericWindow(String defaultTitle, Container textPane) {
        this.createGenericWindow(defaultTitle, textPane, false);
    }

    public void reset(Container panel, Container trackPanel) {
        Handle mainWindowHandle = Utilities.getMainWindowHandle();
        if (mainWindowHandle == null) {
            return;
        }
        try {
            LWindow w = (LWindow)mainWindowHandle.getComponent();
            trackPanel.add((Component)w, "Center");
            w.revalidate();
            w.repaint();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        panel.setVisible(true);
        panel.repaint();
    }
}

