/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.UnbufferedMemory;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public class VariableList
extends Variable {
    private Variable[] list;

    @Override
    public String getClassName() {
        return "com.heirloomcomputing.ecs.exec.VariableList";
    }

    public VariableList(Variable[] pass_list) {
        this.list = pass_list;
        this.itemSize = 0;
        this.pointerMemory = null;
        this.pointerAddress = 0;
        this.valid = false;
        this.dirty = false;
        this.setUsageMisc();
    }

    public VariableList(Variable[] pass_list, String name) {
        this.setName(name);
        this.list = pass_list;
        this.itemSize = 0;
        this.pointerMemory = null;
        this.pointerAddress = 0;
        this.valid = false;
        this.dirty = false;
        this.setUsageMisc();
    }

    public VariableList(Variable[] pass_list, String name, Memory mem, int len) {
        this.setName(name);
        this.list = pass_list;
        this.itemSize = len;
        this.pointerMemory = mem;
        this.pointerAddress = 0;
        this.valid = false;
        this.dirty = false;
        this.setUsageMisc();
    }

    public Variable[] getList() {
        return this.list;
    }

    public void setList(Variable[] data) {
        this.list = data;
    }

    @Override
    public comparableByteArray copy() {
        Variable[] copyVarList = new Variable[this.list.length];
        int sz = 0;
        int off = 0;
        for (Variable fromVar : this.list) {
            off += fromVar.itemSize;
        }
        UnbufferedMemory mem = new UnbufferedMemory(off);
        mem.setDecimal(this.list[0].getDecimal());
        mem.setComma(this.list[0].getComma());
        mem.setCurrency(this.list[0].getCurrency());
        mem.setCollatingSequence(this.list[0].getCollatingSequence());
        off = 0;
        for (Variable fromVar : this.list) {
            fromVar.flushToMemory();
            Variable copy = (Variable)fromVar.clone();
            copy.pointerMemory = mem;
            copy.pointerAddress = off;
            copy.itemSize = fromVar.itemSize;
            copy.notify = null;
            copy.notifyDelayed = false;
            copy.right_array = null;
            copy.left_array = null;
            copy.pointerMemory.copy(fromVar.pointerMemory, fromVar.pointerAddress, copy.pointerAddress, copy.itemSize);
            copyVarList[sz++] = copy;
            off += copy.itemSize;
        }
        return new VariableList(copyVarList, this.getName(), mem, off);
    }

    @Override
    public byte[] toByteArray() {
        byte[] result = new byte[this.length()];
        int off = 0;
        for (Variable aVar : this.list) {
            byte[] part = aVar.toByteArray();
            if (part == null) {
                return null;
            }
            System.arraycopy(part, 0, result, off, part.length);
            off += part.length;
        }
        return result;
    }

    @Override
    public void fromByteArray(byte[] x) {
        if (x == null) {
            return;
        }
        int off = 0;
        for (Variable aVar : this.list) {
            byte[] part = new byte[aVar.length()];
            System.arraycopy(x, off, part, 0, part.length);
            aVar.fromByteArray(part);
            off += part.length;
        }
    }

    @Override
    public Variable moveAll(char parm) {
        for (Variable aVar : this.list) {
            aVar.moveAll(parm);
        }
        return this;
    }

    @Override
    public int length() {
        int tot = 0;
        for (Variable aVar : this.list) {
            tot += aVar.length();
        }
        return tot;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (Variable aKeyPiece : this.list) {
            size += aKeyPiece.getSize();
        }
        return size;
    }

    public void flushComponentsToMemory() {
        if (this.list == null) {
            return;
        }
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] == null) continue;
            this.list[i].flushToMemory();
        }
    }

    public void fillComponentsFromMemory() {
        if (this.list == null) {
            return;
        }
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] == null) continue;
            this.list[i].fillFromMemory();
        }
    }

    public void updateFromComponents() {
        if (this.list == null) {
            return;
        }
        if (this.pointerMemory == null) {
            for (int i = 0; i < this.list.length; ++i) {
                if (this.list[i] == null) continue;
                this.itemSize += this.list[i].length();
            }
            this.pointerMemory = new Memory(this.itemSize, new String[0]);
            this.pointerAddress = 0;
        }
        this.prepareMemoryForWrite();
        int address = 0;
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] == null) continue;
            this.list[i].flushToMemory();
            this.list[i].getMemory().copy(this.list[i].getAddress(), this.getMemory(), address, this.list[i].length());
            address += this.list[i].length();
        }
    }

    public void updateToComponents() {
        if (this.list == null) {
            return;
        }
        if (this.pointerMemory == null) {
            for (int i = 0; i < this.list.length; ++i) {
                if (this.list[i] == null) continue;
                this.itemSize += this.list[i].length();
            }
            this.pointerMemory = new Memory(this.itemSize, new String[0]);
            this.pointerAddress = 0;
        }
        Memory memory = this.getMemory();
        int addr = this.getAddress();
        int offset = 0;
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] == null) continue;
            this.list[i].prepareMemoryForWrite();
            memory.copy(addr + offset, this.list[i].getMemory(), this.list[i].getAddress(), this.list[i].length());
            offset += this.list[i].length();
        }
    }

    @Override
    public void flushDirtyToMemory() {
        this.flushToMemory();
    }

    @Override
    public void flushToMemory() {
        this.updateToComponents();
    }

    @Override
    public void fillFromMemory() {
        this.updateFromComponents();
    }

    @Override
    Variable createKeyFromBytes(byte[] tempBytes, int masterRecordAddress) {
        if (this.list == null) {
            return null;
        }
        VariableList currentKey = (VariableList)this.copy();
        currentKey.prepareMemoryForWrite();
        int address = 0;
        for (int i = 0; i < this.list.length; ++i) {
            currentKey.list[i].getMemory().copy(tempBytes, this.list[i].getAddress() - masterRecordAddress, address, this.list[i].length());
            address += currentKey.list[i].length();
        }
        return currentKey;
    }

    @Override
    public int getAddress() {
        if (this.pointerMemory == null) {
            this.fillFromMemory();
        }
        return super.getAddress();
    }

    @Override
    public void writeBytesToMemory(byte[] bytes, int offset, int len) {
        super.writeBytesToMemory(bytes, offset, len);
        this.flushToMemory();
    }

    public final boolean hasSameAddresses(VariableList b) {
        Variable[] blist = b.getList();
        if (blist == null) {
            return this.list == null;
        }
        if (this.list == null) {
            return false;
        }
        if (this.list.length != blist.length) {
            return false;
        }
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i].getAddress() == blist[i].getAddress()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isVariableList() {
        return true;
    }

    @Override
    public int getType() {
        return this.getBasicType() | 0x20;
    }

    @Override
    public Object[] getElements() {
        return this.list;
    }

    @Override
    public int compareBytes(byte[] bytes, int offset, int len, boolean truncate) {
        this.flushToMemory();
        int totLen = 0;
        for (Variable oneVar : this.list) {
            int l1;
            int address = oneVar.pointerAddress;
            int n = l1 = oneVar.length() > len ? len : oneVar.length();
            while (offset < l1) {
                int result;
                if ((result = (oneVar.pointerMemory.getByte(address++) & 0xFF) - (bytes[offset++] & 0xFF)) == 0) continue;
                return result > 0 ? 1 : -1;
            }
            totLen += this.length();
        }
        if (!truncate) {
            if (this.length() > totLen) {
                return 1;
            }
            if (totLen > this.length()) {
                return -1;
            }
        }
        return 0;
    }
}

