/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecc.HCILicensing;

public class Version {
    private static final String BUILD_VERSION_MAJOR = "25";
    private static final String BUILD_VERSION_MINOR = "10";
    private static final String BUILD_VERSION_SUBMINOR = "28";
    private static final String BUILD_VERSION_SUBSUB = "";
    private static final String BUILD_DATE_TIME = "2025-10-28_18:53:35_UTC on ab9a9a7f14b5 by ";
    private static final String COMPANY_NAME = "Heirloom Computing Inc.";
    private static final String PRODUCT_NAME = "Elastic COBOL";
    private static final String PRODUCT_COPYRIGHT = "Copyright (C) 2010-2018 Heirloom Computing Inc.";
    private static int VERSION_MAJOR = 0;
    private static int VERSION_MINOR = 0;
    private static int VERSION_SUBMINOR = 0;
    private static String VERSION_SUBSUB = "";

    public static void CheckLic() {
        if (!HCILicensing.isJDKSupported()) {
            System.err.println("Java version " + System.getProperty("java.specification.version") + " is not supported! Elastic COBOL plugin currently supports Java version 8 (1.8) only!");
            return;
        }
        String licenseCheckResult = HCILicensing.LicenseCheck("hpaas-cbl-rts", 1, false);
        if (licenseCheckResult.compareTo(BUILD_VERSION_SUBSUB) != 0) {
            System.err.println(licenseCheckResult);
        }
    }

    public static void main(String[] args) {
        Version.outputVersion();
        Version.CheckLic();
    }

    public static void outputVersion() {
        System.out.println(Version.getVersion());
        System.out.println(Version.getCopyright());
        System.out.println(Version.getBuildDateTime());
    }

    public static String getProduct() {
        return PRODUCT_NAME;
    }

    public static String getVersion() {
        return "Elastic COBOL V" + VERSION_MAJOR + "." + VERSION_MINOR + "." + VERSION_SUBMINOR + VERSION_SUBSUB;
    }

    public static String getCompany() {
        return COMPANY_NAME;
    }

    public static String getCopyright() {
        return PRODUCT_COPYRIGHT;
    }

    public static String getBuildDateTime() {
        if (BUILD_DATE_TIME.charAt(0) == '@') {
            return BUILD_VERSION_SUBSUB;
        }
        return "Build 2025-10-28_18:53:35_UTC on ab9a9a7f14b5 by ";
    }

    public static int getMajor() {
        return VERSION_MAJOR;
    }

    public static int getMinor() {
        return VERSION_MINOR;
    }

    public static int getSubMinor() {
        return VERSION_SUBMINOR;
    }

    static {
        try {
            VERSION_MAJOR = Integer.parseInt(BUILD_VERSION_MAJOR);
            VERSION_MINOR = Integer.parseInt(BUILD_VERSION_MINOR);
            VERSION_SUBMINOR = Integer.parseInt(BUILD_VERSION_SUBMINOR);
            if (BUILD_VERSION_SUBSUB.compareTo(BUILD_VERSION_SUBSUB) != 0) {
                VERSION_SUBSUB = ".";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

