/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import java.text.Collator;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.ResourceBundle;

public class XOpenInternational {
    private static Locale locale;
    private static DecimalFormatSymbols dfs;
    public static char zeroSymbol;
    public static char groupingSymbol;
    public static char decimalSymbol;
    public static char percentSymbol;
    public static char currencySymbol;
    public static String intlCurrencySymbol;
    public static String uppercase;
    public static String lowercase;
    public static String collatingSequence;
    public static Collator collator;

    private static char parse(String s) throws NumberFormatException {
        if (s == null || s.length() < 1) {
            throw new NumberFormatException();
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        if (s.length() == 3 && s.charAt(0) == '\'') {
            return s.charAt(1);
        }
        if (s.length() == 3 && s.charAt(0) == '\"') {
            return s.charAt(1);
        }
        try {
            int n = ConvertData.parseInt(s);
            return (char)n;
        }
        catch (Exception exception) {
            throw new NumberFormatException();
        }
    }

    static void init() {
        String[] currencyElements;
        String localeString = RuntimeEnvironment.getGlobalParameter("LANG");
        if (localeString == null) {
            return;
        }
        if (localeString.equalsIgnoreCase("STANDARD")) {
            return;
        }
        if (localeString.equals("") || localeString.equalsIgnoreCase("DEFAULT")) {
            locale = Locale.getDefault();
        } else {
            String lang = null;
            String country = null;
            String variant = null;
            int i = -1;
            if ((i = localeString.indexOf(95, i + 1)) != -1) {
                lang = localeString.substring(0, i);
                int previous = i + 1;
                if ((i = localeString.indexOf(95, i + 1)) != -1) {
                    country = localeString.substring(previous, i);
                    previous = i + 1;
                    if ((i = localeString.indexOf(95, i + 1)) != -1) {
                        variant = localeString.substring(previous);
                    }
                } else {
                    country = localeString.substring(previous);
                }
            } else {
                lang = localeString;
            }
            locale = lang != null ? (country != null ? (variant != null ? new Locale(lang, country, variant) : new Locale(lang, country)) : new Locale(lang, "")) : Locale.getDefault();
        }
        if (locale == null) {
            return;
        }
        dfs = new DecimalFormatSymbols(locale);
        zeroSymbol = dfs.getZeroDigit();
        groupingSymbol = dfs.getGroupingSeparator();
        decimalSymbol = dfs.getDecimalSeparator();
        percentSymbol = dfs.getPercent();
        ResourceBundle rb = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
        if (rb != null && (currencyElements = rb.getStringArray("CurrencyElements")) != null) {
            try {
                currencySymbol = currencyElements[0].charAt(0);
            }
            catch (RuntimeException variant) {
                // empty catch block
            }
            try {
                intlCurrencySymbol = currencyElements[1];
            }
            catch (RuntimeException variant) {
                // empty catch block
            }
        }
        try {
            String temp;
            ResourceBundle cobolBundle = locale != null ? ResourceBundle.getBundle("ecobol", locale) : ResourceBundle.getBundle("ecobol");
            try {
                temp = cobolBundle.getString("intl.currency");
                currencySymbol = XOpenInternational.parse(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                temp = cobolBundle.getString("intl.zero");
                zeroSymbol = XOpenInternational.parse(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                temp = cobolBundle.getString("intl.grouping");
                groupingSymbol = XOpenInternational.parse(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                temp = cobolBundle.getString("intl.comma");
                groupingSymbol = XOpenInternational.parse(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                temp = cobolBundle.getString("intl.decimal");
                decimalSymbol = XOpenInternational.parse(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                temp = cobolBundle.getString("intl.percent");
                percentSymbol = XOpenInternational.parse(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                intlCurrencySymbol = cobolBundle.getString("intl.intlcurrency");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                uppercase = cobolBundle.getString("intl.uppercase");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                lowercase = cobolBundle.getString("intl.lowercase");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                collatingSequence = cobolBundle.getString("intl.collation");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (collatingSequence == null) {
            collator = Collator.getInstance(locale);
        }
    }

    static {
        zeroSymbol = (char)48;
        groupingSymbol = (char)44;
        decimalSymbol = (char)46;
        percentSymbol = (char)37;
        currencySymbol = (char)36;
        intlCurrencySymbol = "USD";
        uppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        lowercase = "abcdefghijklmnopqrstuvwxyz";
        collatingSequence = null;
        try {
            XOpenInternational.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

