/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ProcedurePointer;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.XmlParseAction;
import com.heirloomcomputing.ecs.exec.XmlParseConstants;
import java.io.InputStream;
import java.io.StringReader;

public class XmlParse
implements XmlParseConstants {
    public static final void process(String xmlText, int xmlTextLength, ProcedurePointer processingCode, String options) {
        if (xmlText == null) {
            xmlText = "";
        }
        if (xmlTextLength > 0 && xmlTextLength < xmlText.length()) {
            xmlText = xmlText.substring(0, xmlTextLength);
        }
        XmlParse.process(xmlText, processingCode, options);
    }

    public static final void process(String xmlText, ProcedurePointer processingCode, String options) {
        if (xmlText == null) {
            xmlText = "";
        }
        if (processingCode == null) {
            throw new RuntimeException("NO PROCEDURE TO EXECUTE");
        }
        new XmlParseAction(new StringReader(xmlText), processingCode, options, xmlText).parse();
    }

    public static InputStream getInputStream(ClassLoader classLoader, String resourceName) {
        return Utilities.getInputStream(classLoader, resourceName);
    }

    public static final void process(InputStream xmlText, ProcedurePointer processingCode, String options) {
        if (xmlText == null) {
            throw new RuntimeException("INVALID RESOURCE NAME");
        }
        if (processingCode == null) {
            throw new RuntimeException("NO PROCEDURE TO EXECUTE");
        }
        new XmlParseAction(xmlText, processingCode, options, "").parse();
    }
}

