/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.ProcedurePointer;
import com.heirloomcomputing.ecs.exec.XMLUserRuntimeException;
import com.heirloomcomputing.ecs.exec.XmlParseConstants;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class XmlParseAction
implements XmlParseConstants,
ContentHandler,
ErrorHandler {
    private ProcedurePointer processingCode;
    private Context context;
    private Reader reader;
    private InputStream inputStream;
    private String options;
    private String data;
    private boolean featureWhitespace;
    private boolean isUserAction;
    private XMLReader xmlReader;

    public XmlParseAction(Reader reader, ProcedurePointer processingCode, String options, String data) {
        this.processingCode = processingCode;
        this.reader = reader;
        this.options = options;
        this.data = data;
        this.context = processingCode.getContext();
        this.context.resetXmlSpecialRegisters();
    }

    public XmlParseAction(InputStream inputStream, ProcedurePointer processingCode, String options, String data) {
        this.processingCode = processingCode;
        this.inputStream = inputStream;
        this.options = options;
        this.data = data;
        this.context = processingCode.getContext();
        this.context.resetXmlSpecialRegisters();
    }

    private boolean setOptions(Object passSpf, String options) {
        block42: {
            String locase;
            block41: {
                SAXParserFactory spf;
                block40: {
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    if (options == null) {
                                        return false;
                                    }
                                    spf = (SAXParserFactory)passSpf;
                                    locase = options.toLowerCase();
                                    try {
                                        if (locase.indexOf("nons:") >= 0) {
                                            spf.setNamespaceAware(false);
                                        } else if (locase.indexOf("ns:") >= 0) {
                                            spf.setNamespaceAware(true);
                                        }
                                    }
                                    catch (Throwable t) {
                                        if (!this.handleException(t)) break block36;
                                        return true;
                                    }
                                }
                                try {
                                    if (locase.indexOf("nonsp:") >= 0) {
                                        spf.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                                    } else if (locase.indexOf("nsp:") >= 0) {
                                        spf.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                                    }
                                }
                                catch (Throwable t) {
                                    if (!this.handleException(t)) break block37;
                                    return true;
                                }
                            }
                            try {
                                if (locase.indexOf("noint:") >= 0) {
                                    spf.setFeature("http://xml.org/sax/features/string-interning", false);
                                } else if (locase.indexOf("int:") >= 0) {
                                    spf.setFeature("http://xml.org/sax/features/string-interning", true);
                                }
                            }
                            catch (Throwable t) {
                                if (!this.handleException(t)) break block38;
                                return true;
                            }
                        }
                        try {
                            if (locase.indexOf("noval:") >= 0) {
                                spf.setValidating(false);
                            } else if (locase.indexOf("val:") >= 0) {
                                spf.setValidating(true);
                            }
                        }
                        catch (Throwable t) {
                            if (!this.handleException(t)) break block39;
                            return true;
                        }
                    }
                    try {
                        if (locase.indexOf("nogen:") >= 0) {
                            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                        } else if (locase.indexOf("gen:") >= 0) {
                            spf.setFeature("http://xml.org/sax/features/external-general-entities", true);
                        }
                    }
                    catch (Throwable t) {
                        if (!this.handleException(t)) break block40;
                        return true;
                    }
                }
                try {
                    if (locase.indexOf("nopar:") >= 0) {
                        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    } else if (locase.indexOf("par:") >= 0) {
                        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
                    }
                }
                catch (Throwable t) {
                    if (!this.handleException(t)) break block41;
                    return true;
                }
            }
            try {
                if (locase.indexOf("nows:") >= 0) {
                    this.featureWhitespace = false;
                } else if (locase.indexOf("ws:") >= 0) {
                    this.featureWhitespace = true;
                }
            }
            catch (Throwable t) {
                if (!this.handleException(t)) break block42;
                return true;
            }
        }
        return false;
    }

    private boolean handleException(Throwable t) {
        return this.handleException(t, false);
    }

    private boolean handleException(Throwable t, boolean shouldAbort) {
        if (t != null) {
            this.processException(t);
            if (shouldAbort) {
                throw new RuntimeException(t.toString());
            }
        }
        if (shouldAbort) {
            throw new RuntimeException("XML EXCEPTION");
        }
        return shouldAbort;
    }

    public void parse() {
        block10: {
            block9: {
                try {
                    this.createParser14();
                }
                catch (Throwable cannotCreate14Parser) {
                    block8: {
                        try {
                            this.createParser13();
                        }
                        catch (Throwable cannotCreate13Parser) {
                            if (!this.handleException(cannotCreate13Parser, true)) break block8;
                            return;
                        }
                    }
                    if (this.xmlReader != null || !this.handleException(cannotCreate14Parser, true)) break block9;
                    return;
                }
            }
            try {
                this.xmlReader.setContentHandler(this);
                this.xmlReader.setErrorHandler(this);
                if (this.reader != null) {
                    this.xmlReader.parse(new InputSource(this.reader));
                } else {
                    this.xmlReader.parse(new InputSource(this.inputStream));
                }
            }
            catch (Throwable t) {
                if (!this.handleException(t, true)) break block10;
                return;
            }
        }
    }

    public void createParser14() throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        this.setOptions(spf, this.options);
        SAXParser saxParser = spf.newSAXParser();
        this.xmlReader = saxParser.getXMLReader();
    }

    public void createParser13() throws Exception {
        try {
            this.xmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (Throwable t) {
            this.xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        }
    }

    @Override
    public void error(SAXParseException error) {
        if (this.handleException(error, true)) {
            // empty if block
        }
    }

    @Override
    public void fatalError(SAXParseException error) {
        this.handleException(error, true);
        throw new RuntimeException(error.toString());
    }

    @Override
    public void warning(SAXParseException error) {
        if (this.handleException(error, false)) {
            // empty if block
        }
    }

    private void process(String xmlEvent) {
        this.process(xmlEvent, "");
    }

    private void process(String xmlEvent, String xmlText) {
        Numeric xmlCode = this.context.getXmlCode();
        this.context.setXmlEvent(xmlEvent);
        this.context.setXmlText(xmlText);
        xmlCode.move(0);
        this.processingCode.perform();
        int xmlCodeValue = xmlCode.toInt();
        if (xmlCodeValue < 0) {
            if (xmlEvent != "EXCEPTION" && xmlCodeValue == -1) {
                this.setUserAction(true);
                throw new XMLUserRuntimeException("XML USER EXCEPTION " + xmlCodeValue);
            }
            throw new RuntimeException("XML USER EXCEPTION " + xmlCodeValue);
        }
    }

    private void processException(Throwable t) {
        if (t instanceof SAXException) {
            if (t instanceof SAXParseException) {
                this.processException(100, t.toString());
            }
        } else if (t instanceof Exception) {
            if (t instanceof XMLUserRuntimeException) {
                this.processException(-1, t.toString());
            } else if (t instanceof RuntimeException) {
                this.processException(600, t.toString());
            } else {
                this.processException(500, t.toString());
            }
        } else {
            this.processException(700, t.toString());
        }
    }

    private void processException(int exceptionCode) {
        this.processException(exceptionCode, "");
    }

    private void processException(int exceptionCode, String xmlText) {
        int xmlCodeValue;
        Numeric xmlCode = this.context.getXmlCode();
        this.context.setXmlEvent("EXCEPTION");
        this.context.setXmlText(xmlText);
        xmlCode.move(exceptionCode);
        if (!this.isUserAction) {
            this.processingCode.perform();
        }
        if ((xmlCodeValue = xmlCode.toInt()) != 0) {
            if (this.isUserAction) {
                throw new XMLUserRuntimeException("XML RUNTIME EXCEPTION " + xmlCodeValue);
            }
            throw new RuntimeException("XML RUNTIME EXCEPTION " + xmlCodeValue);
        }
    }

    @Override
    public void startDocument() {
        if (this.data == null) {
            this.data = "";
        }
        this.process("START-OF-DOCUMENT", this.data);
        this.data = null;
    }

    @Override
    public void endDocument() {
        this.process("END-OF-DOCUMENT");
        this.data = null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        if (localName == null || localName.length() == 0) {
            localName = qName;
        }
        if (localName == null) {
            return;
        }
        this.process("START-OF-ELEMENT", localName);
        if (attrs != null) {
            int length = attrs.getLength();
            for (int i = 0; i < length; ++i) {
                localName = attrs.getLocalName(i);
                if (localName == null || localName.length() == 0) {
                    localName = attrs.getQName(i);
                }
                this.process("ATTRIBUTE-NAME", localName);
                String value = attrs.getValue(i);
                if (value == null) continue;
                if (value.length() == 1) {
                    switch (value.charAt(0)) {
                        case '\"': 
                        case '&': 
                        case '\'': 
                        case '<': 
                        case '>': {
                            this.process("ATTRIBUTE-CHARACTER", value);
                            break;
                        }
                        default: {
                            this.process("ATTRIBUTE-CHARACTERS", value);
                            break;
                        }
                    }
                    continue;
                }
                this.process("ATTRIBUTE-CHARACTERS", value);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (localName == null || localName.length() == 0) {
            localName = qName;
        }
        if (localName == null) {
            return;
        }
        this.process("END-OF-ELEMENT", localName);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (length > 0) {
            this.processCharacters(new String(ch, start, length));
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.featureWhitespace && length > 0) {
            this.processCharacters(new String(ch, start, length));
        }
    }

    private void processCharacters(String xmlText) {
        if (xmlText == null) {
            return;
        }
        if (xmlText.length() == 1) {
            switch (xmlText.charAt(0)) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    this.process("CONTENT-CHARACTER", xmlText);
                    return;
                }
            }
        }
        this.process("CONTENT-CHARACTERS", xmlText);
    }

    @Override
    public void processingInstruction(String target, String data) {
        if (target == null) {
            return;
        }
        if (target.equalsIgnoreCase("xml")) {
            if (data != null) {
                int finalIndex;
                int index = data.indexOf("version");
                if (index >= 0) {
                    index = data.indexOf(34, index + 1);
                    finalIndex = data.indexOf(34, index + 1);
                    if (index >= 0 && finalIndex > index) {
                        this.process("VERSION-INFORMATION", data.substring(index + 1, finalIndex));
                    }
                }
                if ((index = data.indexOf("encoding")) >= 0) {
                    index = data.indexOf(34, index + 1);
                    finalIndex = data.indexOf(34, index + 1);
                    if (index >= 0 && finalIndex > index) {
                        this.process("ENCODING-DECLARATION", data.substring(index + 1, finalIndex));
                    }
                }
                if ((index = data.indexOf("standalone")) >= 0) {
                    index = data.indexOf(34, index + 1);
                    finalIndex = data.indexOf(34, index + 1);
                    if (index >= 0 && finalIndex > index) {
                        this.process("STANDALONE-DECLARATION", data.substring(index + 1, finalIndex));
                    }
                }
            }
        } else {
            this.process("PROCESSING-INSTRUCTION-TARGET", target);
            if (data == null) {
                data = "";
            }
            this.process("PROCESSING-INSTRUCTION-DATA", data);
        }
    }

    @Override
    public void setDocumentLocator(Locator loc) {
    }

    @Override
    public void skippedEntity(String name) {
        this.process("SKIPPED-ENTITY", name);
    }

    public boolean isUserAction() {
        return this.isUserAction;
    }

    public void setUserAction(boolean isUserAction) {
        this.isUserAction = isUserAction;
    }
}

