/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ACUFilePointer;
import com.heirloomcomputing.ecs.exec.PackedDecimalP;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.bTreeNode;
import com.heirloomcomputing.ecs.exec.comparableByteArray;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class bTree {
    static Charset debugcs = Charset.forName("iso-8859-1");
    protected static final boolean debugMode = false;
    protected static final boolean splitDebugMode = false;
    protected static final boolean sanityCheck = false;
    private static final int MAX_STACK_SIZE = 128;
    public static final int SYNKRONIX_TYPE = 0;
    public static final int MF_TYPE = 1;
    public static final int ACU_TYPE = 2;
    private int type = 0;
    static final int CACHE_100_PERCENT_SIZE = 32;
    private static final int DEFAULT_PERCENT = 100;
    private comparableByteArray MAX_KEY = null;
    private byte[] maxKeyBytes = null;
    private int maxKeyLength = 0;
    private boolean allowsDuplicates = false;
    private bTreeNode rootNode = null;
    private boolean readOnlyCache = true;
    private BTreeCache cache = null;
    private long numberOfSplits = 0L;
    private long numberOfRedistributes = 0L;
    private int cursorPosition = -1;
    private boolean isAtEnd = false;
    private Object[] nodeStack = null;
    private int nodeStackSize = 0;
    private long currentDuplicateCount = -1L;
    private Object[] savedStack = null;
    private int savedStackSize = 0;
    private int savedPos = -1;
    private boolean savedIsAtEnd = false;
    private boolean isSaved = false;

    public static void debug(String text) {
        System.out.println("bTree: " + text);
    }

    public bTree() {
    }

    public bTree(bTreeNode rootNode) {
        this(rootNode, 0, false, false);
    }

    public bTree(bTreeNode rootNode, boolean allowsDuplicates) {
        this(rootNode, 0, allowsDuplicates, false);
    }

    public bTree(bTreeNode rootNode, int type) {
        this(rootNode, type, false, false);
    }

    public bTree(bTreeNode rootNode, int type, boolean allowsDuplicates) {
        this(rootNode, type, allowsDuplicates, false);
    }

    public bTree(bTreeNode rootNode, int type, boolean allowsDuplicates, boolean readOnlyCaching) {
        this.readOnlyCache = readOnlyCaching;
        int percent = 100;
        int CACHE_SIZE = 32;
        String cacheVar = null;
        try {
            cacheVar = RuntimeEnvironment.getGlobalParameter("IDXCACHE");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cacheVar != null) {
            try {
                percent = Integer.valueOf(cacheVar);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CACHE_SIZE = (int)(32.0f * ((float)percent / 100.0f));
        }
        this.cache = new BTreeCache(CACHE_SIZE);
        this.type = type;
        this.allowsDuplicates = allowsDuplicates;
        Object loc = rootNode.getLocation();
        if (loc instanceof comparableByteArray) {
            loc = ((comparableByteArray)loc).copy();
        }
        this.push(loc);
        this.rootNode = rootNode;
    }

    public int checkSanityLT1k(int num) {
        if (num > 1000) {
            throw new RuntimeException("*** Heirloom Computing internal error bTree: cursorPosition should not be > numKeys in a node but is  " + num);
        }
        return num;
    }

    public Object checkSanityX1K(Object num) {
        long lnum;
        comparableByteArray cba;
        byte[] bytes;
        if (num instanceof comparableByteArray && (bytes = (cba = (comparableByteArray)num).toByteArray()).length == 6 && (lnum = (long)(bytes[0] & 0xFF) << 40 | (long)(bytes[1] & 0xFF) << 32 | (long)(bytes[2] & 0xFF) << 24 | (long)(bytes[3] & 0xFF) << 16 | (long)(bytes[4] & 0xFF) << 8 | (long)(bytes[5] & 0xFF)) % 1024L != 0L) {
            throw new RuntimeException("*** Heirloom Computing internal error bTree: MFFilePointer should on 1K boundary but is  " + lnum);
        }
        return num;
    }

    public void setMaxKey(comparableByteArray max) {
        this.MAX_KEY = max;
    }

    public comparableByteArray getMaxKey() {
        if (this.MAX_KEY != null) {
            return this.MAX_KEY;
        }
        bTreeNode rootNode = this.allocateNode(this.bos());
        if (rootNode == null) {
            return null;
        }
        if (rootNode.getNumberOfKeys() == 0) {
            this.deallocateNode(rootNode);
            return null;
        }
        this.MAX_KEY = rootNode.getMaxKey();
        this.maxKeyBytes = rootNode.getMaxKeyBytes();
        this.maxKeyLength = rootNode.getMaxKeyLength();
        this.deallocateNode(rootNode);
        return this.MAX_KEY;
    }

    public final void flushCache() {
        this.cache.flush();
    }

    private final bTreeNode allocateNode() {
        if (this.rootNode == null) {
            return null;
        }
        Object rootLocation = this.bos();
        bTreeNode newNode = this.cache.allocate(null, false);
        newNode.setRoot(rootLocation == null || rootLocation.hashCode() == newNode.getLocation().hashCode());
        return newNode;
    }

    private final bTreeNode allocateNode(Object location) {
        if (this.rootNode == null || location == null) {
            return null;
        }
        Object rootLocation = this.bos();
        bTreeNode newNode = this.cache.allocate(location, true);
        newNode.setRoot(rootLocation == null || rootLocation.hashCode() == location.hashCode());
        return newNode;
    }

    private final void deallocateNode(bTreeNode node) {
        this.deallocateNode(node, false);
    }

    private final void deallocateNode(bTreeNode node, boolean makeDirty) {
        if (node == null) {
            return;
        }
        this.cache.deallocate(node, makeDirty);
    }

    private final boolean advanceRightChildKey(bTreeNode parent, bTreeNode leftChildOfParentKey, int parentIndex) {
        int numKeys = leftChildOfParentKey.getNumberOfKeys();
        int keyNumber = numKeys - 1;
        comparableByteArray tempKey = leftChildOfParentKey.getKey(keyNumber);
        long dupCount = leftChildOfParentKey.getDuplicateCount(keyNumber);
        if (this.type != 1 && this.type != 2) {
            leftChildOfParentKey.setChild(numKeys, leftChildOfParentKey.getChild(keyNumber));
            leftChildOfParentKey.deleteKey(keyNumber);
        }
        Object loc = leftChildOfParentKey.getLocation();
        return parent.addKey(tempKey, loc, parentIndex, dupCount);
    }

    private final boolean advanceLeftChildKey(bTreeNode parent, bTreeNode leftChildOfParentKey, bTreeNode rightChildOfParentKey, int parentIndex) {
        int numKeys = leftChildOfParentKey.getNumberOfKeys();
        comparableByteArray tempKey = rightChildOfParentKey.getKey(0);
        long dupCount = rightChildOfParentKey.getDuplicateCount(0);
        Object tempData = rightChildOfParentKey.getChild(0);
        if (this.type == 1 || this.type == 2) {
            leftChildOfParentKey.addKey(tempKey, tempData, -1, dupCount);
        } else {
            leftChildOfParentKey.setChild(numKeys, tempData);
        }
        Object loc = leftChildOfParentKey.getLocation();
        if (!parent.addKey(tempKey, loc, parentIndex, dupCount)) {
            rightChildOfParentKey.deleteKey(0);
            return false;
        }
        rightChildOfParentKey.deleteKey(0);
        return true;
    }

    private final boolean moveFromParent(bTreeNode parent, bTreeNode leftChildOfParentKey, bTreeNode curNode, int keyNumber, boolean rightToLeft) {
        comparableByteArray tempKey = parent.getKey(keyNumber);
        long dupCount = parent.getDuplicateCount(keyNumber);
        int leftNumKeys = leftChildOfParentKey.getNumberOfKeys();
        Object tempData = null;
        tempData = this.type == 1 || this.type == 2 ? leftChildOfParentKey.getChild(leftNumKeys - 1) : leftChildOfParentKey.getChild(leftNumKeys);
        parent.deleteKey(keyNumber);
        if (this.type == 1 || this.type == 2) {
            leftChildOfParentKey.deleteKey(leftNumKeys - 1);
        }
        if (!rightToLeft) {
            curNode.addKey(tempKey, tempData, 0, dupCount);
        } else {
            curNode.addKey(tempKey, tempData, -1, dupCount);
        }
        return true;
    }

    private final boolean moveFromLeftSibling(bTreeNode destNode, bTreeNode sourceNode, int numberOfKeys) {
        if (numberOfKeys <= 0 || numberOfKeys > sourceNode.getNumberOfKeys()) {
            return false;
        }
        int keyNum = sourceNode.getNumberOfKeys() - numberOfKeys;
        for (int count = 0; count < numberOfKeys; ++count) {
            destNode.addKey(sourceNode, keyNum, -1);
            sourceNode.deleteKey(keyNum);
        }
        return true;
    }

    private final boolean moveFromRightSibling(bTreeNode destNode, bTreeNode sourceNode, int numberOfKeys) {
        if (numberOfKeys <= 0 || numberOfKeys > sourceNode.getNumberOfKeys()) {
            return false;
        }
        destNode.moveFrom(sourceNode, numberOfKeys);
        return true;
    }

    private final void redistribute() {
        comparableByteArray maxKey = this.getMaxKey();
        bTreeNode curNode = this.allocateNode(this.pop());
        if (curNode == null) {
            return;
        }
        Object parentLoc = this.tos();
        if (parentLoc == null) {
            curNode.setRoot(true);
            if (!curNode.isLeaf()) {
                if (this.type == 1 || this.type == 2) {
                    if (curNode.getNumberOfKeys() == 1 && maxKey != null && curNode.compareKey(0, this.maxKeyBytes, 0, this.maxKeyLength, false) == 0) {
                        Object rootLoc = curNode.getChild(0);
                        curNode.deleteKey(0);
                        curNode.setNode();
                        curNode.setRoot(false);
                        this.deallocateNode(curNode);
                        bTreeNode newRoot = this.allocateNode(rootLoc);
                        newRoot.setRoot(true);
                        int h = newRoot.getTotalHeightOfTree();
                        if (h > 0) {
                            newRoot.setTotalHeightOfTree(h - 1);
                        }
                        this.deallocateNode(newRoot, true);
                        this.push(rootLoc);
                        return;
                    }
                } else if (curNode.getNumberOfKeys() == 0) {
                    Object rootLoc = curNode.getChild(0);
                    curNode.setChild(0, (Object)null);
                    bTreeNode newRoot = this.allocateNode(rootLoc);
                    curNode.setNode();
                    curNode.setRoot(false);
                    this.deallocateNode(curNode);
                    newRoot.setRoot(true);
                    int h = newRoot.getTotalHeightOfTree();
                    if (h > 0) {
                        newRoot.setTotalHeightOfTree(h - 1);
                    }
                    this.deallocateNode(newRoot, true);
                    this.push(rootLoc);
                    return;
                }
            }
            this.push(curNode);
            this.deallocateNode(curNode);
            return;
        }
        bTreeNode parent = this.allocateNode(parentLoc);
        int curIndex = parent.findKeyWithChild(curNode);
        if (curIndex == 0) {
            bTreeNode tempNode = this.allocateNode(parent.getChild(1));
            int numberOfKeys = tempNode.getNumberOfKeys();
            if (tempNode.isBelowOrAtMinimum()) {
                if (this.type == 1 || this.type == 2) {
                    parent.deleteKey(0);
                } else {
                    this.moveFromParent(parent, curNode, tempNode, 0, false);
                }
                this.moveFromLeftSibling(tempNode, curNode, curNode.getNumberOfKeys());
                Object tempNodeLoc = tempNode.getLocation();
                boolean parentIsBelowMinimum = parent.isBelowMinimum();
                this.deallocateNode(parent, true);
                this.deallocateNode(curNode, true);
                this.deallocateNode(tempNode, true);
                if (parentIsBelowMinimum) {
                    this.redistribute();
                }
                if (!tempNodeLoc.equals(this.tos())) {
                    this.push(tempNodeLoc);
                }
                return;
            }
            if (this.type == 1 || this.type == 2) {
                parent.deleteKey(0);
            } else {
                this.moveFromParent(parent, curNode, curNode, 0, true);
            }
            this.advanceLeftChildKey(parent, curNode, tempNode, 0);
            Object curNodeLoc = curNode.getLocation();
            this.deallocateNode(tempNode, true);
            this.deallocateNode(curNode, true);
            this.deallocateNode(parent, true);
            this.push(curNodeLoc);
            return;
        }
        bTreeNode tempNode = this.allocateNode(parent.getChild(curIndex - 1));
        int numberOfKeys = tempNode.getNumberOfKeys();
        if (tempNode.isBelowOrAtMinimum()) {
            if (this.type == 1 || this.type == 2) {
                parent.deleteKey(curIndex - 1);
            } else {
                this.moveFromParent(parent, tempNode, curNode, curIndex - 1, false);
            }
            this.moveFromLeftSibling(curNode, tempNode, numberOfKeys);
            Object curNodeLoc = curNode.getLocation();
            boolean parentIsBelowMinimum = parent.isBelowMinimum();
            this.deallocateNode(parent, true);
            this.deallocateNode(tempNode, true);
            this.deallocateNode(curNode, true);
            if (parentIsBelowMinimum) {
                this.redistribute();
            }
            if (!curNodeLoc.equals(this.tos())) {
                this.push(curNodeLoc);
            }
            return;
        }
        this.moveFromParent(parent, tempNode, curNode, curIndex - 1, false);
        this.advanceRightChildKey(parent, tempNode, curIndex - 1);
        Object curNodeLoc = curNode.getLocation();
        this.deallocateNode(tempNode, true);
        this.deallocateNode(curNode, true);
        this.deallocateNode(parent, true);
        this.push(curNodeLoc);
    }

    private final void split(comparableByteArray additionalKey, Object additionalData, long duplicateKeyCount, int height) {
        byte[] dataBytes;
        byte[] keyBytes = additionalKey.toByteArray();
        try {
            dataBytes = ((comparableByteArray)additionalData).toByteArray();
        }
        catch (Exception e) {
            dataBytes = null;
        }
        this.split(keyBytes, dataBytes, duplicateKeyCount, height);
    }

    private final void split(byte[] additionalKey, byte[] additionalData, long duplicateKeyCount, int height) {
        comparableByteArray maxKey = this.getMaxKey();
        bTreeNode curNode = this.allocateNode(this.pop());
        if (curNode == null) {
            return;
        }
        bTreeNode parent = this.allocateNode(this.tos());
        if (parent == null) {
            parent = this.allocateNode();
            Object loc = curNode.getLocation();
            if (this.type == 1 || this.type == 2) {
                parent.addKey(maxKey, loc);
            } else {
                parent.setChild(0, loc);
            }
            parent.setHeight(curNode.getHeight() + 1);
            int ht = parent.getTotalHeightOfTree();
            if (ht >= 0) {
                parent.setTotalHeightOfTree(ht + 1);
            }
            curNode.setRoot(false);
            parent.setRoot(true);
            parent.setLeaf(false);
            this.push(parent);
        }
        bTreeNode newNode = this.allocateNode();
        newNode.setLeaf(height == 0);
        newNode.setHeight(height);
        int minKeys = curNode.getNumberOfKeys() / 2;
        this.moveFromRightSibling(newNode, curNode, minKeys + 1);
        newNode.addKey(additionalKey, 0, additionalKey.length, additionalData, 0, -1, duplicateKeyCount);
        this.moveFromLeftSibling(curNode, newNode, 1);
        int numKeys = newNode.getNumberOfKeys() - 1;
        comparableByteArray tempKey = newNode.getKey(numKeys);
        long dupCount = newNode.getDuplicateCount(numKeys);
        int parentIndex = parent.findKeyWithChild(curNode);
        if (!this.advanceRightChildKey(parent, newNode, parentIndex)) {
            ++height;
            Object loc = newNode.getLocation();
            Object curLoc = curNode.getLocation();
            this.deallocateNode(curNode, true);
            this.deallocateNode(parent, true);
            this.deallocateNode(newNode, true);
            this.split(tempKey, loc, dupCount, height);
            this.push(curLoc);
        } else {
            this.push(curNode);
            this.deallocateNode(curNode, true);
            this.deallocateNode(parent, true);
            this.deallocateNode(newNode, true);
        }
    }

    private final void mf_delete(int curIndex) {
        this.saveState();
        bTreeNode curNode = this.allocateNode(this.pop());
        int lastKey = curNode.getNumberOfKeys() - 1;
        curNode.deleteKey(curIndex);
        if (curIndex != lastKey || curIndex == 0 && curNode.isRoot()) {
            this.clearSavedState();
            this.push(curNode);
            this.deallocateNode(curNode, true);
            return;
        }
        curNode.setNode();
        --lastKey;
        bTreeNode parent = this.allocateNode(this.tos());
        comparableByteArray maxKey = this.getMaxKey();
        while (parent != null) {
            boolean isMaxKey;
            int parentKeyIndex = parent.findKeyWithChild(curNode);
            boolean bl = isMaxKey = maxKey != null && parent.compareKey(parentKeyIndex, this.maxKeyBytes, 0, this.maxKeyLength, false) == 0;
            if (isMaxKey || lastKey < 0) break;
            comparableByteArray tempKey = curNode.getKey(lastKey);
            parent.setKey(parentKeyIndex, tempKey);
            parent.setNode();
            this.deallocateNode(curNode);
            this.pop();
            curNode = parent;
            parent = this.allocateNode(this.tos());
            lastKey = curNode.getNumberOfKeys() - 1;
            if (parentKeyIndex == lastKey) continue;
            break;
        }
        if (parent != null) {
            this.deallocateNode(parent);
        }
        this.deallocateNode(curNode);
        this.restoreState();
    }

    private final boolean deleteKey(comparableByteArray key, int curIndex) {
        bTreeNode curNode = this.allocateNode(this.tos());
        if (curNode == null) {
            return false;
        }
        if (!curNode.isLeaf()) {
            int tempIndex = curIndex;
            bTreeNode rightChildNode = this.allocateNode(curNode.getChild(tempIndex + 1));
            this.push(rightChildNode);
            bTreeNode leftChildNode = this.allocateNode(curNode.getChild(tempIndex));
            curNode.deleteKey(tempIndex);
            bTreeNode leftMostSuccessorOfRightChildNode = rightChildNode;
            while (!leftMostSuccessorOfRightChildNode.isLeaf()) {
                Object childLoc = leftMostSuccessorOfRightChildNode.getChild(0);
                this.deallocateNode(leftMostSuccessorOfRightChildNode);
                leftMostSuccessorOfRightChildNode = this.allocateNode(childLoc);
                this.push(leftMostSuccessorOfRightChildNode);
            }
            comparableByteArray tempKey = leftMostSuccessorOfRightChildNode.getKey(0);
            Object tempData = leftMostSuccessorOfRightChildNode.getChild(0);
            leftMostSuccessorOfRightChildNode.deleteKey(0);
            this.cursorPosition = 0;
            Object loc = leftChildNode.getLocation();
            curNode.addKey(tempKey, loc, tempIndex);
            bTreeNode rightMostPredecessorOfLeftChildNode = leftChildNode;
            while (!rightMostPredecessorOfLeftChildNode.isLeaf()) {
                Object childLoc = rightMostPredecessorOfLeftChildNode.getChild(rightMostPredecessorOfLeftChildNode.getNumberOfKeys());
                this.deallocateNode(rightMostPredecessorOfLeftChildNode);
                rightMostPredecessorOfLeftChildNode = this.allocateNode(childLoc);
            }
            rightMostPredecessorOfLeftChildNode.setChild(rightMostPredecessorOfLeftChildNode.getNumberOfKeys(), tempData);
            this.deallocateNode(curNode, true);
            this.deallocateNode(rightMostPredecessorOfLeftChildNode, true);
            if (leftMostSuccessorOfRightChildNode.isBelowMinimum()) {
                this.deallocateNode(leftMostSuccessorOfRightChildNode, true);
                ++this.numberOfRedistributes;
                this.redistribute();
            } else {
                this.deallocateNode(leftMostSuccessorOfRightChildNode, true);
            }
        } else {
            boolean makeDirty = false;
            if (this.type == 1 || this.type == 2) {
                this.mf_delete(curIndex);
            } else {
                curNode.deleteKey(curIndex);
                makeDirty = true;
            }
            if (!(!curNode.isBelowMinimum() || curNode.isRoot() && curNode.isLeaf())) {
                this.deallocateNode(curNode, makeDirty);
                ++this.numberOfRedistributes;
                this.redistribute();
            } else {
                this.deallocateNode(curNode, makeDirty);
            }
        }
        return true;
    }

    public final boolean addKey(comparableByteArray key, Object data) {
        return this.addKey(key, data, 1L);
    }

    public final boolean addKey(comparableByteArray key, Object data, long dupNumber) {
        if (this.nodeStack == null || key == null) {
            return false;
        }
        byte[] keyBytes = key.toByteArray();
        if (key instanceof PackedDecimalP) {
            for (int i = 0; i < keyBytes.length; ++i) {
                keyBytes[i] = (byte)((keyBytes[i] & 0xFF) << 4 | (keyBytes[i] & 0xFF) >> 4);
            }
        }
        if (this.seekToKey(keyBytes)) {
            if (!this.allowsDuplicates) {
                return false;
            }
            long lastDupNumberFound = this.seekToNextNonDuplicateKey(keyBytes);
            if (lastDupNumberFound > 0L) {
                dupNumber = lastDupNumberFound + 1L;
            }
        }
        return this.addKeyAtCursor(keyBytes, data, dupNumber);
    }

    public final boolean addKeyAtCursor(comparableByteArray key, Object data, long duplicateKeyCount) {
        if (this.nodeStack == null || key == null) {
            return false;
        }
        byte[] keyBytes = key.toByteArray();
        if (key instanceof PackedDecimalP) {
            for (int i = 0; i < keyBytes.length; ++i) {
                keyBytes[i] = (byte)((keyBytes[i] & 0xFF) << 4 | (keyBytes[i] & 0xFF) >> 4);
            }
        }
        return this.addKeyAtCursor(keyBytes, data, duplicateKeyCount);
    }

    public final boolean addKeyAtCursor(byte[] keyBytes, Object data, long duplicateKeyCount) {
        byte[] dataBytes;
        bTreeNode currentNode = this.allocateNode(this.tos());
        if (currentNode == null) {
            return false;
        }
        if (this.type == 2 && currentNode.isRoot() && currentNode.isLeaf() && currentNode.getNumberOfKeys() == 0) {
            currentNode.addKey(currentNode.getMaxKey(), new ACUFilePointer(0L));
            currentNode.setTotalHeightOfTree(1);
        }
        try {
            dataBytes = ((comparableByteArray)data).toByteArray();
        }
        catch (Exception e) {
            dataBytes = null;
        }
        if (!currentNode.addKey(keyBytes, 0, keyBytes.length, dataBytes, 0, this.cursorPosition, duplicateKeyCount)) {
            this.deallocateNode(currentNode);
            ++this.numberOfSplits;
            this.split(keyBytes, dataBytes, duplicateKeyCount, 0);
            if (!this.seekToKeyWithChild(keyBytes, dataBytes)) {
                // empty if block
            }
        } else {
            this.deallocateNode(currentNode, true);
        }
        return true;
    }

    public final boolean deleteCurrentKey() {
        bTreeNode node;
        if (this.isAtEnd) {
            return false;
        }
        comparableByteArray nextKey = null;
        Object nextChild = null;
        if (this.seekToNext()) {
            node = this.allocateNode(this.tos());
            nextChild = node.getChild(this.cursorPosition);
            this.deallocateNode(node);
            if (nextChild != null) {
                nextKey = this.getCurrentKey();
            }
            this.seekToPrevious();
        } else {
            this.seekToPrevious();
        }
        node = this.allocateNode(this.tos());
        if (node == null) {
            return false;
        }
        comparableByteArray key = null;
        int index = this.cursorPosition;
        if (this.type != 1 && this.type != 2 && this.cursorPosition == node.getNumberOfKeys()) {
            this.pop();
            bTreeNode parent = null;
            do {
                parent = this.allocateNode(this.pop());
                index = parent.findKeyWithChild(node);
                this.deallocateNode(node);
            } while (index == (node = parent).getNumberOfKeys());
            key = node.getKey(index);
            this.push(node);
        } else {
            key = node.getKey(this.cursorPosition);
        }
        this.deallocateNode(node);
        boolean flag = this.deleteKey(key, index);
        if (flag) {
            if (nextChild != null && nextKey != null) {
                this.seekToKeyWithChild(nextKey, nextChild);
            } else {
                this.isAtEnd = false;
                this.seekToEnd();
            }
        }
        return flag;
    }

    public final long getHeight() {
        bTreeNode root = this.allocateNode(this.bos());
        if (root == null) {
            return 0L;
        }
        long h = root.getTotalHeightOfTree();
        if (h < 0L) {
            h = (long)root.getHeight() + 1L;
        }
        this.deallocateNode(root);
        return h;
    }

    public final Object getData() {
        bTreeNode node;
        if (this.cursorPosition == -1) {
            this.seekToBeginning();
            if (this.cursorPosition == -1) {
                return null;
            }
        }
        if ((node = this.allocateNode(this.tos())) == null) {
            return null;
        }
        Object data = node.getData(this.cursorPosition);
        this.deallocateNode(node);
        return data;
    }

    public final Object getData(comparableByteArray key) {
        this.saveState();
        boolean found = this.seekToKey(key);
        if (!found) {
            this.restoreState();
            return null;
        }
        this.clearSavedState();
        bTreeNode currentNode = this.allocateNode(this.tos());
        Object data = currentNode.getData(currentNode.getChild());
        this.deallocateNode(currentNode);
        return data;
    }

    public final Object getNextData() {
        if (!this.seekToNext()) {
            return null;
        }
        bTreeNode currentNode = this.allocateNode(this.tos());
        if (currentNode == null) {
            return null;
        }
        Object tempChild = currentNode.getChild(this.cursorPosition);
        if (tempChild == null) {
            this.deallocateNode(currentNode);
            return null;
        }
        Object data = currentNode.getData(tempChild);
        this.deallocateNode(currentNode);
        return data;
    }

    public final Object getCurrentNodeDataLocation() {
        if (this.cursorPosition < 0) {
            return null;
        }
        bTreeNode currentNode = this.allocateNode(this.tos());
        if (currentNode == null) {
            return null;
        }
        Object loc = currentNode.getChild(this.cursorPosition);
        this.deallocateNode(currentNode);
        return loc;
    }

    public final boolean setCurrentNodeDataLocation(Object data) {
        if (this.cursorPosition < 0) {
            return false;
        }
        bTreeNode currentNode = this.allocateNode(this.tos());
        if (currentNode == null) {
            return false;
        }
        currentNode.setChild(this.cursorPosition, data);
        this.deallocateNode(currentNode, true);
        return true;
    }

    public final Object getRootLocation() {
        Object rootLoc = this.bos();
        return rootLoc;
    }

    public final void setRootLocation(Object loc) {
        if (loc == null) {
            return;
        }
        this.flushCache();
        this.nodeStack = null;
        this.push(loc);
        this.cursorPosition = -1;
        this.isAtEnd = false;
    }

    public final int getCursorPosition() {
        return this.cursorPosition;
    }

    public final boolean isAtBeginning() {
        boolean isAtBegin = this.cursorPosition == -1;
        return isAtBegin;
    }

    public final boolean isAtEnd() {
        return this.isAtEnd;
    }

    public final boolean isAtEnd(comparableByteArray key) {
        if (this.cursorPosition == -1) {
            this.seekToBeginning();
            if (this.cursorPosition == -1) {
                return false;
            }
        }
        this.saveState();
        this.seekToKey(key);
        boolean flag = this.isAtEnd;
        this.restoreState();
        return flag;
    }

    public final boolean isNextAtEnd() {
        if (this.isAtEnd) {
            return true;
        }
        this.saveState();
        this.seekToNext();
        boolean flag = this.isAtEnd;
        this.restoreState();
        return flag;
    }

    public final boolean isPreviousAtBeginning() {
        if (this.cursorPosition == -1) {
            return false;
        }
        this.saveState();
        this.seekToPrevious();
        boolean flag = this.cursorPosition == -1;
        this.restoreState();
        return flag;
    }

    public final boolean isNextKeyDuplicate() {
        if (this.isAtEnd) {
            return false;
        }
        comparableByteArray lastKey = this.getCurrentKey();
        if (lastKey == null) {
            return false;
        }
        this.saveState();
        if (!this.seekToNext()) {
            this.clearSavedState();
            return false;
        }
        comparableByteArray key = this.getCurrentKey();
        this.restoreState();
        if (key == null) {
            return false;
        }
        if (lastKey.supportsCompareBytes()) {
            byte[] bytes = key.toByteArray();
            return lastKey.compareBytes(bytes, 0, bytes.length, true) == 0;
        }
        return lastKey.compare(key, true) == 0;
    }

    private boolean advanceCurNode() {
        bTreeNode curNode = null;
        bTreeNode parent = null;
        int index = 0;
        int numKeys = 0;
        curNode = this.allocateNode(this.pop());
        if (curNode == null) {
            return false;
        }
        parent = this.allocateNode(this.tos());
        if (parent == null) {
            this.deallocateNode(curNode);
            return false;
        }
        index = parent.findKeyWithChild(curNode);
        numKeys = parent.getNumberOfKeys();
        if ((this.type == 1 || this.type == 2) && index + 1 < numKeys || this.type != 1 && this.type != 2 && index + 1 <= numKeys) {
            this.deallocateNode(curNode);
            curNode = this.allocateNode(parent.getChild(index + 1));
            this.cursorPosition = 0;
            while (!curNode.isLeaf()) {
                Object loc = curNode.getChild(0);
                this.push(curNode);
                this.deallocateNode(curNode);
                curNode = this.allocateNode(loc);
            }
            this.push(curNode);
            this.deallocateNode(curNode);
            this.deallocateNode(parent);
            return true;
        }
        this.deallocateNode(curNode);
        this.deallocateNode(parent);
        return this.advanceCurNode();
    }

    private boolean retreatCurNode() {
        bTreeNode curNode = null;
        bTreeNode parent = null;
        int index = 0;
        curNode = this.allocateNode(this.pop());
        if (curNode == null) {
            return false;
        }
        parent = this.allocateNode(this.tos());
        if (parent == null) {
            this.deallocateNode(curNode);
            return false;
        }
        index = parent.findKeyWithChild(curNode);
        if (index - 1 >= 0) {
            this.deallocateNode(curNode);
            curNode = this.allocateNode(parent.getChild(index - 1));
            index = curNode.getNumberOfKeys();
            if (this.type == 1 || this.type == 2) {
                --index;
            }
            while (!curNode.isLeaf()) {
                Object loc = curNode.getChild(index);
                this.push(curNode);
                this.deallocateNode(curNode);
                curNode = this.allocateNode(loc);
                index = curNode.getNumberOfKeys();
                if (this.type != 1 && this.type != 2) continue;
                --index;
            }
            this.cursorPosition = index;
            this.push(curNode);
            this.deallocateNode(curNode);
            this.deallocateNode(parent);
            return true;
        }
        this.deallocateNode(curNode);
        this.deallocateNode(parent);
        return this.retreatCurNode();
    }

    public final boolean seekToPrevious() {
        if (this.nodeStack == null || this.cursorPosition < 0) {
            return false;
        }
        if (this.cursorPosition - 1 >= 0) {
            --this.cursorPosition;
            this.isAtEnd = false;
            return true;
        }
        Object[] stack = this.getCopyOfNodeStack();
        int stackSize = this.nodeStackSize;
        boolean wasSaved = this.isSaved;
        this.isSaved = true;
        if (!this.retreatCurNode()) {
            this.nodeStack = stack;
            this.nodeStackSize = stackSize;
            this.isSaved = wasSaved;
            this.cursorPosition = -1;
            this.isAtEnd = false;
            return false;
        }
        this.isSaved = wasSaved;
        this.isAtEnd = false;
        return true;
    }

    public final boolean seekToNext() {
        if (this.nodeStack == null) {
            return false;
        }
        if (this.cursorPosition == -1) {
            this.seekToBeginning();
            return this.cursorPosition != -1;
        }
        if (this.isAtEnd) {
            return false;
        }
        bTreeNode node = this.allocateNode(this.tos());
        if (node == null) {
            return false;
        }
        int numKeys = node.getNumberOfKeys();
        if (this.type == 1 || this.type == 2) {
            if (this.cursorPosition + 1 < numKeys) {
                ++this.cursorPosition;
                if (this.type == 2 && this.cursorPosition + 1 == numKeys && node.lastKeyIsMaxKey()) {
                    this.isAtEnd = true;
                }
                this.deallocateNode(node);
                return true;
            }
        } else if (this.cursorPosition + 1 <= numKeys) {
            ++this.cursorPosition;
            if (this.cursorPosition == numKeys && node.getChild(this.cursorPosition) == null) {
                this.isAtEnd = true;
            }
            this.deallocateNode(node);
            return true;
        }
        this.deallocateNode(node);
        Object[] stack = this.getCopyOfNodeStack();
        int stackSize = this.nodeStackSize;
        boolean wasSaved = this.isSaved;
        this.isSaved = true;
        if (!this.advanceCurNode()) {
            this.nodeStack = stack;
            this.nodeStackSize = stackSize;
            this.isSaved = wasSaved;
            boolean flag = true;
            if (this.cursorPosition + 1 > numKeys) {
                flag = false;
            }
            if (this.type == 2 && this.cursorPosition + 1 == numKeys && node.lastKeyIsMaxKey()) {
                this.isAtEnd = true;
                return true;
            }
            this.cursorPosition = numKeys;
            this.isAtEnd = true;
            return flag;
        }
        this.isSaved = wasSaved;
        return true;
    }

    public final void seekToBeginning() {
        if (this.nodeStack == null) {
            return;
        }
        bTreeNode node = this.allocateNode(this.bos());
        if (node == null) {
            return;
        }
        this.clearNodeStack();
        while (!node.isLeaf()) {
            Object loc = node.getChild(0);
            this.push(node);
            this.deallocateNode(node);
            node = this.allocateNode(loc);
        }
        this.cursorPosition = 0;
        this.isAtEnd = false;
        if (this.type == 2 && node.getNumberOfKeys() == 1 && node.isRoot() && node.isLeaf()) {
            this.isAtEnd = true;
            this.push(node);
            this.deallocateNode(node);
            return;
        }
        if (node.getNumberOfKeys() == 0) {
            this.isAtEnd = true;
        }
        this.push(node);
        this.deallocateNode(node);
    }

    public final boolean seekToEnd() {
        if (this.isAtEnd) {
            return true;
        }
        if (this.nodeStack == null) {
            return false;
        }
        bTreeNode node = this.allocateNode(this.bos());
        if (node == null) {
            return false;
        }
        this.clearNodeStack();
        while (!node.isLeaf()) {
            int pos = node.getNumberOfKeys();
            if (this.type == 1 || this.type == 2) {
                --pos;
            }
            node.setCurrentIndex(pos);
            Object loc = node.getChild();
            bTreeNode newNode = this.allocateNode(loc);
            this.push(node);
            this.deallocateNode(node);
            node = newNode;
        }
        this.cursorPosition = node.getNumberOfKeys();
        this.isAtEnd = true;
        this.push(node);
        this.deallocateNode(node);
        return true;
    }

    private final boolean seekToKeyWithChild(comparableByteArray key, Object child) {
        byte[] childBytes;
        byte[] keyBytes = key.toByteArray();
        try {
            childBytes = ((comparableByteArray)child).toByteArray();
        }
        catch (Exception e) {
            childBytes = null;
        }
        return this.seekToKeyWithChild(keyBytes, childBytes);
    }

    private final boolean seekToKeyWithChild(byte[] keyBytes, byte[] childBytes) {
        if (this.seekToKey(keyBytes)) {
            bTreeNode curNode = null;
            while ((curNode = this.allocateNode(this.tos())) != null) {
                byte[] bytes;
                comparableByteArray curKey;
                int index = curNode.findKeyWithChild(childBytes, 0);
                this.deallocateNode(curNode);
                if (index >= 0) {
                    return true;
                }
                if (this.seekToNext() && (curKey = this.getCurrentKey()) != null && bTreeNode.compareBytes(bytes = curKey.toByteArray(), 0, bytes.length, keyBytes, 0, keyBytes.length, true) == 0) continue;
                break;
            }
        }
        return false;
    }

    private final int isCursorInPosition(byte[] bytes) {
        boolean isAtEndLeaf;
        if (this.cursorPosition <= 0) {
            return -1;
        }
        bTreeNode node = this.allocateNode(this.tos());
        if (node == null) {
            return -1;
        }
        int lastKey = node.getNumberOfKeys();
        if (this.type == 1 || this.type == 2) {
            --lastKey;
        }
        if (lastKey <= 0 || this.cursorPosition > lastKey) {
            this.deallocateNode(node);
            return -1;
        }
        if (this.cursorPosition == lastKey && (!this.isAtEnd || this.type != 1 && this.type != 2)) {
            this.deallocateNode(node);
            return -1;
        }
        boolean bl = isAtEndLeaf = this.isAtEnd && node.isLeaf();
        if (!isAtEndLeaf && node.compareKey(this.cursorPosition - 1, bytes, 0, bytes.length, true) <= 0) {
            this.deallocateNode(node);
            return -1;
        }
        int result = node.compareKey(this.cursorPosition, bytes, 0, bytes.length, true);
        if (result > 0) {
            if (isAtEndLeaf) {
                node.setCurrentIndex(++this.cursorPosition);
                this.deallocateNode(node);
                return 2;
            }
            if (this.cursorPosition == lastKey - 1) {
                this.deallocateNode(node);
                return -1;
            }
            if (!node.findKey(bytes)) {
                int index = node.getCurrentIndex();
                if (index >= lastKey || index <= 0) {
                    this.deallocateNode(node);
                    return -1;
                }
                this.cursorPosition = index;
                result = 1;
            } else {
                this.cursorPosition = node.getCurrentIndex();
                result = 0;
            }
        } else {
            if (isAtEndLeaf) {
                this.deallocateNode(node);
                return -1;
            }
            node.setCurrentIndex(this.cursorPosition);
        }
        this.isAtEnd = false;
        this.deallocateNode(node);
        return -result;
    }

    public final boolean seekToKey(comparableByteArray key) {
        if (this.nodeStack == null || key == null) {
            return false;
        }
        byte[] keyBytes = key.toByteArray();
        if (key instanceof PackedDecimalP) {
            for (int i = 0; i < keyBytes.length; ++i) {
                keyBytes[i] = (byte)((keyBytes[i] & 0xFF) << 4 | (keyBytes[i] & 0xFF) >> 4);
            }
        }
        return this.seekToKey(keyBytes);
    }

    public final boolean seekToKey(byte[] keyBytes) {
        int result = this.isCursorInPosition(keyBytes);
        if (result >= 0) {
            return result == 0;
        }
        bTreeNode node = this.allocateNode(this.bos());
        if (node == null) {
            return false;
        }
        this.clearNodeStack();
        this.isAtEnd = true;
        boolean found = false;
        while (!node.isLeaf()) {
            if (node.findKey(keyBytes)) {
                found = true;
                this.cursorPosition = node.getCurrentIndex();
            } else if (this.isAtEnd) {
                this.cursorPosition = node.getCurrentIndex();
                int numKeys = node.getNumberOfKeys();
                if (this.type == 1 || this.type == 2) {
                    if (this.cursorPosition < numKeys - 1) {
                        this.isAtEnd = false;
                    }
                } else if (this.cursorPosition < numKeys) {
                    this.isAtEnd = false;
                }
            } else {
                this.cursorPosition = node.getCurrentIndex();
            }
            Object loc = node.getChild();
            if (loc == null) {
                if (node.getNumberOfKeys() == 0) {
                    return false;
                }
                node.setCurrentIndex(node.getNumberOfKeys() - 1);
                this.cursorPosition = node.getCurrentIndex();
                loc = node.getChild();
                if (loc == null) {
                    return false;
                }
            }
            this.push(node);
            this.deallocateNode(node);
            node = this.allocateNode(loc);
            if (node != null) continue;
            return false;
        }
        if (this.type == 1 || this.type == 2) {
            found = false;
        }
        if (node.findKey(keyBytes)) {
            found = true;
        }
        this.cursorPosition = node.getCurrentIndex();
        if (!found) {
            if (this.isAtEnd && this.cursorPosition < node.getNumberOfKeys()) {
                this.isAtEnd = false;
                if (this.type == 2 && this.cursorPosition == node.getNumberOfKeys() - 1 && node.lastKeyIsMaxKey()) {
                    this.isAtEnd = true;
                }
            }
        } else {
            this.isAtEnd = false;
        }
        this.push(node);
        this.deallocateNode(node);
        return found;
    }

    public final long seekToNextNonDuplicateKey(comparableByteArray lastKey) {
        if (this.nodeStack == null || lastKey == null) {
            return -1L;
        }
        byte[] keyBytes = lastKey.toByteArray();
        return this.seekToNextNonDuplicateKey(keyBytes);
    }

    public final long seekToNextNonDuplicateKey(byte[] lastKey) {
        byte[] bytes;
        comparableByteArray key;
        long lastDupNumFound = -1L;
        while (this.seekToNext() && (key = this.getCurrentKey()) != null && bTreeNode.compareBytes(lastKey, 0, lastKey.length, bytes = key.toByteArray(), 0, bytes.length, true) == 0) {
            lastDupNumFound = this.getCurrentDuplicateCount();
        }
        return lastDupNumFound;
    }

    private final long getCurrentDuplicateCount() {
        return this.currentDuplicateCount;
    }

    public final comparableByteArray getCurrentKey() {
        comparableByteArray key = null;
        this.currentDuplicateCount = -1L;
        if (this.cursorPosition == -1) {
            this.seekToBeginning();
            if (this.cursorPosition == -1) {
                return null;
            }
        }
        if (this.isAtEnd) {
            return null;
        }
        bTreeNode node = this.allocateNode(this.tos());
        if (node == null) {
            return null;
        }
        int numKeys = node.getNumberOfKeys();
        if (this.type != 1 && this.type != 2 && this.cursorPosition == numKeys) {
            int index;
            Object[] stack = this.getCopyOfNodeStack();
            int stackSize = this.nodeStackSize;
            boolean wasSaved = this.isSaved;
            this.isSaved = true;
            this.pop();
            bTreeNode parent = null;
            do {
                if ((parent = this.allocateNode(this.pop())) == null) {
                    this.nodeStack = stack;
                    this.nodeStackSize = stackSize;
                    this.isSaved = wasSaved;
                    return null;
                }
                index = parent.findKeyWithChild(node);
                this.deallocateNode(node);
            } while (index == (node = parent).getNumberOfKeys());
            key = node.getKey(index);
            this.currentDuplicateCount = node.getDuplicateCount(index);
            this.nodeStack = stack;
            this.nodeStackSize = stackSize;
            this.isSaved = wasSaved;
            this.deallocateNode(node);
            return key;
        }
        key = node.getKey(this.cursorPosition);
        this.currentDuplicateCount = node.getDuplicateCount(this.cursorPosition);
        this.deallocateNode(node);
        return key;
    }

    public long getNumberOfSplits() {
        return this.numberOfSplits;
    }

    public long getNumberOfRedistributes() {
        return this.numberOfRedistributes;
    }

    private Object pop() {
        if (this.nodeStack == null || this.nodeStackSize <= 0) {
            return null;
        }
        Object nodePointer = this.nodeStack[--this.nodeStackSize];
        return nodePointer;
    }

    private void push(bTreeNode node) {
        this.push(node.getLocation());
    }

    private void push(Object loc) {
        if (this.nodeStack == null) {
            this.nodeStack = new Object[128];
            this.nodeStackSize = 0;
        }
        this.nodeStack[this.nodeStackSize++] = loc;
    }

    private Object tos() {
        if (this.nodeStack == null) {
            return null;
        }
        int pos = this.nodeStackSize - 1;
        if (pos < 0) {
            return null;
        }
        return this.nodeStack[pos];
    }

    private Object bos() {
        if (this.nodeStack == null || this.nodeStackSize == 0) {
            return null;
        }
        return this.nodeStack[0];
    }

    private void clearNodeStack() {
        if (this.nodeStack == null) {
            return;
        }
        this.nodeStackSize = 0;
    }

    private Object[] getCopyOfNodeStack() {
        if (this.nodeStack == null) {
            return null;
        }
        Object[] stack = new Object[128];
        System.arraycopy(this.nodeStack, 0, stack, 0, 128);
        return stack;
    }

    private void saveState() {
        this.savedStack = this.getCopyOfNodeStack();
        this.savedStackSize = this.nodeStackSize;
        this.savedPos = this.cursorPosition;
        this.savedIsAtEnd = this.isAtEnd;
        this.isSaved = true;
    }

    private void restoreState() {
        if (this.isSaved) {
            this.nodeStack = this.savedStack;
            this.nodeStackSize = this.savedStackSize;
            this.cursorPosition = this.savedPos;
            this.isAtEnd = this.savedIsAtEnd;
            this.isSaved = false;
        }
    }

    private void clearSavedState() {
        this.isSaved = false;
    }

    private final void plotTreeNode(bTreeNode node) {
        bTree.debug(node.toString());
    }

    private final void plotTreeTraversal(Object location) {
        int i;
        if (location == null) {
            return;
        }
        bTreeNode node = this.allocateNode(location);
        this.plotTreeNode(node);
        if (node.isLeaf()) {
            this.deallocateNode(node);
            return;
        }
        int numKeys = node.getNumberOfKeys();
        Object[] loc = new Object[numKeys + 1];
        for (i = 0; i <= numKeys; ++i) {
            loc[i] = node.getChild(i);
        }
        this.deallocateNode(node);
        for (i = 0; i <= numKeys; ++i) {
            this.plotTreeTraversal(loc[i]);
        }
    }

    public final void outputTree2() {
        try {
            Object root = this.bos();
            if (root == null) {
                bTree.debug("root is null");
                return;
            }
            this.plotTreeTraversal(root);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            bTree.debug("******************");
            System.exit(1);
        }
    }

    public final void outputTree() {
        try {
            Object root = this.bos();
            if (root == null) {
                bTree.debug("root is null");
                return;
            }
            this.plotTreeTraversal(root);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            bTree.debug("******************");
            System.exit(1);
        }
    }

    private final void checkTreeTraversal(Object location, bTreeNode parent) {
        int i;
        if (location == null) {
            return;
        }
        bTreeNode node = this.allocateNode(location);
        if (node.isLeaf()) {
            this.deallocateNode(node);
            return;
        }
        int numKeys = node.getNumberOfKeys();
        Object[] loc = new Object[numKeys];
        comparableByteArray[] keys = new comparableByteArray[numKeys];
        for (i = 0; i < numKeys; ++i) {
            loc[i] = node.getChild(i);
            keys[i] = node.getKey(i);
        }
        this.deallocateNode(node);
        for (i = 0; i < numKeys; ++i) {
            bTreeNode keyNode = this.allocateNode(loc[i]);
            if (keys[i].toByteArray()[0] != -1 && !keyNode.findKey(keys[i])) {
                System.out.println("*** messed up bTree node " + keyNode.toString());
                System.out.println("*** does not contain key " + i + " from parent node " + node.toString());
                System.out.println();
            }
            this.deallocateNode(keyNode);
            this.checkTreeTraversal(loc[i], node);
        }
    }

    public final void checkTree2() {
        try {
            Object root = this.bos();
            if (root == null) {
                return;
            }
            this.checkTreeTraversal(root, null);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            bTree.debug("******** checkTree2 exception **********");
            System.exit(1);
        }
    }

    public final void dumpNodeStack() {
    }

    class BTreeCache {
        private int size;
        private final Vector<bTreeNode> freeNodes = new Vector();
        Hashtable<Object, bTreeNode> cache;

        public BTreeCache(int size) {
            this.cache = new Hashtable(size);
            this.size = size;
        }

        public final int getCacheSize() {
            return this.size;
        }

        public final void flush() {
            Enumeration<bTreeNode> elements = this.cache.elements();
            while (elements.hasMoreElements()) {
                bTreeNode node = elements.nextElement();
                if (node == null) continue;
                if (node.isDirty()) {
                    node.setNode();
                }
                node.free();
                if (this.freeNodes.size() >= 200) continue;
                this.freeNodes.addElement(node);
            }
            this.cache.clear();
        }

        private final boolean flushLowestPriorityNonReferencedNodes() {
            int lowestPriority = 500000;
            bTreeNode lowestPriorityNode = null;
            Enumeration<bTreeNode> elements = this.cache.elements();
            while (elements.hasMoreElements()) {
                int priority;
                bTreeNode node = elements.nextElement();
                if (node.getReferenceCount() != 0 || (priority = node.getPriority()) >= lowestPriority) continue;
                lowestPriority = priority;
                lowestPriorityNode = node;
            }
            if (lowestPriorityNode != null) {
                Object location = lowestPriorityNode.getLocation();
                if (lowestPriorityNode.isDirty()) {
                    lowestPriorityNode.setNode();
                }
                lowestPriorityNode.free();
                if (this.freeNodes.size() < 200) {
                    this.freeNodes.addElement(lowestPriorityNode);
                }
                this.cache.remove(location);
                return true;
            }
            return false;
        }

        public final bTreeNode allocate(Object location, boolean useLocation) {
            int cacheSize;
            bTreeNode newNode;
            int last;
            boolean inCache = false;
            if (!useLocation) {
                last = this.freeNodes.size() - 1;
                if (last >= 0) {
                    this.freeNodes.removeElementAt(last);
                }
                newNode = bTree.this.rootNode.newInstance();
                location = newNode.getLocation();
            } else {
                newNode = this.cache.get(location);
                if (newNode == null) {
                    last = this.freeNodes.size() - 1;
                    if (last >= 0) {
                        bTreeNode tempNode = this.freeNodes.elementAt(last);
                        this.freeNodes.removeElementAt(last);
                        newNode = bTree.this.rootNode.getNode(location, tempNode);
                    } else {
                        newNode = bTree.this.rootNode.getNode(location);
                    }
                } else {
                    inCache = true;
                }
            }
            if (!inCache && (cacheSize = this.getCacheSize()) > 0) {
                if (cacheSize == this.cache.size()) {
                    if (this.flushLowestPriorityNonReferencedNodes()) {
                        this.cache.put(location, newNode);
                    }
                } else {
                    this.cache.put(location, newNode);
                }
            }
            newNode.increasePriority();
            newNode.increaseReferenceCount();
            return newNode;
        }

        public final boolean deallocate(bTreeNode node) {
            return this.deallocate(node, false);
        }

        public final boolean deallocate(bTreeNode node, boolean makeDirty) {
            if (makeDirty && bTree.this.readOnlyCache) {
                node.setNode();
                makeDirty = false;
            }
            int cacheSize = this.getCacheSize();
            Object location = node.getLocation();
            if (location != null && cacheSize > 0 && this.cache.get(location) == node) {
                int referenceCount = node.getReferenceCount() - 1;
                if (referenceCount == 0 && node.getNumberOfKeys() == 0) {
                    if (makeDirty) {
                        node.setNode();
                    }
                    node.free();
                    if (this.freeNodes.size() < 200) {
                        this.freeNodes.addElement(node);
                    }
                    this.cache.remove(location);
                    return true;
                }
                node.setReferenceCount(referenceCount);
                if (makeDirty) {
                    node.setDirty(true);
                }
                return true;
            }
            if (makeDirty) {
                node.setNode();
            }
            node.free();
            if (this.freeNodes.size() < 200) {
                this.freeNodes.addElement(node);
            }
            return false;
        }

        public final String toString() {
            return "A bunch of cache values";
        }
    }
}

