/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class clipboard
implements ClipboardOwner,
FileProtocol,
FileConstants {
    private boolean readable = true;
    private boolean writable = true;
    private boolean lineSequential;
    private boolean open;
    private String clipboardString = "";

    public static String getProtocol() {
        return "clipboard";
    }

    @Override
    public final boolean init(String filename, boolean lineSequential) {
        if (filename != null) {
            filename = filename.trim();
        }
        this.lineSequential = lineSequential;
        return true;
    }

    @Override
    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
    }

    @Override
    public final int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        StringBuffer addition = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            addition.append((char)data[offset + i]);
        }
        this.clipboardString = this.clipboardString + addition.toString();
        return 0;
    }

    @Override
    public final int read(byte[] data, int offset, int length) {
        int i;
        if (!this.isOpen()) {
            return -47;
        }
        String result = null;
        if (this.lineSequential) {
            for (int i2 = 0; i2 < this.clipboardString.length(); ++i2) {
                if (i2 < length && this.clipboardString.charAt(i2) != '\r' && this.clipboardString.charAt(i2) != '\n') continue;
                if (i2 < this.clipboardString.length() - 1 && this.clipboardString.charAt(i2) == '\r' && this.clipboardString.charAt(i2 + 1) == '\n') {
                    result = this.clipboardString.substring(0, i2);
                    this.clipboardString = this.clipboardString.substring(i2 + 2);
                    continue;
                }
                if (this.clipboardString.charAt(i2) == '\n') {
                    result = this.clipboardString.substring(0, i2);
                    this.clipboardString = this.clipboardString.substring(i2 + 1);
                    continue;
                }
                result = this.clipboardString.substring(0, length);
                this.clipboardString = this.clipboardString.substring(length);
            }
            return result.length();
        }
        result = this.clipboardString.substring(0, length);
        if (this.clipboardString.length() < length) {
            result = this.clipboardString;
            this.clipboardString = "";
        } else {
            this.clipboardString = this.clipboardString.substring(length);
        }
        if (result == null || result.equals("")) {
            return -10;
        }
        for (i = result.length() - 1; i >= 0; --i) {
            data[offset + i] = (byte)result.charAt(i);
        }
        for (i = length - 1; i >= result.length(); --i) {
            data[offset + i] = 32;
        }
        return result.length();
    }

    @Override
    public final int close(int mode) {
        this.readable = true;
        this.writable = true;
        if (this.writable) {
            try {
                Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (c == null) {
                    return -30;
                }
                c.setContents(new StringSelection(this.clipboardString), this);
                this.open = false;
            }
            catch (Exception e) {
                return -30;
            }
        }
        if (this.readable) {
            this.open = false;
        }
        return 0;
    }

    @Override
    public final int open(int mode) {
        this.readable = false;
        if ((mode & 1) != 0) {
            this.readable = true;
            if (this.open) {
                return -41;
            }
            try {
                this.clipboardString = "";
                Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this.clipboardString);
                if (t == null) {
                    return -30;
                }
                this.clipboardString = (String)t.getTransferData(DataFlavor.stringFlavor);
                this.open = true;
            }
            catch (Exception e) {
                return -30;
            }
        }
        this.writable = false;
        if ((mode & 2) != 0) {
            this.writable = true;
            if (this.open) {
                return -41;
            }
            this.open = true;
        }
        return 0;
    }

    @Override
    public final long getFilePointer() {
        return -90L;
    }

    @Override
    public final int seek(long position) {
        return -90;
    }

    @Override
    public final long length() {
        return -90L;
    }

    @Override
    public final int backup() {
        return 0;
    }

    @Override
    public final boolean isStream() {
        return false;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return false;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final int readLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        return true;
    }

    @Override
    public final Object getObject() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception t) {
            return null;
        }
    }

    @Override
    public final void lostOwnership(Clipboard clipboard2, Transferable contents) {
        this.clipboardString = "";
    }

    @Override
    public void setBlockSize(int size) {
    }

    @Override
    public void flush() {
    }
}

