/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ipcio
implements FileProtocol,
FileConstants {
    private static boolean INBUFFER = false;
    private static boolean OUTBUFFER = false;
    private static int MAX_LENGTH = 511;
    private static int OPEN_SLEEP = 0;
    private String filename;
    private boolean readable = true;
    private boolean writable = true;
    private boolean lineSequential;
    private boolean open;
    private InputStream is;
    private OutputStream os;
    private Process p;

    public static void setBuffering(boolean in, boolean out) {
        INBUFFER = in;
        OUTBUFFER = out;
    }

    public static void setOpenSleep(int value) {
        OPEN_SLEEP = value;
    }

    public static final String getProtocol() {
        return "ipcio";
    }

    @Override
    public final boolean init(String filename, boolean lineSequential) {
        if (filename != null) {
            filename = filename.trim();
        }
        this.filename = filename;
        this.lineSequential = lineSequential;
        this.readable = true;
        this.writable = true;
        return true;
    }

    @Override
    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
    }

    @Override
    public final int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        try {
            if (MAX_LENGTH <= 0) {
                this.os.write(data, offset, length);
                this.flush();
            } else {
                while (length > MAX_LENGTH) {
                    this.os.write(data, offset, MAX_LENGTH);
                    offset += MAX_LENGTH;
                    length -= MAX_LENGTH;
                    this.flush();
                }
                if (length > 0) {
                    this.os.write(data, offset, length);
                    this.flush();
                }
            }
            return 0;
        }
        catch (IOException e) {
            return -30;
        }
    }

    @Override
    public final int read(byte[] data, int offset, int length) {
        if (!this.open) {
            return -47;
        }
        int bytesRead = 0;
        this.flush();
        try {
            block28: {
                if (this.lineSequential) {
                    int bytesStored = 0;
                    int ch = 0;
                    boolean finished = false;
                    boolean escaped = false;
                    boolean eof = false;
                    try {
                        do {
                            if ((ch = this.is.read()) < 0) {
                                finished = true;
                                eof = true;
                                continue;
                            }
                            if (ch == 0 && !escaped) {
                                escaped = true;
                                continue;
                            }
                            if (!escaped) {
                                switch (ch) {
                                    case 13: {
                                        break;
                                    }
                                    case 10: {
                                        finished = true;
                                        break;
                                    }
                                    case 26: {
                                        finished = true;
                                        eof = true;
                                        break;
                                    }
                                    default: {
                                        if (bytesStored < length) {
                                            data[offset + bytesStored] = (byte)(ch & 0xFF);
                                            ++bytesStored;
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                            } else if (bytesStored < length) {
                                data[offset + bytesStored] = (byte)(ch & 0xFF);
                                ++bytesStored;
                            }
                            escaped = false;
                        } while (!finished);
                    }
                    catch (Exception eofException) {
                        eof = true;
                    }
                    for (int i = bytesStored; i < length; ++i) {
                        data[offset + i] = Variable.SPACE_BYTE;
                    }
                    return eof ? -10 : bytesStored;
                }
                bytesRead = 0;
                int chunk = 0;
                if (MAX_LENGTH <= 0) {
                    try {
                        while ((chunk = this.is.read(data, offset, length)) > 0) {
                            offset += chunk;
                            if ((bytesRead += chunk) < (length -= chunk)) continue;
                        }
                    }
                    catch (Exception endOfFile) {
                        bytesRead = -1;
                    }
                } else {
                    try {
                        while (length > MAX_LENGTH && (chunk = this.is.read(data, offset, MAX_LENGTH)) > 0) {
                            offset += chunk;
                            length -= chunk;
                            bytesRead += chunk;
                        }
                        if (length <= 0) break block28;
                        while ((chunk = this.is.read(data, offset, length)) > 0) {
                            offset += chunk;
                            if ((bytesRead += chunk) < (length -= chunk)) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        bytesRead = -1;
                    }
                }
            }
            return bytesRead <= 0 ? -10 : bytesRead;
        }
        catch (Exception permanentError) {
            return -30;
        }
    }

    @Override
    public final int close(int mode) {
        this.open = false;
        int result = 0;
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (Exception e) {
            result = -30;
        }
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            result = -30;
        }
        this.p = null;
        this.is = null;
        this.os = null;
        this.readable = true;
        this.writable = true;
        return result;
    }

    @Override
    public final int open(int mode) {
        block11: {
            if (this.open) {
                return -41;
            }
            this.is = null;
            this.os = null;
            this.readable = (mode & 1) != 0;
            this.writable = (mode & 2) != 0;
            try {
                this.p = Runtime.getRuntime().exec(this.filename);
                if (this.p == null) {
                    this.open = false;
                    return -30;
                }
                if (this.readable) {
                    this.is = this.p.getInputStream();
                    if (INBUFFER) {
                        this.is = new BufferedInputStream(this.is);
                    }
                }
                if (this.writable) {
                    this.os = this.p.getOutputStream();
                    if (OUTBUFFER) {
                        this.os = new BufferedOutputStream(this.os);
                    }
                }
                if (!this.readable && !this.writable) break block11;
                this.open = true;
                try {
                    if (OPEN_SLEEP > 0) {
                        Thread.sleep(OPEN_SLEEP);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -30;
    }

    @Override
    public final long getFilePointer() {
        return -90L;
    }

    @Override
    public final int seek(long position) {
        return -90;
    }

    @Override
    public final long length() {
        return -90L;
    }

    @Override
    public final int backup() {
        return 0;
    }

    @Override
    public final boolean isStream() {
        return true;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return false;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final int readLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        return true;
    }

    @Override
    public final Object getObject() {
        return this.p;
    }

    @Override
    public void setBlockSize(int size) {
        MAX_LENGTH = size > 0 ? size : -1;
    }

    @Override
    public void flush() {
        try {
            if (this.os != null) {
                this.os.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

