/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileCountTracker;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.exec.lockManager;
import com.sun.xfile.XFile;
import com.sun.xfile.XFileOutputStream;
import com.sun.xfile.XRandomAccessFile;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public class nfs
implements FileProtocol,
FileConstants {
    private String filename;
    private String wk_filename;
    private boolean readable = true;
    private boolean writable = true;
    private boolean lineSequential;
    private boolean open;
    private XRandomAccessFile Xraf;
    private boolean optionalMissing;
    private long filePosition;
    private long nextFilePosition;
    private lockManager locker = new lockManager();
    private static final char CR = '\r';
    int bufferedReadChar = -1;
    private static Hashtable<String, FileCountTracker> fileregistry = new Hashtable();

    public static final String getProtocol() {
        return "nfs";
    }

    @Override
    public final synchronized boolean init(String filename, boolean lineSequential) {
        if (filename != null) {
            filename = filename.trim();
        }
        this.lineSequential = lineSequential;
        this.readable = true;
        this.writable = true;
        this.optionalMissing = false;
        if (Context.getGlobalFileCharacter() != '\uffff') {
            filename = filename.replace(Context.getGlobalFileCharacter(), File.separatorChar);
        }
        this.filename = filename;
        return true;
    }

    @Override
    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
    }

    public final synchronized boolean initWithLocalFilename(String filename, boolean lineSequential) {
        this.lineSequential = lineSequential;
        this.readable = true;
        this.writable = true;
        this.optionalMissing = false;
        this.filename = filename;
        return true;
    }

    @Override
    public final synchronized int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        try {
            this.Xraf.write(data, offset, length);
            return 0;
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -30;
    }

    @Override
    public final synchronized int read(byte[] data, int offset, int length) {
        int result = this.readInner(data, offset, length);
        return result;
    }

    private final synchronized int readInner(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -47;
        }
        int bytesRead = 0;
        if (this.optionalMissing & !this.open) {
            return -10;
        }
        try {
            this.filePosition = this.nextFilePosition;
            if (this.lineSequential) {
                int minorbytes = 0;
                byte[] buffer = new byte[1];
                try {
                    for (bytesRead = 0; bytesRead <= length; ++bytesRead) {
                        int rc;
                        do {
                            if (this.bufferedReadChar != -1) {
                                rc = this.bufferedReadChar;
                                this.bufferedReadChar = -1;
                                if (bytesRead < length) {
                                    data[offset + bytesRead] = (byte)rc;
                                }
                                minorbytes = 1;
                            } else {
                                if (bytesRead < length) {
                                    try {
                                        minorbytes = this.Xraf.read(data, offset + bytesRead, 1);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    rc = (char)data[offset + bytesRead];
                                } else {
                                    try {
                                        minorbytes = this.Xraf.read(buffer, 0, 1);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    rc = (char)buffer[0];
                                }
                                if (minorbytes == -1) {
                                    rc = 65535;
                                }
                            }
                            if (rc != 13) continue;
                            ++this.nextFilePosition;
                        } while (rc == 13 && minorbytes != -1);
                        if (rc == 10 || minorbytes == -1) {
                            this.nextFilePosition += (long)bytesRead;
                            --bytesRead;
                            if (minorbytes != -1) {
                                if (offset + bytesRead > 0 && data[offset + bytesRead] == 13) {
                                    --bytesRead;
                                }
                                if (bytesRead < 0) {
                                    bytesRead = 0;
                                }
                            }
                            try {
                                for (int i = bytesRead + 1; i < length; ++i) {
                                    data[offset + i] = 32;
                                }
                            }
                            catch (Exception i) {
                                // empty catch block
                            }
                            if (bytesRead <= 0 && minorbytes == -1) {
                                return -10;
                            }
                            return bytesRead;
                        }
                        if (bytesRead != length) continue;
                        this.bufferedReadChar = rc;
                    }
                }
                catch (Exception e) {
                    try {
                        for (int i = bytesRead + 1; i < length; ++i) {
                            data[offset + i] = 32;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return -10;
                }
                if (bytesRead > 0) {
                    this.nextFilePosition += (long)bytesRead;
                    return bytesRead;
                }
                return -10;
            }
            try {
                bytesRead = -1;
                if (this.Xraf.getFilePointer() >= this.Xraf.length()) {
                    return -10;
                }
                bytesRead = this.Xraf.read(data, offset, length);
                if (bytesRead >= 0) {
                    this.nextFilePosition += (long)bytesRead;
                }
            }
            catch (IOException e) {
                return -10;
            }
            catch (Exception e) {
                return -10;
            }
            if (bytesRead <= 0) {
                return -10;
            }
            if (bytesRead <= 0) {
                return -10;
            }
            return bytesRead;
        }
        catch (Exception e) {
            return -30;
        }
    }

    private final int innerClose(int mode) {
        this.readable = true;
        this.writable = true;
        if (this.Xraf != null) {
            try {
                this.Xraf.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.Xraf = null;
        }
        this.open = false;
        return 0;
    }

    @Override
    public final synchronized int open(int mode) {
        this.optionalMissing = false;
        this.bufferedReadChar = -1;
        int returnCode = this.innerOpen(mode);
        if ((mode & 4) != 0) {
            long seekCode;
            if (returnCode <= -10 || returnCode == -5 || returnCode == 5 || returnCode >= 10) {
                return returnCode;
            }
            this.nextFilePosition = seekCode = this.length();
            this.filePosition = seekCode;
            if (seekCode < 0L) {
                return (int)seekCode;
            }
            if ((seekCode = (long)this.seek(seekCode)) != 0L) {
                return (int)seekCode;
            }
        }
        return returnCode;
    }

    private final int innerOpen(int mode) {
        if ((mode & 0x800) != 0) {
            int returnCode;
            mode &= 0xFFFFF7FF;
            FileCountTracker thisfile = fileregistry.get(this.filename);
            if (thisfile == null) {
                returnCode = this.innerOpen2(mode);
                if (returnCode > -10 && returnCode < 10) {
                    fileregistry.put(this.filename, new FileCountTracker(this.Xraf));
                }
            } else {
                thisfile.incCount();
                try {
                    this.Xraf = (XRandomAccessFile)thisfile.getXRandomAccessFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                returnCode = 0;
                this.open = true;
            }
            return returnCode;
        }
        return this.innerOpen2(mode);
    }

    private final int innerOpen2(int mode) {
        this.filePosition = 0L;
        this.nextFilePosition = 0L;
        this.optionalMissing = false;
        boolean newFile = false;
        this.writable = (mode & 2) != 0;
        this.readable = (mode & 1) != 0;
        String stringMode = "r";
        if (this.writable) {
            stringMode = stringMode + "w";
        }
        try {
            this.wk_filename = "nfs:" + this.filename;
            this.Xraf = new XRandomAccessFile(this.wk_filename, "r");
            if (this.readable && !this.writable) {
                this.open = true;
                return 0;
            }
            try {
                this.Xraf.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.writable && (mode & 4) == 0 && !this.readable) {
                try {
                    XFile fout1 = new XFile(this.wk_filename);
                    fout1.delete();
                    XFileOutputStream fout = new XFileOutputStream(this.wk_filename);
                    fout.close();
                    newFile = true;
                }
                catch (Exception fout1) {
                    // empty catch block
                }
            }
            try {
                this.Xraf = new XRandomAccessFile(this.wk_filename, stringMode);
            }
            catch (Exception fout1) {
                // empty catch block
            }
            this.open = true;
            return newFile ? -8 : 0;
        }
        catch (Exception e) {
            newFile = true;
            if ((mode & 8) != 0) {
                this.optionalMissing = true;
                if (this.writable || (mode & 0x400) != 0) {
                    try {
                        this.Xraf = (mode & 0x400) != 0 ? new XRandomAccessFile(this.wk_filename, "rw") : new XRandomAccessFile(this.wk_filename, stringMode);
                        this.open = true;
                    }
                    catch (Exception e1) {
                        return newFile ? 30 : -30;
                    }
                } else {
                    this.optionalMissing = true;
                }
                this.open = true;
                return newFile ? 5 : -5;
            }
            if ((mode & 4) != 0) {
                return newFile ? 35 : -35;
            }
            if (this.writable && !this.readable) {
                try {
                    this.Xraf = new XRandomAccessFile(this.wk_filename, stringMode);
                    this.open = true;
                    return newFile ? -8 : 0;
                }
                catch (Exception e1) {
                    return newFile ? 35 : -35;
                }
            }
            return newFile ? 35 : -35;
        }
    }

    @Override
    public final synchronized int close(int mode) {
        FileCountTracker thisfile;
        if ((mode & 0x800) != 0 && (thisfile = fileregistry.get(this.filename)) != null && !thisfile.decCount()) {
            return 0;
        }
        return this.innerClose(mode);
    }

    @Override
    public final synchronized long getFilePointer() {
        try {
            return this.Xraf.getFilePointer();
        }
        catch (Exception e) {
            return -90L;
        }
    }

    @Override
    public final synchronized int seek(long position) {
        try {
            this.Xraf.seek(position);
            return 0;
        }
        catch (Exception e) {
            return -23;
        }
    }

    @Override
    public final synchronized long length() {
        try {
            return this.Xraf.length();
        }
        catch (Exception e) {
            return -90L;
        }
    }

    @Override
    public final synchronized int backup() {
        return this.seek(this.filePosition);
    }

    @Override
    public final boolean isStream() {
        return false;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return true;
    }

    @Override
    public final synchronized boolean isOpen() {
        return this.open;
    }

    @Override
    public final synchronized int readLock(long offset, int length) {
        return this.locker.readLock(offset, length);
    }

    @Override
    public final synchronized boolean readUnlock(long offset, int length) {
        this.locker.readUnlock(offset, length);
        return true;
    }

    @Override
    public final synchronized boolean readUnlock(int handle) {
        this.locker.readUnlock(handle);
        return true;
    }

    @Override
    public final synchronized int writeLock(long offset, int length) {
        return this.locker.writeLock(offset, length);
    }

    @Override
    public final synchronized boolean writeUnlock(long offset, int length) {
        this.locker.writeUnlock(offset, length);
        return true;
    }

    @Override
    public final synchronized boolean writeUnlock(int handle) {
        this.locker.writeUnlock(handle);
        return true;
    }

    @Override
    public final Object getObject() {
        return this.Xraf;
    }

    @Override
    public void setBlockSize(int size) {
    }

    @Override
    public void flush() {
    }
}

