/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Utilities;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;

public class remote
implements FileProtocol,
FileConstants {
    private boolean lineSequential;
    private Socket server;
    private DataInputStream is;
    private DataOutputStream os;

    public static final String getProtocol() {
        return "remote";
    }

    @Override
    public final boolean init(String filename, boolean lineSequential) {
        boolean returnCode;
        if (filename != null) {
            filename = filename.trim();
        }
        int index = filename.lastIndexOf(58);
        int port = 6584;
        if (index >= 0) {
            try {
                port = Integer.decode(filename.substring(index + 1));
                filename = filename.substring(0, index);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String site = null;
        index = filename.indexOf(58);
        if (index >= 0) {
            site = filename.substring(0, index);
            filename = filename.substring(index + 1);
        }
        if (site == null) {
            site = Utilities.getCodeBase().toString();
        }
        if (site == null) {
            site = RuntimeEnvironment.getGlobalParameter("remotehost");
        }
        if (site == null) {
            site = "127.0.0.1";
        }
        try {
            this.server = new Socket(site, port);
            this.is = new DataInputStream(this.server.getInputStream());
            this.os = new DataOutputStream(this.server.getOutputStream());
        }
        catch (Exception e) {
            this.server = null;
            return false;
        }
        if (Context.getGlobalFileCharacter() != '/') {
            int i = 0;
            do {
                if ((i = filename.indexOf(47, i)) < 0) continue;
                filename = filename.substring(0, i - 1) + '/' + filename.substring(i);
                i += 2;
            } while (i >= 0);
            filename = filename.replace(Context.getGlobalFileCharacter(), '/');
        }
        try {
            this.os.writeByte(1);
            this.os.writeBoolean(lineSequential);
            this.writeString(this.os, filename);
            returnCode = this.is.readBoolean();
        }
        catch (Exception e) {
            returnCode = false;
        }
        return returnCode;
    }

    @Override
    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
    }

    @Override
    public final int write(byte[] data, int offset, int length) {
        int returnCode;
        try {
            this.os.writeByte(5);
            byte[] byteArray = new byte[length];
            System.arraycopy(data, offset, byteArray, 0, length);
            this.writeBytes(this.os, byteArray);
            returnCode = this.is.readInt();
        }
        catch (Exception e) {
            returnCode = -93;
        }
        return returnCode;
    }

    @Override
    public final int read(byte[] data, int offset, int length) {
        int returnCode;
        try {
            this.os.writeByte(4);
            this.os.writeInt(length);
            returnCode = this.is.readInt();
            byte[] byteArray = this.readBytes(this.is);
            System.arraycopy(byteArray, 0, data, offset, byteArray.length);
        }
        catch (Exception e) {
            returnCode = -93;
        }
        return returnCode;
    }

    @Override
    public final int close(int mode) {
        int returnCode;
        try {
            this.os.writeByte(3);
            this.os.writeInt(mode);
            returnCode = this.is.readInt();
        }
        catch (Exception e) {
            returnCode = -93;
        }
        return returnCode;
    }

    @Override
    public final int open(int mode) {
        int returnCode;
        try {
            this.os.writeByte(2);
            this.os.writeInt(mode);
            returnCode = this.is.readInt();
        }
        catch (Exception e) {
            returnCode = -93;
        }
        return returnCode;
    }

    @Override
    public final long getFilePointer() {
        long returnCode;
        try {
            this.os.writeByte(9);
            returnCode = this.is.readLong();
        }
        catch (Exception e) {
            returnCode = -93L;
        }
        return returnCode;
    }

    @Override
    public final int seek(long position) {
        int returnCode;
        try {
            this.os.writeByte(8);
            this.os.writeLong(position);
            returnCode = this.is.readInt();
        }
        catch (Exception e) {
            returnCode = -93;
        }
        return returnCode;
    }

    @Override
    public final long length() {
        long returnCode;
        try {
            this.os.writeByte(7);
            returnCode = this.is.readLong();
        }
        catch (Exception e) {
            returnCode = -93L;
        }
        return returnCode;
    }

    @Override
    public final int backup() {
        int returnCode;
        try {
            this.os.writeByte(6);
            returnCode = this.is.readInt();
        }
        catch (Exception e) {
            returnCode = -93;
        }
        return returnCode;
    }

    @Override
    public final boolean isStream() {
        boolean returnCode;
        try {
            this.os.writeByte(10);
            returnCode = this.is.readBoolean();
        }
        catch (Exception e) {
            returnCode = false;
        }
        return returnCode;
    }

    @Override
    public final boolean isReadable() {
        boolean returnCode;
        try {
            this.os.writeByte(11);
            returnCode = this.is.readBoolean();
        }
        catch (Exception e) {
            returnCode = false;
        }
        return returnCode;
    }

    @Override
    public final boolean isWritable() {
        boolean returnCode;
        try {
            this.os.writeByte(12);
            returnCode = this.is.readBoolean();
        }
        catch (Exception e) {
            returnCode = false;
        }
        return returnCode;
    }

    @Override
    public final boolean isSeekable() {
        boolean returnCode;
        try {
            this.os.writeByte(13);
            returnCode = this.is.readBoolean();
        }
        catch (Exception e) {
            returnCode = false;
        }
        return returnCode;
    }

    @Override
    public final boolean isOpen() {
        boolean returnCode;
        try {
            this.os.writeByte(14);
            returnCode = this.is.readBoolean();
        }
        catch (Exception e) {
            returnCode = false;
        }
        return returnCode;
    }

    @Override
    public final int readLock(long offset, int length) {
        try {
            this.os.writeByte(15);
            this.os.writeLong(offset);
            this.os.writeInt(length);
            return this.is.readInt();
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        try {
            this.os.writeByte(16);
            this.os.writeLong(offset);
            this.os.writeInt(length);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        try {
            this.os.writeByte(17);
            this.os.writeInt(handle);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        try {
            this.os.writeByte(18);
            this.os.writeLong(offset);
            this.os.writeInt(length);
            return this.is.readInt();
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        try {
            this.os.writeByte(19);
            this.os.writeLong(offset);
            this.os.writeInt(length);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        try {
            this.os.writeByte(20);
            this.os.writeInt(handle);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private final byte[] readBytes(DataInputStream is) {
        try {
            int length = is.readInt();
            byte[] byteArray = new byte[length];
            is.readFully(byteArray);
            return byteArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    private final boolean writeBytes(DataOutputStream os, byte[] byteArray) {
        try {
            int length = byteArray.length;
            os.writeInt(length);
            os.write(byteArray, 0, length);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private final boolean writeString(DataOutputStream os, String stringData) {
        try {
            int length = stringData.length();
            os.writeInt(length);
            for (int i = 0; i < length; ++i) {
                os.writeChar(stringData.charAt(i));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public final Object getObject() {
        return this.server;
    }

    @Override
    public void setBlockSize(int size) {
    }

    @Override
    public void flush() {
        try {
            if (this.os != null) {
                this.os.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

