/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.ibm.sslite.SSLContext;
import com.ibm.sslite.SSLException;
import com.ibm.sslite.SSLInputStream;
import com.ibm.sslite.SSLOutputStream;
import com.ibm.sslite.SSLSocket;
import com.ibm.sslite.SSLightKeyRing;
import java.io.IOException;

public class ssliteclient
implements FileProtocol,
FileConstants {
    private String filename;
    private boolean readable = true;
    private boolean writable = true;
    private boolean lineSequential;
    private boolean open;
    private static final char CR = '\r';
    private SSLSocket sslsocket;
    private int port;
    private SSLInputStream is;
    private SSLOutputStream os;
    int bufferedReadChar = -1;

    public static final String getProtocol() {
        return "ssl";
    }

    @Override
    public final boolean init(String filename, boolean lineSequential) {
        if (filename != null) {
            filename = filename.trim();
        }
        this.filename = filename;
        this.lineSequential = lineSequential;
        if (filename.toUpperCase().startsWith("SSLITECLIENT:")) {
            filename = filename.substring(14);
        }
        this.readable = true;
        this.writable = true;
        int i = filename.indexOf(58);
        if (i >= 0) {
            try {
                this.port = Integer.valueOf(filename.substring(i + 1));
            }
            catch (Exception e) {
                this.port = 9335;
            }
            filename = filename.substring(0, i);
        } else {
            try {
                this.port = Integer.valueOf(filename);
            }
            catch (Exception e) {
                this.port = 9335;
            }
        }
        return true;
    }

    @Override
    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
    }

    @Override
    public final int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        try {
            this.os.write(data, offset, length);
            return 0;
        }
        catch (IOException e) {
            return -30;
        }
    }

    @Override
    public final int read(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -47;
        }
        int bytesRead = 0;
        if (this.lineSequential) {
            byte[] buffer = new byte[1];
            try {
                for (bytesRead = 0; bytesRead <= length; ++bytesRead) {
                    int minorbytes;
                    int rc;
                    do {
                        if (this.bufferedReadChar != -1) {
                            rc = this.bufferedReadChar;
                            this.bufferedReadChar = -1;
                            if (bytesRead < length) {
                                data[offset + bytesRead] = (byte)rc;
                            }
                            minorbytes = 1;
                            continue;
                        }
                        if (bytesRead < length) {
                            minorbytes = this.is.read(data, offset + bytesRead, 1);
                            rc = (char)data[offset + bytesRead];
                        } else {
                            minorbytes = this.is.read(buffer, 0, 1);
                            rc = (char)buffer[0];
                        }
                        if (minorbytes != -1) continue;
                        rc = 65535;
                    } while (rc == 13 && minorbytes != -1);
                    if (rc == 10 || minorbytes == -1) {
                        --bytesRead;
                        if (minorbytes != -1) {
                            if (offset + bytesRead > 0 && data[offset + bytesRead] == 13) {
                                --bytesRead;
                            }
                            if (bytesRead < 0) {
                                bytesRead = 0;
                            }
                        }
                        try {
                            for (int i = bytesRead + 1; i < length; ++i) {
                                data[offset + i] = 32;
                            }
                        }
                        catch (Exception i) {
                            // empty catch block
                        }
                        if (bytesRead <= 0 && minorbytes == -1) {
                            return -10;
                        }
                        return bytesRead;
                    }
                    if (bytesRead != length) continue;
                    this.bufferedReadChar = rc;
                }
            }
            catch (Exception e) {
                try {
                    for (int i = bytesRead + 1; i < length; ++i) {
                        data[offset + i] = 32;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return -10;
            }
            if (bytesRead > 0) {
                return bytesRead;
            }
            return -10;
        }
        try {
            bytesRead = this.is.read(data, offset, length);
            if (bytesRead <= 0) {
                return -10;
            }
            int start = 0;
            if (bytesRead > 0) {
                start = bytesRead;
            }
            for (int i = start; i < length; ++i) {
                data[offset + i] = 32;
            }
            return bytesRead;
        }
        catch (Exception e) {
            try {
                return -10;
            }
            catch (Exception t) {
                return -10;
            }
        }
    }

    @Override
    public final int close(int mode) {
        this.open = false;
        if (this.sslsocket != null) {
            try {
                this.sslsocket.close();
                this.sslsocket = null;
            }
            catch (Exception e) {
                return -30;
            }
        }
        this.is = null;
        this.os = null;
        return 0;
    }

    @Override
    public final int open(int mode) {
        if (this.open) {
            return -41;
        }
        if (this.filename.toUpperCase().startsWith("SSLITECLIENT:")) {
            this.filename = this.filename.substring(14);
        }
        SSLContext sslcontext = new SSLContext();
        String ascii = null;
        int i = 0;
        int j = 0;
        int k = 0;
        String password = null;
        int max_parms = 4;
        String[] dest_parm = new String[max_parms];
        boolean cipher_failure = false;
        j = 0;
        for (i = 0; i < max_parms - 1 && j < this.filename.length(); ++i) {
            k = this.filename.indexOf(58, j);
            if (k < 0) continue;
            dest_parm[i] = this.filename.substring(j, k);
            j = k + 1;
        }
        if (j <= this.filename.length() - 1) {
            dest_parm[max_parms - 1] = this.filename.substring(j, this.filename.length() - 1);
        }
        String host = dest_parm[0].substring(2);
        password = dest_parm[3];
        try {
            SSLightKeyRing ring = (SSLightKeyRing)Class.forName(dest_parm[2]).newInstance();
            ascii = ring.getKeyRingData();
            sslcontext.importKeyRings(ascii, password);
        }
        catch (Exception e) {
            return -30;
        }
        if (dest_parm[1] != null) {
            try {
                this.port = Integer.valueOf(dest_parm[1]);
            }
            catch (Exception e) {
                this.port = 9335;
            }
            host = dest_parm[0].substring(2);
        } else if (dest_parm[0] != null) {
            try {
                this.port = Integer.valueOf(this.filename.substring(2));
            }
            catch (Exception e) {
                this.port = 9335;
            }
        } else {
            this.port = 9335;
        }
        String[] cipher_suites = sslcontext.getEnabledCipherSuites();
        try {
            for (i = 0; i < cipher_suites.length; ++i) {
                try {
                    sslcontext.setEnabledCipherSuites(cipher_suites[i]);
                    this.sslsocket = new SSLSocket(host, this.port, sslcontext, false);
                    this.sslsocket.setSoTimeout(1000);
                    this.is = (SSLInputStream)this.sslsocket.getInputStream();
                    this.os = (SSLOutputStream)this.sslsocket.getOutputStream();
                    cipher_failure = false;
                    i = cipher_suites.length;
                    continue;
                }
                catch (SSLException sSLException) {
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!cipher_failure) {
                this.open = true;
                return 0;
            }
            return -30;
        }
        catch (Exception e) {
            return -30;
        }
    }

    @Override
    public final long getFilePointer() {
        return -90L;
    }

    @Override
    public final int seek(long position) {
        return -90;
    }

    @Override
    public final long length() {
        return -90L;
    }

    @Override
    public final int backup() {
        return 0;
    }

    @Override
    public final boolean isStream() {
        return true;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return false;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final int readLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        return true;
    }

    @Override
    public final Object getObject() {
        return this.sslsocket;
    }

    @Override
    public void setBlockSize(int size) {
    }

    @Override
    public void flush() {
        try {
            if (this.os != null) {
                this.os.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

