/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.BufferedRandomAccessFile;
import com.heirloomcomputing.ecs.exec.ICobolInterface;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.QuickVector;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.basicFile;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Vector;

public class smFile {
    protected int minimum = -1;
    protected int maximum = -1;
    protected Variable dependingOn;
    protected String filename;
    protected Variable filenameVariable;
    protected Variable mainVariable;
    private Vector<Variable> keys;
    private Vector<Variable> keysComparand;
    private Vector<String> direction;
    private final String ascendingMark = "A";
    private final String descendingMark = "D";
    private String directionMark;
    private Vector<basicFile> inputFiles;
    private Vector<basicFile> outputFiles;
    private int inputPerformFrom = -1;
    private int inputPerformTo = -1;
    private int outputPerformFrom = -1;
    private int outputPerformTo = -1;
    private Vector<Object> recordList;
    private Vector<Integer> originalOrder;
    private int[] originalOrderArray;
    private int returnOffset = -1;
    private Variable masterRecord;
    private Memory memoryA;
    private Memory memoryB;
    private int baseAddress;
    private int topAddress;
    private BufferedRandomAccessFile raf;
    private byte[] alpha;
    private byte[] beta;
    private Variable[] sortArray = null;

    private final int size() {
        if (this.dependingOn != null) {
            try {
                return this.dependingOn.toInt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.maximum;
    }

    private final int getOrigOrder(int n) {
        return this.originalOrder.elementAt(n);
    }

    private final int getOrigOrderArray(int n) {
        return this.originalOrderArray[n];
    }

    private final void setOrigOrder(int n, int order) {
        this.originalOrder.setElementAt(new Integer(order), n);
    }

    private final void setOrigOrderArray(int n, int order) {
        this.originalOrderArray[n] = order;
    }

    private final void addOrigOrder(int returnOffset) {
        this.originalOrder.addElement(new Integer(returnOffset));
    }

    public String getFilename() {
        return this.filename;
    }

    public final void declare(String assignTo, int recordFrom, int recordTo, Variable dependingOn, Variable notUsed) {
        String nameValue = basicFile.resolveExpandedAlias(assignTo);
        if (nameValue != null) {
            String[] nameAndValue = nameValue.split("=");
            this.filename = nameAndValue[1];
        } else {
            this.filename = assignTo;
        }
        if (recordFrom > recordTo) {
            recordTo = recordFrom;
        }
        this.minimum = recordFrom;
        this.setMaximum(recordTo);
        this.dependingOn = dependingOn;
        this.directionMark = "A";
    }

    public final void declare(String assignTo, int recordFrom, int recordTo, Variable dependingOn, Variable notUsed, int newModes) {
        this.declare(assignTo, recordFrom, recordTo, dependingOn, notUsed);
    }

    public final void declare(Variable assignTo, int recordFrom, int recordTo, Variable dependingOn, Variable notUsed) {
        this.filenameVariable = assignTo;
        if (recordFrom > recordTo) {
            recordTo = recordFrom;
        }
        this.minimum = recordFrom;
        this.setMaximum(recordTo);
        this.dependingOn = dependingOn;
        this.directionMark = "A";
    }

    public final void declare(Variable assignTo, int recordFrom, int recordTo, Variable dependingOn, Variable notUsed, int newModes) {
        this.declare(assignTo, recordFrom, recordTo, dependingOn, notUsed);
    }

    public final boolean release(Variable record) {
        record.flushToMemory();
        Variable copy = (Variable)record.copy();
        if (copy.notify == null) {
            copy.notify = new QuickVector();
        }
        copy.notify.addElement(record);
        ++this.returnOffset;
        this.setRecord(this.returnOffset, copy);
        this.addOrigOrder(this.returnOffset);
        return false;
    }

    public final boolean returnRecord(Variable record) {
        if (this.returnOffset >= 0) {
            record.move(this.record(this.returnOffset));
            if (this.raf == null) {
                this.recordList.removeElementAt(this.returnOffset);
            }
            --this.returnOffset;
            return false;
        }
        this.reset();
        return true;
    }

    private final void usingFile(basicFile file2, String collatingSequence) {
        file2.open(1);
        boolean endOfFile = false;
        do {
            Variable temp = Variable.newVariableOfSize(this.size());
            temp.getMemory().setCollatingSequence(collatingSequence);
            endOfFile = file2.read(temp);
            if (endOfFile) continue;
            this.release(temp);
        } while (!endOfFile);
        file2.close();
    }

    private final void givingFile(basicFile file2) {
        file2.open(2);
        int holder = this.returnOffset;
        while (this.returnOffset >= 0) {
            file2.write(this.record(this.returnOffset));
            --this.returnOffset;
        }
        this.returnOffset = holder;
        file2.close();
    }

    private final Variable findMasterRecord() {
        if (this.keys == null) {
            this.masterRecord = null;
            return null;
        }
        this.masterRecord = this.keys.elementAt(0);
        this.memoryA.setDecimal(this.masterRecord.getDecimal());
        this.memoryA.setComma(this.masterRecord.getComma());
        this.memoryA.setCurrency(this.masterRecord.getCurrency());
        this.memoryA.setCollatingSequence(this.masterRecord.getMemory().getCollatingSequence());
        this.memoryB.setDecimal(this.masterRecord.getDecimal());
        this.memoryB.setComma(this.masterRecord.getComma());
        this.memoryB.setCurrency(this.masterRecord.getCurrency());
        this.memoryB.setCollatingSequence(this.masterRecord.getMemory().getCollatingSequence());
        while (this.masterRecord.getParent() != null) {
            this.masterRecord = this.masterRecord.getParent();
        }
        return this.masterRecord;
    }

    private final void setupKeys() {
        int length = this.keys.size();
        this.keysComparand = new Vector(length);
        for (int i = 0; i < length; ++i) {
            Variable key = this.keys.elementAt(i);
            key.flushToMemory();
            key.setAddress(key.getAddress() - this.masterRecord.getAddress());
            Variable keyComparand = (Variable)key.clone();
            this.keysComparand.addElement(keyComparand);
            key.setMemoryOld(this.memoryA);
            keyComparand.setMemoryOld(this.memoryB);
        }
    }

    private final void setupRecords(Variable varA, Variable varB) {
        int i;
        varA.flushToMemory();
        varB.flushToMemory();
        Memory varAMemory = varA.getMemory();
        Memory varBMemory = varB.getMemory();
        int size = 0;
        try {
            size = this.size();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (size > this.memoryA.getTopOfMemory()) {
                size = this.memoryA.getTopOfMemory();
            }
            if (size > varAMemory.getTopOfMemory()) {
                int maxsize = size;
                for (i = size = varAMemory.getTopOfMemory(); i < maxsize; ++i) {
                    this.memoryA.setByte(i, (byte)0);
                }
            }
            varAMemory.copy(0, this.memoryA, 0, size);
        }
        catch (Exception maxsize) {
            // empty catch block
        }
        try {
            if (size > this.memoryB.getTopOfMemory()) {
                size = this.memoryB.getTopOfMemory();
            }
            if (size > varBMemory.getTopOfMemory()) {
                int maxsize = size;
                for (i = size = varBMemory.getTopOfMemory(); i < maxsize; ++i) {
                    this.memoryB.setByte(i, (byte)0);
                }
            }
            varBMemory.copy(0, this.memoryB, 0, size);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void merge(ICobolInterface program, String collatingSequence) {
        this.sort(program, 0, collatingSequence);
    }

    public final void sort(ICobolInterface program, int duplicates, String collatingSequence) {
        int i2;
        this.findMasterRecord();
        this.setupKeys();
        if (this.sortArray != null) {
            this.quickSortArray(duplicates == 512, collatingSequence);
            this.updateOriginalSortArray();
            return;
        }
        if (this.filenameVariable != null) {
            this.filename = this.filenameVariable.toString();
            this.filename = this.filename.trim();
        }
        if (this.filename != null && this.filename.length() > 0) {
            try {
                if (this.filename.startsWith("LINE:")) {
                    this.filename = this.filename.substring(5);
                }
                this.raf = new BufferedRandomAccessFile(new RandomAccessFile(this.filename, "rw"), this.maximum + 4);
            }
            catch (Throwable t) {
                this.raf = null;
            }
        }
        int numberOfFiles = this.inputFiles.size();
        for (i2 = 0; i2 < numberOfFiles; ++i2) {
            this.usingFile(this.inputFiles.elementAt(i2), collatingSequence);
        }
        this.inputFiles = null;
        if (this.inputPerformFrom != -1) {
            try {
                program.perform(this.inputPerformFrom, this.inputPerformTo);
            }
            catch (Throwable i2) {
                // empty catch block
            }
        }
        this.quickSortRecords(duplicates == 512, collatingSequence);
        numberOfFiles = this.outputFiles.size();
        for (i2 = 0; i2 < numberOfFiles; ++i2) {
            this.givingFile(this.outputFiles.elementAt(i2));
        }
        if (this.outputPerformFrom != -1) {
            try {
                program.perform(this.outputPerformFrom, this.outputPerformTo);
            }
            catch (Throwable i3) {
                // empty catch block
            }
        }
        if (this.raf != null) {
            try {
                this.raf.close();
                File f = new File(this.filename);
                f.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.raf = null;
        }
    }

    private final Variable record(int n) {
        if (this.raf == null) {
            return (Variable)this.recordList.elementAt(n);
        }
        try {
            this.raf.seek((this.maximum + 4) * n);
            int thesize = this.raf.readInt();
            byte[] byteArray = new byte[thesize];
            this.raf.read(byteArray, 0, this.maximum);
            return new Variable(byteArray);
        }
        catch (Exception e) {
            return new Variable(new byte[this.maximum]);
        }
    }

    private final Variable recordArray(int n) {
        try {
            return this.sortArray[n - 1];
        }
        catch (Exception arrayException) {
            return new Variable(new byte[this.maximum]);
        }
    }

    private final void setRecord(int n, Variable variable) {
        if (this.raf == null) {
            if (n >= this.recordList.size()) {
                this.recordList.addElement(variable);
            } else {
                this.recordList.setElementAt(variable, n);
            }
        } else {
            try {
                this.raf.seek((this.maximum + 4) * n);
                int thesize = variable.length();
                this.raf.writeInt(thesize);
                this.raf.write(variable.getMemory().getBytes(variable.getAddress(), thesize), 0, thesize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void setRecordFromRecord(int i, int j) {
        if (i == j) {
            return;
        }
        if (this.raf == null) {
            Variable variable = null;
            variable = (Variable)this.recordList.elementAt(j);
            if (i >= this.recordList.size()) {
                this.recordList.addElement(variable);
            } else {
                this.recordList.setElementAt(variable, i);
            }
        } else {
            byte[] byteArray = null;
            int thesize = this.maximum;
            try {
                this.raf.seek((this.maximum + 4) * j);
                thesize = this.raf.readInt();
                byteArray = new byte[thesize];
                this.raf.read(byteArray, 0, this.maximum);
            }
            catch (Exception e) {
                thesize = this.maximum;
                byteArray = new byte[thesize];
            }
            try {
                this.raf.seek((this.maximum + 4) * i);
                this.raf.writeInt(thesize);
                this.raf.write(byteArray, 0, thesize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void swapRecordForRecord(int i, int j) {
        if (i == j) {
            return;
        }
        if (this.raf == null) {
            try {
                Object alpha_var = this.recordList.elementAt(i);
                Object beta_var = this.recordList.elementAt(j);
                this.recordList.setElementAt(alpha_var, j);
                this.recordList.setElementAt(beta_var, i);
            }
            catch (Exception alpha_var) {}
        } else {
            int alpha_size = 0;
            int beta_size = 0;
            long ipos = (this.maximum + 4) * i;
            long jpos = (this.maximum + 4) * j;
            try {
                this.raf.seek(ipos);
                alpha_size = this.raf.readInt();
                this.raf.read(this.alpha, 0, this.maximum);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.raf.seek(jpos);
                beta_size = this.raf.readInt();
                this.raf.read(this.beta, 0, this.maximum);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.raf.seek(jpos);
                this.raf.writeInt(alpha_size);
                this.raf.write(this.alpha, 0, alpha_size);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.raf.seek(ipos);
                this.raf.writeInt(beta_size);
                this.raf.write(this.beta, 0, beta_size);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final Variable keyA(int n) {
        return this.keys.elementAt(n);
    }

    private final Variable keyB(int n) {
        return this.keysComparand.elementAt(n);
    }

    private final boolean isAscending(int n) {
        return this.direction.elementAt(n) == "A";
    }

    public final int compareRecords(int i, Variable jrec, int origj, String collatingSequence) {
        int result = 0;
        int keysToCompare = this.keys.size();
        int type = 0;
        Variable a = this.record(i);
        Variable b = jrec;
        this.setupRecords(a, b);
        for (int k = 0; k < keysToCompare; ++k) {
            Numeric keybn;
            Numeric keyan;
            Variable keya = this.keyA(k);
            Variable keyb = this.keyB(k);
            if (keya.isNumericInstance()) {
                keyan = (Numeric)keya;
                type = 1;
            } else {
                keyan = null;
                type = 0;
            }
            if (keyb.isNumericInstance()) {
                keybn = (Numeric)keyb;
                type += 2;
            } else {
                keybn = null;
            }
            switch (type) {
                case 0: {
                    keya.fillFromMemory();
                    keyb.fillFromMemory();
                    result = keya.compare(keyb, collatingSequence);
                    break;
                }
                case 1: {
                    keyan.fillFromMemory();
                    keyb.fillFromMemory();
                    result = keyan.compare(keyb, collatingSequence);
                    break;
                }
                case 2: {
                    keya.fillFromMemory();
                    keybn.fillFromMemory();
                    result = keya.compare(keybn, collatingSequence);
                    break;
                }
                case 3: {
                    keyan.fillFromMemory();
                    keybn.fillFromMemory();
                    result = keyan.compare(keybn, collatingSequence);
                }
            }
            if (result > 0) {
                return this.isAscending(k) ? -1 : 1;
            }
            if (result >= 0) continue;
            return this.isAscending(k) ? 1 : -1;
        }
        if (origj != -1) {
            if (this.getOrigOrder(i) > origj) {
                return -1;
            }
            if (this.getOrigOrder(i) < origj) {
                return 1;
            }
        }
        return 0;
    }

    public final int compareRecords(int i, Variable jrec, String collatingSequence) {
        int result = 0;
        int keysToCompare = this.keys.size();
        int type = 0;
        Variable a = this.record(i);
        Variable b = jrec;
        this.setupRecords(a, b);
        for (int k = 0; k < keysToCompare; ++k) {
            Numeric keybn;
            Numeric keyan;
            Variable keya = this.keyA(k);
            Variable keyb = this.keyB(k);
            if (keya.isNumericInstance()) {
                keyan = (Numeric)keya;
                type = 1;
            } else {
                keyan = null;
                type = 0;
            }
            if (keyb.isNumericInstance()) {
                keybn = (Numeric)keyb;
                type += 2;
            } else {
                keybn = null;
            }
            switch (type) {
                case 0: {
                    keya.fillFromMemory();
                    keyb.fillFromMemory();
                    result = keya.compare(keyb, collatingSequence);
                    break;
                }
                case 1: {
                    keyan.fillFromMemory();
                    keyb.fillFromMemory();
                    result = keyan.compare(keyb, collatingSequence);
                    break;
                }
                case 2: {
                    keya.fillFromMemory();
                    keybn.fillFromMemory();
                    result = keya.compare(keybn, collatingSequence);
                    break;
                }
                case 3: {
                    keyan.fillFromMemory();
                    keybn.fillFromMemory();
                    result = keyan.compare(keybn, collatingSequence);
                }
            }
            if (result > 0) {
                return this.isAscending(k) ? -1 : 1;
            }
            if (result >= 0) continue;
            return this.isAscending(k) ? 1 : -1;
        }
        return 0;
    }

    public final int compareRecordsArray(int i, Variable jrec, int origj, String collatingSequence) {
        int result = 0;
        int keysToCompare = this.keys.size();
        this.setupRecords(this.recordArray(i), jrec);
        for (int k = 0; k < keysToCompare; ++k) {
            Numeric keyan = null;
            Numeric keybn = null;
            Variable keya = this.keyA(k);
            Variable keyb = this.keyB(k);
            if (keya.isNumericInstance()) {
                keyan = (Numeric)keya;
            }
            if (keyb.isNumericInstance()) {
                keybn = (Numeric)keyb;
            }
            if (keyan != null) {
                keyan.fillFromMemory();
            } else {
                keya.fillFromMemory();
            }
            if (keybn != null) {
                keybn.fillFromMemory();
            } else {
                keyb.fillFromMemory();
            }
            if (keyan != null && keybn != null) {
                result = keyan.compare(keybn);
            } else if (keyan == null && keybn == null) {
                result = keya.compare(keyb, collatingSequence);
            } else if (keyan == null && keybn != null) {
                result = keya.compare(keybn, collatingSequence);
            } else if (keyan != null && keybn == null) {
                result = keyan.compare(this.keyB(k), collatingSequence);
            }
            if (result > 0) {
                return this.isAscending(k) ? -1 : 1;
            }
            if (result >= 0) continue;
            return this.isAscending(k) ? 1 : -1;
        }
        if (origj != -1) {
            if (this.getOrigOrderArray(i) > origj) {
                return -1;
            }
            if (this.getOrigOrderArray(i) < origj) {
                return 1;
            }
        }
        return 0;
    }

    private final void quickSortRecords(boolean duplicates, String collatingSequence) {
        if (duplicates) {
            this.quicksortDuplicates(collatingSequence, 0, this.returnOffset);
        } else {
            this.quicksort(collatingSequence, 0, this.returnOffset);
        }
    }

    private final void quicksortDuplicates(String collatingSequence, int l, int r) {
        int origv = -1;
        if (r > l) {
            int i = l;
            int j = r;
            int pivot = (l + r) / 2;
            Variable v = this.record(pivot);
            origv = this.getOrigOrder(pivot);
            while (true) {
                if (i < r && this.compareRecords(i, v, origv, collatingSequence) < 0) {
                    ++i;
                    continue;
                }
                while (j > l && this.compareRecords(j, v, origv, collatingSequence) > 0) {
                    --j;
                }
                if (i <= j) {
                    this.swapRecords(i, j);
                    ++i;
                    --j;
                }
                if (i > j) break;
            }
            if (l < j) {
                this.quicksortDuplicates(collatingSequence, l, j);
            }
            if (i < r) {
                this.quicksortDuplicates(collatingSequence, i, r);
            }
        }
    }

    private final void quicksort(String collatingSequence, int l, int r) {
        if (r > l) {
            int i = l;
            int j = r;
            Variable v = this.record((l + r) / 2);
            while (true) {
                if (i < r && this.compareRecords(i, v, collatingSequence) < 0) {
                    ++i;
                    continue;
                }
                while (j > l && this.compareRecords(j, v, collatingSequence) > 0) {
                    --j;
                }
                if (i <= j) {
                    this.swapRecords(i, j);
                    ++i;
                    --j;
                }
                if (i > j) break;
            }
            if (l < j) {
                this.quicksort(collatingSequence, l, j);
            }
            if (i < r) {
                this.quicksort(collatingSequence, i, r);
            }
        }
    }

    private final void swapRecords(int i, int j) {
        this.swapRecordForRecord(i, j);
        int swaporder = this.getOrigOrder(i);
        this.setOrigOrder(i, this.getOrigOrder(j));
        this.setOrigOrder(j, swaporder);
    }

    private final void quickSortArray(boolean duplicates, String collatingSequence) {
        this.quicksortArray(duplicates, collatingSequence, 0, this.returnOffset);
    }

    private final void quicksortArray(boolean duplicates, String collatingSequence, int l, int r) {
        int origv = -1;
        if (r > l) {
            int i = l;
            int j = r;
            int pivot = (l + r) / 2;
            Variable v = this.recordArray(pivot);
            if (duplicates) {
                origv = this.getOrigOrderArray(pivot);
            }
            while (true) {
                if (i < r && this.compareRecordsArray(i, v, origv, collatingSequence) < 0) {
                    ++i;
                    continue;
                }
                while (j > l && this.compareRecordsArray(j, v, origv, collatingSequence) > 0) {
                    --j;
                }
                if (i <= j) {
                    this.swapRecordsArray(i, j);
                    ++i;
                    --j;
                }
                if (i > j) break;
            }
            if (l < j) {
                this.quicksortArray(duplicates, collatingSequence, l, j);
            }
            if (i < r) {
                this.quicksortArray(duplicates, collatingSequence, i, r);
            }
        }
    }

    private final void swapRecordsArray(int i, int j) {
        Variable o = this.sortArray[i];
        this.sortArray[i] = this.sortArray[j];
        this.sortArray[j] = o;
        int swaporder = this.getOrigOrderArray(i);
        this.setOrigOrderArray(i, this.getOrigOrderArray(j));
        this.setOrigOrderArray(j, swaporder);
    }

    private final void updateOriginalSortArray() {
        try {
            int i;
            int length = this.sortArray.length;
            byte[] storage = new byte[this.topAddress - this.baseAddress];
            Variable v = null;
            for (i = 0; i < length; ++i) {
                if (this.sortArray[i] == null) continue;
                this.sortArray[i].flushToMemory();
            }
            for (i = 0; i < length; ++i) {
                if (this.sortArray[i] == null) continue;
                v = this.sortArray[i];
                v.getMemory().copy(v.getAddress(), storage, i * this.maximum, v.length());
            }
            if (v != null) {
                v.getMemory().copy(storage, 0, this.baseAddress, this.topAddress - this.baseAddress);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final smFile reset() {
        if (this.maximum < 0) {
            this.setMaximum(0);
        }
        this.memoryA = new Memory(this.maximum, new String[0]);
        this.memoryB = new Memory(this.maximum, new String[0]);
        this.keys = new Vector();
        this.direction = new Vector();
        this.directionMark = "A";
        this.inputPerformFrom = -1;
        this.inputPerformTo = -1;
        this.outputPerformFrom = -1;
        this.outputPerformTo = -1;
        this.inputFiles = new Vector();
        this.outputFiles = new Vector();
        this.returnOffset = -1;
        this.recordList = new Vector();
        this.originalOrder = new Vector();
        this.sortArray = null;
        return this;
    }

    public final smFile reset(Object[] array) {
        this.keys = new Vector();
        this.direction = new Vector();
        this.directionMark = "A";
        this.inputPerformFrom = -1;
        this.inputPerformTo = -1;
        this.outputPerformFrom = -1;
        this.outputPerformTo = -1;
        this.inputFiles = new Vector();
        this.outputFiles = new Vector();
        this.returnOffset = -1;
        this.recordList = new Vector();
        this.originalOrder = new Vector();
        this.sortArray = null;
        if (this.sortArray != null) {
            return this;
        }
        if (array == null) {
            return this;
        }
        int length = array.length + 1;
        this.originalOrderArray = new int[length];
        this.minimum = -1;
        this.setMaximum(0);
        this.baseAddress = -1;
        this.topAddress = 0;
        this.sortArray = new Variable[length];
        for (int i = 0; i < length; ++i) {
            this.originalOrderArray[i] = i;
            try {
                int address;
                this.sortArray[i] = (Variable)array[i];
                int reclen = this.sortArray[i].length();
                if (reclen < this.minimum || this.minimum < 0) {
                    this.minimum = reclen;
                }
                if (reclen > this.maximum) {
                    this.setMaximum(reclen);
                }
                if ((address = this.sortArray[i].getAddress()) < this.baseAddress || this.baseAddress < 0) {
                    this.baseAddress = address;
                }
                if (address + reclen <= this.topAddress) continue;
                this.topAddress = address + reclen;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.memoryA = new Memory(this.maximum, new String[0]);
        this.memoryB = new Memory(this.maximum, new String[0]);
        return this;
    }

    public final void init() {
        this.reset();
    }

    public final smFile ascend() {
        this.directionMark = "A";
        return this;
    }

    public final smFile descend() {
        this.directionMark = "D";
        return this;
    }

    public final smFile key(Variable variable) {
        variable.flushToMemory();
        this.keys.addElement((Variable)variable.clone());
        this.direction.addElement(this.directionMark);
        return this;
    }

    public final smFile input(int perform) {
        this.inputPerformFrom = perform;
        this.inputPerformTo = perform;
        return this;
    }

    public final smFile input(int performFrom, int performTo) {
        this.inputPerformFrom = performFrom;
        this.inputPerformTo = performTo;
        return this;
    }

    public final smFile output(int perform) {
        this.outputPerformFrom = perform;
        this.outputPerformTo = perform;
        return this;
    }

    public final smFile output(int performFrom, int performTo) {
        this.outputPerformFrom = performFrom;
        this.outputPerformTo = performTo;
        return this;
    }

    public final smFile using(basicFile file2) {
        this.inputFiles.addElement(file2);
        return this;
    }

    public final smFile using(Object[] array) {
        if (this.sortArray != null) {
            return this;
        }
        if (array == null) {
            return this;
        }
        int length = array.length + 1;
        this.originalOrderArray = new int[length];
        this.minimum = -1;
        this.setMaximum(0);
        this.baseAddress = -1;
        this.topAddress = 0;
        this.sortArray = new Variable[length];
        for (int i = 0; i < length; ++i) {
            this.originalOrderArray[i] = i;
            try {
                int address;
                this.sortArray[i] = (Variable)array[i];
                int reclen = this.sortArray[i].length();
                if (reclen < this.minimum || this.minimum < 0) {
                    this.minimum = reclen;
                }
                if (reclen > this.maximum) {
                    this.setMaximum(reclen);
                }
                if ((address = this.sortArray[i].getAddress()) < this.baseAddress || this.baseAddress < 0) {
                    this.baseAddress = address;
                }
                if (address + reclen <= this.topAddress) continue;
                this.topAddress = address + reclen;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    private void setMaximum(int value) {
        this.maximum = value;
        if (this.maximum > 0) {
            if (this.alpha == null || this.alpha.length != this.maximum) {
                this.alpha = new byte[this.maximum];
            }
            if (this.beta == null || this.beta.length != this.maximum) {
                this.beta = new byte[this.maximum];
            }
        } else {
            this.alpha = null;
            this.beta = null;
        }
    }

    public final smFile giving(basicFile file2) {
        this.outputFiles.addElement(file2);
        return this;
    }

    public final smFile giving(Object[] array) {
        if (this.sortArray != null) {
            return this;
        }
        this.using(array);
        return this;
    }

    public final smFile keyArea(Variable keyArea) {
        return this;
    }

    public final Object getObject() {
        return null;
    }

    public boolean deleteFile() {
        return false;
    }
}

