/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.isamsql;

import com.heirloomcomputing.ecs.isamsql.DCB;
import com.heirloomcomputing.ecs.isamsql.DCBFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeMap;

public class DCBDB
extends DCB {
    private static Connection conn;
    public static boolean LOGDCB;

    private void init() {
        this.datasetName = null;
        this.datasetNamePath = null;
        this.organization = null;
        this.orientation = null;
        this.recordFormat = null;
        this.protocols = null;
        this.recordMinimum = null;
        this.recordAverage = null;
        this.lrecl = null;
        this.blksize = null;
        this.bufno = null;
        this.bufsize = null;
        this.limit = null;
        this.keyOffset = null;
        this.keyLength = null;
        this.altKeyOffsets = null;
        this.altKeyLengths = null;
        this.altKeyDuplicates = null;
        this.altKeyGroups = null;
        this.dcbPath = null;
        this.properties = null;
        this.label = null;
        this.expdt = null;
        this.reuse = null;
        this.relate = null;
        this.associates = null;
        this.path = null;
        this.fileLock = null;
        this.onDisk = false;
        this.isDamaged = false;
        this.changed = false;
        this.charset = null;
        this.notSticky = 0;
    }

    public DCBDB() {
        this.init();
        if (System.getProperty("logdcb") != null) {
            LOGDCB = true;
        }
    }

    public DCBDB(DCB cpy) {
        super(cpy);
        if (System.getProperty("logdcb") != null) {
            LOGDCB = true;
        }
    }

    public DCBDB(String dsn, String dsnPath) {
        super(dsn, dsnPath);
        if (System.getProperty("logdcb") != null) {
            LOGDCB = true;
        }
    }

    public DCBDB(String dsn, String dsnPath, boolean forUpdate) {
        super(dsn, dsnPath, forUpdate);
        if (System.getProperty("logdcb") != null) {
            LOGDCB = true;
        }
    }

    @Override
    public void removeDCB(String dsn) {
        if (LOGDCB) {
            System.out.println("DCBDB->removeDCB(" + dsn + ");");
        }
        DCBDB.removeDcbEntry(dsn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDcbEntry(String dsn) {
        if (LOGDCB) {
            System.out.println("DCBDB->removeDcbEntry(" + dsn + ");");
        }
        Statement ps = null;
        try {
            Connection connection = DCBDB.getConnection();
            if (connection == null) {
                System.err.println("Failed to make connection!");
                return;
            }
            String sql = "DELETE FROM \"DCBDB" + DCBFactory.getDcbTableNameExt() + "\" WHERE DSNAME = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, dsn);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
    }

    public static void rm_rf(File ford) {
        if (LOGDCB) {
            System.out.println("DCBDB->rm_rf(" + ford.getName() + ");");
        }
        if (ford.isDirectory()) {
            for (File child : ford.listFiles()) {
                DCBDB.rm_rf(child);
            }
        }
        DCBDB.removeDcbEntry(ford.getName());
    }

    @Override
    public synchronized RandomAccessFile loadDCB() {
        if (LOGDCB) {
            System.out.println("DCBDB->loadDCB();");
        }
        boolean forUpdate = false;
        RandomAccessFile raf = null;
        this.loadDCB(forUpdate);
        return raf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void loadDCB(boolean forupdate) {
        block57: {
            if (LOGDCB) {
                System.out.println("DCBDB->loadDCB(" + forupdate + ");");
            }
            if (this.isDamaged || this.datasetNamePath == null) {
                return;
            }
            this.properties = new Properties();
            if (this.datasetNamePath.startsWith("/dev") || this.datasetNamePath.equalsIgnoreCase("NUL:")) {
                return;
            }
            File dsnFile = new File(this.datasetNamePath);
            if (this.datasetName == null) {
                this.datasetName = dsnFile.getName();
            }
            if (!dsnFile.isDirectory()) {
                String baseName;
                File dsnParentDir;
                if (this.datasetName.matches("^G[0-9]{4}V00")) {
                    dsnParentDir = dsnFile.getParentFile();
                    if (dsnParentDir != null && dsnParentDir.isDirectory() && (baseName = dsnParentDir.getName()) != null) {
                        this.datasetName = baseName + "." + this.datasetName;
                    }
                } else if (!this.datasetName.contains(".") && (dsnParentDir = dsnFile.getParentFile()) != null && dsnParentDir.isDirectory() && (baseName = dsnParentDir.getName()).contains(".")) {
                    this.datasetName = baseName + "." + this.datasetName;
                }
            }
            Statement ps = null;
            try {
                Connection connection = DCBDB.getConnection();
                if (connection == null) {
                    System.err.println("Failed to make connection!");
                    return;
                }
                String sql = "SELECT DSNAME, LRECL, DSORG, ORIENTATION, PROTOTYPE, RECFM, RECMIN, RECAVG, CHARSET, BLKSIZE, GDG_LIMIT, KEYLEN, KEYOFF, ALTKEYOFFS, ALTKEYLENS, ALTKEYDUPS, ALTKEYGROUPS, LABEL, EXPDT, REUSE, RELATE, ASSOCIATES, PATH, UPDATE_USER, UPDATE_TS  FROM \"DCBDB" + DCBFactory.getDcbTableNameExt() + "\" WHERE DSNAME = ?";
                ps = connection.prepareStatement(sql);
                ps.setString(1, this.datasetName);
                boolean hasResultSet = ps.execute();
                if (hasResultSet) {
                    ResultSet rs = ps.getResultSet();
                    if (rs.next()) {
                        if (rs.getString(2) != null && rs.getString(2).length() > 0) {
                            this.properties.put(this.datasetName + "-lrecl", rs.getString(2));
                        }
                        if (rs.getString(3) != null && rs.getString(3).length() > 0) {
                            this.properties.put(this.datasetName + "-dsorg", rs.getString(3));
                        }
                        if (rs.getString(4) != null && rs.getString(4).length() > 0) {
                            this.properties.put(this.datasetName + "-orient", rs.getString(4));
                        }
                        if (rs.getString(5) != null && rs.getString(5).length() > 0) {
                            this.properties.put(this.datasetName + "-proto", rs.getString(5));
                        }
                        if (rs.getString(6) != null && rs.getString(6).length() > 0) {
                            this.properties.put(this.datasetName + "-recfm", rs.getString(6));
                        }
                        if (rs.getString(7) != null && rs.getString(7).length() > 0) {
                            this.properties.put(this.datasetName + "-recmin", rs.getString(7));
                        }
                        if (rs.getString(8) != null && rs.getString(8).length() > 0) {
                            this.properties.put(this.datasetName + "-recavg", rs.getString(8));
                        }
                        if (rs.getString(9) != null && rs.getString(9).length() > 0) {
                            this.properties.put(this.datasetName + "-charset", rs.getString(9));
                        }
                        if (rs.getString(10) != null && rs.getString(10).length() > 0) {
                            this.properties.put(this.datasetName + "-blksize", rs.getString(10));
                        }
                        if (rs.getString(11) != null && rs.getString(11).length() > 0) {
                            this.properties.put(this.datasetName + "-limit", rs.getString(11));
                        }
                        if (rs.getString(12) != null && rs.getString(12).length() > 0) {
                            this.properties.put(this.datasetName + "-keylen", rs.getString(12));
                        }
                        if (rs.getString(13) != null && rs.getString(13).length() > 0) {
                            this.properties.put(this.datasetName + "-keyoff", rs.getString(13));
                        }
                        if (rs.getString(14) != null && rs.getString(14).length() > 0) {
                            this.properties.put(this.datasetName + "-altkeyoffs", rs.getString(14));
                        }
                        if (rs.getString(15) != null && rs.getString(15).length() > 0) {
                            this.properties.put(this.datasetName + "-altkeylens", rs.getString(15));
                        }
                        if (rs.getString(16) != null && rs.getString(16).length() > 0) {
                            this.properties.put(this.datasetName + "-altkeydups", rs.getString(16));
                        }
                        if (rs.getString(17) != null && rs.getString(17).length() > 0) {
                            this.properties.put(this.datasetName + "-altkeygroups", rs.getString(17));
                        }
                        if (rs.getString(18) != null && rs.getString(18).length() > 0) {
                            this.properties.put(this.datasetName + "-label", rs.getString(18));
                        }
                        if (rs.getString(19) != null && rs.getString(19).length() > 0) {
                            this.properties.put(this.datasetName + "-expdt", rs.getString(19));
                        }
                        if (rs.getString(20) != null && rs.getString(20).length() > 0) {
                            this.properties.put(this.datasetName + "-reuse", rs.getString(20));
                        }
                        if (rs.getString(21) != null && rs.getString(21).length() > 0) {
                            this.properties.put(this.datasetName + "-relate", rs.getString(21));
                        }
                        if (rs.getString(22) != null && rs.getString(22).length() > 0) {
                            this.properties.put(this.datasetName + "-associates", rs.getString(22));
                        }
                        if (rs.getString(23) != null && rs.getString(23).length() > 0) {
                            this.properties.put(this.datasetName + "-path", rs.getString(23));
                        }
                        if (this.datasetName != null) {
                            this.merge(this.properties);
                        }
                        this.setDefaultAttributes();
                        if (this.changed) {
                            this.saveDCB(connection);
                        }
                    } else {
                        this.setDefaultAttributes();
                        this.saveDCB(connection);
                        this.onDisk = true;
                        return;
                    }
                    this.onDisk = true;
                    LastError = "";
                    break block57;
                }
                this.setDefaultAttributes();
                this.onDisk = false;
                return;
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.onDisk = false;
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException se) {
                        se.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void saveDCB() {
        if (LOGDCB) {
            System.out.println("DCBDB->saveDCB();");
        }
        if (this.isDamaged) {
            return;
        }
        if (this.organization == DCB.Organization.PS && this.orientation == null && this.recordFormat == null && this.protocols == null && this.recordMinimum == null && this.recordAverage == null && this.lrecl == null && this.blksize == null && this.limit == null && this.keyOffset == null && this.keyLength == null && this.altKeyOffsets == null && this.altKeyLengths == null && this.altKeyDuplicates == null && this.altKeyGroups == null && this.expdt == null && this.label == null) {
            return;
        }
        this.properties = new Properties();
        File dsnFile = new File(this.datasetNamePath);
        if (this.datasetName == null) {
            this.datasetName = dsnFile.getName();
        }
        if (!dsnFile.isDirectory()) {
            String baseName;
            File dsnParentDir;
            if (this.datasetName.matches("G[0-9]{4}V00")) {
                dsnParentDir = dsnFile.getParentFile();
                if (dsnParentDir != null && dsnParentDir.isDirectory() && (baseName = dsnParentDir.getName()) != null) {
                    this.datasetName = baseName + "." + this.datasetName;
                }
            } else if (!this.datasetName.contains(".") && (dsnParentDir = dsnFile.getParentFile()) != null && dsnParentDir.isDirectory() && (baseName = dsnParentDir.getName()).contains(".")) {
                this.datasetName = baseName + "." + this.datasetName;
            }
        }
        Statement ps = null;
        try {
            ResultSet rs;
            Connection connection = DCBDB.getConnection();
            if (connection == null) {
                System.err.println("Failed to make connection!");
                return;
            }
            String sql = "SELECT DSNAME, LRECL, DSORG, ORIENTATION, PROTOTYPE, RECFM, RECMIN, RECAVG, CHARSET, BLKSIZE, GDG_LIMIT, KEYLEN, KEYOFF, ALTKEYOFFS, ALTKEYLENS, ALTKEYDUPS, ALTKEYGROUPS, LABEL, EXPDT, REUSE, RELATE, ASSOCIATES, PATH, UPDATE_USER, UPDATE_TS  FROM \"DCBDB" + DCBFactory.getDcbTableNameExt() + "\" WHERE DSNAME = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, this.datasetName);
            boolean hasResultSet = ps.execute();
            if (hasResultSet && (rs = ps.getResultSet()).next()) {
                if (rs.getString(2) != null && rs.getString(2).length() > 0) {
                    this.properties.put(this.datasetName + "-lrecl", rs.getString(2));
                }
                if (rs.getString(3) != null && rs.getString(3).length() > 0) {
                    this.properties.put(this.datasetName + "-dsorg", rs.getString(3));
                }
                if (rs.getString(4) != null && rs.getString(4).length() > 0) {
                    this.properties.put(this.datasetName + "-orient", rs.getString(4));
                }
                if (rs.getString(5) != null && rs.getString(5).length() > 0) {
                    this.properties.put(this.datasetName + "-proto", rs.getString(5));
                }
                if (rs.getString(6) != null && rs.getString(6).length() > 0) {
                    this.properties.put(this.datasetName + "-recfm", rs.getString(6));
                }
                if (rs.getString(7) != null && rs.getString(7).length() > 0) {
                    this.properties.put(this.datasetName + "-recmin", rs.getString(7));
                }
                if (rs.getString(8) != null && rs.getString(8).length() > 0) {
                    this.properties.put(this.datasetName + "-recavg", rs.getString(8));
                }
                if (rs.getString(9) != null && rs.getString(9).length() > 0) {
                    this.properties.put(this.datasetName + "-charset", rs.getString(9));
                }
                if (rs.getString(10) != null && rs.getString(10).length() > 0) {
                    this.properties.put(this.datasetName + "-blksize", rs.getString(10));
                }
                if (rs.getString(11) != null && rs.getString(11).length() > 0) {
                    this.properties.put(this.datasetName + "-limit", rs.getString(11));
                }
                if (rs.getString(12) != null && rs.getString(12).length() > 0) {
                    this.properties.put(this.datasetName + "-keylen", rs.getString(12));
                }
                if (rs.getString(13) != null && rs.getString(13).length() > 0) {
                    this.properties.put(this.datasetName + "-keyoff", rs.getString(13));
                }
                if (rs.getString(14) != null && rs.getString(14).length() > 0) {
                    this.properties.put(this.datasetName + "-altkeyoffs", rs.getString(14));
                }
                if (rs.getString(15) != null && rs.getString(15).length() > 0) {
                    this.properties.put(this.datasetName + "-altkeylens", rs.getString(15));
                }
                if (rs.getString(16) != null && rs.getString(16).length() > 0) {
                    this.properties.put(this.datasetName + "-altkeydups", rs.getString(16));
                }
                if (rs.getString(17) != null && rs.getString(17).length() > 0) {
                    this.properties.put(this.datasetName + "-altkeygroups", rs.getString(17));
                }
                if (rs.getString(18) != null && rs.getString(18).length() > 0) {
                    this.properties.put(this.datasetName + "-label", rs.getString(18));
                }
                if (rs.getString(19) != null && rs.getString(19).length() > 0) {
                    this.properties.put(this.datasetName + "-expdt", rs.getString(19));
                }
                if (rs.getString(20) != null && rs.getString(20).length() > 0) {
                    this.properties.put(this.datasetName + "-reuse", rs.getString(20));
                }
                if (rs.getString(21) != null && rs.getString(21).length() > 0) {
                    this.properties.put(this.datasetName + "-relate", rs.getString(21));
                }
                if (rs.getString(22) != null && rs.getString(22).length() > 0) {
                    this.properties.put(this.datasetName + "-associates", rs.getString(22));
                }
                if (rs.getString(23) != null && rs.getString(23).length() > 0) {
                    this.properties.put(this.datasetName + "-path", rs.getString(23));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
        this.saveDCB(DCBDB.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int saveDCB(Connection connection) {
        String etp;
        if (LOGDCB) {
            System.out.println("DCBDB->saveDCB(connection);");
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.datasetName != null) {
            String sw = this.datasetName + "-";
            if (this.organization != null) {
                if (this.organization.equals((Object)DCB.Organization.GDG) && this.datasetName.matches("^.*G[0-9]{4}V00.*")) {
                    this.organization = DCB.Organization.PS;
                }
                this.properties.setProperty(sw + "dsorg", this.toString(this.organization));
            } else {
                this.properties.remove(sw + "dsorg");
            }
            if (this.orientation != null) {
                this.properties.setProperty(sw + "orient", this.toString(this.orientation));
            } else {
                this.properties.remove(sw + "orient");
            }
            if (this.recordFormat != null) {
                this.properties.setProperty(sw + "recfm", this.toString(this.recordFormat));
            } else {
                this.properties.remove(sw + "recfm");
            }
            if (this.protocols != null) {
                this.properties.setProperty(sw + "proto", this.toString(this.protocols));
            } else {
                this.properties.remove(sw + "proto");
            }
            if (this.recordMinimum != null) {
                this.properties.setProperty(sw + "recmin", this.toString(this.recordMinimum));
            } else {
                this.properties.remove(sw + "recmin");
            }
            if (this.recordAverage != null) {
                this.properties.setProperty(sw + "recavg", this.toString(this.recordAverage));
            } else {
                this.properties.remove(sw + "recavg");
            }
            if (this.lrecl != null) {
                this.properties.setProperty(sw + "lrecl", this.toString(this.lrecl));
            } else {
                this.properties.remove(sw + "lrecl");
            }
            if (this.blksize != null) {
                this.properties.setProperty(sw + "blksize", this.toString(this.blksize));
            } else {
                this.properties.remove(sw + "blksize");
            }
            if (this.limit != null) {
                this.properties.setProperty(sw + "limit", this.toString(this.limit));
            } else {
                this.properties.remove(sw + "limit");
            }
            if (this.keyLength != null) {
                this.properties.setProperty(sw + "keylen", DCBDB.toString(this.keyLength));
            } else {
                this.properties.remove(sw + "keylen");
            }
            if (this.keyOffset != null) {
                this.properties.setProperty(sw + "keyoff", DCBDB.toString(this.keyOffset));
            } else {
                this.properties.remove(sw + "keyoff");
            }
            if (this.altKeyLengths != null && this.altKeyLengths.length > 0) {
                this.properties.setProperty(sw + "altkeylens", DCBDB.toString(this.altKeyLengths));
            } else {
                this.properties.remove(sw + "altkeylens");
            }
            if (this.altKeyOffsets != null && this.altKeyOffsets.length > 0) {
                this.properties.setProperty(sw + "altkeyoffs", DCBDB.toString(this.altKeyOffsets));
            } else {
                this.properties.remove(sw + "altkeyoffs");
            }
            if (this.altKeyDuplicates != null && this.altKeyDuplicates.length > 0) {
                this.properties.setProperty(sw + "altkeydups", DCBDB.toString(this.altKeyDuplicates));
            } else {
                this.properties.remove(sw + "altkeydups");
            }
            if (this.altKeyGroups != null && this.altKeyGroups.length > 0) {
                this.properties.setProperty(sw + "altkeygroups", DCBDB.toString(this.altKeyGroups));
            } else {
                this.properties.remove(sw + "altkeygroups");
            }
            if (this.label != null) {
                this.properties.setProperty(sw + "label", this.toString(this.label));
            } else {
                this.properties.remove(sw + "label");
            }
            if (this.expdt != null) {
                this.properties.setProperty(sw + "expdt", this.expdt);
            } else {
                this.properties.remove(sw + "expdt");
            }
            if (this.reuse != null) {
                this.properties.setProperty(sw + "reuse", DCBDB.toString(this.reuse));
            } else {
                this.properties.remove(sw + "reuse");
            }
            if (this.relate != null) {
                this.properties.setProperty(sw + "relate", this.relate);
            } else {
                this.properties.remove(sw + "relate");
            }
            if (this.path != null) {
                this.properties.setProperty(sw + "path", this.path);
            } else {
                this.properties.remove(sw + "path");
            }
            if (this.associates != null && this.associates.length != 0) {
                this.properties.setProperty(sw + "associates", DCBDB.toString(this.associates));
            } else {
                this.properties.remove(sw + "associates");
            }
            if (this.charset != null) {
                this.properties.setProperty(sw + "charset", this.charset);
            } else {
                this.properties.remove(sw + "charset");
            }
        }
        if ((etp = System.getProperty("dcb.db.etp")) != null && !etp.equalsIgnoreCase("false")) {
            return 0;
        }
        int rowsImported = 0;
        int idx = -1;
        ArrayList<String> importList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Statement ps = null;
        try {
            String sql;
            TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>(this.properties);
            String keyStack = null;
            for (String propKey : sortedMap.keySet()) {
                idx = propKey.lastIndexOf(45);
                String keyPrefix = propKey.substring(0, idx);
                if (keyStack == null) {
                    keyStack = keyPrefix;
                    sb.append("dsname=");
                    sb.append(keyStack);
                    sb.append('\u001c');
                    sb.append(propKey.substring(idx + 1));
                    sb.append("=");
                    sb.append((String)sortedMap.get(propKey));
                    sb.append('\u001c');
                    continue;
                }
                if (keyStack.equals(keyPrefix)) {
                    sb.append(propKey.substring(idx + 1));
                    sb.append("=");
                    sb.append((String)sortedMap.get(propKey));
                    sb.append('\u001c');
                    continue;
                }
                importList.add(sb.toString());
                System.out.println(sb.toString());
                sb = new StringBuilder();
                keyStack = keyPrefix;
                sb.append("dsname=");
                sb.append(keyStack);
                sb.append('\u001c');
                sb.append(propKey.substring(idx + 1));
                sb.append("=");
                sb.append((String)sortedMap.get(propKey));
                sb.append('\u001c');
            }
            if (sb.length() > 0) {
                importList.add(sb.toString());
            }
            if (connection == null) {
                System.err.println("Failed to make connection!");
                int n = -1;
                return n;
            }
            if (DCBDB.exists(connection, this.datasetName, null)) {
                sql = "UPDATE \"DCBDB" + DCBFactory.getDcbTableNameExt() + "\" SET DSNAME=?, LRECL=?, DSORG=?, ORIENTATION=?, PROTOTYPE=?, RECFM=?, RECMIN=?, RECAVG=?, CHARSET=?, BLKSIZE=?, GDG_LIMIT=?, KEYLEN=?, KEYOFF=?, ALTKEYOFFS=?, ALTKEYLENS=?, ALTKEYDUPS=?, ALTKEYGROUPS=?, LABEL=?, EXPDT=?, REUSE=?, RELATE=?, ASSOCIATES=?, PATH=?, UPDATE_USER=?, UPDATE_TS=?  WHERE DSNAME = ?";
                ps = connection.prepareStatement(sql);
                for (String valStr : importList) {
                    String[] parts = valStr.split("\u001c");
                    HashMap<String, String> colvalMap = new HashMap<String, String>();
                    for (String s : parts) {
                        String[] sparts = s.split("=");
                        if (sparts.length <= 1) continue;
                        colvalMap.put(sparts[0], sparts[1]);
                    }
                    ps.setString(1, (String)colvalMap.get("dsname"));
                    ps.setString(2, (String)colvalMap.get("lrecl"));
                    ps.setString(3, (String)colvalMap.get("dsorg"));
                    ps.setString(4, (String)colvalMap.get("orient"));
                    ps.setString(5, (String)colvalMap.get("proto"));
                    ps.setString(6, (String)colvalMap.get("recfm"));
                    ps.setString(7, (String)colvalMap.get("recmin"));
                    ps.setString(8, (String)colvalMap.get("recavg"));
                    ps.setString(9, (String)colvalMap.get("charset"));
                    ps.setString(10, (String)colvalMap.get("blksize"));
                    ps.setString(11, (String)colvalMap.get("limit"));
                    ps.setString(12, (String)colvalMap.get("keylen"));
                    ps.setString(13, (String)colvalMap.get("keyoff"));
                    ps.setString(14, (String)colvalMap.get("altkeyoffs"));
                    ps.setString(15, (String)colvalMap.get("altkeylens"));
                    ps.setString(16, (String)colvalMap.get("altkeydups"));
                    ps.setString(17, (String)colvalMap.get("altkeygroups"));
                    ps.setString(18, (String)colvalMap.get("label"));
                    ps.setString(19, (String)colvalMap.get("expdt"));
                    ps.setString(20, (String)colvalMap.get("reuse"));
                    ps.setString(21, (String)colvalMap.get("relate"));
                    ps.setString(22, (String)colvalMap.get("associates"));
                    ps.setString(23, (String)colvalMap.get("path"));
                    ps.setString(24, "DcbUtils");
                    ps.setTimestamp(25, Timestamp.valueOf(LocalDateTime.now()));
                    ps.setString(26, this.datasetName);
                    rowsImported += ps.executeUpdate();
                }
            } else {
                sql = "INSERT INTO \"DCBDB" + DCBFactory.getDcbTableNameExt() + "\" (DSNAME, LRECL, DSORG, ORIENTATION, PROTOTYPE, RECFM, RECMIN, RECAVG, CHARSET, BLKSIZE, GDG_LIMIT, KEYLEN, KEYOFF, ALTKEYOFFS, ALTKEYLENS, ALTKEYDUPS, ALTKEYGROUPS, LABEL, EXPDT, REUSE, RELATE, ASSOCIATES, PATH, UPDATE_USER, UPDATE_TS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = connection.prepareStatement(sql);
                for (String valStr : importList) {
                    String[] parts = valStr.split("\u001c");
                    HashMap<String, String> colvalMap = new HashMap<String, String>();
                    for (String s : parts) {
                        String[] sparts = s.split("=");
                        colvalMap.put(sparts[0], sparts[1]);
                    }
                    ps.setString(1, (String)colvalMap.get("dsname"));
                    ps.setString(2, (String)colvalMap.get("lrecl"));
                    ps.setString(3, (String)colvalMap.get("dsorg"));
                    ps.setString(4, (String)colvalMap.get("orient"));
                    ps.setString(5, (String)colvalMap.get("proto"));
                    ps.setString(6, (String)colvalMap.get("recfm"));
                    ps.setString(7, (String)colvalMap.get("recmin"));
                    ps.setString(8, (String)colvalMap.get("recavg"));
                    ps.setString(9, (String)colvalMap.get("charset"));
                    ps.setString(10, (String)colvalMap.get("blksize"));
                    ps.setString(11, (String)colvalMap.get("limit"));
                    ps.setString(12, (String)colvalMap.get("keylen"));
                    ps.setString(13, (String)colvalMap.get("keyoff"));
                    ps.setString(14, (String)colvalMap.get("altkeyoffs"));
                    ps.setString(15, (String)colvalMap.get("altkeylens"));
                    ps.setString(16, (String)colvalMap.get("altkeydups"));
                    ps.setString(17, (String)colvalMap.get("altkeygroups"));
                    ps.setString(18, (String)colvalMap.get("label"));
                    ps.setString(19, (String)colvalMap.get("expdt"));
                    ps.setString(20, (String)colvalMap.get("reuse"));
                    ps.setString(21, (String)colvalMap.get("relate"));
                    ps.setString(22, (String)colvalMap.get("associates"));
                    ps.setString(23, (String)colvalMap.get("path"));
                    ps.setString(24, "DcbUtils");
                    ps.setTimestamp(25, Timestamp.valueOf(LocalDateTime.now()));
                    rowsImported += ps.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
        return rowsImported;
    }

    @Override
    public synchronized void unlockDCB() {
        this.fileLock = null;
    }

    @Override
    public synchronized void deleteDCB() {
        if (LOGDCB) {
            System.out.println("DCBDB->deleteDCB();");
        }
        this.removeDCB(this.datasetName);
    }

    public static synchronized boolean exists(String dsn, String dsnPath) {
        if (LOGDCB) {
            System.out.println("DCBDB->exists(" + dsn + "," + dsnPath + ");");
        }
        boolean exists = false;
        Connection connection = DCBDB.getConnection();
        if (connection == null) {
            System.err.println("Failed to make connection!");
            return exists;
        }
        return DCBDB.exists(connection, dsn, dsnPath);
    }

    public static synchronized boolean exists(Connection connection, String dsn, String dsnPath) {
        if (LOGDCB) {
            System.out.println("DCBDB->exists(connection," + dsn + "," + dsnPath + ");");
        }
        boolean exists = false;
        try {
            if (connection == null) {
                System.err.println("Failed to make connection!");
                return exists;
            }
            if (dsn != null) {
                ResultSet rs;
                String baseName;
                File dsnFileParent;
                String baseName2;
                File dsnFile;
                PreparedStatement ps = null;
                if (dsn.matches("^G[0-9]{4}V00") && dsnPath != null) {
                    dsnFile = new File(dsnPath);
                    if (dsnFile.isDirectory()) {
                        baseName2 = dsnFile.getName();
                        if (baseName2 != null) {
                            dsn = baseName2 + "." + dsn;
                        }
                    } else {
                        dsnFileParent = dsnFile.getParentFile();
                        if (dsnFileParent != null && dsnFileParent.isDirectory() && (baseName = dsnFileParent.getName()) != null) {
                            dsn = baseName + "." + dsn;
                        }
                    }
                } else if (!dsn.contains(".") && dsnPath != null) {
                    dsnFile = new File(dsnPath);
                    if (dsnFile.isDirectory()) {
                        baseName2 = dsnFile.getName();
                        if (baseName2.contains(".")) {
                            dsn = baseName2 + "." + dsn;
                        }
                    } else {
                        dsnFileParent = dsnFile.getParentFile();
                        if (dsnFileParent != null && dsnFileParent.isDirectory() && (baseName = dsnFileParent.getName()).contains(".")) {
                            dsn = baseName + "." + dsn;
                        }
                    }
                }
                String sql = "SELECT DSNAME FROM \"DCBDB" + DCBFactory.getDcbTableNameExt() + "\" WHERE DSNAME = ?";
                ps = connection.prepareStatement(sql);
                ps.setString(1, dsn);
                boolean found = ps.execute();
                if (found && (rs = ps.getResultSet()).next()) {
                    exists = true;
                }
                ps.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return exists;
    }

    private static Connection getConnection() {
        block15: {
            if (LOGDCB) {
                System.out.println("DCBDB->getConnection();");
            }
            Connection connection = null;
            if (conn == null) {
                String url2 = System.getProperty("dcb.db.url");
                String user = System.getProperty("dcb.db.user");
                String pass = System.getProperty("dcb.db.pass");
                String driver = System.getProperty("dcb.db.driver");
                String etp = System.getProperty("dcb.db.etp");
                try {
                    if (driver != null) {
                        Class.forName(driver);
                    }
                    if ((connection = DriverManager.getConnection(url2, user, pass)) != null) {
                        if (etp != null && !etp.equalsIgnoreCase("false")) {
                            connection.setReadOnly(true);
                        }
                        DCBDB.setConnection(connection);
                    }
                }
                catch (ClassNotFoundException | SQLException e) {
                    System.err.println("Connection Failed! Check output console");
                    System.err.println("Conn Info : Url[" + url2 + "] User[" + user + "] pass[" + pass + "] driver[" + driver + "]");
                    e.printStackTrace();
                }
            } else {
                try {
                    if (conn.isValid(10)) break block15;
                    String url3 = System.getProperty("dcb.db.url");
                    String user = System.getProperty("dcb.db.user");
                    String pass = System.getProperty("dcb.db.pass");
                    String driver = System.getProperty("dcb.db.driver");
                    String etp = System.getProperty("dcb.db.etp");
                    try {
                        if (driver != null) {
                            Class.forName(driver);
                        }
                        if ((connection = DriverManager.getConnection(url3, user, pass)) != null) {
                            if (etp != null && !etp.equalsIgnoreCase("false")) {
                                connection.setReadOnly(true);
                            }
                            DCBDB.setConnection(connection);
                        }
                    }
                    catch (ClassNotFoundException | SQLException e) {
                        System.err.println("Connection retry failed! Check output console");
                        System.err.println("Conn Info : Url[" + url3 + "] User[" + user + "] pass[" + pass + "] driver[" + driver + "]");
                        e.printStackTrace();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return conn;
    }

    private static void setConnection(Connection connection) {
        if (LOGDCB) {
            System.out.println("DCBDB->setConnection(connection);");
        }
        conn = connection;
    }

    public static int importDCBFile(String dcbfile, String url2, String user, String pass) {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url2, user, pass);
        }
        catch (SQLException e) {
            System.err.println("Connection Failed! Check output console");
            e.printStackTrace();
            return -1;
        }
        if (connection == null) {
            System.err.println("Failed to make connection!");
            return -1;
        }
        return DCBDB.importDCBFile(dcbfile, connection);
    }

    public static int importDCBFile(String dcbfile, Connection connection) {
        int rowsImported = 0;
        int idx = -1;
        ArrayList<String> importList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(dcbfile));
            TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>(props);
            String keyStack = null;
            for (String propKey : sortedMap.keySet()) {
                idx = propKey.lastIndexOf(45);
                String keyPrefix = propKey.substring(0, idx);
                if (keyStack == null) {
                    keyStack = keyPrefix;
                    sb.append("dsname=");
                    sb.append(keyStack);
                    sb.append('\u001c');
                    sb.append(propKey.substring(idx + 1));
                    sb.append("=");
                    sb.append((String)sortedMap.get(propKey));
                    sb.append('\u001c');
                    continue;
                }
                if (keyStack.equals(keyPrefix)) {
                    sb.append(propKey.substring(idx + 1));
                    sb.append("=");
                    sb.append((String)sortedMap.get(propKey));
                    sb.append('\u001c');
                    continue;
                }
                importList.add(sb.toString());
                sb = new StringBuilder();
                keyStack = keyPrefix;
                sb.append("dsname=");
                sb.append(keyStack);
                sb.append('\u001c');
                sb.append(propKey.substring(idx + 1));
                sb.append("=");
                sb.append((String)sortedMap.get(propKey));
                sb.append('\u001c');
            }
            if (sb.length() > 0) {
                importList.add(sb.toString());
            }
            if (connection == null) {
                System.err.println("Failed to make connection!");
                return -1;
            }
            PreparedStatement ps = null;
            try {
                String sql = "INSERT INTO DCBDB (DSNAME, LRECL, DSORG, ORIENTATION, PROTOTYPE, RECFM, RECMIN, RECAVG, CHARSET, BLKSIZE, GDG_LIMIT, KEYLEN, KEYOFF, ALTKEYOFFS, ALTKEYLENS, ALTKEYDUPS, ALTKEYGROUPS, LABEL, EXPDT, REUSE, RELATE, ASSOCIATES, PATH, UPDATE_USER, UPDATE_TS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = connection.prepareStatement(sql);
                for (String valStr : importList) {
                    String[] parts = valStr.split("\u001c");
                    HashMap<String, String> colvalMap = new HashMap<String, String>();
                    for (String s : parts) {
                        String[] sparts = s.split("=");
                        colvalMap.put(sparts[0], sparts[1]);
                    }
                    ps.setString(1, (String)colvalMap.get("dsname"));
                    ps.setString(2, (String)colvalMap.get("lrecl"));
                    ps.setString(3, (String)colvalMap.get("dsorg"));
                    ps.setString(4, (String)colvalMap.get("orient"));
                    ps.setString(5, (String)colvalMap.get("proto"));
                    ps.setString(6, (String)colvalMap.get("recfm"));
                    ps.setString(7, (String)colvalMap.get("recmin"));
                    ps.setString(8, (String)colvalMap.get("recavg"));
                    ps.setString(9, (String)colvalMap.get("charset"));
                    ps.setString(10, (String)colvalMap.get("blksize"));
                    ps.setString(11, (String)colvalMap.get("limit"));
                    ps.setString(12, (String)colvalMap.get("keylen"));
                    ps.setString(13, (String)colvalMap.get("keyoff"));
                    ps.setString(14, (String)colvalMap.get("altkeyoffs"));
                    ps.setString(15, (String)colvalMap.get("altkeylens"));
                    ps.setString(16, (String)colvalMap.get("altkeydups"));
                    ps.setString(17, (String)colvalMap.get("altkeygroups"));
                    ps.setString(18, (String)colvalMap.get("label"));
                    ps.setString(19, (String)colvalMap.get("expdt"));
                    ps.setString(20, (String)colvalMap.get("reuse"));
                    ps.setString(21, (String)colvalMap.get("relate"));
                    ps.setString(22, (String)colvalMap.get("associates"));
                    ps.setString(23, (String)colvalMap.get("path"));
                    ps.setString(24, "DcbUtils");
                    ps.setTimestamp(25, Timestamp.valueOf(LocalDateTime.now()));
                    rowsImported += ps.executeUpdate();
                }
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return rowsImported;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rowsImported;
    }

    public static int importGDGDCBFile(String dcbfile, String url2, String user, String pass) {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url2, user, pass);
        }
        catch (SQLException e) {
            System.err.println("Connection Failed! Check output console");
            e.printStackTrace();
            return -1;
        }
        if (connection == null) {
            System.err.println("Failed to make connection!");
            return -1;
        }
        return DCBDB.importGDGDCBFile(dcbfile, connection);
    }

    public static int importGDGDCBFile(String dcbfile, Connection connection) {
        int rowsImported = 0;
        int idx = -1;
        File gdgDCB = new File(dcbfile);
        String gdgBase = gdgDCB.getParentFile().getName();
        ArrayList<String> importList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(dcbfile));
            TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>(props);
            if (!"GDG".equalsIgnoreCase((String)sortedMap.get(gdgBase + "_dsorg"))) {
                for (Object propKey : sortedMap.keySet()) {
                    if (!((String)propKey).endsWith("_dsorg") || !"GDG".equalsIgnoreCase((String)sortedMap.get(propKey))) continue;
                    gdgBase = ((String)propKey).replaceAll("_dsorg", "");
                    break;
                }
            }
            String keyStack = null;
            for (String propKey : sortedMap.keySet()) {
                idx = propKey.lastIndexOf(45);
                String keyPrefix = propKey.substring(0, idx);
                if (keyStack == null) {
                    keyStack = keyPrefix;
                    sb.append("dsname=");
                    if (keyStack.equals(gdgBase)) {
                        sb.append(keyStack);
                    } else {
                        sb.append(gdgBase + "." + keyStack);
                    }
                    sb.append('\u001c');
                    sb.append(propKey.substring(idx + 1));
                    sb.append("=");
                    sb.append((String)sortedMap.get(propKey));
                    sb.append('\u001c');
                    continue;
                }
                if (keyStack.equals(keyPrefix)) {
                    sb.append(propKey.substring(idx + 1));
                    sb.append("=");
                    sb.append((String)sortedMap.get(propKey));
                    sb.append('\u001c');
                    continue;
                }
                importList.add(sb.toString());
                sb = new StringBuilder();
                keyStack = keyPrefix;
                sb.append("dsname=");
                if (keyStack.equals(gdgBase)) {
                    sb.append(keyStack);
                } else {
                    sb.append(gdgBase + "." + keyStack);
                }
                sb.append('\u001c');
                sb.append(propKey.substring(idx + 1));
                sb.append("=");
                sb.append((String)sortedMap.get(propKey));
                sb.append('\u001c');
            }
            if (sb.length() > 0) {
                importList.add(sb.toString());
            }
            if (connection == null) {
                System.err.println("Failed to make connection!");
                return -1;
            }
            PreparedStatement ps = null;
            try {
                String sql = "INSERT INTO DCBDB (DSNAME, LRECL, DSORG, ORIENTATION, PROTOTYPE, RECFM, RECMIN, RECAVG, CHARSET, BLKSIZE, GDG_LIMIT, KEYLEN, KEYOFF, ALTKEYOFFS, ALTKEYLENS, ALTKEYDUPS, ALTKEYGROUPS, LABEL, EXPDT, REUSE, RELATE, ASSOCIATES, PATH, UPDATE_USER, UPDATE_TS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = connection.prepareStatement(sql);
                for (String valStr : importList) {
                    String[] parts = valStr.split("\u001c");
                    HashMap<String, String> colvalMap = new HashMap<String, String>();
                    for (String s : parts) {
                        String[] sparts = s.split("=");
                        colvalMap.put(sparts[0], sparts[1]);
                    }
                    ps.setString(1, (String)colvalMap.get("dsname"));
                    ps.setString(2, (String)colvalMap.get("lrecl"));
                    ps.setString(3, (String)colvalMap.get("dsorg"));
                    ps.setString(4, (String)colvalMap.get("orient"));
                    ps.setString(5, (String)colvalMap.get("proto"));
                    ps.setString(6, (String)colvalMap.get("recfm"));
                    ps.setString(7, (String)colvalMap.get("recmin"));
                    ps.setString(8, (String)colvalMap.get("recavg"));
                    ps.setString(9, (String)colvalMap.get("charset"));
                    ps.setString(10, (String)colvalMap.get("blksize"));
                    ps.setString(11, (String)colvalMap.get("limit"));
                    ps.setString(12, (String)colvalMap.get("keylen"));
                    ps.setString(13, (String)colvalMap.get("keyoff"));
                    ps.setString(14, (String)colvalMap.get("altkeyoffs"));
                    ps.setString(15, (String)colvalMap.get("altkeylens"));
                    ps.setString(16, (String)colvalMap.get("altkeydups"));
                    ps.setString(17, (String)colvalMap.get("altkeygroups"));
                    ps.setString(18, (String)colvalMap.get("label"));
                    ps.setString(19, (String)colvalMap.get("expdt"));
                    ps.setString(20, (String)colvalMap.get("reuse"));
                    ps.setString(21, (String)colvalMap.get("relate"));
                    ps.setString(22, (String)colvalMap.get("associates"));
                    ps.setString(23, (String)colvalMap.get("path"));
                    ps.setString(24, "DcbUtils");
                    ps.setTimestamp(25, Timestamp.valueOf(LocalDateTime.now()));
                    rowsImported += ps.executeUpdate();
                }
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return rowsImported;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rowsImported;
    }
}

