/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.isamsql;

import com.heirloomcomputing.ecs.api.DatatypeGenerator;
import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.isamsql.DBMS;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import org.xml.sax.Attributes;

public class SqlColumn
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private int[] offset;
    private int[] length;
    private int usage;
    private int pictureLength;
    private String sqltype;
    private String table;
    private int place;
    private int scale;
    private boolean keyfield;
    IDatatype datatypeColumn;
    private String picString = "";

    public SqlColumn(String name, int offset, int length, int place, int usage, int piclen, String sqltype, String table) {
        this.name = name;
        this.place = place;
        if (name.startsWith("idx") || name.startsWith("IDX")) {
            String[] keyComponents = name.substring(3).split("__");
            this.offset = new int[keyComponents.length];
            this.length = new int[keyComponents.length];
            for (int i = 0; i < keyComponents.length; ++i) {
                int idx = keyComponents[i].indexOf(95);
                if (idx > 0) {
                    try {
                        this.offset[i] = Integer.parseInt(keyComponents[i].substring(0, idx));
                        this.length[i] = Integer.parseInt(keyComponents[i].substring(idx + 1));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.offset = new int[]{offset};
                        this.length = new int[]{length};
                    }
                } else {
                    this.offset = new int[]{offset};
                    this.length = new int[]{length};
                }
                break;
            }
        } else if (name.toLowerCase().startsWith("ci_")) {
            String[] keyComponents = null;
            keyComponents = name.toLowerCase().startsWith("ci_n") ? name.substring(9).split("__") : name.substring(6).split("__");
            this.offset = new int[keyComponents.length];
            this.length = new int[keyComponents.length];
            for (int i = 0; i < keyComponents.length; ++i) {
                int idx = keyComponents[i].indexOf(95);
                if (idx > 0) {
                    try {
                        this.offset[i] = Integer.parseInt(keyComponents[i].substring(0, idx));
                        this.length[i] = Integer.parseInt(keyComponents[i].substring(idx + 1));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.offset = new int[]{offset};
                        this.length = new int[]{length};
                    }
                } else {
                    this.offset = new int[]{offset};
                    this.length = new int[]{length};
                }
                break;
            }
        } else {
            this.offset = new int[]{offset};
            this.length = new int[]{length};
        }
        this.usage = usage;
        this.pictureLength = piclen;
        this.sqltype = sqltype;
        this.table = table;
        this.datatypeColumn = DatatypeGenerator.create(usage, null, offset, length, place, this.scale, this.pictureLength);
        if (this.datatypeColumn instanceof Variable) {
            ((Variable)this.datatypeColumn).setAlwaysFlush(true);
        }
        if (Variable.getPackedSignEncoding() == null) {
            Variable.setPackedSignEncoding(RuntimeEnvironment.getGlobalParameter("NUMPROC"));
        }
    }

    public SqlColumn createWorkingCopy() {
        return new SqlColumn(this.name, 0, this.length[0], this.place, this.usage, this.pictureLength, this.sqltype, this.table);
    }

    public IDatatype getIDataTypeColumn() {
        return this.datatypeColumn;
    }

    public SqlColumn(Attributes attributes) {
        this.pictureLength = 0;
        this.place = 0;
        this.scale = 0;
        if (attributes != null) {
            int attributesLength = attributes.getLength();
            for (int i = 0; i < attributesLength; ++i) {
                String value;
                String localName = attributes.getLocalName(i);
                if (localName == null || localName.length() == 0) {
                    localName = attributes.getQName(i);
                }
                if (localName == null || (value = attributes.getValue(i)) == null) continue;
                if ("name".equals(localName)) {
                    this.name = value;
                    continue;
                }
                if ("offset".equals(localName)) {
                    this.offset = new int[]{Integer.parseInt(value.trim())};
                    continue;
                }
                if ("length".equals(localName)) {
                    this.length = new int[]{Integer.parseInt(value.trim())};
                    continue;
                }
                if ("usage".equals(localName)) {
                    this.usage = Integer.parseInt(value.trim());
                    continue;
                }
                if ("type".equals(localName)) {
                    this.usage = Integer.parseInt(value.trim());
                    continue;
                }
                if ("piclen".equals(localName)) {
                    this.pictureLength = Integer.parseInt(value.trim());
                    continue;
                }
                if ("sqltype".equals(localName)) {
                    this.sqltype = value;
                    continue;
                }
                if ("table".equals(localName)) {
                    this.table = value;
                    continue;
                }
                if ("place".equals(localName)) {
                    this.place = Integer.parseInt(value.trim());
                    continue;
                }
                if ("scale".equals(localName)) {
                    this.scale = Integer.parseInt(value.trim());
                    continue;
                }
                if (!"picstring".equals(localName)) continue;
                this.picString = value.toUpperCase();
            }
        }
        this.datatypeColumn = DatatypeGenerator.create(this.usage, null, this.offset[0], this.length[0], this.place, this.scale, this.pictureLength);
        if (this.datatypeColumn instanceof Variable) {
            ((Variable)this.datatypeColumn).setAlwaysFlush(true);
        }
    }

    public boolean isKeyField() {
        return this.keyfield;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String str) {
        this.name = str;
    }

    public int getOffset() {
        return this.offset[0];
    }

    public boolean isSplitKey() {
        return this.offset.length > 1;
    }

    public int getComponentCount() {
        return this.offset.length;
    }

    public int getOffset(int n) {
        return this.offset[n];
    }

    public void setOffset(int off) {
        this.offset = new int[]{off};
    }

    public int getLength() {
        int tot = 0;
        for (int j = 0; j < this.length.length; ++j) {
            tot += this.length[j];
        }
        return tot;
    }

    public boolean isTypeNumeric() {
        return ((Variable)this.datatypeColumn).isTypeNumeric();
    }

    public int getLength(int n) {
        return this.length[n];
    }

    public void setLength(int len) {
        this.length = new int[]{len};
    }

    public int getPictureLength() {
        return this.pictureLength;
    }

    public int getUsage() {
        return this.usage;
    }

    public String getSqlType() {
        return this.sqltype;
    }

    public String getPicString() {
        return this.picString;
    }

    public String getTable() {
        return this.table;
    }

    public int getPlace() {
        return this.place;
    }

    public int getScale() {
        return this.scale;
    }

    private void storeDate(Calendar cal, byte[] data, int storeOffset) {
        String format = null;
        switch (this.length[0]) {
            case 4: {
                format = "MMDD";
                break;
            }
            case 6: {
                format = "YYMMDD";
                break;
            }
            case 8: {
                format = "YYYYMMDD";
                break;
            }
            case 14: {
                format = "YYYYMMDDHHNNSS";
            }
        }
        if (this.sqltype.length() > 1) {
            format = this.sqltype.substring(1);
        }
        if (format == null) {
            format = "?";
        }
        int formatLength = format.length();
        boolean nibbleFilled = false;
        int nibbleValue = 0;
        int dateStorage = -1;
        for (int i = 0; i < formatLength; ++i) {
            int count = 1;
            char c = format.charAt(i);
            if (c == '@' && (c = format.charAt(++i)) >= '0' && c <= '8') {
                dateStorage = c - 48;
                c = format.charAt(++i);
            }
            for (int j = i + 1; j < formatLength && c == format.charAt(j); ++j) {
                ++count;
            }
            String partial = null;
            int partialValue = 0;
            block6 : switch (c) {
                case '0': {
                    partialValue = 0;
                    partial = "0";
                    break;
                }
                case '1': {
                    partialValue = 1;
                    partial = "1";
                    break;
                }
                case '2': {
                    partialValue = 2;
                    partial = "2";
                    break;
                }
                case '3': {
                    partialValue = 3;
                    partial = "3";
                    break;
                }
                case '4': {
                    partialValue = 4;
                    partial = "4";
                    break;
                }
                case '5': {
                    partialValue = 5;
                    partial = "5";
                    break;
                }
                case '6': {
                    partialValue = 6;
                    partial = "6";
                    break;
                }
                case '7': {
                    partialValue = 7;
                    partial = "7";
                    break;
                }
                case '8': {
                    partialValue = 8;
                    partial = "8";
                    break;
                }
                case '9': {
                    partialValue = 9;
                    partial = "9";
                    break;
                }
                case 'M': {
                    partialValue = cal.get(2) + 1;
                    partial = String.valueOf(partialValue);
                    break;
                }
                case 'Y': {
                    partialValue = cal.get(1);
                    partial = String.valueOf(partialValue);
                    break;
                }
                case 'D': {
                    partialValue = cal.get(5);
                    partial = String.valueOf(partialValue);
                    break;
                }
                case 'H': {
                    partialValue = cal.get(11);
                    partial = String.valueOf(partialValue);
                    break;
                }
                case 'N': {
                    partialValue = cal.get(12);
                    partial = String.valueOf(partialValue);
                    break;
                }
                case 'S': {
                    partialValue = cal.get(13);
                    partial = String.valueOf(partialValue);
                    break;
                }
                case 'T': {
                    partialValue = (int)(cal.getTime().getTime() % 1000L / 10L);
                    partial = String.valueOf(partialValue);
                    break;
                }
                case 'C': {
                    partialValue = cal.get(1) / 100;
                    partial = String.valueOf(partialValue);
                    break;
                }
                default: {
                    switch (c) {
                        case 'J': {
                            partialValue = cal.get(6);
                            partial = String.valueOf(partialValue);
                            break block6;
                        }
                        case 'E': {
                            partialValue = cal.get(6);
                            partial = String.valueOf(partialValue);
                        }
                    }
                }
            }
            if (dateStorage < 0) {
                if (partial.length() > count) {
                    partial = partial.substring(partial.length() - count);
                } else if (partial.length() < count) {
                    partial = "00000000000000000000000000000000".substring(0, count - partial.length()) + partial;
                }
                int partialLength = partial.length();
                for (int k = 0; k < partialLength; ++k) {
                    data[storeOffset++] = (byte)(partial.charAt(k) & 0xFF);
                }
            } else {
                switch (dateStorage) {
                    case 0: {
                        if (nibbleFilled) {
                            nibbleValue <<= 4;
                            data[storeOffset++] = (byte)(nibbleValue |= partialValue);
                            nibbleValue = 0;
                            break;
                        }
                        nibbleValue = partialValue;
                        break;
                    }
                    case 1: {
                        data[storeOffset++] = (byte)(partialValue & 0xFF);
                        break;
                    }
                    case 2: {
                        data[storeOffset++] = (byte)(partialValue & 0xFF);
                        data[storeOffset++] = (byte)((partialValue >>= 8) & 0xFF);
                        partialValue >>= 8;
                        break;
                    }
                    case 4: {
                        data[storeOffset++] = (byte)(partialValue & 0xFF);
                        data[storeOffset++] = (byte)((partialValue >>= 8) & 0xFF);
                        data[storeOffset++] = (byte)((partialValue >>= 8) & 0xFF);
                        data[storeOffset++] = (byte)((partialValue >>= 8) & 0xFF);
                        partialValue >>= 8;
                        break;
                    }
                    case 8: {
                        data[storeOffset++] = (byte)(partialValue & 0xFF);
                        data[storeOffset++] = (byte)((partialValue >>= 8) & 0xFF);
                        data[storeOffset++] = (byte)((partialValue >>= 8) & 0xFF);
                        data[storeOffset++] = (byte)((partialValue >>= 8) & 0xFF);
                        data[storeOffset++] = (byte)((partialValue >>= 8) & 0xFF);
                        data[storeOffset++] = (byte)((partialValue >>= 8) & 0xFF);
                        data[storeOffset++] = (byte)((partialValue >>= 8) & 0xFF);
                        data[storeOffset++] = (byte)((partialValue >>= 8) & 0xFF);
                        partialValue >>= 8;
                    }
                }
            }
            dateStorage = -1;
            i += count - 1;
        }
    }

    public void retrieve(ResultSet rs, byte[] data) throws SQLException {
        DatatypeGenerator.setMemory(this.datatypeColumn, data, this.offset[0]);
        if (this.sqltype == null || this.sqltype.length() == 0) {
            this.sqltype = "A";
        }
        switch (this.sqltype.charAt(0)) {
            case 'A': 
            case 'C': 
            case 'S': {
                if (rs == null) {
                    String result = " ";
                    this.datatypeColumn.fromText(result);
                } else {
                    String result = rs.getString(this.name);
                    if (result != null) {
                        this.datatypeColumn.fromText(result);
                    } else {
                        this.datatypeColumn.fromText(" ");
                    }
                }
                return;
            }
            case 'B': {
                if (rs == null) {
                    byte[] result = new byte[1];
                    this.datatypeColumn.fromByteArray(result);
                } else {
                    byte[] result = rs.getBytes(this.name);
                    if (result != null) {
                        this.datatypeColumn.fromByteArray(result);
                    } else {
                        this.datatypeColumn.fromByteArray(new byte[1]);
                    }
                }
                return;
            }
            case 'D': {
                if (rs == null) {
                    String result = " ";
                    this.datatypeColumn.fromText(result);
                } else {
                    Date date = rs.getDate(this.name);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    this.storeDate(cal, data, this.offset[0]);
                }
                return;
            }
            case 'N': {
                if (this.sqltype.length() > 1) {
                    switch (this.sqltype.charAt(1)) {
                        case '1': {
                            if (rs == null) {
                                float result = 0.0f;
                                this.datatypeColumn.fromFloat(result);
                            } else {
                                float result = rs.getFloat(this.name);
                                this.datatypeColumn.fromFloat(result);
                            }
                            return;
                        }
                        case '2': {
                            if (rs == null) {
                                double result = 0.0;
                                this.datatypeColumn.fromDouble(result);
                            } else {
                                double result = rs.getDouble(this.name);
                                this.datatypeColumn.fromDouble(result);
                            }
                            return;
                        }
                        case 'P': 
                        case 'Z': {
                            if (rs == null) {
                                int result = 0;
                                this.datatypeColumn.fromInt(result);
                            } else {
                                BigDecimal result1 = rs.getBigDecimal(this.name);
                                if (result1 != null) {
                                    String result = result1.toString();
                                    this.datatypeColumn.fromText(result);
                                } else {
                                    int result = 0;
                                    this.datatypeColumn.fromInt(result);
                                }
                            }
                            return;
                        }
                        case 'B': {
                            switch (this.length[0]) {
                                case 1: {
                                    if (rs == null) {
                                        byte result = 0;
                                        this.datatypeColumn.fromByte(result);
                                    } else {
                                        byte result = rs.getByte(this.name);
                                        this.datatypeColumn.fromByte(result);
                                    }
                                    return;
                                }
                                case 2: {
                                    if (rs == null) {
                                        short result = 0;
                                        this.datatypeColumn.fromShort(result);
                                    } else {
                                        short result = rs.getShort(this.name);
                                        this.datatypeColumn.fromShort(result);
                                    }
                                    return;
                                }
                                case 4: {
                                    if (rs == null) {
                                        int result = 0;
                                        this.datatypeColumn.fromInt(result);
                                    } else {
                                        int result = rs.getInt(this.name);
                                        this.datatypeColumn.fromInt(result);
                                    }
                                    return;
                                }
                                case 8: {
                                    if (rs == null) {
                                        long result = 0L;
                                        this.datatypeColumn.fromLong(result);
                                    } else {
                                        long result = rs.getLong(this.name);
                                        this.datatypeColumn.fromLong(result);
                                    }
                                    return;
                                }
                            }
                            if (rs == null) {
                                int result = 0;
                                this.datatypeColumn.fromInt(result);
                            } else {
                                BigDecimal result1 = rs.getBigDecimal(this.name);
                                if (result1 != null) {
                                    String result = result1.toString();
                                    this.datatypeColumn.fromText(result);
                                } else {
                                    int result = 0;
                                    this.datatypeColumn.fromInt(result);
                                }
                            }
                            return;
                        }
                    }
                    if (rs == null) {
                        int result = 0;
                        this.datatypeColumn.fromInt(result);
                    } else {
                        BigDecimal result1 = rs.getBigDecimal(this.name);
                        if (result1 != null) {
                            String result = result1.toString();
                            this.datatypeColumn.fromText(result);
                        } else {
                            int result = 0;
                            this.datatypeColumn.fromInt(result);
                        }
                    }
                    return;
                }
                if (rs == null) {
                    int result = 0;
                    this.datatypeColumn.fromInt(result);
                } else {
                    BigDecimal result1 = rs.getBigDecimal(this.name);
                    if (result1 != null) {
                        String result = result1.toString();
                        this.datatypeColumn.fromText(result);
                    } else {
                        int result = 0;
                        this.datatypeColumn.fromInt(result);
                    }
                }
                return;
            }
            case 'L': {
                if (rs == null) {
                    boolean result = false;
                    this.datatypeColumn.fromBoolean(result);
                } else {
                    boolean result = rs.getBoolean(this.name);
                    this.datatypeColumn.fromBoolean(result);
                }
                return;
            }
        }
        if (rs == null) {
            String result = " ";
            this.datatypeColumn.fromText(result);
        } else {
            String result = rs.getString(this.name);
            if (result == null) {
                this.datatypeColumn.fromText(" ");
            } else {
                this.datatypeColumn.fromText(result);
            }
        }
    }

    public Object updateColumn(byte[] data, int offsetIntoData, Object value) throws NumberFormatException {
        DatatypeGenerator.setMemory(this.datatypeColumn, data, this.offset[0]);
        if (this.sqltype == null || this.sqltype.length() == 0) {
            this.sqltype = "A";
        }
        String strval = null;
        byte[] _byte = null;
        if (value instanceof String) {
            strval = (String)value;
        }
        if (value instanceof byte[]) {
            _byte = (byte[])value;
            if (_byte.length == 0) {
                _byte = new byte[1];
            }
            this.datatypeColumn.fromByteArray(_byte);
            return this.datatypeColumn.toByteArray();
        }
        switch (this.sqltype.charAt(0)) {
            case 'A': 
            case 'C': 
            case 'S': {
                if (strval != null) {
                    if (strval.isEmpty()) {
                        strval = " ";
                    }
                    this.datatypeColumn.fromText(strval);
                } else {
                    this.datatypeColumn.fromText(" ");
                }
                return this.datatypeColumn.toText();
            }
            case 'B': {
                if (_byte == null) {
                    if (strval == null) {
                        _byte = new byte[1];
                    } else {
                        this.datatypeColumn.fromText(strval);
                        return this.datatypeColumn.toText();
                    }
                }
                this.datatypeColumn.fromByteArray(_byte);
                return this.datatypeColumn.toByteArray();
            }
            case 'N': {
                if (this.sqltype.length() > 1) {
                    switch (this.sqltype.charAt(1)) {
                        case '1': {
                            if (strval == null || strval.isEmpty()) {
                                float result = 0.0f;
                                this.datatypeColumn.fromFloat(result);
                                return new Float(result);
                            }
                            float result = Float.valueOf(strval).floatValue();
                            this.datatypeColumn.fromFloat(result);
                            return new Float(result);
                        }
                        case '2': {
                            if (strval == null || strval.isEmpty()) {
                                double result = 0.0;
                                this.datatypeColumn.fromDouble(result);
                                return new Double(result);
                            }
                            double result = Double.valueOf(strval);
                            this.datatypeColumn.fromDouble(result);
                            return new Double(result);
                        }
                        case 'P': 
                        case 'Z': {
                            if (strval == null || strval.isEmpty()) {
                                int result = 0;
                                this.datatypeColumn.fromInt(result);
                                return new Integer(0);
                            }
                            BigDecimal result1 = new BigDecimal(strval);
                            String result = result1.toString();
                            this.datatypeColumn.fromText(result);
                            return result;
                        }
                        case 'B': {
                            switch (this.length[0]) {
                                case 1: {
                                    if (strval == null || strval.isEmpty()) {
                                        byte result = 0;
                                        this.datatypeColumn.fromByte(result);
                                        return new Byte(result);
                                    }
                                    byte result = strval.getBytes()[0];
                                    this.datatypeColumn.fromByte(result);
                                    return new Byte(result);
                                }
                                case 2: {
                                    if (strval == null || strval.isEmpty()) {
                                        short result = 0;
                                        this.datatypeColumn.fromShort(result);
                                        return new Short(result);
                                    }
                                    short result = Short.parseShort(strval);
                                    this.datatypeColumn.fromShort(result);
                                    return new Short(result);
                                }
                                case 4: {
                                    if (strval == null || strval.isEmpty()) {
                                        int result = 0;
                                        this.datatypeColumn.fromInt(result);
                                        return new Integer(result);
                                    }
                                    int result = Integer.parseInt(strval);
                                    this.datatypeColumn.fromInt(result);
                                    return new Integer(result);
                                }
                                case 8: {
                                    if (strval == null || strval.isEmpty()) {
                                        long result = 0L;
                                        this.datatypeColumn.fromLong(result);
                                        return new Long(result);
                                    }
                                    long result = Long.valueOf(strval);
                                    this.datatypeColumn.fromLong(result);
                                    return new Long(result);
                                }
                            }
                            if (strval == null || strval.isEmpty()) {
                                int result = 0;
                                this.datatypeColumn.fromInt(result);
                                return new Integer(result);
                            }
                            BigDecimal result1 = new BigDecimal(strval);
                            String result = result1.toString();
                            this.datatypeColumn.fromText(result);
                            return result;
                        }
                    }
                    if (strval == null || strval.isEmpty()) {
                        int result = 0;
                        this.datatypeColumn.fromInt(result);
                        return new Integer(result);
                    }
                    BigDecimal result1 = new BigDecimal(strval);
                    String result = result1.toString();
                    this.datatypeColumn.fromText(result);
                    return result;
                }
                if (strval == null || strval.isEmpty()) {
                    int result = 0;
                    this.datatypeColumn.fromInt(result);
                    return new Integer(result);
                }
                BigDecimal result1 = new BigDecimal(strval);
                String result = result1.toString();
                this.datatypeColumn.fromText(result);
                return result;
            }
        }
        if (strval == null || strval.isEmpty()) {
            strval = " ";
        }
        this.datatypeColumn.fromText(strval);
        return this.datatypeColumn.toText();
    }

    public String snagToString(byte[] data, int offsetIntoData) {
        int storeOffset = this.offset[0] + offsetIntoData;
        DatatypeGenerator.setMemory(this.datatypeColumn, data, storeOffset);
        String value = this.datatypeColumn instanceof Numeric ? this.datatypeColumn.toBigDecimal().toPlainString() : this.datatypeColumn.toText();
        return value;
    }

    private Object toDateLike() {
        int century = 0;
        int year = 0;
        int month = 0;
        int date = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int milli = 0;
        int yearCount = 0;
        String format = null;
        switch (this.length[0]) {
            case 4: {
                format = "MMDD";
                break;
            }
            case 6: {
                format = "YYMMDD";
                break;
            }
            case 8: {
                format = "YYYYMMDD";
                break;
            }
            case 14: {
                format = "YYYYMMDDHHNNSS";
            }
        }
        if (this.sqltype.length() > 1) {
            format = this.sqltype.substring(1);
        }
        if (format == null) {
            format = "?";
        }
        int formatLength = format.length();
        int dateStorage = -1;
        byte[] dateBytes = this.datatypeColumn.toByteArray();
        int load = 0;
        for (int i = 0; i < formatLength; ++i) {
            int count = 1;
            char c = format.charAt(i);
            if (c == '@' && (c = format.charAt(++i)) >= '0' && c <= '8') {
                dateStorage = c - 48;
                c = format.charAt(++i);
            }
            for (int j = i + 1; j < formatLength && c == format.charAt(j); ++j) {
                ++count;
            }
            long value = 0L;
            switch (dateStorage) {
                case 0: {
                    for (int ascii = 0; ascii < count; ++ascii) {
                        value *= 10L;
                        value += (long)(dateBytes[load++] - 48);
                    }
                    break;
                }
                case 1: {
                    value = dateBytes[load++];
                    break;
                }
                case 2: {
                    value = (long)(dateBytes[load++] & 0xFF) << 8 | (long)(dateBytes[load++] & 0xFF);
                    break;
                }
                case 4: {
                    value = (long)(dateBytes[load++] & 0xFF) << 24 | (long)(dateBytes[load++] & 0xFF) << 16 | (long)(dateBytes[load++] & 0xFF) << 8 | (long)(dateBytes[load++] & 0xFF);
                    break;
                }
                case 8: {
                    value = (long)(dateBytes[load++] & 0xFF) << 56 | (long)(dateBytes[load++] & 0xFF) << 48 | (long)(dateBytes[load++] & 0xFF) << 40 | (long)(dateBytes[load++] & 0xFF) << 32 | (long)(dateBytes[load++] & 0xFF) << 24 | (long)(dateBytes[load++] & 0xFF) << 16 | (long)(dateBytes[load++] & 0xFF) << 8 | (long)(dateBytes[load++] & 0xFF);
                }
            }
            switch (c) {
                case 'M': {
                    month = (int)(value - 1L);
                    break;
                }
                case 'Y': {
                    yearCount = count;
                    year = (int)value;
                    break;
                }
                case 'D': {
                    date = (int)value;
                    break;
                }
                case 'H': {
                    hour = (int)value;
                    break;
                }
                case 'N': {
                    minute = (int)value;
                    break;
                }
                case 'S': {
                    second = (int)value;
                    break;
                }
                case 'T': {
                    milli = (int)value * 10;
                    break;
                }
                case 'C': {
                    if (count == 1) {
                        century = (int)(value + 19L);
                        break;
                    }
                    if (count != 2) break;
                    century = (int)value;
                }
            }
            dateStorage = -1;
            i += count - 1;
        }
        if (century != 0) {
            if (yearCount == 2) {
                year = year + century * 100 - 1900;
            } else if (yearCount == 4) {
                year -= 1900;
            }
        } else if (yearCount != 2 && yearCount == 4) {
            year -= 1900;
        }
        boolean timeSet = hour != 0 || minute != 0 || second != 0;
        boolean dateSet = year != 0 || month != 0 || date != 0;
        boolean timestampSet = timeSet && dateSet || milli != 0;
        Calendar cal = Calendar.getInstance();
        if (timestampSet) {
            cal.set(1, year + 1900);
            cal.set(2, month);
            cal.set(5, date);
            cal.set(10, hour);
            cal.set(12, minute);
            cal.set(13, second);
            cal.set(14, milli);
            return new Timestamp(cal.getTimeInMillis());
        }
        if (timeSet) {
            cal.set(1, year + 1900);
            cal.set(2, month);
            cal.set(5, date);
            cal.set(10, hour);
            cal.set(12, minute);
            cal.set(13, second);
            return new Time(cal.getTimeInMillis());
        }
        cal.set(1, year + 1900);
        cal.set(2, month);
        cal.set(5, date);
        return new Date(cal.getTimeInMillis());
    }

    public Object snagValue(byte[] data, int offsetIntoData) {
        DatatypeGenerator.setMemory(this.datatypeColumn, data, this.offset[0]);
        if (this.sqltype == null || this.sqltype.length() == 0) {
            this.sqltype = "A";
        }
        switch (this.sqltype.charAt(0)) {
            case 'A': 
            case 'C': 
            case 'S': {
                return this.datatypeColumn.toText();
            }
            case 'B': {
                return this.datatypeColumn.toByteArray();
            }
            case 'D': {
                return this.toDateLike();
            }
            case 'N': {
                if (this.sqltype.length() > 1) {
                    switch (this.sqltype.charAt(1)) {
                        case '1': {
                            return new Float(this.datatypeColumn.toFloat());
                        }
                        case '2': {
                            return new Double(this.datatypeColumn.toDouble());
                        }
                        case 'P': 
                        case 'Z': {
                            return this.datatypeColumn.toBigDecimal();
                        }
                        case 'B': {
                            switch (this.length[0]) {
                                case 1: {
                                    return new Byte(this.datatypeColumn.toByte());
                                }
                                case 2: {
                                    return new Short(this.datatypeColumn.toShort());
                                }
                                case 4: {
                                    return new Integer(this.datatypeColumn.toInt());
                                }
                                case 8: {
                                    return new Long(this.datatypeColumn.toLong());
                                }
                            }
                            return this.datatypeColumn.toBigDecimal();
                        }
                        case 'F': {
                            return this.datatypeColumn.toText();
                        }
                    }
                    return this.datatypeColumn.toBigDecimal();
                }
                return this.datatypeColumn.toBigDecimal();
            }
            case 'L': {
                return new Boolean(this.datatypeColumn.toBoolean());
            }
        }
        return this.datatypeColumn.toText();
    }

    public String toString() {
        String off = "(";
        for (int i = 0; i < this.offset.length; ++i) {
            off = off + this.offset[i] + " ";
        }
        off = off + ")";
        String len = "(";
        for (int i = 0; i < this.length.length; ++i) {
            len = len + this.length[i] + " ";
        }
        len = len + ")";
        return "\nSqlColumn: name=" + this.name + ", offset=" + off + ", length=" + len + ", piclen=" + this.pictureLength + ", table=" + this.table + ", keyfield=" + this.keyfield + ", usage=" + this.usage + ". sqltype=" + this.sqltype + ", place=" + this.place + ", scale=" + this.scale;
    }

    public static Vector<SqlColumn> getColumns(String dbTable, Connection conn, DBMS dbms, int driverMajorVersion) {
        return SqlColumn.getColumns(dbTable, conn, dbms, driverMajorVersion, true);
    }

    public static Vector<SqlColumn> getColumns(String dbTable, Connection conn, DBMS dbms, int driverMajorVersion, boolean commitConnection) {
        String tabPat;
        String schPat;
        String sys;
        String colPat = null;
        String[] components = dbTable.split("\\.", 3);
        if (components.length == 3) {
            if (dbms == DBMS.DB2) {
                sys = components[0].toUpperCase();
                schPat = components[1].toUpperCase();
                tabPat = components[2].toUpperCase();
            } else {
                sys = components[0];
                schPat = components[1];
                tabPat = components[2];
            }
        } else if (components.length == 2) {
            if (dbms == DBMS.DB2) {
                sys = null;
                schPat = components[0].toUpperCase();
                tabPat = components[1].toUpperCase();
            } else if (dbms == DBMS.MYSQL) {
                sys = schPat = components[0];
                tabPat = components[1];
            } else {
                sys = null;
                schPat = components[0];
                tabPat = components[1];
            }
        } else {
            sys = null;
            schPat = null;
            tabPat = dbms == DBMS.DB2 ? components[0].toUpperCase() : components[0];
        }
        if (dbms == DBMS.MYSQL && driverMajorVersion > 5) {
            colPat = "%";
        }
        Vector<SqlColumn> ret = new Vector<SqlColumn>();
        try {
            int moreVariants = 2;
            if (!conn.getAutoCommit() && commitConnection) {
                conn.commit();
            }
            while (moreVariants-- > 0) {
                ResultSet results = conn.getMetaData().getColumns(sys, schPat, tabPat, colPat);
                while (results.next()) {
                    int keyComponentLen;
                    String[] offLen;
                    int len;
                    int off;
                    String[] keyComponents;
                    String colName = results.getString("COLUMN_NAME");
                    if (colName.startsWith("IDX") || colName.startsWith("idx")) {
                        keyComponents = colName.substring(3).split("__");
                        off = 0;
                        len = 0;
                        for (String aKeyComponent : keyComponents) {
                            offLen = aKeyComponent.split("_");
                            if (offLen.length != 2) continue;
                            try {
                                int keyComponentOff = Integer.parseInt(offLen[0]);
                                keyComponentLen = Integer.parseInt(offLen[1]);
                                if (len == 0) {
                                    off = keyComponentOff;
                                    len = keyComponentLen;
                                    continue;
                                }
                                off = 0;
                                len += keyComponentLen;
                            }
                            catch (NumberFormatException keyComponentOff) {
                                // empty catch block
                            }
                        }
                    } else if (colName.toLowerCase().startsWith("ci_")) {
                        keyComponents = null;
                        keyComponents = colName.toLowerCase().startsWith("ci_n") ? colName.substring(9).split("__") : colName.substring(6).split("__");
                        off = 0;
                        len = 0;
                        for (String aKeyComponent : keyComponents) {
                            offLen = aKeyComponent.split("_");
                            if (offLen.length != 2) continue;
                            try {
                                int keyComponentOff = Integer.parseInt(offLen[0]);
                                keyComponentLen = Integer.parseInt(offLen[1]);
                                if (len == 0) {
                                    off = keyComponentOff;
                                    len = keyComponentLen;
                                    continue;
                                }
                                off = 0;
                                len += keyComponentLen;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    } else {
                        off = 0;
                        len = Integer.parseInt(results.getString("COLUMN_SIZE"));
                    }
                    SqlColumn sc = new SqlColumn(colName, off, len, 0, 0, len, results.getString("TYPE_NAME").toUpperCase(), tabPat);
                    ret.add(sc);
                }
                results.close();
                if (!conn.getAutoCommit() && commitConnection) {
                    conn.commit();
                }
                if (ret.size() > 0) {
                    moreVariants = 0;
                    continue;
                }
                if (sys != null) {
                    sys = sys.toUpperCase();
                }
                if (schPat != null) {
                    schPat = schPat.toUpperCase();
                }
                if (tabPat != null) {
                    tabPat = tabPat.toUpperCase();
                }
                if (colPat == null) continue;
                colPat = colPat.toUpperCase();
            }
            return ret;
        }
        catch (SQLException e) {
            System.out.println("SQLException in getColumns : " + e.getMessage());
        }
        catch (NumberFormatException f) {
            System.out.println("NumberFormatException in getColumns : " + f.getMessage());
        }
        return null;
    }
}

