/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.isamsql;

import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.relFile;
import com.heirloomcomputing.ecs.isamsql.ACCESSMODE;
import com.heirloomcomputing.ecs.isamsql.FILETYPE;
import com.heirloomcomputing.ecs.isamsql.OPENMODE;
import com.heirloomcomputing.ecs.isamsql.READSTATE;
import com.heirloomcomputing.ecs.isamsql.VDB;
import java.sql.Connection;
import java.sql.SQLException;

public class VDBRelativeFile
extends relFile {
    VDB vdb = null;
    private VDBRelativeFile externalFile = null;
    public boolean forgottenEndDeclare = true;

    public VDBRelativeFile() {
        this.vdb = new VDB("VDBRelativeFile");
    }

    public VDBRelativeFile(VDBRelativeFile cpy) {
        this.vdb = new VDB(cpy.vdb);
        this.externalFile = cpy.externalFile;
        this.file = cpy.file;
    }

    @Override
    public VDBRelativeFile clone() {
        return new VDBRelativeFile(this);
    }

    @Override
    public String toString() {
        try {
            String linesep = System.getProperty("line.separator");
            if (linesep == null) {
                linesep = "\n";
            }
            StringBuffer result = new StringBuffer();
            result.append("VDBRelativeFile instance").append(linesep);
            result.append("PROTOCOL IS VDB (RRDS)").append(linesep);
            result.append("ORGANIZATION IS RELATIVE").append(linesep);
            result.append(this.vdb.toString());
            if (this.file != null) {
                result.append("ASSIGN TO \"").append(this.getFilename()).append("\"").append(linesep);
            }
            result.append((this.externalFile != null ? "" : "NOT-") + "EXTERNAL").append(linesep);
            return result.toString();
        }
        catch (RuntimeException t) {
            return "NUMBERED FILE";
        }
    }

    @Override
    public synchronized relFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        return this.declare(optional, filenameVariable, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public synchronized relFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        this.vdb.filenameVariable = filenameVariable;
        String assignTo = filenameVariable.toString();
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public synchronized relFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public synchronized relFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(": Assign To:" + assignTo);
        }
        this.vdb.fileType = FILETYPE.RELATIVE;
        this.vdb.optional = optional;
        if (assignTo != null && this.vdb.assignTo == null) {
            this.vdb.assignTo = this.aliasFilename(assignTo, true);
        }
        this.fileStatus = this.vdb.fileStatus = fileStatus;
        this.vdb.accessMode = accessMode == 1 ? ACCESSMODE.SEQUENTIAL : (accessMode == 2 ? ACCESSMODE.RANDOM : (accessMode == 4 ? ACCESSMODE.DYNAMIC : ACCESSMODE.UNKNOWN));
        this.vdb.primaryKeyColumn = "rel";
        this.vdb.isKeyDuplicates[0] = false;
        this.vdb.blockFrom = blockFrom;
        this.vdb.blockTo = blockTo;
        this.vdb.isRecords = isRecords;
        this.vdb.recordFrom = recordFrom;
        this.vdb.recordTo = recordTo;
        this.vdb.dependingOn = dependingOn;
        this.vdb.keyArray[0] = recordKey != null && recordKey.getSize() > 0 ? recordKey : null;
        this.vdb.numberOfKeys = 1;
        this.vdb.keyNameArray[0] = "rel";
        return this;
    }

    @Override
    public synchronized relFile endDeclare() {
        this.vdb.sortKeys();
        this.vdb.filteredFilename = this.vdb.getFilteredFilename();
        if (!this.vdb.initFile()) {
            this.file = null;
            if (this.vdb.fileStatus != null) {
                this.vdb.fileStatus.move(-92);
            }
        }
        return this;
    }

    public void resetDefaultAndGlobalFetchSize(int fetchSize) {
        this.vdb.resetDefaultAndGlobalFetchSize(fetchSize);
    }

    @Override
    public synchronized boolean isOK() {
        int priorErrorCode = this.vdb.getPriorError();
        return priorErrorCode > -10 && priorErrorCode < 10;
    }

    @Override
    public synchronized boolean isOpen() {
        return !this.vdb.isOpen(OPENMODE.CLOSED);
    }

    public void executeSql(String sql) {
        this.vdb.execSQL(sql);
    }

    public void setConnection(Connection sqlConnection) {
        String func = ".setConnection()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine(VDB.PGM + ".setConnection()" + ": Setting existing " + VDB.toString(sqlConnection));
        }
        this.vdb.conn = sqlConnection;
        this.vdb.ETPcontrolledConnection = sqlConnection != null;
    }

    public void swap(Variable older, Variable newer) {
        this.vdb.swap(older, newer);
    }

    @Override
    public synchronized boolean open(int mode) {
        if (this.forgottenEndDeclare) {
            this.forgottenEndDeclare = false;
            this.endDeclare();
        }
        String func = ".open()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".open()" + ": on [" + this.vdb.toDesc() + "].");
        }
        return this.vdb.open(mode);
    }

    @Override
    public synchronized boolean openTimeoutSeconds(int mode, Numeric timeout) {
        String func = ".openTimeoutSeconds()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".openTimeoutSeconds()" + ": on [" + this.vdb.toDesc() + "].");
        }
        return this.vdb.openTimeoutSeconds(mode, timeout);
    }

    @Override
    public synchronized boolean openTimeoutRetries(int mode, Numeric timeout) {
        String func = ".openTimeoutRetries()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".openTimeoutRetries()" + ": on [" + this.vdb.toDesc() + "].");
        }
        return this.vdb.openTimeoutRetries(mode, timeout);
    }

    @Override
    public synchronized boolean openTimeoutRetries(int mode) {
        String func = ".openTimeoutRetries()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".openTimeoutRetries()" + ": on [" + this.vdb.toDesc() + "].");
        }
        return this.vdb.openTimeoutRetries(mode);
    }

    @Override
    public synchronized boolean close() {
        return this.close(0);
    }

    @Override
    public synchronized boolean close(int mode) {
        String func = ".close()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".close()" + ": on [" + this.vdb.toDesc() + "].");
        }
        return this.vdb.close(mode);
    }

    @Override
    public boolean deleteFile() {
        String func = ".deleteFile()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".deleteFile()" + ": on [" + this.vdb.toDesc() + "].");
        }
        return this.vdb.deleteFile();
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode, int keyOffset) {
        return this.start(mode, keyOffset);
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode, Variable currentKey) {
        return this.start(mode, currentKey);
    }

    @Override
    public synchronized boolean start(int mode, Variable currentKey) {
        boolean rc;
        String func = ".start()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".start()" + ": on [" + this.vdb.toDesc() + "].");
        }
        if (this.vdb == null || !this.vdb.isOpen(OPENMODE.OPEN_INPUT) && !this.vdb.isOpen(OPENMODE.OPEN_IO)) {
            this.vdb.setIOStatus(-47);
            this.vdb.readState = READSTATE.ERROR;
            return true;
        }
        if (this.vdb.accessMode != ACCESSMODE.SEQUENTIAL && this.vdb.accessMode != ACCESSMODE.DYNAMIC) {
            this.vdb.setIOStatus(-90);
            VDB.Logit("file status=" + (this.vdb.fileStatus == null ? "ERROR_OTHER" : this.vdb.fileStatus.toText()) + ": ERROR! ACCESS MODE must be SEQUENTIAL or DYNAMIC.", ".start()");
            this.vdb.readState = READSTATE.ERROR;
            return true;
        }
        this.end();
        int fileStatus = this.vdb.startNextPrev(currentKey, mode);
        if (fileStatus > -10) {
            this.vdb.isReadRandom = true;
            fileStatus = this.vdb.advanceAndRetrieveData(true);
            this.vdb.isReadRandom = true;
            if (fileStatus != 0 && fileStatus != -23) {
                fileStatus = 0;
                this.vdb.setIOStatus(fileStatus);
            }
        }
        boolean bl = rc = fileStatus <= -10;
        if (!rc) {
            this.vdb.browsing = true;
        }
        return rc;
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode) {
        return this.start(mode);
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, Variable currentKey) {
        return this.start(currentKey);
    }

    @Override
    public synchronized boolean start(Variable currentKey) {
        try {
            return this.start(0, currentKey);
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in indexed file START.", t);
            return true;
        }
    }

    public synchronized boolean end() {
        String func = ".end()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".end()" + ": on [" + this.vdb.toDesc() + "].");
        }
        if (this.vdb == null || !this.vdb.isOpen(OPENMODE.OPEN_INPUT) && !this.vdb.isOpen(OPENMODE.OPEN_IO)) {
            this.vdb.setIOStatus(-47);
            this.vdb.readState = READSTATE.ERROR;
            return true;
        }
        this.vdb.browsing = false;
        this.vdb.closeResultSet();
        return false;
    }

    @Override
    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, Variable keyIs, int mode, Numeric timeout) {
        return this.read(intoVar, keyIs, mode, timeout);
    }

    private boolean read(Variable intoVar, Variable keyIs, int mode, Numeric timeout) {
        int fileStatus;
        String func = ".read()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".read()" + ": on [" + this.vdb.toDesc() + "].");
        }
        if (this.vdb == null || !this.vdb.isOpen(OPENMODE.OPEN_INPUT) && !this.vdb.isOpen(OPENMODE.OPEN_IO)) {
            this.vdb.setIOStatus(-47);
            this.vdb.readState = READSTATE.ERROR;
            return true;
        }
        if (keyIs == null) {
            if (this.vdb.accessMode == ACCESSMODE.RANDOM) {
                this.vdb.readState = READSTATE.ERROR;
                this.vdb.setIOStatus(-47);
                VDB.LogAndThrowException(VDB.PGM + ".read()" + ": READ KEY required for Random Access mode.", false);
                return true;
            }
            return this.readNext(intoVar, mode, null);
        }
        this.vdb.readMode = mode >> 8;
        if ((fileStatus = this.vdb.startNextPrev(keyIs, mode = (mode &= 0xFF) == 0x200000 ? 0 : 0)) > -10) {
            this.vdb.isReadRandom = true;
            fileStatus = this.vdb.advanceAndRetrieveData(true);
            this.vdb.isReadRandom = false;
        }
        if (fileStatus <= -10) {
            return true;
        }
        this.vdb.updateIntoVarAndLen(intoVar);
        this.vdb.updateDeclaredKeys(keyIs);
        this.vdb.readState = READSTATE.READRAND;
        if (this.vdb.readMode != 3 && !this.vdb.browsing) {
            this.vdb.closeResultSet();
        }
        return false;
    }

    @Override
    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        if (this.vdb.accessMode == ACCESSMODE.SEQUENTIAL) {
            return this.readNext(intoVar, mode, timeout);
        }
        return this.read(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean read(Variable intoVar, int mode, Numeric timeout) {
        Variable key = this.vdb.keyArray[0];
        return this.read(intoVar, key, mode, timeout);
    }

    @Override
    public synchronized boolean read(Variable intoVar) {
        return this.read(intoVar, 0, null);
    }

    @Override
    public synchronized boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readNext(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean readNext(Variable intoVar, int mode, Numeric timeout) {
        int fileStatus;
        String func = ".readNext()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".readNext()" + ": on [" + this.vdb.toDesc() + "].");
        }
        if (this.vdb == null || !this.vdb.isOpen(OPENMODE.OPEN_INPUT) && !this.vdb.isOpen(OPENMODE.OPEN_IO)) {
            this.vdb.setIOStatus(-47);
            this.vdb.readState = READSTATE.ERROR;
            VDB.Logit("file status=" + (this.vdb.fileStatus == null ? "ERROR_LOGIC_READ_NOT_INPUT" : this.vdb.fileStatus.toText()) + "ERROR! READ NEXT requires file be OPENed as INPUT or IO.", ".readNext()");
            return true;
        }
        this.vdb.readMode = mode >> 8;
        this.vdb.browsing = true;
        if ((mode &= 0xFF) == 0x200000) {
            mode = 0;
        }
        if ((fileStatus = this.vdb.advanceAndRetrieveData(true)) <= -10) {
            return true;
        }
        this.vdb.updateIntoVarAndLen(intoVar);
        this.vdb.updateDeclaredKeys(null);
        if (this.vdb.readMode != 3 && !this.vdb.browsing) {
            this.vdb.closeResultSet();
        }
        return false;
    }

    @Override
    public synchronized boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.readNext(intoVar);
    }

    @Override
    public synchronized boolean readNext(Variable intoVar) {
        return this.readNext(intoVar, 0, null);
    }

    @Override
    public synchronized boolean readPrevious(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readPrevious(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean readPrevious(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.readPrevious(intoVar);
    }

    @Override
    public synchronized boolean readPrevious(Variable intoVar) {
        return this.readPrevious(intoVar, 0, null);
    }

    @Override
    public synchronized boolean readPrevious(Variable intoVar, int mode, Numeric timeout) {
        int fileStatus;
        String func = ".readPrevious()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".readPrevious()" + ": on [" + this.vdb.toDesc() + "].");
        }
        if (this.vdb == null || !this.vdb.isOpen(OPENMODE.OPEN_INPUT) && !this.vdb.isOpen(OPENMODE.OPEN_IO)) {
            this.vdb.setIOStatus(-47);
            this.vdb.readState = READSTATE.ERROR;
            VDB.Logit("file status=" + (this.vdb.fileStatus == null ? "ERROR_LOGIC_READ_NOT_INPUT" : this.vdb.fileStatus.toText()) + "ERROR! READ NEXT requires file be OPENed as INPUT or IO.", ".readPrevious()");
            return true;
        }
        this.vdb.readMode = mode >> 8;
        this.vdb.browsing = true;
        if ((mode &= 0xFF) == 0x200000) {
            mode = 0;
        }
        if ((fileStatus = this.vdb.advanceAndRetrieveData(false)) <= -10) {
            return true;
        }
        this.vdb.updateIntoVarAndLen(intoVar);
        this.vdb.updateDeclaredKeys(null);
        if (this.vdb.readMode != 3 && !this.vdb.browsing) {
            this.vdb.closeResultSet();
        }
        return false;
    }

    @Override
    public boolean write(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar, int mode, Numeric timeout) {
        return this.write(fromVar);
    }

    @Override
    public boolean write(Variable fromVar, int mode, Numeric timeout) {
        return this.write(fromVar);
    }

    @Override
    public synchronized boolean write(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar) {
        return this.write(fromVar);
    }

    @Override
    public synchronized boolean write(Variable fromVar) {
        String func = VDB.PGM + ".write()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + func + ": on [" + this.vdb.toDesc() + "].");
        }
        if (this.vdb == null || !this.vdb.isOpen(OPENMODE.OPEN_OUTPUT) && !this.vdb.isOpen(OPENMODE.OPEN_IO)) {
            this.vdb.setIOStatus(-48);
            return true;
        }
        return this.vdb.insert(fromVar);
    }

    @Override
    public boolean rewrite(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar, int mode, Numeric timeout) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("mode=" + mode + ".");
        }
        return this.rewrite(fromVar);
    }

    @Override
    public synchronized boolean rewrite(String format, Variable nullKeyMap, Variable nullMap, Variable fromVar) {
        return this.rewrite(fromVar);
    }

    @Override
    public boolean rewrite(Variable fromVar) {
        String func = ".rewrite()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".rewrite()" + ": on [" + this.vdb.toDesc() + "].");
        }
        if (this.vdb == null || !this.vdb.isOpen(OPENMODE.OPEN_IO)) {
            this.vdb.setIOStatus(-49);
            return true;
        }
        return this.vdb.update(fromVar);
    }

    @Override
    public boolean delete(String format, Variable nullKeyMap, int mode, Numeric timeout) {
        return this.delete(mode, timeout);
    }

    @Override
    public synchronized boolean delete(String format, Variable nullKeyMap) {
        return this.delete();
    }

    @Override
    public synchronized boolean delete() {
        String func = ".delete()";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(VDB.PGM + ".delete()" + ": on [" + this.vdb.toDesc() + "].");
        }
        if (this.vdb == null || !this.vdb.isOpen(OPENMODE.OPEN_OUTPUT) && !this.vdb.isOpen(OPENMODE.OPEN_IO)) {
            this.vdb.setIOStatus(-49);
            VDB.Logit("file status=" + (this.vdb.fileStatus == null ? "ERROR_LOGIC_DELETE_NOT_I_O" : this.vdb.fileStatus.toText()) + ". Record cannot be deleted. File must be OPENed for I-O.", ".delete()");
            return true;
        }
        return this.vdb.delete();
    }

    @Override
    public synchronized boolean useException() {
        int priorErrorCode = this.vdb.getPriorError();
        if (priorErrorCode < 0) {
            priorErrorCode = -priorErrorCode;
        }
        return priorErrorCode >= 10;
    }

    @Override
    public synchronized int useException(int specific, int input, int output, int io, int extend) {
        if (this.useException()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
            if (this.isExtend()) {
                return extend;
            }
        }
        return -1;
    }

    @Override
    public synchronized boolean useAtEnd() {
        int priorErrorCode = this.vdb.getPriorError();
        return priorErrorCode == -10 || priorErrorCode == 10 || priorErrorCode == 14 || priorErrorCode == -14;
    }

    @Override
    public synchronized int useAtEnd(int specific, int input, int output, int io, int extend) {
        if (this.useAtEnd()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
            if (this.isExtend()) {
                return extend;
            }
        }
        return -1;
    }

    @Override
    public synchronized int useAtEnd(int specific) {
        if (this.useAtEnd() && specific >= 0) {
            return specific;
        }
        return -1;
    }

    @Override
    public synchronized Numeric getLinageCounter() {
        return new Numeric(1);
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public relFile setPassword(Variable identifier) {
        return this;
    }

    public boolean supportsTransactions() {
        if (this.vdb.conn != null) {
            try {
                return !this.vdb.conn.getAutoCommit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }
}

