/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.jfc.LComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public final class LBar
extends LComponent
implements KeyListener {
    private static final int MAX_WIDTH = 256;
    private final Color[] colors = new Color[256];
    private final int[] shades = new int[256];
    private final int[] trailingShift = new int[256];
    private final int[] leadingShift = new int[256];
    private int colorsIndex;
    private int shadesIndex;
    private int trailingIndex;
    private int leadingIndex;
    private int minLeading;
    private int maxTrailing;
    private int width = 1;
    private int positionShift;
    private boolean horizontal;

    public LBar() {
        this.setOpaque(false);
        this.lines = 0.0;
        this.size = 0.0;
        this.horizontal = true;
        this.adjustLines = 0;
        this.width = 1;
        this.setStyle(0xC000000);
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        this.addKeyListener(this);
    }

    public void removeConstantListeners() {
        this.removeKeyListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isAcceptable() {
        return false;
    }

    @Override
    public int getControlType() {
        return 11;
    }

    @Override
    public int getUnitWidth() {
        return this.getCellWidth();
    }

    @Override
    public int getUnitHeight() {
        return this.getCellHeight();
    }

    public boolean isNormal() {
        return !this.isStyle(3);
    }

    public void setNormal() {
        this.setStyleOn(0, 3);
    }

    public void setNormal(boolean state) {
        this.setStyle(0, state, 3);
    }

    public boolean isDotted() {
        return this.isStyle(1);
    }

    public int getDotted() {
        return this.isDotted() ? 1 : 0;
    }

    public void setDotted() {
        this.setStyleOn(1, 2);
    }

    public void setDotted(boolean state) {
        this.setStyle(1, state, 2);
    }

    public boolean isDashed() {
        return this.isStyle(2);
    }

    public int getDashed() {
        return this.isDashed() ? 1 : 0;
    }

    public void setDashed() {
        this.setStyleOn(2, 1);
    }

    public void setDashed(boolean state) {
        this.setStyle(2, state, 1);
    }

    public boolean isDotDash() {
        return this.isStyle(3);
    }

    public int getDotDash() {
        return this.isDotDash() ? 1 : 0;
    }

    public void setDotDash() {
        this.setStyleOn(3);
    }

    public void setDotDash(boolean state) {
        this.setStyle(3, state);
    }

    @Override
    public void setStyle(int mask) {
        super.setStyle(mask);
        this.repaint();
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 1: {
                this.setBarWidth(this.getInt(property));
                break;
            }
            case 2: {
                this.setColors(this.getInt(property));
                break;
            }
            case 3: {
                this.setShading(this.getInt(property));
                break;
            }
            case 4: {
                this.setPositionShift(this.getInt(property));
                break;
            }
            case 5: {
                this.setLeadingShift(this.getInt(property));
                break;
            }
            case 6: {
                this.setTrailingShift(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 1: {
                return String.valueOf(this.getBarWidth());
            }
            case 2: {
                return String.valueOf(this.getColors());
            }
            case 3: {
                return String.valueOf(this.getShading());
            }
            case 4: {
                return String.valueOf(this.getPositionShift());
            }
            case 5: {
                return String.valueOf(this.getLeadingShift());
            }
            case 6: {
                return String.valueOf(this.getTrailingShift());
            }
        }
        return super.getProperty(number);
    }

    public void setBarWidth(int value) {
        if (value > 0) {
            this.width = value;
            this.recalculateSizes();
        }
        this.redisplay();
    }

    public int getBarWidth() {
        return this.width;
    }

    public void setPositionShift(int value) {
        this.positionShift = value;
        this.recalculateSizes();
        this.redisplay();
    }

    public int getPositionShift() {
        return this.positionShift;
    }

    public void setLeadingShift(int value) {
        if (value >= 999) {
            this.leadingIndex = 0;
            this.minLeading = 0;
        } else if (this.leadingIndex < 256) {
            this.leadingShift[this.leadingIndex] = value;
            ++this.leadingIndex;
            if (value < this.minLeading) {
                this.minLeading = value;
            }
        }
        this.recalculateSizes();
    }

    public int getLeadingShift() {
        return this.leadingIndex;
    }

    public void setTrailingShift(int value) {
        if (value >= 999) {
            this.trailingIndex = 0;
            this.maxTrailing = 0;
        } else if (this.trailingIndex < 256) {
            this.trailingShift[this.trailingIndex] = value;
            ++this.trailingIndex;
            if (value > this.maxTrailing) {
                this.maxTrailing = value;
            }
        }
        this.recalculateSizes();
    }

    public int getTrailingShift() {
        return this.trailingIndex;
    }

    public void setShading(int value) {
        if (value < -2 || value > 2) {
            this.shadesIndex = 0;
        } else if (this.shadesIndex < 256) {
            this.shades[this.shadesIndex] = value;
            ++this.shadesIndex;
        }
    }

    public int getShading() {
        return this.shadesIndex;
    }

    public void setColorsRGB(int rgb) {
        if (rgb < 0) {
            this.colorsIndex = 0;
        } else if (this.colorsIndex < 256) {
            this.colors[this.colorsIndex] = new Color(rgb);
            ++this.colorsIndex;
        }
    }

    public void setColors(int value) {
        if (value < 1 || value > 16) {
            this.colorsIndex = 0;
        } else if (this.colorsIndex < 256) {
            this.colors[this.colorsIndex] = value != 16 ? LBar.getCobolColor(value) : Color.white;
            ++this.colorsIndex;
        }
    }

    public int getColors() {
        return this.colorsIndex;
    }

    @Override
    public void setColumnsPixelsInternal(int value) {
        if (value <= 0) {
            this.horizontal = false;
            this.adjustLines = 0;
            this.adjustSize = this.width;
            this.adjustColumn = this.positionShift;
            this.adjustLine = 0;
            this.setLinePixelsInternal();
            this.setColumnPixelsInternal();
            this.adjustLines += this.maxTrailing;
            this.adjustLines -= this.minLeading;
            this.adjustLine = -this.minLeading;
        } else {
            this.horizontal = true;
            this.adjustSize = 0;
            this.adjustLines = this.width;
            this.adjustColumn = 0;
            this.adjustLine = this.positionShift;
            this.setLinePixelsInternal();
            this.setColumnPixelsInternal();
            this.adjustSize += this.maxTrailing;
            this.adjustSize -= this.minLeading;
            this.adjustColumn = -this.minLeading;
        }
        super.setColumnsPixelsInternal(value);
    }

    @Override
    public void setLinesPixelsInternal(int value) {
        if (value <= 0) {
            this.horizontal = true;
            this.adjustLines = this.width;
            this.adjustSize = 0;
            this.adjustColumn = 0;
            this.adjustLine = this.positionShift;
            this.setLinePixelsInternal();
            this.setColumnPixelsInternal();
            this.adjustSize += this.maxTrailing;
            this.adjustSize -= this.minLeading;
            this.adjustColumn = -this.minLeading;
        } else {
            this.horizontal = false;
            this.adjustSize = this.width;
            this.adjustLines = 0;
            this.adjustColumn = this.positionShift;
            this.adjustLine = 0;
            this.setLinePixelsInternal();
            this.setColumnPixelsInternal();
            this.adjustLines += this.maxTrailing;
            this.adjustLines -= this.minLeading;
            this.adjustLine = -this.minLeading;
        }
        super.setLinesPixelsInternal(value);
    }

    @Override
    public void paintComponent(Graphics g) {
        Color oldColor = g.getColor();
        Color main = this.getForeground();
        Color c = null;
        Dimension r = this.getSize();
        int x = 0;
        int y = 0;
        int x2 = r.width;
        int y2 = r.height;
        int lineStyle = this.getStyle() & 3;
        lineStyle = (lineStyle & 3) == 3 ? 1 : ((lineStyle & 2) == 2 ? 2 : ((lineStyle & 1) == 1 ? 3 : 0));
        int tracker = 0;
        if (this.horizontal) {
            x -= this.minLeading;
            x2 -= this.maxTrailing;
            int line = y;
            int leading = 0;
            int trailing = 0;
            for (int i = 0; i < this.width; ++i) {
                c = i < this.colorsIndex ? this.colors[i] : main;
                if (i < this.shadesIndex) {
                    switch (this.shades[i]) {
                        case 2: {
                            c = Color.white;
                            break;
                        }
                        case 1: {
                            c = LComponent.doubleBrighter(c);
                            break;
                        }
                        case -1: {
                            c = LComponent.doubleDarker(c);
                            break;
                        }
                        case -2: {
                            c = Color.black;
                        }
                    }
                }
                g.setColor(c);
                leading = x;
                if (i < this.leadingIndex) {
                    leading += this.leadingShift[i];
                }
                tracker = leading;
                trailing = x2;
                if (i < this.trailingIndex) {
                    trailing += this.trailingShift[i];
                }
                do {
                    switch (lineStyle) {
                        case 1: {
                            g.drawLine(tracker, line, tracker + 8, line);
                            g.drawLine(tracker + 15, line, tracker + 17, line);
                            tracker += 24;
                            break;
                        }
                        case 2: {
                            g.drawLine(tracker, line, tracker + 17, line);
                            tracker += 24;
                            break;
                        }
                        case 3: {
                            g.drawLine(tracker, line, tracker + 2, line);
                            tracker += 6;
                            break;
                        }
                        default: {
                            g.drawLine(leading, line, trailing, line);
                            tracker += trailing;
                        }
                    }
                } while (tracker < trailing);
                ++line;
            }
        } else {
            y -= this.minLeading;
            y2 -= this.maxTrailing;
            int column = x;
            int leading = 0;
            int trailing = 0;
            for (int i = 0; i < this.width; ++i) {
                c = i < this.colorsIndex ? this.colors[i] : main;
                if (i < this.shadesIndex) {
                    switch (this.shades[i]) {
                        case 2: {
                            c = Color.white;
                            break;
                        }
                        case 1: {
                            c = LComponent.doubleBrighter(c);
                            break;
                        }
                        case -1: {
                            c = LComponent.doubleDarker(c);
                            break;
                        }
                        case -2: {
                            c = Color.black;
                        }
                    }
                }
                g.setColor(c);
                leading = y;
                if (i < this.leadingIndex) {
                    leading += this.leadingShift[i];
                }
                trailing = y2;
                if (i < this.trailingIndex) {
                    trailing += this.trailingShift[i];
                }
                tracker = leading;
                do {
                    switch (lineStyle) {
                        case 1: {
                            g.drawLine(column, tracker, column, tracker + 8);
                            g.drawLine(column, tracker + 15, column, tracker + 17);
                            tracker += 24;
                            break;
                        }
                        case 2: {
                            g.drawLine(column, tracker, column, tracker + 17);
                            tracker += 24;
                            break;
                        }
                        case 3: {
                            g.drawLine(column, tracker, column, tracker + 2);
                            tracker += 6;
                            break;
                        }
                        default: {
                            g.drawLine(column, leading, column, trailing);
                            tracker += trailing;
                        }
                    }
                } while (tracker < trailing);
                ++column;
            }
        }
        g.setColor(oldColor);
    }

    private void redisplay() {
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.preferredSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.preferredSize;
    }
}

