/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.StringToIcon;
import com.heirloomcomputing.ecs.jfc.LComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Icon;

public final class LBitmap
extends LComponent
implements Icon,
KeyListener {
    public static int defaultBitmapHandle = 0;
    private boolean scaled;
    private boolean tiled;
    private boolean centered;
    private int bitmapNumber;
    private int bitmapHandle;
    private int bitmapStart = 1;
    private int bitmapEnd = 1;
    private int bitmapTimer;
    private int horizontalTileOffset;
    private int imageBorderWidth;
    private int imageBorderHeight;
    private int imageWidth;
    private int imageHeight;
    private int overrideImageWidth;
    private int overrideImageHeight;
    private int actualWidth;
    private int actualHeight;
    private String imageResource;
    private Image image;
    private BitmapAnimator animator;
    private int setImageLine;
    private StringToIcon stringToIcon;
    private int getImageLine;

    public LBitmap() {
        this.setOpaque(false);
        this.lines = 0.0;
        this.size = 0.0;
    }

    public LBitmap(String value) {
        this.setOpaque(false);
        this.setValue(value);
        this.lines = 0.0;
        this.size = 0.0;
    }

    public LBitmap(LBitmap copy, int bitmapNum) {
        this.image = copy.image;
        this.imageResource = copy.imageResource;
        this.imageWidth = copy.imageWidth;
        this.imageHeight = copy.imageHeight;
        this.overrideImageWidth = copy.overrideImageWidth;
        this.overrideImageHeight = copy.overrideImageHeight;
        this.actualWidth = copy.actualWidth;
        this.actualHeight = copy.actualHeight;
        this.bitmapNumber = bitmapNum - 1;
        this.bitmapStart = 1;
        this.bitmapEnd = 1;
        this.bitmapTimer = 0;
        this.horizontalTileOffset = 0;
    }

    public LBitmap(LBitmap copy, int bitmapNum, int bitmapWidth) {
        this.image = copy.image;
        this.imageResource = copy.imageResource;
        this.imageWidth = bitmapWidth;
        this.imageHeight = copy.imageHeight;
        this.overrideImageWidth = copy.overrideImageWidth;
        this.overrideImageHeight = copy.overrideImageHeight;
        this.actualWidth = copy.actualWidth;
        this.actualHeight = copy.actualHeight;
        this.bitmapNumber = bitmapNum;
        this.bitmapStart = 1;
        this.bitmapEnd = 1;
        this.bitmapTimer = 0;
        this.horizontalTileOffset = 0;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        this.addKeyListener(this);
    }

    public void removeConstantListeners() {
        this.removeKeyListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    public static int getDefaultBitmapHandle() {
        return defaultBitmapHandle;
    }

    public static void setDefaultBitmapHandle(int value) {
        defaultBitmapHandle = value;
    }

    @Override
    public boolean isAcceptable() {
        return false;
    }

    @Override
    public int getIconHeight() {
        return this.imageHeight;
    }

    @Override
    public int getIconWidth() {
        return this.imageWidth;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Rectangle r = g.getClipBounds();
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        g.clipRect(x, y, width, height);
        this.paint(g, c, x, y, this.imageWidth, this.bitmapNumber);
        g.setClip(r);
    }

    @Override
    public int getControlType() {
        return 13;
    }

    @Override
    public void setCleanTitle(String s) {
        this.setToolTipText(s);
    }

    public boolean isTiled() {
        return this.isStyle(256);
    }

    public int getTiled() {
        return this.isTiled() ? 1 : 0;
    }

    public void setTiled() {
        this.setStyleOn(256, 1536);
    }

    public void setTiled(boolean state) {
        this.setStyle(256, state, 1536);
    }

    public boolean isCentered() {
        return this.isStyle(512);
    }

    public int getCentered() {
        return this.isCentered() ? 1 : 0;
    }

    public void setCentered() {
        this.setStyleOn(512, 1280);
    }

    public void setCentered(boolean state) {
        this.setStyle(512, state, 1280);
    }

    public boolean isScaled() {
        return this.isStyle(1024);
    }

    public int getScaled() {
        return this.isScaled() ? 1 : 0;
    }

    public void setScaled() {
        this.setStyleOn(1024, 768);
    }

    public void setScaled(boolean state) {
        this.setStyle(1024, state, 768);
    }

    @Override
    public void setStyle(int mask) {
        int change = this.style ^ mask;
        boolean repaintRequest = false;
        if ((change & 0x100) == 256) {
            this.tiled = (mask & 0x100) == 256;
            repaintRequest = true;
        }
        if ((change & 0x200) == 512) {
            this.centered = (mask & 0x200) == 512;
            repaintRequest = true;
        }
        if ((change & 0x400) == 1024) {
            this.scaled = (mask & 0x400) == 1024;
            repaintRequest = true;
        }
        if (repaintRequest) {
            this.repaint();
        }
        super.setStyle(mask);
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 1: {
                this.setBitmapNumber(this.getInt(property));
                break;
            }
            case 2: {
                this.setBitmapHandle(this.getInt(property));
                break;
            }
            case 3: {
                this.setBitmapStart(this.getInt(property));
                break;
            }
            case 4: {
                this.setBitmapEnd(this.getInt(property));
                break;
            }
            case 5: {
                this.setBitmapTimer(this.getInt(property));
                break;
            }
            case 100: {
                this.setTileOffset(this.getInt(property));
                break;
            }
            case 101: {
                this.setBorderWidth(this.getInt(property));
                break;
            }
            case 102: {
                this.setBorderHeight(this.getInt(property));
                break;
            }
            case 103: {
                this.setImage(this.getString(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 1: {
                return String.valueOf(this.getBitmapNumber());
            }
            case 2: {
                return String.valueOf(this.getBitmapHandle());
            }
            case 3: {
                return String.valueOf(this.getBitmapStart());
            }
            case 4: {
                return String.valueOf(this.getBitmapEnd());
            }
            case 5: {
                return String.valueOf(this.getBitmapTimer());
            }
            case 100: {
                return String.valueOf(this.getTileOffset());
            }
            case 101: {
                return String.valueOf(this.getBorderWidth());
            }
            case 102: {
                return String.valueOf(this.getBorderHeight());
            }
            case 103: {
                return this.getImage();
            }
        }
        return super.getProperty(number);
    }

    @Override
    public void destroy() {
        try {
            if (this.image != null) {
                this.image.flush();
            }
            this.image = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void flush() {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
    }

    public void setBitmapNumber(int value) {
        this.bitmapNumber = value;
        this.repaint();
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public void incrementBitmapNumber() {
        ++this.bitmapNumber;
        if (this.bitmapNumber > this.bitmapEnd) {
            this.bitmapNumber = this.bitmapStart;
        }
        this.repaint();
    }

    public void setBitmapHandle(int value) {
        this.bitmapHandle = value;
        try {
            LBitmap otherBitmap;
            Handle h = Handle.getHandle(this.bitmapHandle);
            if (h != null && (otherBitmap = (LBitmap)h.getComponent()) != null) {
                this.image = otherBitmap.image;
                this.imageResource = otherBitmap.imageResource;
                if (this.image != null) {
                    this.finishImageWait();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getBitmapHandle() {
        return this.bitmapHandle;
    }

    public void setBitmapStart(int value) {
        this.bitmapStart = value;
    }

    public int getBitmapStart() {
        return this.bitmapStart;
    }

    public void setBitmapEnd(int value) {
        this.bitmapEnd = value;
    }

    public int getBitmapEnd() {
        return this.bitmapEnd;
    }

    public void setBitmapTimer(int value) {
        this.bitmapNumber = this.bitmapStart;
        this.bitmapTimer = value;
        if (this.bitmapTimer <= 0) {
            this.bitmapTimer = 0;
            if (this.animator != null) {
                this.animator.stopAnimating();
                this.animator = null;
            }
        } else if (this.animator == null) {
            this.animator = new BitmapAnimator(this, value * 10);
            this.startThreadQueue(this.animator);
        } else {
            this.animator.setTimer(value * 10);
        }
    }

    public int getBitmapTimer() {
        return this.bitmapTimer;
    }

    public int getTileOffset() {
        return this.horizontalTileOffset;
    }

    public void setTileOffset(int x) {
        this.horizontalTileOffset = x;
        this.repaint();
    }

    public int getBorderWidth() {
        return this.imageBorderWidth;
    }

    public void setBorderWidth(int x) {
        this.imageBorderWidth = x;
        this.repaint();
    }

    public int getBorderHeight() {
        return this.imageBorderHeight;
    }

    public void setBorderHeight(int y) {
        this.imageBorderHeight = y;
        this.repaint();
    }

    @Override
    public void setLines(double lines) {
        this.imageHeight = this.overrideImageHeight = (int)lines;
        this.setLinesPixelsInternal(this.imageHeight + this.imageBorderHeight * 2);
        this.repaint();
    }

    @Override
    public void setColumns(double size) {
        this.imageWidth = this.overrideImageWidth = (int)size;
        this.setColumnsPixelsInternal(this.imageWidth + this.imageBorderWidth * 2);
        this.repaint();
    }

    @Override
    public double getLines() {
        return this.getSize().height - this.imageBorderHeight * 2;
    }

    @Override
    public double getColumns() {
        return this.getSize().width - this.imageBorderWidth * 2;
    }

    @Override
    public double getLinesCells() {
        int height = this.getCellHeight();
        if (height != 0) {
            return this.getSize().height / height;
        }
        return 1.0;
    }

    @Override
    public double getColumnsCells() {
        int width = this.getCellWidth();
        if (width != 0) {
            return this.getSize().width / width;
        }
        return 1.0;
    }

    @Override
    public void recalculateSizes() {
    }

    @Override
    public void setValue(String resource) {
        if (resource == null) {
            return;
        }
        resource = resource.replace('\u0000', ' ');
        this.imageResource = resource = resource.trim();
        this.image = this.getImage(this.imageResource);
        this.waitForImage();
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    @Override
    public void setImplicitTitle(String resource) {
        this.setValue(resource);
    }

    @Override
    public String getValue() {
        return this.imageResource != null ? this.imageResource : "";
    }

    public void setImage(String s) {
        if (s == null) {
            s = "";
        }
        Dimension d = this.getSize();
        if (this.stringToIcon == null || this.setImageLine == 0) {
            int w = d.width;
            int h = d.height;
            if (w <= 0) {
                w = 16;
            }
            if (h <= 0) {
                h = 15;
            }
            this.stringToIcon = new StringToIcon(w -= this.imageBorderWidth * 2, h -= this.imageBorderHeight * 2);
        }
        if (this.stringToIcon != null) {
            this.stringToIcon.setPixels(s);
        }
        ++this.setImageLine;
        int finalLine = d.height - this.imageBorderHeight * 2;
        if (this.setImageLine >= finalLine) {
            this.image = this.stringToIcon.createImage();
            this.actualWidth = d.width;
            this.actualHeight = d.height;
            this.repaint();
            this.setImageLine = 0;
        }
    }

    public String getImage() {
        ++this.getImageLine;
        return "";
    }

    public Image getImageObject() {
        return this.image;
    }

    public void setImageObject(Image x) {
        this.image = x;
        this.repaint();
    }

    private void waitForImage() {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.finishImageWait();
    }

    private void finishImageWait() {
        this.actualWidth = this.image.getWidth(this);
        this.actualHeight = this.image.getHeight(this);
        this.imageWidth = this.overrideImageWidth;
        this.imageHeight = this.overrideImageHeight;
        if (this.imageWidth <= 0) {
            this.imageWidth = this.actualWidth;
            this.setColumnsPixelsInternal(this.imageWidth + this.imageBorderWidth * 2);
        }
        if (this.imageHeight <= 0) {
            this.imageHeight = this.actualHeight;
            this.setLinesPixelsInternal(this.imageHeight + this.imageBorderHeight * 2);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.image != null) {
            this.paint(g, this, 0, 0, this.getSize().width, this.bitmapNumber);
        } else {
            Dimension size = this.getSize();
            g.drawRect(0, 0, size.width - 1, size.height - 1);
            g.drawLine(0, 0, size.width - 1, size.height - 1);
            g.drawLine(0, size.height - 1, size.width - 1, 0);
        }
        super.paint(g);
    }

    public void paint(Graphics g, Component component, int xpos, int ypos, int bitmapWidth, int bitmapNumber) {
        if (this.image != null) {
            Dimension size = this.getSize();
            if (bitmapNumber > 1) {
                xpos -= (bitmapNumber - 1) * bitmapWidth;
            }
            try {
                if (this.scaled) {
                    g.drawImage(this.image, xpos + this.imageBorderWidth, ypos + this.imageBorderHeight, size.width - this.imageBorderWidth * 2, size.height - this.imageBorderHeight * 2, component);
                } else if (!this.tiled) {
                    if (this.centered) {
                        int offx = (size.width - this.imageBorderWidth * 2 - this.actualWidth) / 2;
                        int offy = (size.height - this.imageBorderHeight * 2 - this.actualHeight) / 2;
                        g.drawImage(this.image, xpos + this.imageBorderWidth + offx, ypos + this.imageBorderHeight + offy, this.actualWidth, this.actualHeight, component);
                    } else {
                        g.drawImage(this.image, xpos + this.imageBorderWidth, ypos + this.imageBorderHeight, this.actualWidth, this.actualHeight, component);
                    }
                } else {
                    int sizeWidth = size.width;
                    int sizeHeight = size.height;
                    int width = this.actualWidth + this.imageBorderWidth * 2;
                    int height = this.actualHeight + this.imageBorderHeight * 2;
                    int ho = this.horizontalTileOffset % width;
                    int startx = 0;
                    for (int y = 0; y < sizeHeight; y += height) {
                        for (int x = startx; x < sizeWidth; x += width) {
                            g.drawImage(this.image, xpos + x + this.imageBorderWidth, ypos + y + this.imageBorderHeight, this.actualWidth, this.actualHeight, component);
                        }
                        if ((startx -= ho) >= -width) continue;
                        startx += width;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        g.setColor(this.getForeground());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.imageWidth + this.imageBorderWidth * 2, this.imageHeight + this.imageBorderHeight * 2);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    class BitmapAnimator
    implements Runnable {
        private boolean stopAnim;
        private int counter = 1000;
        private LBitmap bitmap;

        public BitmapAnimator(LBitmap bitmap, int timer) {
            this.bitmap = bitmap;
            if (timer > 0) {
                this.counter = timer;
            }
        }

        @Override
        public void run() {
            while (!this.stopAnim && this.bitmap != null) {
                try {
                    Thread.sleep(this.counter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.bitmap.incrementBitmapNumber();
            }
            this.stopAnim = false;
        }

        public void setTimer(int value) {
            if (value > 0) {
                this.counter = value;
            }
        }

        public void stopAnimating() {
            this.stopAnim = true;
        }
    }
}

